/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.hover;

import java.util.jar.Attributes;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.osgi.util.NLS;

public class JavaElementLabelComposer {
    static final long QUALIFIER_FLAGS = 0x1002000000000L;
    private static String fgPkgNamePrefix;
    private static String fgPkgNamePostfix;
    private static int fgPkgNameChars;
    private static int fgPkgNameLength;
    protected final FlexibleBuilder fBuilder;

    static {
        fgPkgNameLength = -1;
    }

    protected static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public JavaElementLabelComposer(FlexibleBuilder builder) {
        this.fBuilder = builder;
    }

    public JavaElementLabelComposer(StringBuilder builder) {
        this(new FlexibleStringBuilder(builder));
    }

    public void appendElementLabel(IJavaElement element, long flags) {
        int type = element.getElementType();
        IPackageFragmentRoot root = null;
        if (type != 1 && type != 2 && type != 3) {
            root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)element);
        }
        if (root != null && JavaElementLabelComposer.getFlag(flags, 0x100000000000L)) {
            this.appendPackageFragmentRootLabel(root, 0x20000000000L);
            this.fBuilder.append(" - ");
        }
        switch (type) {
            case 9: {
                this.appendMethodLabel((IMethod)element, flags);
                break;
            }
            case 8: {
                this.appendFieldLabel((IField)element, flags);
                break;
            }
            case 14: {
                this.appendLocalVariableLabel((ILocalVariable)element, flags);
                break;
            }
            case 15: {
                this.appendTypeParameterLabel((ITypeParameter)element, flags);
                break;
            }
            case 10: {
                this.appendInitializerLabel((IInitializer)element, flags);
                break;
            }
            case 7: {
                this.appendTypeLabel((IType)element, flags);
                break;
            }
            case 6: {
                this.appendClassFileLabel((IClassFile)element, flags);
                break;
            }
            case 5: {
                this.appendCompilationUnitLabel((ICompilationUnit)element, flags);
                break;
            }
            case 4: {
                this.appendPackageFragmentLabel((IPackageFragment)element, flags);
                break;
            }
            case 3: {
                this.appendPackageFragmentRootLabel((IPackageFragmentRoot)element, flags);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.appendDeclarationLabel(element, flags);
                break;
            }
            case 1: 
            case 2: {
                this.fBuilder.append(element.getElementName());
                break;
            }
            default: {
                this.fBuilder.append(element.getElementName());
            }
        }
        if (root != null && JavaElementLabelComposer.getFlag(flags, 0x80000000000L)) {
            this.fBuilder.append(" - ");
            this.appendPackageFragmentRootLabel(root, 0x20000000000L);
        }
    }

    public void appendMethodLabel(IMethod method, long flags) {
        try {
            String[] types;
            BindingKey declaringType;
            String resolvedSig;
            BindingKey resolvedKey = JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && method.isResolved() ? new BindingKey(method.getKey()) : null;
            String string = resolvedSig = resolvedKey != null ? resolvedKey.toSignature() : null;
            if (JavaElementLabelComposer.getFlag(flags, 4L)) {
                ITypeParameter[] typeParameters;
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags);
                            this.fBuilder.append(' ');
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            this.appendTypeParameterSignaturesLabel(typeParameterSigs, flags);
                            this.fBuilder.append(' ');
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    this.appendTypeParametersLabels(typeParameters, flags);
                    this.fBuilder.append(' ');
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 64L) && method.exists() && !method.isConstructor()) {
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, returnTypeSig, flags);
                this.fBuilder.append(' ');
            }
            if (JavaElementLabelComposer.getFlag(flags, 128L)) {
                this.appendTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                this.fBuilder.append('.');
            }
            this.fBuilder.append(this.getElementName((IJavaElement)method));
            if (JavaElementLabelComposer.getFlag(flags, 0x200000L) && method.exists() && method.isConstructor() && resolvedSig != null && resolvedKey.isParameterizedType() && (declaringType = resolvedKey.getDeclaringType()) != null) {
                String[] declaringTypeArguments = declaringType.getTypeArguments();
                this.appendTypeArgumentSignaturesLabel((IJavaElement)method, declaringTypeArguments, flags);
            }
            this.fBuilder.append('(');
            String[] declaredParameterTypes = method.getParameterTypes();
            if (JavaElementLabelComposer.getFlag(flags, 3L)) {
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                boolean isPolymorphic = false;
                if (JavaElementLabelComposer.getFlag(flags, 1L)) {
                    types = resolvedSig != null ? Signature.getParameterTypes((String)resolvedSig) : declaredParameterTypes;
                    nParams = types.length;
                    boolean bl = renderVarargs = method.exists() && Flags.isVarargs((int)method.getFlags());
                    if (renderVarargs && resolvedSig != null && declaredParameterTypes.length == 1 && JavaModelUtil.isPolymorphicSignature((IMethod)method)) {
                        renderVarargs = false;
                        isPolymorphic = true;
                    }
                }
                String[] names = null;
                if (JavaElementLabelComposer.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    if (!isPolymorphic) {
                        if (types == null) {
                            nParams = names.length;
                        } else if (nParams != names.length) {
                            if (resolvedSig != null && types.length > names.length) {
                                nParams = names.length;
                                String[] typesWithoutSyntheticParams = new String[nParams];
                                System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                                types = typesWithoutSyntheticParams;
                            } else {
                                names = null;
                            }
                        }
                    }
                }
                ILocalVariable[] annotatedParameters = null;
                if (nParams > 0 && JavaElementLabelComposer.getFlag(flags, 0x10000000000000L)) {
                    annotatedParameters = method.getParameters();
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        this.fBuilder.append(", ");
                    }
                    if (annotatedParameters != null && i < annotatedParameters.length) {
                        this.appendAnnotationLabels(annotatedParameters[i].getAnnotations(), flags);
                    }
                    if (types != null) {
                        String paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = Signature.getArrayCount((String)paramSig) - 1;
                            this.appendTypeSignatureLabel((IJavaElement)method, Signature.getElementType((String)paramSig), flags);
                            int k = 0;
                            while (k < newDim) {
                                this.fBuilder.append('[').append(']');
                                ++k;
                            }
                            this.fBuilder.append("...");
                        } else {
                            this.appendTypeSignatureLabel((IJavaElement)method, paramSig, flags);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            this.fBuilder.append(' ');
                        }
                        if (isPolymorphic) {
                            this.fBuilder.append(String.valueOf(names[0]) + i);
                        } else {
                            this.fBuilder.append(names[i]);
                        }
                    }
                    ++i;
                }
            } else if (declaredParameterTypes.length > 0) {
                this.fBuilder.append("...");
            }
            this.fBuilder.append(')');
            if (JavaElementLabelComposer.getFlag(flags, 16L)) {
                if (resolvedKey != null) {
                    types = resolvedKey.getThrownExceptions();
                } else {
                    String[] stringArray = types = method.exists() ? method.getExceptionTypes() : new String[]{};
                }
                if (types.length > 0) {
                    this.fBuilder.append(" throws ");
                    int i = 0;
                    while (i < types.length) {
                        if (i > 0) {
                            this.fBuilder.append(", ");
                        }
                        this.appendTypeSignatureLabel((IJavaElement)method, types[i], flags);
                        ++i;
                    }
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 8L)) {
                ITypeParameter[] typeParameters;
                if (resolvedKey != null) {
                    if (resolvedKey.isParameterizedMethod()) {
                        String[] typeArgRefs = resolvedKey.getTypeArguments();
                        if (typeArgRefs.length > 0) {
                            this.fBuilder.append(' ');
                            this.appendTypeArgumentSignaturesLabel((IJavaElement)method, typeArgRefs, flags);
                        }
                    } else {
                        String[] typeParameterSigs = Signature.getTypeParameters((String)resolvedSig);
                        if (typeParameterSigs.length > 0) {
                            this.fBuilder.append(' ');
                            this.appendTypeParameterSignaturesLabel(typeParameterSigs, flags);
                        }
                    }
                } else if (method.exists() && (typeParameters = method.getTypeParameters()).length > 0) {
                    this.fBuilder.append(' ');
                    this.appendTypeParametersLabels(typeParameters, flags);
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 32L) && method.exists() && !method.isConstructor()) {
                this.fBuilder.append(":");
                String returnTypeSig = resolvedSig != null ? Signature.getReturnType((String)resolvedSig) : method.getReturnType();
                this.appendTypeSignatureLabel((IJavaElement)method, returnTypeSig, flags);
            }
            if (JavaElementLabelComposer.getFlag(flags, 256L)) {
                this.fBuilder.append(" - ");
                this.appendTypeLabel(method.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("", e);
        }
    }

    protected void appendAnnotationLabels(IAnnotation[] annotations, long flags) throws JavaModelException {
        int j = 0;
        while (j < annotations.length) {
            IAnnotation annotation = annotations[j];
            this.appendAnnotationLabel(annotation, flags);
            this.fBuilder.append(' ');
            ++j;
        }
    }

    public void appendAnnotationLabel(IAnnotation annotation, long flags) throws JavaModelException {
        this.fBuilder.append('@');
        this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)annotation.getElementName(), (boolean)false), flags);
        IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
        if (memberValuePairs.length == 0) {
            return;
        }
        this.fBuilder.append('(');
        int i = 0;
        while (i < memberValuePairs.length) {
            if (i > 0) {
                this.fBuilder.append(", ");
            }
            IMemberValuePair memberValuePair = memberValuePairs[i];
            this.fBuilder.append(this.getMemberName((IJavaElement)annotation, annotation.getElementName(), memberValuePair.getMemberName()));
            this.fBuilder.append('=');
            this.appendAnnotationValue(annotation, memberValuePair.getValue(), memberValuePair.getValueKind(), flags);
            ++i;
        }
        this.fBuilder.append(')');
    }

    private void appendAnnotationValue(IAnnotation annotation, Object value, int valueKind, long flags) throws JavaModelException {
        if (value instanceof Object[]) {
            this.fBuilder.append('{');
            Object[] values = (Object[])value;
            int j = 0;
            while (j < values.length) {
                if (j > 0) {
                    this.fBuilder.append(", ");
                }
                value = values[j];
                this.appendAnnotationValue(annotation, value, valueKind, flags);
                ++j;
            }
            this.fBuilder.append('}');
        } else {
            switch (valueKind) {
                case 11: {
                    this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)((String)value), (boolean)false), flags);
                    this.fBuilder.append(".class");
                    break;
                }
                case 12: {
                    String name = (String)value;
                    int lastDot = name.lastIndexOf(46);
                    if (lastDot != -1) {
                        String type = name.substring(0, lastDot);
                        String field = name.substring(lastDot + 1);
                        this.appendTypeSignatureLabel((IJavaElement)annotation, Signature.createTypeSignature((String)type, (boolean)false), flags);
                        this.fBuilder.append('.');
                        this.fBuilder.append(this.getMemberName((IJavaElement)annotation, type, field));
                        break;
                    }
                }
                case 10: {
                    this.appendAnnotationLabel((IAnnotation)value, flags);
                    break;
                }
                case 9: {
                    this.fBuilder.append(ASTNodes.getEscapedStringLiteral((String)((String)value)));
                    break;
                }
                case 4: {
                    this.fBuilder.append(ASTNodes.getEscapedCharacterLiteral((char)((Character)value).charValue()));
                    break;
                }
                default: {
                    this.fBuilder.append(String.valueOf(value));
                }
            }
        }
    }

    private void appendTypeParametersLabels(ITypeParameter[] typeParameters, long flags) throws JavaModelException {
        if (typeParameters.length > 0) {
            this.fBuilder.append(this.getLT());
            int i = 0;
            while (i < typeParameters.length) {
                if (i > 0) {
                    this.fBuilder.append(", ");
                }
                this.appendTypeParameterWithBounds(typeParameters[i], flags);
                ++i;
            }
            this.fBuilder.append(this.getGT());
        }
    }

    public void appendFieldLabel(IField field, long flags) {
        try {
            if (JavaElementLabelComposer.getFlag(flags, 32768L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                if (JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    this.appendTypeSignatureLabel((IJavaElement)field, new BindingKey(field.getKey()).toSignature(), flags);
                } else {
                    this.appendTypeSignatureLabel((IJavaElement)field, field.getTypeSignature(), flags);
                }
                this.fBuilder.append(' ');
            }
            if (JavaElementLabelComposer.getFlag(flags, 65536L)) {
                this.appendTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
                this.fBuilder.append('.');
            }
            this.fBuilder.append(this.getElementName((IJavaElement)field));
            if (JavaElementLabelComposer.getFlag(flags, 16384L) && field.exists() && !Flags.isEnum((int)field.getFlags())) {
                this.fBuilder.append(":");
                if (JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && field.isResolved()) {
                    this.appendTypeSignatureLabel((IJavaElement)field, new BindingKey(field.getKey()).toSignature(), flags);
                } else {
                    this.appendTypeSignatureLabel((IJavaElement)field, field.getTypeSignature(), flags);
                }
            }
            if (JavaElementLabelComposer.getFlag(flags, 131072L)) {
                this.fBuilder.append(" - ");
                this.appendTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("", e);
        }
    }

    public void appendLocalVariableLabel(ILocalVariable localVariable, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 32768L)) {
            this.appendTypeSignatureLabel((IJavaElement)localVariable, localVariable.getTypeSignature(), flags);
            this.fBuilder.append(' ');
        }
        if (JavaElementLabelComposer.getFlag(flags, 65536L)) {
            this.appendElementLabel((IJavaElement)localVariable.getDeclaringMember(), 0x40081L | flags & 0x1002000000000L);
            this.fBuilder.append('.');
        }
        this.fBuilder.append(this.getElementName((IJavaElement)localVariable));
        if (JavaElementLabelComposer.getFlag(flags, 16384L)) {
            this.fBuilder.append(":");
            this.appendTypeSignatureLabel((IJavaElement)localVariable, localVariable.getTypeSignature(), flags);
        }
        if (JavaElementLabelComposer.getFlag(flags, 131072L)) {
            this.fBuilder.append(" - ");
            this.appendElementLabel((IJavaElement)localVariable.getDeclaringMember(), 0x40081L | flags & 0x1002000000000L);
        }
    }

    public void appendTypeParameterLabel(ITypeParameter typeParameter, long flags) {
        try {
            this.appendTypeParameterWithBounds(typeParameter, flags);
            if (JavaElementLabelComposer.getFlag(flags, 0x400000L)) {
                this.fBuilder.append(" - ");
                IMember declaringMember = typeParameter.getDeclaringMember();
                this.appendElementLabel((IJavaElement)declaringMember, 0x40081L | flags & 0x1002000000000L);
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("", e);
        }
    }

    private void appendTypeParameterWithBounds(ITypeParameter typeParameter, long flags) throws JavaModelException {
        String[] bounds;
        this.fBuilder.append(this.getElementName((IJavaElement)typeParameter));
        if (typeParameter.exists() && (bounds = typeParameter.getBoundsSignatures()).length > 0 && (bounds.length != 1 || !"Ljava.lang.Object;".equals(bounds[0]))) {
            this.fBuilder.append(" extends ");
            int j = 0;
            while (j < bounds.length) {
                if (j > 0) {
                    this.fBuilder.append(" & ");
                }
                this.appendTypeSignatureLabel((IJavaElement)typeParameter, bounds[j], flags);
                ++j;
            }
        }
    }

    public void appendInitializerLabel(IInitializer initializer, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 1024L)) {
            this.appendTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
            this.fBuilder.append('.');
        }
        this.fBuilder.append("{...}");
        if (JavaElementLabelComposer.getFlag(flags, 2048L)) {
            this.fBuilder.append(" - ");
            this.appendTypeLabel(initializer.getDeclaringType(), 0x40000L | flags & 0x1002000000000L);
        }
    }

    protected void appendTypeSignatureLabel(IJavaElement enclosingElement, String typeSig, long flags) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSig);
        switch (sigKind) {
            case 2: {
                this.fBuilder.append(Signature.toString((String)typeSig));
                break;
            }
            case 4: {
                this.appendTypeSignatureLabel(enclosingElement, Signature.getElementType((String)typeSig), flags);
                int dim = Signature.getArrayCount((String)typeSig);
                while (dim > 0) {
                    this.fBuilder.append('[').append(']');
                    --dim;
                }
                break;
            }
            case 1: {
                String baseType = this.getSimpleTypeName(enclosingElement, typeSig);
                this.fBuilder.append(baseType);
                String[] typeArguments = Signature.getTypeArguments((String)typeSig);
                this.appendTypeArgumentSignaturesLabel(enclosingElement, typeArguments, flags);
                break;
            }
            case 3: {
                this.fBuilder.append(this.getSimpleTypeName(enclosingElement, typeSig));
                break;
            }
            case 5: {
                char ch = typeSig.charAt(0);
                if (ch == '*') {
                    this.fBuilder.append('?');
                    break;
                }
                if (ch == '+') {
                    this.fBuilder.append("? extends ");
                    this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                    break;
                }
                if (ch != '-') break;
                this.fBuilder.append("? super ");
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                break;
            }
            case 6: {
                this.appendTypeSignatureLabel(enclosingElement, typeSig.substring(1), flags);
                break;
            }
            case 7: {
                String[] typeBounds = Signature.getIntersectionTypeBounds((String)typeSig);
                this.appendTypeBoundsSignaturesLabel(enclosingElement, typeBounds, flags);
            }
        }
    }

    protected String getSimpleTypeName(IJavaElement enclosingElement, String typeSig) {
        return Signature.getSimpleName((String)Signature.toString((String)Signature.getTypeErasure((String)typeSig)));
    }

    protected String getMemberName(IJavaElement enclosingElement, String typeName, String memberName) {
        return memberName;
    }

    private void appendTypeArgumentSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags) {
        if (typeArgsSig.length > 0) {
            this.fBuilder.append(this.getLT());
            int i = 0;
            while (i < typeArgsSig.length) {
                if (i > 0) {
                    this.fBuilder.append(", ");
                }
                this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags);
                ++i;
            }
            this.fBuilder.append(this.getGT());
        }
    }

    private void appendTypeBoundsSignaturesLabel(IJavaElement enclosingElement, String[] typeArgsSig, long flags) {
        int i = 0;
        while (i < typeArgsSig.length) {
            if (i > 0) {
                this.fBuilder.append(" | ");
            }
            this.appendTypeSignatureLabel(enclosingElement, typeArgsSig[i], flags);
            ++i;
        }
    }

    private void appendTypeParameterSignaturesLabel(String[] typeParamSigs, long flags) {
        if (typeParamSigs.length > 0) {
            this.fBuilder.append(this.getLT());
            int i = 0;
            while (i < typeParamSigs.length) {
                if (i > 0) {
                    this.fBuilder.append(", ");
                }
                this.fBuilder.append(Signature.getTypeVariable((String)typeParamSigs[i]));
                ++i;
            }
            this.fBuilder.append(this.getGT());
        }
    }

    protected String getLT() {
        return "<";
    }

    protected String getGT() {
        return ">";
    }

    public void appendTypeLabel(IType type, long flags) {
        String typeName;
        IPackageFragment pack;
        if (JavaElementLabelComposer.getFlag(flags, 262144L) && !(pack = type.getPackageFragment()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuilder.append('.');
        }
        IJavaElement parent = type.getParent();
        if (JavaElementLabelComposer.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                this.appendTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L);
                this.fBuilder.append('.');
            }
            if ((parentType = parent.getElementType()) == 9 || parentType == 8 || parentType == 10) {
                this.appendElementLabel(parent, 0L);
                this.fBuilder.append('.');
            }
        }
        boolean isAnonymous = false;
        if (type.isLambda()) {
            typeName = "() -> {...}";
            try {
                String[] superInterfaceSignatures = type.getSuperInterfaceTypeSignatures();
                if (superInterfaceSignatures.length > 0) {
                    typeName = String.valueOf(typeName) + ' ' + this.getSimpleTypeName((IJavaElement)type, superInterfaceSignatures[0]);
                }
            }
            catch (JavaModelException superInterfaceSignatures) {}
        } else {
            typeName = this.getElementName((IJavaElement)type);
            try {
                isAnonymous = type.isAnonymous();
            }
            catch (JavaModelException e1) {
                boolean bl = isAnonymous = typeName.length() == 0;
            }
            if (isAnonymous) {
                try {
                    if (parent instanceof IField && type.isEnum()) {
                        typeName = "{...}";
                    } else {
                        String supertypeName = null;
                        String[] superInterfaceSignatures = type.getSuperInterfaceTypeSignatures();
                        if (superInterfaceSignatures.length > 0) {
                            supertypeName = this.getSimpleTypeName((IJavaElement)type, superInterfaceSignatures[0]);
                        } else {
                            String supertypeSignature = type.getSuperclassTypeSignature();
                            if (supertypeSignature != null) {
                                supertypeName = this.getSimpleTypeName((IJavaElement)type, supertypeSignature);
                            }
                        }
                        typeName = supertypeName == null ? "new Anonymous" : NLS.bind((String)"new {0}() '{'...}", (Object)supertypeName);
                    }
                }
                catch (JavaModelException e) {
                    typeName = "new Anonymous";
                }
            }
        }
        this.fBuilder.append(typeName);
        if (JavaElementLabelComposer.getFlag(flags, 0x200000L)) {
            if (JavaElementLabelComposer.getFlag(flags, 0x1000000000000L) && type.isResolved()) {
                BindingKey key = new BindingKey(type.getKey());
                if (key.isParameterizedType()) {
                    String[] typeArguments = key.getTypeArguments();
                    this.appendTypeArgumentSignaturesLabel((IJavaElement)type, typeArguments, flags);
                } else {
                    String[] typeParameters = Signature.getTypeParameters((String)key.toSignature());
                    this.appendTypeParameterSignaturesLabel(typeParameters, flags);
                }
            } else if (type.exists()) {
                try {
                    this.appendTypeParametersLabels(type.getTypeParameters(), flags);
                }
                catch (JavaModelException key) {
                    // empty catch block
                }
            }
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x100000L)) {
            String tqn;
            int lastDollar;
            this.fBuilder.append(" - ");
            IType declaringType = type.getDeclaringType();
            if (declaringType == null && type.isBinary() && isAnonymous && (lastDollar = (tqn = type.getTypeQualifiedName()).lastIndexOf(36)) != 1) {
                String declaringTypeCF = String.valueOf(tqn.substring(0, lastDollar)) + ".class";
                declaringType = type.getPackageFragment().getClassFile(declaringTypeCF).getType();
                try {
                    IJavaElement realParent;
                    ISourceRange typeSourceRange = type.getSourceRange();
                    if (declaringType.exists() && SourceRange.isAvailable((ISourceRange)typeSourceRange) && (realParent = declaringType.getTypeRoot().getElementAt(typeSourceRange.getOffset() - 1)) != null) {
                        parent = realParent;
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (declaringType != null) {
                this.appendTypeLabel(declaringType, 0x40000L | flags & 0x1002000000000L);
                int parentType = parent.getElementType();
                if (parentType == 9 || parentType == 8 || parentType == 10) {
                    this.fBuilder.append('.');
                    this.appendElementLabel(parent, 0L);
                }
            } else {
                this.appendPackageFragmentLabel(type.getPackageFragment(), flags & 0x1002000000000L);
            }
        }
    }

    protected String getElementName(IJavaElement element) {
        return element.getElementName();
    }

    public void appendDeclarationLabel(IJavaElement declaration, long flags) {
        IJavaElement openable;
        if (JavaElementLabelComposer.getFlag(flags, 0x1000000L) && (openable = (IJavaElement)declaration.getOpenable()) != null) {
            this.appendElementLabel(openable, 0x88000000L | flags & 0x1002000000000L);
            this.fBuilder.append('/');
        }
        if (declaration.getElementType() == 12) {
            this.fBuilder.append("import declarations");
        } else {
            this.fBuilder.append(this.getElementName(declaration));
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x2000000L) && (openable = (IJavaElement)declaration.getOpenable()) != null) {
            this.fBuilder.append(" - ");
            this.appendElementLabel(openable, 0x88000000L | flags & 0x1002000000000L);
        }
    }

    public void appendClassFileLabel(IClassFile classFile, long flags) {
        IPackageFragment pack;
        if (JavaElementLabelComposer.getFlag(flags, 0x8000000L) && !(pack = (IPackageFragment)classFile.getParent()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuilder.append('.');
        }
        this.fBuilder.append(classFile.getElementName());
        if (JavaElementLabelComposer.getFlag(flags, 0x10000000L)) {
            this.fBuilder.append(" - ");
            this.appendPackageFragmentLabel((IPackageFragment)classFile.getParent(), flags & 0x1002000000000L);
        }
    }

    public void appendCompilationUnitLabel(ICompilationUnit cu, long flags) {
        IPackageFragment pack;
        if (JavaElementLabelComposer.getFlag(flags, 0x80000000L) && !(pack = (IPackageFragment)cu.getParent()).isDefaultPackage()) {
            this.appendPackageFragmentLabel(pack, flags & 0x1002000000000L);
            this.fBuilder.append('.');
        }
        this.fBuilder.append(cu.getElementName());
        if (JavaElementLabelComposer.getFlag(flags, 0x100000000L)) {
            this.fBuilder.append(" - ");
            this.appendPackageFragmentLabel((IPackageFragment)cu.getParent(), flags & 0x1002000000000L);
        }
    }

    public void appendPackageFragmentLabel(IPackageFragment pack, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 0x800000000L)) {
            this.appendPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L);
            this.fBuilder.append('/');
        }
        if (pack.isDefaultPackage()) {
            this.fBuilder.append("(default package)");
        } else if (JavaElementLabelComposer.getFlag(flags, 0x2000000000L)) {
            this.appendCompressedPackageFragment(pack);
        } else {
            this.fBuilder.append(this.getElementName((IJavaElement)pack));
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x1000000000L)) {
            this.fBuilder.append(" - ");
            this.appendPackageFragmentRootLabel((IPackageFragmentRoot)pack.getParent(), 0x20000000000L);
        }
    }

    private void appendCompressedPackageFragment(IPackageFragment pack) {
        this.appendCompressedPackageFragment(pack.getElementName());
    }

    private void appendCompressedPackageFragment(String elementName) {
        if (fgPkgNameLength < 0) {
            this.fBuilder.append(elementName);
            return;
        }
        String name = elementName;
        int start = 0;
        int dot = name.indexOf(46, start);
        while (dot > 0) {
            if (dot - start > fgPkgNameLength - 1) {
                this.fBuilder.append(fgPkgNamePrefix);
                if (fgPkgNameChars > 0) {
                    this.fBuilder.append(name.substring(start, Math.min(start + fgPkgNameChars, dot)));
                }
                this.fBuilder.append(fgPkgNamePostfix);
            } else {
                this.fBuilder.append(name.substring(start, dot + 1));
            }
            start = dot + 1;
            dot = name.indexOf(46, start);
        }
        this.fBuilder.append(name.substring(start));
    }

    public void appendPackageFragmentRootLabel(IPackageFragmentRoot root, long flags) {
        if (JavaElementLabelComposer.getFlag(flags, 0x10000000000L) && this.appendVariableLabel(root, flags)) {
            return;
        }
        if (root.isArchive()) {
            this.appendArchiveLabel(root, flags);
        } else {
            this.appendFolderLabel(root, flags);
        }
    }

    private void appendArchiveLabel(IPackageFragmentRoot root, long flags) {
        boolean external = root.isExternal();
        if (external) {
            this.appendExternalArchiveLabel(root, flags);
        } else {
            this.appendInternalArchiveLabel(root, flags);
        }
    }

    private boolean appendVariableLabel(IPackageFragmentRoot root, long flags) {
        block10: {
            IClasspathEntry rawEntry;
            block11: {
                try {
                    rawEntry = root.getRawClasspathEntry();
                    if (rawEntry.getEntryKind() != 4) break block10;
                    IClasspathEntry entry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)root);
                    if (entry.getReferencingEntry() == null) break block11;
                    return false;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            IPath path = rawEntry.getPath().makeRelative();
            if (JavaElementLabelComposer.getFlag(flags, 0x200000000000L)) {
                int segements = path.segmentCount();
                if (segements > 0) {
                    this.fBuilder.append(path.segment(segements - 1));
                    if (segements > 1) {
                        this.fBuilder.append(" - ");
                        this.fBuilder.append(path.removeLastSegments(1).toOSString());
                    }
                } else {
                    this.fBuilder.append(path.toString());
                }
            } else {
                this.fBuilder.append(path.toString());
            }
            this.fBuilder.append(" - ");
            if (root.isExternal()) {
                this.fBuilder.append(root.getPath().toOSString());
            } else {
                this.fBuilder.append(root.getPath().makeRelative().toString());
            }
            return true;
        }
        return false;
    }

    private void appendExternalArchiveLabel(IPackageFragmentRoot root, long flags) {
        IPath path;
        IClasspathEntry classpathEntry = null;
        try {
            classpathEntry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)root);
            IPath rawPath = classpathEntry.getPath();
            path = classpathEntry.getEntryKind() != 5 && !rawPath.isAbsolute() ? rawPath : root.getPath();
        }
        catch (JavaModelException e) {
            path = root.getPath();
        }
        if (JavaElementLabelComposer.getFlag(flags, 0x200000000000L)) {
            int segments = path.segmentCount();
            if (segments > 0) {
                IClasspathEntry referencingEntry;
                this.fBuilder.append(path.segment(segments - 1));
                if (segments > 1 || path.getDevice() != null) {
                    this.fBuilder.append(" - ");
                    this.fBuilder.append(path.removeLastSegments(1).toOSString());
                }
                if (classpathEntry != null && (referencingEntry = classpathEntry.getReferencingEntry()) != null) {
                    this.fBuilder.append(NLS.bind((String)" (from {0} of {1})", (Object[])new Object[]{Attributes.Name.CLASS_PATH.toString(), referencingEntry.getPath().lastSegment()}));
                }
            } else {
                this.fBuilder.append(path.toOSString());
            }
        } else {
            this.fBuilder.append(path.toOSString());
        }
    }

    private void appendInternalArchiveLabel(IPackageFragmentRoot root, long flags) {
        IResource resource = root.getResource();
        boolean rootQualified = JavaElementLabelComposer.getFlag(flags, 0x20000000000L);
        if (rootQualified) {
            this.fBuilder.append(root.getPath().makeRelative().toString());
        } else {
            this.fBuilder.append(root.getElementName());
            boolean referencedPostQualified = JavaElementLabelComposer.getFlag(flags, 0x200000000000L);
            if (referencedPostQualified && this.isReferenced(root)) {
                this.fBuilder.append(" - ");
                this.fBuilder.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (JavaElementLabelComposer.getFlag(flags, 0x40000000000L)) {
                this.fBuilder.append(" - ");
                this.fBuilder.append(root.getParent().getPath().makeRelative().toString());
            }
            if (referencedPostQualified) {
                try {
                    IClasspathEntry referencingEntry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)root).getReferencingEntry();
                    if (referencingEntry != null) {
                        this.fBuilder.append(NLS.bind((String)" (from {0} of {1})", (Object[])new Object[]{Attributes.Name.CLASS_PATH.toString(), referencingEntry.getPath().lastSegment()}));
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }

    private void appendFolderLabel(IPackageFragmentRoot root, long flags) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        if (resource == null) {
            this.appendExternalArchiveLabel(root, flags);
            return;
        }
        boolean rootQualified = JavaElementLabelComposer.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = JavaElementLabelComposer.getFlag(flags, 0x200000000000L) && this.isReferenced(root);
        if (rootQualified) {
            this.fBuilder.append(root.getPath().makeRelative().toString());
        } else {
            IPath projectRelativePath = resource.getProjectRelativePath();
            if (projectRelativePath.segmentCount() == 0) {
                this.fBuilder.append(resource.getName());
                referencedQualified = false;
            } else {
                this.fBuilder.append(projectRelativePath.toString());
            }
            if (referencedQualified) {
                this.fBuilder.append(" - ");
                this.fBuilder.append(resource.getProject().getName());
            } else if (JavaElementLabelComposer.getFlag(flags, 0x40000000000L)) {
                this.fBuilder.append(" - ");
                this.fBuilder.append(root.getParent().getElementName());
            } else {
                return;
            }
        }
    }

    private boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    public static abstract class FlexibleBuilder {
        public abstract FlexibleBuilder append(char var1);

        public abstract FlexibleBuilder append(String var1);

        public abstract int length();
    }

    public static class FlexibleStringBuilder
    extends FlexibleBuilder {
        private final StringBuilder builder;

        public FlexibleStringBuilder(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public FlexibleBuilder append(char ch) {
            this.builder.append(ch);
            return this;
        }

        @Override
        public FlexibleBuilder append(String string) {
            this.builder.append(string);
            return this;
        }

        @Override
        public int length() {
            return this.builder.length();
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

