/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.lsp.DidChangeWorkspaceFoldersParams;
import org.eclipse.jdt.ls.core.internal.lsp.WorkspaceFolder;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;

public class WorkspaceFolderChangeHandler {
    private ProjectsManager projectManager;

    WorkspaceFolderChangeHandler(ProjectsManager projectManager) {
        this.projectManager = projectManager;
    }

    public void update(DidChangeWorkspaceFoldersParams params) {
        IPath rootPath;
        WorkspaceFolder folder;
        ArrayList<IPath> addedRootPaths = new ArrayList<IPath>();
        ArrayList<IPath> removedRootPaths = new ArrayList<IPath>();
        WorkspaceFolder[] workspaceFolderArray = params.getEvent().getAdded();
        int n = workspaceFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            folder = workspaceFolderArray[n2];
            rootPath = ResourceUtils.filePathFromURI(folder.getUri());
            if (rootPath != null) {
                addedRootPaths.add(rootPath);
            }
            ++n2;
        }
        workspaceFolderArray = params.getEvent().getRemoved();
        n = workspaceFolderArray.length;
        n2 = 0;
        while (n2 < n) {
            folder = workspaceFolderArray[n2];
            rootPath = ResourceUtils.filePathFromURI(folder.getUri());
            if (rootPath != null) {
                removedRootPaths.add(rootPath);
            }
            ++n2;
        }
        this.projectManager.updateWorkspaceFolders(addedRootPaths, removedRootPaths);
    }
}

