/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public final class MapFlattener {
    private MapFlattener() {
    }

    public static String getString(Map<String, Object> configuration, String key) {
        return MapFlattener.getString(configuration, key, null);
    }

    public static String getString(Map<String, Object> configuration, String key, String def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof String) {
            return (String)val;
        }
        return def;
    }

    public static List<String> getList(Map<String, Object> configuration, String key) {
        return MapFlattener.getList(configuration, key, null);
    }

    public static List<String> getList(Map<String, Object> configuration, String key, List<String> def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof String) {
            if (!((String)val).trim().startsWith("[")) {
                val = String.valueOf('[') + (String)val + ']';
            }
            try {
                Gson gson = new Gson();
                Type type = new TypeToken<List<String>>(){}.getType();
                List list = (List)gson.fromJson((String)val, type);
                return list;
            }
            catch (JsonSyntaxException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
                return def;
            }
        }
        if (val instanceof List) {
            try {
                List ret = (List)val;
                return ret;
            }
            catch (Exception e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return def;
    }

    public static boolean getBoolean(Map<String, Object> configuration, String key) {
        return MapFlattener.getBoolean(configuration, key, false);
    }

    public static boolean getBoolean(Map<String, Object> configuration, String key, boolean def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.parseBoolean((String)val);
        }
        return def;
    }

    public static int getInt(Map<String, Object> configuration, String key) {
        return MapFlattener.getInt(configuration, key, 0);
    }

    public static int getInt(Map<String, Object> configuration, String key, int def) {
        Object val = MapFlattener.getValue(configuration, key);
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof String) {
            try {
                return Integer.parseInt((String)val);
            }
            catch (NumberFormatException nfe) {
                JavaLanguageServerPlugin.logError(String.valueOf(key) + " value (" + val + ") is not an int, falling back on " + def);
            }
        }
        return def;
    }

    public static Object getValue(Map<String, Object> configuration, String key) {
        Object value = configuration.get(key);
        if (value != null) {
            return value;
        }
        String[] keyParts = key.split("\\.");
        String currKey = null;
        Map currMap = configuration;
        int i = 0;
        while (i < keyParts.length) {
            currKey = keyParts[i];
            Object val = currMap.get(currKey);
            if (i == keyParts.length - 1) {
                return val;
            }
            if (!(val instanceof Map)) {
                return null;
            }
            currMap = (Map)val;
            ++i;
        }
        return null;
    }
}

