/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.BindingLabelProvider;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.ls.core.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.ls.core.internal.corext.dom.Bindings;
import org.eclipse.jdt.ls.core.internal.corrections.ASTResolving;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;
import org.eclipse.jdt.ls.core.internal.corrections.NameMatcher;
import org.eclipse.jdt.ls.core.internal.corrections.SimilarElement;
import org.eclipse.jdt.ls.core.internal.corrections.SimilarElementsRequestor;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.AddArgumentCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.AddImportCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.AddTypeParameterProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CastCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ChangeMethodSignatureProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewAnnotationMemberProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewMethodCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.NewVariableCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.RenameNodeCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ReplaceCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.TypeMismatchSubProcessor;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;

public class UnresolvedElementsSubProcessor {
    public static void getVariableProposals(IInvocationContext context, IProblemLocation problem, IVariableBinding resolvedField, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding binding = null;
        ITypeBinding declaringTypeBinding = Bindings.getBindingOfParentTypeContext(selectedNode);
        if (declaringTypeBinding == null) {
            return;
        }
        boolean suggestVariableProposals = true;
        int typeKind = 0;
        while (selectedNode instanceof ParenthesizedExpression) {
            selectedNode = ((ParenthesizedExpression)selectedNode).getExpression();
        }
        SimpleName node = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                node = (SimpleName)selectedNode;
                ASTNode parent = node.getParent();
                StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
                if (locationInParent == ExpressionMethodReference.EXPRESSION_PROPERTY) {
                    typeKind = 30;
                    break;
                }
                if (locationInParent == MethodInvocation.EXPRESSION_PROPERTY) {
                    if (JavaModelUtil.is18OrHigher((IJavaProject)cu.getJavaProject())) {
                        typeKind = 22;
                        break;
                    }
                    typeKind = 2;
                    break;
                }
                if (locationInParent == FieldAccess.NAME_PROPERTY) {
                    Expression expression = ((FieldAccess)parent).getExpression();
                    if (expression == null || (binding = expression.resolveTypeBinding()) != null) break;
                    node = null;
                    break;
                }
                if (parent instanceof SimpleType || parent instanceof NameQualifiedType) {
                    suggestVariableProposals = false;
                    typeKind = 62;
                    break;
                }
                if (parent instanceof QualifiedName) {
                    Name qualifier = ((QualifiedName)parent).getQualifier();
                    if (qualifier != node) {
                        binding = qualifier.resolveTypeBinding();
                    } else {
                        typeKind = 30;
                    }
                    ASTNode outerParent = parent.getParent();
                    while (outerParent instanceof QualifiedName) {
                        outerParent = outerParent.getParent();
                    }
                    if (!(outerParent instanceof SimpleType) && !(outerParent instanceof NameQualifiedType)) break;
                    typeKind = 30;
                    suggestVariableProposals = false;
                    break;
                }
                if (locationInParent == SwitchCase.EXPRESSION_PROPERTY) {
                    ITypeBinding switchExp = ((SwitchStatement)node.getParent().getParent()).getExpression().resolveTypeBinding();
                    if (switchExp == null || !switchExp.isEnum()) break;
                    binding = switchExp;
                    break;
                }
                if (locationInParent != SuperFieldAccess.NAME_PROPERTY) break;
                binding = declaringTypeBinding.getSuperclass();
                break;
            }
            case 40: {
                QualifiedName qualifierName = (QualifiedName)selectedNode;
                ITypeBinding qualifierBinding = qualifierName.getQualifier().resolveTypeBinding();
                if (qualifierBinding != null) {
                    node = qualifierName.getName();
                    binding = qualifierBinding;
                } else {
                    node = qualifierName.getQualifier();
                    typeKind = 30;
                    suggestVariableProposals = node.isSimpleName();
                }
                if (!(selectedNode.getParent() instanceof SimpleType) && !(selectedNode.getParent() instanceof NameQualifiedType)) break;
                typeKind = 30;
                suggestVariableProposals = false;
                break;
            }
            case 22: {
                FieldAccess access = (FieldAccess)selectedNode;
                Expression expression = access.getExpression();
                if (expression == null || (binding = expression.resolveTypeBinding()) == null) break;
                node = access.getName();
                break;
            }
            case 47: {
                binding = declaringTypeBinding.getSuperclass();
                node = ((SuperFieldAccess)selectedNode).getName();
            }
        }
        if (node == null) {
            return;
        }
        if (typeKind != 0) {
            if (!JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject())) {
                typeKind &= 0xFFFFFFC7;
            }
            int relevance = Character.isUpperCase(ASTNodes.getSimpleNameIdentifier((Name)node).charAt(0)) ? 5 : -2;
            UnresolvedElementsSubProcessor.addSimilarTypeProposals(typeKind, cu, (Name)node, relevance + 1, proposals);
            UnresolvedElementsSubProcessor.addNewTypeProposals(cu, (Name)node, typeKind &= 0xFFFFFFF7, relevance, proposals);
        }
        if (!suggestVariableProposals) {
            return;
        }
        SimpleName simpleName = node.isSimpleName() ? node : ((QualifiedName)node).getName();
        boolean isWriteAccess = ASTResolving.isWriteAccess((Name)node);
        UnresolvedElementsSubProcessor.addSimilarVariableProposals(cu, astRoot, binding, resolvedField, simpleName, isWriteAccess, proposals);
        if (binding == null) {
            UnresolvedElementsSubProcessor.addStaticImportFavoriteProposals(context, simpleName, false, proposals);
        }
        if (resolvedField == null || binding == null || resolvedField.getDeclaringClass() != binding.getTypeDeclaration() && Modifier.isPrivate((int)resolvedField.getModifiers())) {
            UnresolvedElementsSubProcessor.addNewFieldProposals(cu, astRoot, binding, declaringTypeBinding, simpleName, isWriteAccess, proposals);
            if (binding == null) {
                UnresolvedElementsSubProcessor.addNewVariableProposals(cu, (Name)node, simpleName, proposals);
            }
        }
    }

    private static void addNewVariableProposals(ICompilationUnit cu, Name node, SimpleName simpleName, Collection<CUCorrectionProposal> proposals) {
        Assignment assignment;
        String label;
        int relevance;
        String name = simpleName.getIdentifier();
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)node, (boolean)true);
        int type = bodyDeclaration.getNodeType();
        if (type == 31) {
            relevance = StubUtility.hasParameterName(cu.getJavaProject(), name) ? 8 : 5;
            label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createparameter_description, BasicElementLabels.getJavaElementName((String)name));
            proposals.add(new NewVariableCorrectionProposal(label, cu, 3, simpleName, null, relevance));
        }
        if (type == 28 || type == 31 && !ASTResolving.isInsideConstructorInvocation((MethodDeclaration)((MethodDeclaration)bodyDeclaration), (ASTNode)node)) {
            relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
            label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createlocal_description, BasicElementLabels.getJavaElementName((String)name));
            proposals.add(new NewVariableCorrectionProposal(label, cu, 1, simpleName, null, relevance));
        }
        if (node.getParent().getNodeType() == 7 && (assignment = (Assignment)node.getParent()).getLeftHandSide() == node && assignment.getParent().getNodeType() == 21) {
            ASTNode statement = assignment.getParent();
            ASTRewrite rewrite = ASTRewrite.create((AST)statement.getAST());
            if (ASTNodes.isControlStatementBody(assignment.getParent().getLocationInParent())) {
                rewrite.replace(statement, (ASTNode)rewrite.getAST().newBlock(), null);
            } else {
                rewrite.remove(statement, null);
            }
            String label2 = CorrectionMessages.UnresolvedElementsSubProcessor_removestatement_description;
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label2, cu, rewrite, 4);
            proposals.add(proposal);
        }
    }

    private static void addNewFieldProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, ITypeBinding declaringTypeBinding, SimpleName simpleName, boolean isWriteAccess, Collection<CUCorrectionProposal> proposals) throws JavaModelException {
        ITypeBinding bind;
        ASTNode anonymDecl;
        ICompilationUnit targetCU;
        ITypeBinding senderDeclBinding;
        if (binding != null) {
            senderDeclBinding = binding.getTypeDeclaration();
            targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)senderDeclBinding);
        } else {
            senderDeclBinding = declaringTypeBinding;
            targetCU = cu;
        }
        if (!senderDeclBinding.isFromSource() || targetCU == null) {
            return;
        }
        boolean mustBeConst = ASTResolving.isInsideModifiers((ASTNode)simpleName);
        UnresolvedElementsSubProcessor.addNewFieldForType(targetCU, binding, senderDeclBinding, simpleName, isWriteAccess, mustBeConst, proposals);
        if (binding == null && senderDeclBinding.isNested() && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderDeclBinding)) != null && !(bind = Bindings.getBindingOfParentType(anonymDecl.getParent())).isAnonymous()) {
            UnresolvedElementsSubProcessor.addNewFieldForType(targetCU, bind, bind, simpleName, isWriteAccess, mustBeConst, proposals);
        }
    }

    private static void addNewFieldForType(ICompilationUnit targetCU, ITypeBinding binding, ITypeBinding senderDeclBinding, SimpleName simpleName, boolean isWriteAccess, boolean mustBeConst, Collection<CUCorrectionProposal> proposals) {
        String name = simpleName.getIdentifier();
        String nameLabel = BasicElementLabels.getJavaElementName((String)name);
        if (senderDeclBinding.isEnum() && !isWriteAccess) {
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createenum_description, new Object[]{nameLabel, ASTResolving.getTypeSignature(senderDeclBinding)});
            proposals.add(new NewVariableCorrectionProposal(label, targetCU, 5, simpleName, senderDeclBinding, 10));
        } else {
            String label;
            if (!mustBeConst) {
                label = binding == null ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createfield_description, nameLabel) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createfield_other_description, new Object[]{nameLabel, ASTResolving.getTypeSignature(senderDeclBinding)});
                int fieldRelevance = StubUtility.hasFieldName(targetCU.getJavaProject(), name) ? 9 : 6;
                proposals.add(new NewVariableCorrectionProposal(label, targetCU, 2, simpleName, senderDeclBinding, fieldRelevance));
            }
            if (!isWriteAccess && !senderDeclBinding.isAnonymous()) {
                label = binding == null ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createconst_description, nameLabel) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createconst_other_description, new Object[]{nameLabel, ASTResolving.getTypeSignature(senderDeclBinding)});
                int constRelevance = StubUtility.hasConstantName(targetCU.getJavaProject(), name) ? 9 : 4;
                proposals.add(new NewVariableCorrectionProposal(label, targetCU, 4, simpleName, senderDeclBinding, constRelevance));
            }
        }
    }

    private static void addSimilarVariableProposals(ICompilationUnit cu, CompilationUnit astRoot, ITypeBinding binding, IVariableBinding resolvedField, SimpleName node, boolean isWriteAccess, Collection<CUCorrectionProposal> proposals) {
        IBinding[] varsAndMethodsInScope;
        int kind = 18;
        if (!isWriteAccess) {
            kind |= 1;
        }
        if ((varsAndMethodsInScope = new ScopeAnalyzer(astRoot).getDeclarationsInScope(node, kind)).length > 0) {
            String otherNameInAssign = null;
            String methodSenderName = null;
            String fieldSenderName = null;
            ASTNode parent = node.getParent();
            switch (parent.getNodeType()) {
                case 59: {
                    otherNameInAssign = ((VariableDeclarationFragment)parent).getName().getIdentifier();
                    break;
                }
                case 7: {
                    Assignment assignment = (Assignment)parent;
                    if (isWriteAccess && assignment.getRightHandSide() instanceof SimpleName) {
                        otherNameInAssign = ((SimpleName)assignment.getRightHandSide()).getIdentifier();
                        break;
                    }
                    if (isWriteAccess || !(assignment.getLeftHandSide() instanceof SimpleName)) break;
                    otherNameInAssign = ((SimpleName)assignment.getLeftHandSide()).getIdentifier();
                    break;
                }
                case 32: {
                    MethodInvocation inv = (MethodInvocation)parent;
                    if (inv.getExpression() != node) break;
                    methodSenderName = inv.getName().getIdentifier();
                    break;
                }
                case 40: {
                    QualifiedName qualName = (QualifiedName)parent;
                    if (qualName.getQualifier() != node) break;
                    fieldSenderName = qualName.getName().getIdentifier();
                }
            }
            ITypeBinding guessedType = ASTResolving.guessBindingForReference((ASTNode)node);
            ITypeBinding objectBinding = astRoot.getAST().resolveWellKnownType("java.lang.Object");
            String identifier = node.getIdentifier();
            boolean isInStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            ArrayList<CUCorrectionProposal> newProposals = new ArrayList<CUCorrectionProposal>(51);
            int i = 0;
            while (i < varsAndMethodsInScope.length && newProposals.size() <= 50) {
                IVariableBinding curr;
                IBinding varOrMeth = varsAndMethodsInScope[i];
                if (varOrMeth instanceof IVariableBinding) {
                    boolean isFinal;
                    curr = (IVariableBinding)varOrMeth;
                    String currName = curr.getName();
                    if (!(currName.equals(otherNameInAssign) || resolvedField != null && Bindings.equals((IBinding)resolvedField, (IBinding)curr) || (isFinal = Modifier.isFinal((int)curr.getModifiers())) && curr.isField() && isWriteAccess || isInStaticContext && !Modifier.isStatic((int)curr.getModifiers()) && curr.isField())) {
                        ITypeBinding varType;
                        int relevance = 0;
                        if (NameMatcher.isSimilarName(currName, identifier)) {
                            relevance += 3;
                        }
                        if (currName.equalsIgnoreCase(identifier)) {
                            relevance += 5;
                        }
                        if ((varType = curr.getType()) != null) {
                            if (guessedType != null && guessedType != objectBinding && (!isWriteAccess && UnresolvedElementsSubProcessor.canAssign(varType, guessedType) || isWriteAccess && UnresolvedElementsSubProcessor.canAssign(guessedType, varType))) {
                                relevance += 2;
                            }
                            if (methodSenderName != null && UnresolvedElementsSubProcessor.hasMethodWithName(varType, methodSenderName)) {
                                relevance += 2;
                            }
                            if (fieldSenderName != null && UnresolvedElementsSubProcessor.hasFieldWithName(varType, fieldSenderName)) {
                                relevance += 2;
                            }
                        }
                        if (relevance > 0) {
                            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changevariable_description, BasicElementLabels.getJavaElementName((String)currName));
                            newProposals.add(new RenameNodeCorrectionProposal(label, cu, node.getStartPosition(), node.getLength(), currName, relevance));
                        }
                    }
                } else if (varOrMeth instanceof IMethodBinding && !(curr = (IMethodBinding)varOrMeth).isConstructor() && guessedType != null && UnresolvedElementsSubProcessor.canAssign(curr.getReturnType(), guessedType) && NameMatcher.isSimilarName(curr.getName(), identifier)) {
                    AST ast = astRoot.getAST();
                    ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                    String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetomethod_description, ASTResolving.getMethodSignature((IMethodBinding)curr));
                    ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 8);
                    newProposals.add(proposal);
                    MethodInvocation newInv = ast.newMethodInvocation();
                    newInv.setName(ast.newSimpleName(curr.getName()));
                    ITypeBinding[] parameterTypes = curr.getParameterTypes();
                    int k = 0;
                    while (k < parameterTypes.length) {
                        Expression arg = ASTNodeFactory.newDefaultExpression(ast, parameterTypes[k]);
                        newInv.arguments().add(arg);
                        ++k;
                    }
                    rewrite.replace((ASTNode)node, (ASTNode)newInv, null);
                }
                ++i;
            }
            if (newProposals.size() <= 50) {
                proposals.addAll(newProposals);
            }
        }
        if (binding != null && binding.isArray()) {
            String idLength = "length";
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changevariable_description, idLength);
            proposals.add(new RenameNodeCorrectionProposal(label, cu, node.getStartPosition(), node.getLength(), idLength, 8));
        }
    }

    private static boolean canAssign(ITypeBinding returnType, ITypeBinding guessedType) {
        return returnType.isAssignmentCompatible(guessedType);
    }

    private static boolean hasMethodWithName(ITypeBinding typeBinding, String name) {
        IVariableBinding[] fields = typeBinding.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return UnresolvedElementsSubProcessor.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private static boolean hasFieldWithName(ITypeBinding typeBinding, String name) {
        IMethodBinding[] methods = typeBinding.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        if (superclass != null) {
            return UnresolvedElementsSubProcessor.hasMethodWithName(superclass, name);
        }
        return false;
    }

    private static int evauateTypeKind(ASTNode node, IJavaProject project) {
        int kind = ASTResolving.getPossibleTypeKinds(node, JavaModelUtil.is50OrHigher((IJavaProject)project));
        return kind;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getTypeProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        int kind = UnresolvedElementsSubProcessor.evauateTypeKind(selectedNode, cu.getJavaProject());
        if (kind == 30) {
            UnresolvedElementsSubProcessor.addEnhancedForWithoutTypeProposals(cu, selectedNode, proposals);
        }
        while (selectedNode.getLocationInParent() == QualifiedName.NAME_PROPERTY) {
            selectedNode = selectedNode.getParent();
        }
        Name node = null;
        if (selectedNode instanceof SimpleType) {
            node = ((SimpleType)selectedNode).getName();
        } else if (selectedNode instanceof NameQualifiedType) {
            node = ((NameQualifiedType)selectedNode).getName();
        } else if (selectedNode instanceof ArrayType) {
            Type elementType = ((ArrayType)selectedNode).getElementType();
            if (elementType.isSimpleType()) {
                node = ((SimpleType)elementType).getName();
            } else {
                if (!elementType.isNameQualifiedType()) return;
                node = ((NameQualifiedType)elementType).getName();
            }
        } else {
            if (!(selectedNode instanceof Name)) return;
            node = (Name)selectedNode;
        }
        UnresolvedElementsSubProcessor.addSimilarTypeProposals(kind, cu, node, 3, proposals);
        while (node.getParent() instanceof QualifiedName) {
            node = (Name)node.getParent();
        }
        if (selectedNode != node) {
            kind = UnresolvedElementsSubProcessor.evauateTypeKind((ASTNode)node, cu.getJavaProject());
        }
        if ((kind & 6) != 0) {
            kind &= 0xFFFFFFF7;
        }
        UnresolvedElementsSubProcessor.addNewTypeProposals(cu, node, kind, 0, proposals);
    }

    private static void addEnhancedForWithoutTypeProposals(ICompilationUnit cu, ASTNode selectedNode, Collection<CUCorrectionProposal> proposals) {
        SingleVariableDeclaration svd;
        ASTNode type;
        if (selectedNode instanceof SimpleName && (selectedNode.getLocationInParent() == SimpleType.NAME_PROPERTY || selectedNode.getLocationInParent() == NameQualifiedType.NAME_PROPERTY) && (type = selectedNode.getParent()).getLocationInParent() == SingleVariableDeclaration.TYPE_PROPERTY && (svd = (SingleVariableDeclaration)type.getParent()).getLocationInParent() == EnhancedForStatement.PARAMETER_PROPERTY && svd.getName().getLength() == 0) {
            SimpleName simpleName = (SimpleName)selectedNode;
            String name = simpleName.getIdentifier();
            int relevance = StubUtility.hasLocalVariableName(cu.getJavaProject(), name) ? 10 : 7;
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_create_loop_variable_description, BasicElementLabels.getJavaElementName((String)name));
            proposals.add(new NewVariableCorrectionProposal(label, cu, 1, simpleName, null, relevance));
        }
    }

    static CompilationUnitChange createAddImportChange(ICompilationUnit cu, Name name, String fullyQualifiedName) throws CoreException {
        Object[] args = new String[]{BasicElementLabels.getJavaElementName((String)Signature.getSimpleName((String)fullyQualifiedName)), BasicElementLabels.getJavaElementName((String)Signature.getQualifier((String)fullyQualifiedName))};
        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_importtype_description, args);
        CompilationUnitChange cuChange = new CompilationUnitChange(label, cu);
        ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)name.getRoot(), true);
        importRewrite.addImport(fullyQualifiedName);
        cuChange.setEdit(importRewrite.rewriteImports(null));
        return cuChange;
    }

    private static void addSimilarTypeProposals(int kind, ICompilationUnit cu, Name node, int relevance, Collection<CUCorrectionProposal> proposals) throws CoreException {
        SimilarElement[] elements = SimilarElementsRequestor.findSimilarElement(cu, node, kind);
        String resolvedTypeName = null;
        ITypeBinding binding = ASTResolving.guessBindingForTypeReference((ASTNode)node);
        if (binding != null) {
            ITypeBinding simpleBinding = binding;
            if (simpleBinding.isArray()) {
                simpleBinding = simpleBinding.getElementType();
            }
            if (!(simpleBinding = simpleBinding.getTypeDeclaration()).isRecovered()) {
                resolvedTypeName = simpleBinding.getQualifiedName();
                CUCorrectionProposal proposal = UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, resolvedTypeName, node, relevance + 2, elements.length);
                proposals.add(proposal);
                if (proposal instanceof AddImportCorrectionProposal) {
                    proposal.setRelevance(relevance + elements.length + 2);
                }
                if (binding.isParameterizedType() && (node.getParent() instanceof SimpleType || node.getParent() instanceof NameQualifiedType) && !(node.getParent().getParent() instanceof Type)) {
                    proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeFullProposal(cu, binding, (ASTNode)node, relevance + 5));
                }
            }
        } else {
            ITypeBinding normBinding;
            ASTNode normalizedNode = ASTNodes.getNormalizedNode((ASTNode)node);
            if (!(normalizedNode.getParent() instanceof Type) && node.getParent() != normalizedNode && (normBinding = ASTResolving.guessBindingForTypeReference((ASTNode)normalizedNode)) != null && !normBinding.isRecovered()) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeFullProposal(cu, normBinding, normalizedNode, relevance + 5));
            }
        }
        int i = 0;
        while (i < elements.length) {
            String fullName;
            SimilarElement elem = elements[i];
            if ((elem.getKind() & 0x7E) != 0 && !(fullName = elem.getName()).equals(resolvedTypeName)) {
                proposals.add(UnresolvedElementsSubProcessor.createTypeRefChangeProposal(cu, fullName, node, relevance, elements.length));
            }
            ++i;
        }
    }

    private static CUCorrectionProposal createTypeRefChangeProposal(ICompilationUnit cu, String fullName, Name node, int relevance, int maxProposals) {
        ASTRewriteCorrectionProposal proposal;
        ImportRewrite importRewrite = null;
        String simpleName = fullName;
        String packName = Signature.getQualifier((String)fullName);
        if (packName.length() > 0) {
            importRewrite = StubUtility.createImportRewrite((CompilationUnit)node.getRoot(), true);
            BodyDeclaration scope = ASTResolving.findParentBodyDeclaration((ASTNode)node);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)(scope != null ? scope : node), importRewrite);
            simpleName = importRewrite.addImport(fullName, (ImportRewrite.ImportRewriteContext)context);
        }
        if (!UnresolvedElementsSubProcessor.isLikelyTypeName(simpleName)) {
            relevance -= 2;
        }
        if (importRewrite != null && node.isSimpleName() && simpleName.equals(((SimpleName)node).getIdentifier())) {
            Object[] arg = new String[]{BasicElementLabels.getJavaElementName((String)simpleName), BasicElementLabels.getJavaElementName((String)packName)};
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_importtype_description, arg);
            proposal = new AddImportCorrectionProposal(label, cu, relevance + 100, packName, simpleName, (SimpleName)node);
        } else {
            String label;
            if (packName.length() == 0) {
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetype_nopack_description, BasicElementLabels.getJavaElementName((String)simpleName));
            } else {
                Object[] arg = new String[]{BasicElementLabels.getJavaElementName((String)simpleName), BasicElementLabels.getJavaElementName((String)packName)};
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetype_description, arg);
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
            rewrite.replace((ASTNode)node, rewrite.createStringPlaceholder(simpleName, 43), null);
            proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance);
        }
        if (importRewrite != null) {
            proposal.setImportRewrite(importRewrite);
        }
        return proposal;
    }

    static CUCorrectionProposal createTypeRefChangeFullProposal(ICompilationUnit cu, ITypeBinding binding, ASTNode node, int relevance) {
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_change_full_type_description, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_DEFAULT));
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, relevance);
        ImportRewrite imports = proposal.createImportRewrite((CompilationUnit)node.getRoot());
        Type type = imports.addImport(binding, node.getAST());
        rewrite.replace(node, (ASTNode)type, null);
        return proposal;
    }

    private static boolean isLikelyTypeName(String name) {
        return name.length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    private static boolean isLikelyPackageName(String name) {
        if (name.length() != 0) {
            int i = 0;
            do {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                return false;
            } while ((i = name.indexOf(46, i) + 1) != 0 && i < name.length());
        }
        return true;
    }

    private static boolean isLikelyTypeParameterName(String name) {
        return name.length() == 1 && Character.isUpperCase(name.charAt(0));
    }

    private static boolean isLikelyMethodTypeParameterName(String name) {
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case 'S': 
                case 'T': 
                case 'U': {
                    return true;
                }
            }
        }
        return false;
    }

    public static void addNewTypeProposals(ICompilationUnit cu, Name refNode, int kind, int relevance, Collection<CUCorrectionProposal> proposals) throws CoreException {
        Name node = refNode;
        if (refNode.isSimpleName() && (kind & 0x20) != 0) {
            CompilationUnit root = (CompilationUnit)refNode.getRoot();
            String name = ((SimpleName)refNode).getIdentifier();
            Object declaration = ASTResolving.findParentBodyDeclaration((ASTNode)refNode);
            int baseRel = relevance;
            if (UnresolvedElementsSubProcessor.isLikelyTypeParameterName(name)) {
                baseRel += 8;
            }
            while (declaration != null) {
                IMethodBinding binding = null;
                int rel = baseRel;
                if (declaration instanceof MethodDeclaration) {
                    binding = ((MethodDeclaration)declaration).resolveBinding();
                    if (UnresolvedElementsSubProcessor.isLikelyMethodTypeParameterName(name)) {
                        rel += 2;
                    }
                } else if (declaration instanceof TypeDeclaration) {
                    binding = ((TypeDeclaration)declaration).resolveBinding();
                    ++rel;
                }
                if (binding != null) {
                    AddTypeParameterProposal proposal = new AddTypeParameterProposal(cu, (IBinding)binding, root, name, null, rel);
                    proposals.add(proposal);
                }
                declaration = !Modifier.isStatic((int)declaration.getModifiers()) ? ASTResolving.findParentBodyDeclaration((ASTNode)declaration.getParent()) : null;
            }
        }
    }

    public static void getMethodProposals(IInvocationContext context, IProblemLocation problem, boolean isOnlyParameterMismatch, Collection<CUCorrectionProposal> proposals) throws CoreException {
        boolean isSuperInvocation;
        Expression sender;
        List arguments;
        MethodInvocation methodImpl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        ASTNode invocationNode = nameNode.getParent();
        if (invocationNode instanceof MethodInvocation) {
            methodImpl = (MethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getExpression();
            isSuperInvocation = false;
        } else if (invocationNode instanceof SuperMethodInvocation) {
            methodImpl = (SuperMethodInvocation)invocationNode;
            arguments = methodImpl.arguments();
            sender = methodImpl.getQualifier();
            isSuperInvocation = true;
        } else {
            return;
        }
        String methodName = nameNode.getIdentifier();
        int nArguments = arguments.size();
        IBinding[] bindings = new ScopeAnalyzer(astRoot).getDeclarationsInScope(nameNode, 1);
        HashSet<String> suggestedRenames = new HashSet<String>();
        int i = 0;
        while (i < bindings.length) {
            IMethodBinding binding = (IMethodBinding)bindings[i];
            String curr = binding.getName();
            if (!curr.equals(methodName) && binding.getParameterTypes().length == nArguments && NameMatcher.isSimilarName(methodName, curr) && suggestedRenames.add(curr)) {
                String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changemethod_description, BasicElementLabels.getJavaElementName((String)curr));
                proposals.add(new RenameNodeCorrectionProposal(label, context.getCompilationUnit(), problem.getOffset(), problem.getLength(), curr, 6));
            }
            ++i;
        }
        suggestedRenames = null;
        if (isOnlyParameterMismatch) {
            ArrayList<IMethodBinding> parameterMismatchs = new ArrayList<IMethodBinding>();
            int i2 = 0;
            while (i2 < bindings.length) {
                IMethodBinding binding = (IMethodBinding)bindings[i2];
                if (binding.getName().equals(methodName)) {
                    parameterMismatchs.add(binding);
                }
                ++i2;
            }
            UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, problem, parameterMismatchs, invocationNode, arguments, proposals);
        }
        if (sender == null) {
            UnresolvedElementsSubProcessor.addStaticImportFavoriteProposals(context, nameNode, true, proposals);
        }
        UnresolvedElementsSubProcessor.addNewMethodProposals(cu, astRoot, sender, arguments, isSuperInvocation, invocationNode, methodName, proposals);
        if (!isOnlyParameterMismatch && !isSuperInvocation && sender != null) {
            UnresolvedElementsSubProcessor.addMissingCastParentsProposal(cu, (MethodInvocation)invocationNode, proposals);
        }
        if (!isSuperInvocation && sender == null && invocationNode.getParent() instanceof ThrowStatement) {
            String str = "new ";
            String label = CorrectionMessages.UnresolvedElementsSubProcessor_addnewkeyword_description;
            int relevance = Character.isUpperCase(methodName.charAt(0)) ? 7 : 4;
            ReplaceCorrectionProposal proposal = new ReplaceCorrectionProposal(label, cu, invocationNode.getStartPosition(), 0, str, relevance);
            proposals.add(proposal);
        }
    }

    private static void addStaticImportFavoriteProposals(IInvocationContext context, SimpleName node, boolean isMethod, Collection<CUCorrectionProposal> proposals) throws JavaModelException {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        if (JavaModelUtil.is50OrHigher((IJavaProject)project)) {
            String[] favourites = PreferenceManager.getPrefs(context.getCompilationUnit().getResource()).getJavaCompletionFavoriteMembers();
            if (favourites.length == 0) {
                return;
            }
            CompilationUnit root = context.getASTRoot();
            AST ast = root.getAST();
            String name = node.getIdentifier();
            String[] staticImports = SimilarElementsRequestor.getStaticImportFavorites(context.getCompilationUnit(), name, isMethod, favourites);
            int i = 0;
            while (i < staticImports.length) {
                String label;
                String curr = staticImports[i];
                ImportRewrite importRewrite = StubUtility.createImportRewrite(root, true);
                ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
                String qualifiedTypeName = Signature.getQualifier((String)curr);
                String elementLabel = BasicElementLabels.getJavaElementName((String)JavaModelUtil.concatenateName((String)Signature.getSimpleName((String)qualifiedTypeName), (String)name));
                String res = importRewrite.addStaticImport(qualifiedTypeName, name, isMethod, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(root, node.getStartPosition(), importRewrite));
                int dot = res.lastIndexOf(46);
                if (dot != -1) {
                    String usedTypeName = importRewrite.addImport(qualifiedTypeName);
                    QualifiedName newName = ast.newQualifiedName(ast.newName(usedTypeName), ast.newSimpleName(name));
                    astRewrite.replace((ASTNode)node, (ASTNode)newName, null);
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_change_to_static_import_description, elementLabel);
                } else {
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_static_import_description, elementLabel);
                }
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), astRewrite, 5);
                proposal.setImportRewrite(importRewrite);
                proposals.add(proposal);
                ++i;
            }
        }
    }

    private static void addNewMethodProposals(ICompilationUnit cu, CompilationUnit astRoot, Expression sender, List<Expression> arguments, boolean isSuperInvocation, ASTNode invocationNode, String methodName, Collection<CUCorrectionProposal> proposals) throws JavaModelException {
        ITypeBinding[] parameterTypes;
        ITypeBinding senderDeclBinding;
        ICompilationUnit targetCU;
        ITypeBinding nodeParentType = Bindings.getBindingOfParentType(invocationNode);
        ITypeBinding binding = null;
        if (sender != null) {
            binding = sender.resolveTypeBinding();
        } else {
            binding = nodeParentType;
            if (isSuperInvocation && binding != null) {
                binding = binding.getSuperclass();
            }
        }
        if (binding != null && binding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)(senderDeclBinding = binding.getTypeDeclaration()))) != null && (parameterTypes = UnresolvedElementsSubProcessor.getParameterTypes(arguments)) != null) {
            ASTNode anonymDecl;
            String sig = ASTResolving.getMethodSignature(methodName, parameterTypes, false);
            boolean is18OrHigher = JavaModelUtil.is18OrHigher((IJavaProject)targetCU.getJavaProject());
            boolean isSenderBindingInterface = senderDeclBinding.isInterface();
            String label = nodeParentType == senderDeclBinding ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_description, sig) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_other_description, new Object[]{sig, BasicElementLabels.getJavaElementName((String)senderDeclBinding.getName())});
            if (is18OrHigher || !isSenderBindingInterface || nodeParentType != senderDeclBinding && (!(sender instanceof SimpleName) || !((SimpleName)sender).getIdentifier().equals(senderDeclBinding.getName()))) {
                proposals.add(new NewMethodCorrectionProposal(label, targetCU, invocationNode, arguments, senderDeclBinding, 5));
            }
            if (senderDeclBinding.isNested() && cu.equals(targetCU) && sender == null && Bindings.findMethodInHierarchy(senderDeclBinding, methodName, null) == null && (anonymDecl = astRoot.findDeclaringNode((IBinding)senderDeclBinding)) != null) {
                senderDeclBinding = Bindings.getBindingOfParentType(anonymDecl.getParent());
                isSenderBindingInterface = senderDeclBinding.isInterface();
                if (!(senderDeclBinding.isAnonymous() || !is18OrHigher && isSenderBindingInterface)) {
                    Object[] args = new String[]{sig, ASTResolving.getTypeSignature(senderDeclBinding)};
                    label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createmethod_other_description, args);
                    proposals.add(new NewMethodCorrectionProposal(label, targetCU, invocationNode, arguments, senderDeclBinding, 5));
                }
            }
        }
    }

    private static void addMissingCastParentsProposal(ICompilationUnit cu, MethodInvocation invocationNode, Collection<CUCorrectionProposal> proposals) {
        Expression sender = invocationNode.getExpression();
        if (sender instanceof ThisExpression) {
            return;
        }
        ITypeBinding senderBinding = sender.resolveTypeBinding();
        if (senderBinding == null || Modifier.isFinal((int)senderBinding.getModifiers())) {
            return;
        }
        if (sender instanceof Name && ((Name)sender).resolveBinding() instanceof ITypeBinding) {
            return;
        }
        ASTNode parent = invocationNode.getParent();
        while (parent instanceof Expression && parent.getNodeType() != 11) {
            parent = parent.getParent();
        }
        boolean hasCastProposal = false;
        if (parent instanceof CastExpression) {
            hasCastProposal = UnresolvedElementsSubProcessor.useExistingParentCastProposal(cu, (CastExpression)parent, sender, invocationNode.getName(), UnresolvedElementsSubProcessor.getArgumentTypes(invocationNode.arguments()), proposals);
        }
        if (!hasCastProposal) {
            String label;
            Expression target = sender;
            while (target instanceof ParenthesizedExpression) {
                target = ((ParenthesizedExpression)target).getExpression();
            }
            if (target.getNodeType() != 11) {
                String targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)target);
                }
                label = targetName == null ? CorrectionMessages.UnresolvedElementsSubProcessor_methodtargetcast_description : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_methodtargetcast2_description, BasicElementLabels.getJavaCodeString((String)targetName));
            } else {
                String targetName = null;
                if (target.getLength() <= 18) {
                    targetName = ASTNodes.asString((ASTNode)((CastExpression)target).getExpression());
                }
                label = targetName == null ? CorrectionMessages.UnresolvedElementsSubProcessor_changemethodtargetcast_description : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changemethodtargetcast2_description, BasicElementLabels.getJavaCodeString((String)targetName));
            }
            proposals.add(new CastCorrectionProposal(label, cu, target, null, 3));
        }
    }

    private static boolean useExistingParentCastProposal(ICompilationUnit cu, CastExpression expression, Expression accessExpression, SimpleName accessSelector, ITypeBinding[] paramTypes, Collection<CUCorrectionProposal> proposals) {
        ITypeBinding castType = expression.getType().resolveBinding();
        if (castType == null) {
            return false;
        }
        if (paramTypes != null ? Bindings.findMethodInHierarchy(castType, accessSelector.getIdentifier(), paramTypes) == null : Bindings.findFieldInHierarchy(castType, accessSelector.getIdentifier()) == null) {
            return false;
        }
        ITypeBinding bindingToCast = accessExpression.resolveTypeBinding();
        if (bindingToCast != null && !bindingToCast.isCastCompatible(castType)) {
            return false;
        }
        IMethodBinding res = Bindings.findMethodInHierarchy(castType, accessSelector.getIdentifier(), paramTypes);
        if (res != null) {
            AST ast = expression.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            CastExpression newCast = ast.newCastExpression();
            newCast.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)expression.getType()));
            newCast.setExpression((Expression)rewrite.createCopyTarget((ASTNode)accessExpression));
            ParenthesizedExpression parents = ast.newParenthesizedExpression();
            parents.setExpression((Expression)newCast);
            ASTNode node = rewrite.createCopyTarget((ASTNode)expression.getExpression());
            rewrite.replace((ASTNode)expression, node, null);
            rewrite.replace((ASTNode)accessExpression, (ASTNode)parents, null);
            String label = CorrectionMessages.UnresolvedElementsSubProcessor_missingcastbrackets_description;
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 8);
            proposals.add(proposal);
            return true;
        }
        return false;
    }

    private static void addParameterMissmatchProposals(IInvocationContext context, IProblemLocation problem, List<IMethodBinding> similarElements, ASTNode invocationNode, List<Expression> arguments, Collection<CUCorrectionProposal> proposals) throws CoreException {
        int nSimilarElements = similarElements.size();
        ITypeBinding[] argTypes = UnresolvedElementsSubProcessor.getArgumentTypes(arguments);
        if (argTypes == null || nSimilarElements == 0) {
            return;
        }
        int i = 0;
        while (i < nSimilarElements) {
            IMethodBinding elem = similarElements.get(i);
            int diff = elem.getParameterTypes().length - argTypes.length;
            if (diff == 0) {
                int nProposals = proposals.size();
                UnresolvedElementsSubProcessor.doEqualNumberOfParameters(context, invocationNode, problem, arguments, argTypes, elem, proposals);
                if (nProposals != proposals.size()) {
                    return;
                }
            } else if (diff > 0) {
                UnresolvedElementsSubProcessor.doMoreParameters(context, invocationNode, argTypes, elem, proposals);
            } else {
                UnresolvedElementsSubProcessor.doMoreArguments(context, invocationNode, arguments, argTypes, elem, proposals);
            }
            ++i;
        }
    }

    private static void doMoreParameters(IInvocationContext context, ASTNode invocationNode, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = paramTypes.length - argTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < paramTypes.length) {
            if (k < argTypes.length && UnresolvedElementsSubProcessor.canAssign(argTypes[k], paramTypes[i])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ITypeBinding declaringType = methodBinding.getDeclaringClass();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        Object[] arg = new String[]{ASTResolving.getMethodSignature(methodBinding)};
        String label = diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addargument_description, arg) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addarguments_description, arg);
        AddArgumentCorrectionProposal proposal = new AddArgumentCorrectionProposal(label, context.getCompilationUnit(), invocationNode, indexSkipped, paramTypes, 8);
        proposals.add(proposal);
        if (!declaringType.isFromSource()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringType);
        if (targetCU != null) {
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            ITypeBinding[] declParameterTypes = methodDecl.getParameterTypes();
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[declParameterTypes.length];
            ITypeBinding[] changedTypes = new ITypeBinding[diff];
            int i2 = diff - 1;
            while (i2 >= 0) {
                int idx = indexSkipped[i2];
                changeDesc[idx] = new ChangeMethodSignatureProposal.RemoveDescription();
                changedTypes[i2] = declParameterTypes[idx];
                --i2;
            }
            Object[] arg2 = new String[]{ASTResolving.getMethodSignature(methodDecl), UnresolvedElementsSubProcessor.getTypeNames(changedTypes)};
            String label2 = methodDecl.isConstructor() ? (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparam_constr_description, arg2) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparams_constr_description, arg2)) : (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparam_description, arg2) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeparams_description, arg2));
            ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU, invocationNode, methodDecl, changeDesc, null, 5);
            proposals.add(proposal2);
        }
    }

    private static String getTypeNames(ITypeBinding[] types) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(ASTResolving.getTypeSignature(types[i]));
            ++i;
        }
        return BasicElementLabels.getJavaElementName((String)buf.toString());
    }

    private static String getArgumentName(List<Expression> arguments, int index) {
        String def = String.valueOf(index + 1);
        ASTNode expr = (ASTNode)arguments.get(index);
        if (expr.getLength() > 18) {
            return def;
        }
        ASTMatcher matcher = new ASTMatcher();
        int i = 0;
        while (i < arguments.size()) {
            if (i != index && matcher.safeSubtreeMatch((Object)expr, (Object)arguments.get(i))) {
                return def;
            }
            ++i;
        }
        return String.valueOf('\'') + BasicElementLabels.getJavaElementName((String)ASTNodes.asString(expr)) + '\'';
    }

    private static void doMoreArguments(IInvocationContext context, ASTNode invocationNode, List<Expression> arguments, ITypeBinding[] argTypes, IMethodBinding methodRef, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ITypeBinding[] paramTypes = methodRef.getParameterTypes();
        int k = 0;
        int nSkipped = 0;
        int diff = argTypes.length - paramTypes.length;
        int[] indexSkipped = new int[diff];
        int i = 0;
        while (i < argTypes.length) {
            if (k < paramTypes.length && UnresolvedElementsSubProcessor.canAssign(argTypes[i], paramTypes[k])) {
                ++k;
            } else {
                if (nSkipped >= diff) {
                    return;
                }
                indexSkipped[nSkipped++] = i;
            }
            ++i;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        int i2 = diff - 1;
        while (i2 >= 0) {
            rewrite.remove((ASTNode)arguments.get(indexSkipped[i2]), null);
            --i2;
        }
        Object[] arg = new String[]{ASTResolving.getMethodSignature(methodRef)};
        String label = diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removeargument_description, arg) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_removearguments_description, arg);
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 8);
        proposals.add(proposal);
        IMethodBinding methodDecl = methodRef.getMethodDeclaration();
        ITypeBinding declaringType = methodDecl.getDeclaringClass();
        if (!declaringType.isFromSource()) {
            return;
        }
        ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringType);
        if (targetCU != null) {
            if (UnresolvedElementsSubProcessor.isImplicitConstructor(methodDecl)) {
                return;
            }
            ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[argTypes.length];
            ITypeBinding[] changeTypes = new ITypeBinding[diff];
            int i3 = diff - 1;
            while (i3 >= 0) {
                int idx = indexSkipped[i3];
                Expression arg2 = arguments.get(idx);
                String name = UnresolvedElementsSubProcessor.getExpressionBaseName(arg2);
                ITypeBinding newType = Bindings.normalizeTypeBinding(argTypes[idx]);
                if (newType == null) {
                    newType = astRoot.getAST().resolveWellKnownType("java.lang.Object");
                }
                if (newType.isWildcardType()) {
                    newType = ASTResolving.normalizeWildcardType((ITypeBinding)newType, (boolean)true, (AST)astRoot.getAST());
                }
                if (!ASTResolving.isUseableTypeInContext((ITypeBinding)newType, (IBinding)methodDecl, (boolean)false)) {
                    return;
                }
                changeDesc[idx] = new ChangeMethodSignatureProposal.InsertDescription(newType, name);
                changeTypes[i3] = newType;
                --i3;
            }
            Object[] arg3 = new String[]{ASTResolving.getMethodSignature(methodDecl), UnresolvedElementsSubProcessor.getTypeNames(changeTypes)};
            String label2 = methodDecl.isConstructor() ? (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparam_constr_description, arg3) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparams_constr_description, arg3)) : (diff == 1 ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparam_description, arg3) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addparams_description, arg3));
            ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU, invocationNode, methodDecl, changeDesc, null, 5);
            proposals.add(proposal2);
        }
    }

    private static boolean isImplicitConstructor(IMethodBinding meth) {
        return meth.isDefaultConstructor();
    }

    private static ITypeBinding[] getParameterTypes(List<Expression> args) {
        ITypeBinding[] params = new ITypeBinding[args.size()];
        int i = 0;
        while (i < args.size()) {
            Expression expr = args.get(i);
            ITypeBinding curr = Bindings.normalizeTypeBinding(expr.resolveTypeBinding());
            if (curr != null && curr.isWildcardType()) {
                curr = ASTResolving.normalizeWildcardType((ITypeBinding)curr, (boolean)true, (AST)expr.getAST());
            }
            if (curr == null) {
                curr = expr.getAST().resolveWellKnownType("java.lang.Object");
            }
            params[i] = curr;
            ++i;
        }
        return params;
    }

    private static void doEqualNumberOfParameters(IInvocationContext context, ASTNode invocationNode, IProblemLocation problem, List<Expression> arguments, ITypeBinding[] argTypes, IMethodBinding methodBinding, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ChangeMethodSignatureProposal.ChangeDescription[] changeDesc;
        ICompilationUnit targetCU;
        String label;
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        int[] indexOfDiff = new int[paramTypes.length];
        int nDiffs = 0;
        int n = 0;
        while (n < argTypes.length) {
            if (!UnresolvedElementsSubProcessor.canAssign(argTypes[n], paramTypes[n])) {
                indexOfDiff[nDiffs++] = n;
            }
            ++n;
        }
        ITypeBinding declaringTypeDecl = methodBinding.getDeclaringClass().getTypeDeclaration();
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode nameNode = problem.getCoveringNode(astRoot);
        if (nameNode == null) {
            return;
        }
        if (nDiffs == 0) {
            MethodInvocation inv;
            if (nameNode.getParent() instanceof MethodInvocation && (inv = (MethodInvocation)nameNode.getParent()).getExpression() == null) {
                UnresolvedElementsSubProcessor.addQualifierToOuterProposal(context, inv, methodBinding, proposals);
            }
            return;
        }
        if (nDiffs == 1) {
            int idx = indexOfDiff[0];
            Expression nodeToCast = arguments.get(idx);
            ITypeBinding castType = paramTypes[idx];
            if ((castType = Bindings.normalizeTypeBinding(castType)).isWildcardType()) {
                castType = ASTResolving.normalizeWildcardType((ITypeBinding)castType, (boolean)false, (AST)nodeToCast.getAST());
            }
            if (castType != null) {
                ITypeBinding boxUnboxedTypeBinding;
                ITypeBinding binding = nodeToCast.resolveTypeBinding();
                ITypeBinding castFixType = null;
                if (binding == null || castType.isCastCompatible(binding)) {
                    castFixType = castType;
                } else if (JavaModelUtil.is50OrHigher((IJavaProject)cu.getJavaProject()) && (boxUnboxedTypeBinding = TypeMismatchSubProcessor.boxUnboxPrimitives(castType, binding, nodeToCast.getAST())) != castType && boxUnboxedTypeBinding.isCastCompatible(binding)) {
                    castFixType = boxUnboxedTypeBinding;
                }
                if (castFixType != null) {
                    ASTRewriteCorrectionProposal proposal = TypeMismatchSubProcessor.createCastProposal(context, castFixType, nodeToCast, 6);
                    String castTypeName = BindingLabelProvider.getBindingLabel((IBinding)castFixType, JavaElementLabels.ALL_DEFAULT);
                    Object[] arg = new String[]{UnresolvedElementsSubProcessor.getArgumentName(arguments, idx), castTypeName};
                    proposal.setDisplayName(Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_addargumentcast_description, arg));
                    proposals.add(proposal);
                }
                TypeMismatchSubProcessor.addChangeSenderTypeProposals(context, nodeToCast, castType, false, 5, proposals);
            }
        }
        if (nDiffs == 2) {
            boolean canSwap;
            int idx1 = indexOfDiff[0];
            int idx2 = indexOfDiff[1];
            boolean bl = canSwap = UnresolvedElementsSubProcessor.canAssign(argTypes[idx1], paramTypes[idx2]) && UnresolvedElementsSubProcessor.canAssign(argTypes[idx2], paramTypes[idx1]);
            if (canSwap) {
                ICompilationUnit targetCU2;
                Expression arg1 = arguments.get(idx1);
                Expression arg2 = arguments.get(idx2);
                ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
                rewrite.replace((ASTNode)arg1, rewrite.createCopyTarget((ASTNode)arg2), null);
                rewrite.replace((ASTNode)arg2, rewrite.createCopyTarget((ASTNode)arg1), null);
                Object[] arg = new String[]{UnresolvedElementsSubProcessor.getArgumentName(arguments, idx1), UnresolvedElementsSubProcessor.getArgumentName(arguments, idx2)};
                label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_swaparguments_description, arg);
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8);
                proposals.add(proposal);
                if (declaringTypeDecl.isFromSource() && (targetCU2 = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringTypeDecl)) != null) {
                    ChangeMethodSignatureProposal.ChangeDescription[] changeDesc2 = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
                    int i = 0;
                    while (i < nDiffs) {
                        changeDesc2[idx1] = new ChangeMethodSignatureProposal.SwapDescription(idx2);
                        ++i;
                    }
                    IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
                    ITypeBinding[] declParamTypes = methodDecl.getParameterTypes();
                    ITypeBinding[] swappedTypes = new ITypeBinding[]{declParamTypes[idx1], declParamTypes[idx2]};
                    Object[] args = new String[]{ASTResolving.getMethodSignature(methodDecl), UnresolvedElementsSubProcessor.getTypeNames(swappedTypes)};
                    String label2 = methodDecl.isConstructor() ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_swapparams_constr_description, args) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_swapparams_description, args);
                    ChangeMethodSignatureProposal proposal2 = new ChangeMethodSignatureProposal(label2, targetCU2, invocationNode, methodDecl, changeDesc2, null, 5);
                    proposals.add(proposal2);
                }
                return;
            }
        }
        if (declaringTypeDecl.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)declaringTypeDecl)) != null && (changeDesc = UnresolvedElementsSubProcessor.createSignatureChangeDescription(indexOfDiff, nDiffs, paramTypes, arguments, argTypes)) != null) {
            IMethodBinding methodDecl = methodBinding.getMethodDeclaration();
            ITypeBinding[] declParamTypes = methodDecl.getParameterTypes();
            ITypeBinding[] newParamTypes = new ITypeBinding[changeDesc.length];
            int i = 0;
            while (i < newParamTypes.length) {
                newParamTypes[i] = changeDesc[i] == null ? declParamTypes[i] : ((ChangeMethodSignatureProposal.EditDescription)changeDesc[i]).type;
                ++i;
            }
            boolean isVarArgs = methodDecl.isVarargs() && newParamTypes.length > 0 && newParamTypes[newParamTypes.length - 1].isArray();
            Object[] args = new String[]{ASTResolving.getMethodSignature(methodDecl), ASTResolving.getMethodSignature(methodDecl.getName(), newParamTypes, isVarArgs)};
            label = methodDecl.isConstructor() ? Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changeparamsignature_constr_description, args) : Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changeparamsignature_description, args);
            ChangeMethodSignatureProposal proposal = new ChangeMethodSignatureProposal(label, targetCU, invocationNode, methodDecl, changeDesc, null, 7);
            proposals.add(proposal);
        }
    }

    private static ChangeMethodSignatureProposal.ChangeDescription[] createSignatureChangeDescription(int[] indexOfDiff, int nDiffs, ITypeBinding[] paramTypes, List<Expression> arguments, ITypeBinding[] argTypes) {
        ChangeMethodSignatureProposal.ChangeDescription[] changeDesc = new ChangeMethodSignatureProposal.ChangeDescription[paramTypes.length];
        int i = 0;
        while (i < nDiffs) {
            int diffIndex = indexOfDiff[i];
            Expression arg = arguments.get(diffIndex);
            String name = UnresolvedElementsSubProcessor.getExpressionBaseName(arg);
            ITypeBinding argType = argTypes[diffIndex];
            if (argType.isWildcardType() && (argType = ASTResolving.normalizeWildcardType((ITypeBinding)argType, (boolean)true, (AST)arg.getAST())) == null) {
                return null;
            }
            changeDesc[diffIndex] = new ChangeMethodSignatureProposal.EditDescription(argType, name);
            ++i;
        }
        return changeDesc;
    }

    private static String getExpressionBaseName(Expression expr) {
        IBinding argBinding = Bindings.resolveExpressionBinding(expr, true);
        if (argBinding instanceof IVariableBinding) {
            ITypeRoot typeRoot;
            IJavaProject project = null;
            ASTNode root = expr.getRoot();
            if (root instanceof CompilationUnit && (typeRoot = ((CompilationUnit)root).getTypeRoot()) != null) {
                project = typeRoot.getJavaProject();
            }
            return StubUtility.getBaseName((IVariableBinding)argBinding, project);
        }
        if (expr instanceof SimpleName) {
            return ((SimpleName)expr).getIdentifier();
        }
        return null;
    }

    private static ITypeBinding[] getArgumentTypes(List<Expression> arguments) {
        ITypeBinding[] res = new ITypeBinding[arguments.size()];
        int i = 0;
        while (i < res.length) {
            Expression expression = arguments.get(i);
            ITypeBinding curr = expression.resolveTypeBinding();
            if (curr == null) {
                return null;
            }
            if (!curr.isNullType() && (curr = Bindings.normalizeTypeBinding(curr)) == null) {
                curr = expression.getAST().resolveWellKnownType("java.lang.Object");
            }
            res[i] = curr;
            ++i;
        }
        return res;
    }

    private static void addQualifierToOuterProposal(IInvocationContext context, MethodInvocation invocationNode, IMethodBinding binding, Collection<CUCorrectionProposal> proposals) {
        Name newExpression;
        ITypeBinding parentType;
        ITypeBinding declaringType = binding.getDeclaringClass();
        ITypeBinding currType = parentType = Bindings.getBindingOfParentType((ASTNode)invocationNode);
        boolean isInstanceMethod = !Modifier.isStatic((int)binding.getModifiers());
        while (currType != null && !Bindings.isSuperType(declaringType, currType)) {
            if (isInstanceMethod && Modifier.isStatic((int)currType.getModifiers())) {
                return;
            }
            currType = currType.getDeclaringClass();
        }
        if (currType == null || currType == parentType) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)invocationNode.getAST());
        String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_changetoouter_description, ASTResolving.getTypeSignature(currType));
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 8);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)invocationNode, imports);
        AST ast = invocationNode.getAST();
        String qualifier = imports.addImport(currType, (ImportRewrite.ImportRewriteContext)importRewriteContext);
        Name name = ASTNodeFactory.newName(ast, qualifier);
        if (isInstanceMethod) {
            ThisExpression expr = ast.newThisExpression();
            expr.setQualifier(name);
            newExpression = expr;
        } else {
            newExpression = name;
        }
        rewrite.set((ASTNode)invocationNode, (StructuralPropertyDescriptor)MethodInvocation.EXPRESSION_PROPERTY, (Object)newExpression, null);
        proposals.add(proposal);
    }

    public static void getConstructorProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ITypeBinding targetDecl;
        ICompilationUnit targetCU;
        ITypeBinding typeBinding;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        ITypeBinding targetBinding = null;
        List arguments = null;
        IMethodBinding recursiveConstructor = null;
        int type = selectedNode.getNodeType();
        if (type == 14) {
            ClassInstanceCreation creation = (ClassInstanceCreation)selectedNode;
            ITypeBinding binding = creation.getType().resolveBinding();
            if (binding instanceof ITypeBinding) {
                targetBinding = binding;
                arguments = creation.arguments();
            }
        } else if (type == 46) {
            typeBinding = Bindings.getBindingOfParentType(selectedNode);
            if (typeBinding != null && !typeBinding.isAnonymous()) {
                targetBinding = typeBinding.getSuperclass();
                arguments = ((SuperConstructorInvocation)selectedNode).arguments();
            }
        } else if (type == 17 && (typeBinding = Bindings.getBindingOfParentType(selectedNode)) != null && !typeBinding.isAnonymous()) {
            targetBinding = typeBinding;
            arguments = ((ConstructorInvocation)selectedNode).arguments();
            recursiveConstructor = ASTResolving.findParentMethodDeclaration((ASTNode)selectedNode).resolveBinding();
        }
        if (targetBinding == null) {
            return;
        }
        IMethodBinding[] methods = targetBinding.getDeclaredMethods();
        ArrayList<IMethodBinding> similarElements = new ArrayList<IMethodBinding>();
        int i = 0;
        while (i < methods.length) {
            IMethodBinding curr = methods[i];
            if (curr.isConstructor() && recursiveConstructor != curr) {
                similarElements.add(curr);
            }
            ++i;
        }
        UnresolvedElementsSubProcessor.addParameterMissmatchProposals(context, problem, similarElements, selectedNode, arguments, proposals);
        if (targetBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)(targetDecl = targetBinding.getTypeDeclaration()))) != null) {
            Object[] args = new String[]{ASTResolving.getMethodSignature(ASTResolving.getTypeSignature(targetDecl), UnresolvedElementsSubProcessor.getParameterTypes(arguments), false)};
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_createconstructor_description, args);
            proposals.add(new NewMethodCorrectionProposal(label, targetCU, selectedNode, arguments, targetDecl, 5));
        }
    }

    public static void getAmbiguousTypeReferenceProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int offset = problem.getOffset();
        int len = problem.getLength();
        IJavaElement[] elements = cu.codeSelect(offset, len);
        int i = 0;
        while (i < elements.length) {
            IJavaElement curr = elements[i];
            if (curr instanceof IType) {
                String qualifiedTypeName = ((IType)curr).getFullyQualifiedName('.');
                CompilationUnit root = context.getASTRoot();
                String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_importexplicit_description, BasicElementLabels.getJavaElementName((String)qualifiedTypeName));
                ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, ASTRewrite.create((AST)root.getAST()), 5);
                ImportRewrite imports = proposal.createImportRewrite(root);
                imports.addImport(qualifiedTypeName);
                proposals.add(proposal);
            }
            ++i;
        }
    }

    public static void getArrayAccessProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) {
        CompilationUnit root = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(root);
        if (!(selectedNode instanceof MethodInvocation)) {
            return;
        }
        MethodInvocation decl = (MethodInvocation)selectedNode;
        SimpleName nameNode = decl.getName();
        String methodName = nameNode.getIdentifier();
        IBinding[] bindings = new ScopeAnalyzer(root).getDeclarationsInScope(nameNode, 1);
        int i = 0;
        while (i < bindings.length) {
            String currName = bindings[i].getName();
            if (NameMatcher.isSimilarName(methodName, currName)) {
                String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_arraychangetomethod_description, BasicElementLabels.getJavaElementName((String)currName));
                proposals.add(new RenameNodeCorrectionProposal(label, context.getCompilationUnit(), nameNode.getStartPosition(), nameNode.getLength(), currName, 6));
            }
            ++i;
        }
        String lengthId = "length";
        String label = CorrectionMessages.UnresolvedElementsSubProcessor_arraychangetolength_description;
        int offset = nameNode.getStartPosition();
        int length = decl.getStartPosition() + decl.getLength() - offset;
        proposals.add(new RenameNodeCorrectionProposal(label, context.getCompilationUnit(), offset, length, lengthId, 7));
    }

    public static void getAnnotationMemberProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ICompilationUnit targetCU;
        String memberName;
        Annotation annotation;
        CompilationUnit astRoot = context.getASTRoot();
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            if (selectedNode.getParent().getLocationInParent() != NormalAnnotation.VALUES_PROPERTY) {
                return;
            }
            annotation = (Annotation)selectedNode.getParent().getParent();
            memberName = ((SimpleName)selectedNode).getIdentifier();
        } else if (selectedNode.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY) {
            annotation = (Annotation)selectedNode.getParent();
            memberName = "value";
        } else {
            return;
        }
        ITypeBinding annotBinding = annotation.resolveTypeBinding();
        if (annotBinding == null) {
            return;
        }
        if (annotation instanceof NormalAnnotation) {
            IMethodBinding[] otherMembers = annotBinding.getDeclaredMethods();
            int i = 0;
            while (i < otherMembers.length) {
                IMethodBinding binding = otherMembers[i];
                String curr = binding.getName();
                int relevance = NameMatcher.isSimilarName(memberName, curr) ? 6 : 3;
                String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_UnresolvedElementsSubProcessor_changetoattribute_description, BasicElementLabels.getJavaElementName((String)curr));
                proposals.add(new RenameNodeCorrectionProposal(label, cu, problem.getOffset(), problem.getLength(), curr, relevance));
                ++i;
            }
        }
        if (annotBinding.isFromSource() && (targetCU = ASTResolving.findCompilationUnitForBinding((ICompilationUnit)cu, (CompilationUnit)astRoot, (ITypeBinding)annotBinding)) != null) {
            String label = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_UnresolvedElementsSubProcessor_createattribute_description, BasicElementLabels.getJavaElementName((String)memberName));
            proposals.add(new NewAnnotationMemberProposal(label, targetCU, selectedNode, annotBinding, 5));
        }
    }
}

