/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.ls.core.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.IProblemLocation;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CUCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CorrectMainTypeNameProposal;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.CorrectPackageDeclarationProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        IJavaProject javaProject = cu.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        CompilationUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        if (!(coveredNode instanceof SimpleName)) {
            return;
        }
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = ((SimpleName)coveredNode).getIdentifier();
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        List types = root.types();
        int i = 0;
        while (i < types.size()) {
            AbstractTypeDeclaration curr = (AbstractTypeDeclaration)types.get(i);
            if (parentType != curr && newTypeName.equals(curr.getName().getIdentifier())) {
                return;
            }
            ++i;
        }
        if (!JavaConventions.validateJavaTypeName((String)newTypeName, (String)sourceLevel, (String)compliance).matches(4)) {
            proposals.add(new CorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5));
        }
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
        proposals.add(new CorrectPackageDeclarationProposal(cu, problem, relevance));
    }

    public static void removeImportStatementProposals(final IInvocationContext context, IProblemLocation problem, Collection<CUCorrectionProposal> proposals) {
        UnusedCodeFix fix = UnusedCodeFix.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            try {
                CompilationUnitChange change = fix.createChange(null);
                CUCorrectionProposal proposal = new CUCorrectionProposal(change.getName(), change.getCompilationUnit(), (TextChange)change, 6);
                proposals.add(proposal);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.log(e);
            }
        }
        final ICompilationUnit cu = context.getCompilationUnit();
        String name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description;
        CUCorrectionProposal proposal = new CUCorrectionProposal(name, cu, 5){

            @Override
            protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
                CompilationUnit astRoot = context.getASTRoot();
                OrganizeImportsOperation op = new OrganizeImportsOperation(cu, astRoot, true, false, true, null);
                editRoot.addChild(op.createTextEdit(null));
            }
        };
        proposals.add(proposal);
    }
}

