/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.CopyTargetEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditVisitor;

public class TextEditConverter
extends TextEditVisitor {
    private final TextEdit source;
    protected ICompilationUnit compilationUnit;
    protected List<org.eclipse.lsp4j.TextEdit> converted;

    public TextEditConverter(ICompilationUnit unit, TextEdit edit) {
        this.source = edit;
        this.converted = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        if (unit == null) {
            throw new IllegalArgumentException("Compilation unit can not be null");
        }
        this.compilationUnit = unit;
    }

    public List<org.eclipse.lsp4j.TextEdit> convert() {
        if (this.source != null) {
            this.source.accept((TextEditVisitor)this);
        }
        return this.converted;
    }

    public boolean visit(InsertEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setNewText(edit.getText());
            te.setRange(JDTUtils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            this.converted.add(te);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(DeleteEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setNewText("");
            te.setRange(JDTUtils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            this.converted.add(te);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(ReplaceEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setNewText(edit.getText());
            te.setRange(JDTUtils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            this.converted.add(te);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(CopyTargetEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setRange(JDTUtils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            Document doc = new Document(this.compilationUnit.getSource());
            edit.apply((IDocument)doc, 2);
            String content = doc.get(edit.getSourceEdit().getOffset(), edit.getSourceEdit().getLength());
            te.setNewText(content);
            this.converted.add(te);
        }
        catch (CoreException | BadLocationException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException("Error converting TextEdits", e);
        }
        return false;
    }

    public boolean visit(MoveSourceEdit edit) {
        try {
            if (edit.getParent() != null && edit.getTargetEdit() != null && edit.getParent().equals((Object)edit.getTargetEdit().getParent())) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
                te.setNewText("");
                te.setRange(JDTUtils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
                this.converted.add(te);
                return false;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error converting TextEdits", e);
        }
        return super.visit(edit);
    }

    public boolean visit(MoveTargetEdit edit) {
        try {
            org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit();
            te.setRange(JDTUtils.toRange((IOpenable)this.compilationUnit, edit.getOffset(), edit.getLength()));
            Document doc = new Document(this.compilationUnit.getSource());
            edit.apply((IDocument)doc, 2);
            String content = doc.get(edit.getSourceEdit().getOffset(), edit.getSourceEdit().getLength());
            te.setNewText(content);
            this.converted.add(te);
        }
        catch (CoreException | BadLocationException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException("Error converting TextEdits", e);
        }
        return false;
    }
}

