/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.List;
import org.eclipse.jdt.ls.core.internal.ActionableNotification;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.StatusReport;
import org.eclipse.jdt.ls.core.internal.handlers.LogHandler;
import org.eclipse.jdt.ls.core.internal.lsp.WorkspaceFoldersProposedClient;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.services.LanguageClient;

public class JavaClientConnection {
    private final LogHandler logHandler;
    private final JavaLanguageClient client;

    public JavaClientConnection(JavaLanguageClient client) {
        this.client = client;
        this.logHandler = new LogHandler();
        this.logHandler.install(this);
    }

    public void logMessage(MessageType type, String msg) {
        MessageParams $ = new MessageParams();
        $.setMessage(msg);
        $.setType(type);
        this.client.logMessage($);
    }

    public void showNotificationMessage(MessageType type, String msg) {
        MessageParams $ = new MessageParams();
        $.setMessage(msg);
        $.setType(type);
        this.client.showMessage($);
    }

    public MessageActionItem showNotificationMessageRequest(MessageType type, String msg, List<MessageActionItem> actions) {
        ShowMessageRequestParams $ = new ShowMessageRequestParams();
        $.setMessage(msg);
        $.setType(type);
        $.setActions(actions);
        return (MessageActionItem)this.client.showMessageRequest($).join();
    }

    public void sendStatus(ServiceStatus serverStatus, String status) {
        StatusReport $ = new StatusReport();
        this.client.sendStatusReport($.withMessage(status).withType(serverStatus.name()));
    }

    public void sendActionableNotification(MessageType severity, String message, Object data, List<Command> commands) {
        ActionableNotification notification = new ActionableNotification().withSeverity(severity).withMessage(message).withData(data).withCommands(commands);
        this.sendActionableNotification(notification);
    }

    public void sendActionableNotification(ActionableNotification notification) {
        this.client.sendActionableNotification(notification);
    }

    public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
        this.client.publishDiagnostics(diagnostics);
    }

    public boolean applyWorkspaceEdit(WorkspaceEdit edit) {
        ApplyWorkspaceEditParams $ = new ApplyWorkspaceEditParams();
        $.setEdit(edit);
        ApplyWorkspaceEditResponse response = (ApplyWorkspaceEditResponse)this.client.applyEdit($).join();
        return response.getApplied();
    }

    public void unregisterCapability(UnregistrationParams params) {
        this.client.unregisterCapability(params);
    }

    public void registerCapability(RegistrationParams params) {
        this.client.registerCapability(params);
    }

    public void disconnect() {
        if (this.logHandler != null) {
            this.logHandler.uninstall();
        }
    }

    public static interface JavaLanguageClient
    extends LanguageClient,
    WorkspaceFoldersProposedClient {
        @JsonNotification(value="language/status")
        public void sendStatusReport(StatusReport var1);

        @JsonNotification(value="language/actionableNotification")
        public void sendActionableNotification(ActionableNotification var1);
    }
}

