/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.hover.JavaElementLabels;
import org.eclipse.jdt.ls.core.internal.javadoc.JavadocContentAccess;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class HoverInfoProvider {
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 0x10000000000000L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long LOCAL_VARIABLE_FLAGS = LABEL_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long COMMON_SIGNATURE_FLAGS = LABEL_FLAGS & (JavaElementLabels.ALL_FULLY_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL) | 0x40000L | 0x80L;
    private static final String LANGUAGE_ID = "java";
    private final ITypeRoot unit;
    private final PreferenceManager preferenceManager;

    public HoverInfoProvider(ITypeRoot aUnit, PreferenceManager preferenceManager) {
        this.unit = aUnit;
        this.preferenceManager = preferenceManager;
    }

    public List<Either<String, MarkedString>> computeHover(int line, int column, IProgressMonitor monitor) {
        LinkedList<Either<String, MarkedString>> res = new LinkedList<Either<String, MarkedString>>();
        try {
            IJavaElement[] elements = JDTUtils.findElementsAtSelection(this.unit, line, column, this.preferenceManager, monitor);
            if (elements == null || elements.length == 0) {
                res.add((Either<String, MarkedString>)Either.forLeft((Object)""));
                return res;
            }
            IJavaElement curr = null;
            if (elements.length != 1) {
                IPackageFragment packageFragment = (IPackageFragment)this.unit.getParent();
                IJavaElement found = Stream.of(elements).filter(e -> e.equals(packageFragment)).findFirst().orElse(null);
                curr = found == null ? elements[0] : found;
            } else {
                curr = elements[0];
            }
            boolean resolved = this.isResolved(curr, monitor);
            if (resolved) {
                String javadoc;
                MarkedString signature = this.computeSignature(curr);
                if (signature != null) {
                    res.add((Either<String, MarkedString>)Either.forRight((Object)signature));
                }
                if ((javadoc = this.computeJavadocHover(curr)) != null) {
                    res.add((Either<String, MarkedString>)Either.forLeft((Object)javadoc));
                }
            }
        }
        catch (Exception e2) {
            JavaLanguageServerPlugin.logException("Error computing hover", e2);
        }
        return res;
    }

    private boolean isResolved(IJavaElement element, IProgressMonitor monitor) throws CoreException {
        if (!(this.unit instanceof ICompilationUnit)) {
            return true;
        }
        if (element == null) {
            return false;
        }
        if (element.getElementType() != 7) {
            return true;
        }
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)3);
        final boolean[] res = new boolean[]{false};
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.unit}, (int)7);
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match.getAccuracy() == 1) {
                        return;
                    }
                    Object o = match.getElement();
                    if (o instanceof IJavaElement) {
                        IJavaElement element = (IJavaElement)o;
                        if (element.getElementType() == 7) {
                            res[0] = true;
                            return;
                        }
                        ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                        if (compilationUnit == null) {
                            return;
                        }
                        res[0] = true;
                        throw new HoverException();
                    }
                }
            }, monitor);
        }
        catch (OperationCanceledException | HoverException object) {
            // empty catch block
        }
        return res[0];
    }

    private MarkedString computeSignature(IJavaElement element) {
        if (element == null) {
            return null;
        }
        String elementLabel = null;
        elementLabel = element instanceof ILocalVariable ? JavaElementLabels.getElementLabel(element, LOCAL_VARIABLE_FLAGS) : JavaElementLabels.getElementLabel(element, COMMON_SIGNATURE_FLAGS);
        return new MarkedString(LANGUAGE_ID, elementLabel);
    }

    private String computeJavadocHover(IJavaElement element) throws CoreException {
        IMember member;
        if (element instanceof ITypeParameter) {
            member = ((ITypeParameter)element).getDeclaringMember();
        } else if (element instanceof IMember) {
            member = (IMember)element;
        } else {
            if (element instanceof IPackageFragment) {
                Reader r = JavadocContentAccess.getMarkdownContentReader((IPackageFragment)element, true);
                if (r == null) {
                    return null;
                }
                return HoverInfoProvider.getString(r);
            }
            return null;
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        Reader r = JavadocContentAccess.getMarkdownContentReader(member);
        if (r == null) {
            return null;
        }
        return HoverInfoProvider.getString(r);
    }

    private static String getString(Reader reader) {
        try {
            return CharStreams.toString((Readable)reader);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private class HoverException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public HoverException() {
            super((IStatus)new Status(0, "org.eclipse.jdt.ls.core", ""));
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

