/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class CompoundDoubleDatasetTest {
    private static final double[] VALUES = new double[]{Double.NEGATIVE_INFINITY, -3.0, 0.0, 3.0, Double.POSITIVE_INFINITY, Double.NaN};

    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new CompoundDoubleDataset().getSize());
        Assert.assertEquals((long)0L, (long)new CompoundDoubleDataset(2).getSize());
        Assert.assertEquals((long)0L, (long)((CompoundDoubleDataset)DatasetFactory.createFromObject((int)2, CompoundDoubleDataset.class, (Object)1.0, (int[])new int[0])).getRank());
        double[] da = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5};
        CompoundDoubleDataset a = new CompoundDoubleDataset(2, da, new int[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            Assert.assertEquals((double)((double)i + 0.5), (double)a.getElementDoubleAbs(it.index + 1), (double)(1.0E-5 * (double)i));
            ++i;
        }
        CompoundDoubleDataset b = new CompoundDoubleDataset(2, da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i2));
            Assert.assertEquals((double)((double)i2 + 0.5), (double)b.getElementDoubleAbs(it.index + 1), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        CompoundDoubleDataset c = new CompoundDoubleDataset(a.getSliceView(new int[]{1}, null, new int[]{2}));
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(2 * i3 + 1), (double)c.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i3));
            Assert.assertEquals((double)((double)(2 * i3) + 1.5), (double)c.getElementDoubleAbs(it.index + 1), (double)(1.0E-5 * (double)i3));
            ++i3;
        }
        a.hashCode();
        b.hashCode();
        c.hashCode();
    }

    @Test
    public void testGetter() {
        double[] da = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5};
        CompoundDoubleDataset a = new CompoundDoubleDataset(2, da, new int[0]);
        int l = da.length / 2;
        int i = 0;
        while (i < l) {
            Assert.assertEquals((double)i, (double)a.getDouble(i), (double)(1.0E-5 * (double)i));
            Assert.assertArrayEquals((double[])new double[]{i, (double)i + 0.5}, (double[])a.getDoubleArray(i), (double)(1.0E-5 * (double)i));
            ++i;
        }
        i = 0;
        while (i < l) {
            int r = l - 1 - i;
            Assert.assertEquals((double)r, (double)a.getDouble(-(i + 1)), (double)(1.0E-5 * (double)r));
            Assert.assertArrayEquals((double[])new double[]{r, (double)r + 0.5}, (double[])a.getDoubleArray(-(i + 1)), (double)(1.0E-5 * (double)i));
            ++i;
        }
        CompoundDataset sv = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        CompoundDataset sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        l = sc.getSize();
        int i22 = 0;
        while (i22 < l) {
            double r = sc.getDouble(-(i22 + 1));
            Assert.assertEquals((double)r, (double)sv.getDouble(-(i22 + 1)), (double)(1.0E-5 * r));
            Assert.assertArrayEquals((double[])new double[]{r, r + 0.5}, (double[])sv.getDoubleArray(-(i22 + 1)), (double)(1.0E-5 * (double)i22));
            ++i22;
        }
        Assert.assertEquals((double)0.0, (double)a.getDouble(), (double)1.0E-16);
        Assert.assertArrayEquals((double[])new double[]{0.0, 0.5}, (double[])a.getDoubleArray(), (double)1.0E-5);
        try {
            a.getDouble(null);
            Assert.fail((String)"Should have thrown an NPE");
        }
        catch (NullPointerException i22) {
            // empty catch block
        }
        try {
            a.getDouble(new int[2]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException i22) {
            // empty catch block
        }
        try {
            a.getDouble(0, 0);
            Assert.fail((String)"Should have thrown a UOE");
        }
        catch (UnsupportedOperationException i22) {
            // empty catch block
        }
        CompoundDataset b = a.reshape(new int[]{4, 3});
        try {
            b.getDouble(new int[1]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            b.getDouble(0);
            Assert.fail((String)"Should have thrown a UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testCreators() {
        double dz = 0.5;
        CompoundDoubleDataset z = CompoundDoubleDataset.createFromObject((Object)dz);
        Assert.assertEquals((long)0L, (long)z.getRank());
        Assert.assertEquals((long)1L, (long)z.getSize());
        Assert.assertEquals((double)dz, (double)z.getElementDoubleAbs(0), (double)1.0E-14);
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        CompoundDoubleDataset a = CompoundDoubleDataset.createFromObject((Object)da);
        Assert.assertEquals((long)6L, (long)a.getElementsPerItem());
        Assert.assertEquals((long)1L, (long)a.getRank());
        Assert.assertEquals((long)1L, (long)a.getSize());
        Assert.assertEquals((long)1L, (long)a.getShapeRef()[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < 6) {
                Assert.assertEquals((double)(i + j), (double)a.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i));
                ++j;
            }
            ++i;
        }
        double[][] db = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        CompoundDoubleDataset b = CompoundDoubleDataset.createFromObject((Object)db);
        Assert.assertEquals((long)3L, (long)b.getElementsPerItem());
        Assert.assertEquals((long)1L, (long)b.getRank());
        Assert.assertEquals((long)2L, (long)b.getSize());
        Assert.assertEquals((long)2L, (long)b.getShapeRef()[0]);
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < 3) {
                Assert.assertEquals((double)(i2 * 3 + j), (double)b.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i2));
                ++j;
            }
            ++i2;
        }
        double[][] dc = new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}};
        CompoundDoubleDataset c = CompoundDoubleDataset.createFromObject((Object)dc);
        Assert.assertEquals((long)4L, (long)c.getElementsPerItem());
        Assert.assertEquals((long)1L, (long)c.getRank());
        Assert.assertEquals((long)2L, (long)c.getSize());
        Assert.assertEquals((long)2L, (long)c.getShapeRef()[0]);
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < 3) {
                int r = i3 * 4 + j;
                Assert.assertEquals((double)(r < 7 ? r : 0), (double)c.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i3));
                ++j;
            }
            ++i3;
        }
        double[][] dd = new double[][]{{0.0, 1.0, 2.0}, {4.0, 5.0, 6.0, 7.0}};
        CompoundDoubleDataset d = CompoundDoubleDataset.createFromObject((Object)dd);
        Assert.assertEquals((long)4L, (long)d.getElementsPerItem());
        Assert.assertEquals((long)1L, (long)d.getRank());
        Assert.assertEquals((long)2L, (long)d.getSize());
        Assert.assertEquals((long)2L, (long)d.getShapeRef()[0]);
        it = d.getIterator();
        int i4 = 0;
        while (it.hasNext()) {
            int j = 0;
            while (j < 3) {
                int r = i4 * 4 + j;
                Assert.assertEquals((double)(r != 3 ? r : 0), (double)d.getElementDoubleAbs(it.index + j), (double)(1.0E-15 * (double)i4));
                ++j;
            }
            ++i4;
        }
    }

    @Test
    public void testStats() {
        DoubleDataset d = (DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)36.0);
        d.setShape(new int[]{3, 4, 3});
        CompoundDataset a = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)d, (boolean)true);
        try {
            a.max(new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            a.max(0, new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            a.argMax(new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            a.argMax(0, new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            a.peakToPeak(new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            a.peakToPeak(0, new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertEquals((long)12L, (long)a.count(new boolean[0]));
        Assert.assertArrayEquals((double[])new double[]{16.5, 17.5, 18.5}, (double[])((double[])a.mean(new boolean[0])), (double)1.0E-10);
        Assert.assertEquals((double)351.0, (double)a.variance(), (double)1.0E-10);
        Assert.assertEquals((double)321.75, (double)a.variance(true, new boolean[0]), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{198.0, 210.0, 222.0}, (double[])((double[])a.sum(new boolean[0])), (double)1.0E-10);
        Assert.assertEquals((double)Math.sqrt(1242.5), (double)a.rootMeanSquare(new boolean[0]), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{33.0, 34.0, 35.0}, (double[])a.maxItem(), (double)1.0E-10);
        CompoundDataset v = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(14), Integer.valueOf(24))});
        try {
            v.max(new boolean[0]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception");
        }
        try {
            v.minPos(new boolean[0]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception");
        }
        Assert.assertArrayEquals((double[])new double[3], (double[])((double[])v.sum(new boolean[0])), (double)1.0E-10);
        double[] dArray = (double[])v.mean(new boolean[0]);
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            Assert.assertTrue((boolean)Double.isNaN(x));
            ++n2;
        }
        a.setShape(new int[]{3, 1, 4});
        CompoundDataset b = a.sum(0, new boolean[0]);
        Assert.assertEquals((Object)((LongDataset)DatasetFactory.zeros(LongDataset.class, (int[])new int[]{1, 4})).fill((Object)3), (Object)a.count(0, new boolean[0]));
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{1, 4}, (int[])b.getShapeRef());
        Assert.assertArrayEquals((double[])new double[]{36.0, 39.0, 42.0}, (double[])b.getDoubleArray(0, 0), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{45.0, 48.0, 51.0}, (double[])b.getDoubleArray(0, 1), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{54.0, 57.0, 60.0}, (double[])b.getDoubleArray(0, 2), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{63.0, 66.0, 69.0}, (double[])b.getDoubleArray(0, 3), (double)1.0E-10);
        b = a.sum(1, new boolean[0]);
        Assert.assertEquals((Object)((LongDataset)DatasetFactory.zeros(LongDataset.class, (int[])new int[]{3, 4})).fill((Object)1), (Object)a.count(1, new boolean[0]));
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])b.getShapeRef());
        Assert.assertEquals((Object)a.squeeze(), (Object)b);
        a.setShape(new int[]{3, 1, 4});
        b = a.sum(2, new boolean[0]);
        Assert.assertEquals((Object)((LongDataset)DatasetFactory.zeros(LongDataset.class, (int[])new int[]{3, 1})).fill((Object)4), (Object)a.count(2, new boolean[0]));
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 1}, (int[])b.getShapeRef());
        Assert.assertArrayEquals((double[])new double[]{18.0, 22.0, 26.0}, (double[])b.getDoubleArray(0, 0), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{66.0, 70.0, 74.0}, (double[])b.getDoubleArray(1, 0), (double)1.0E-10);
        Assert.assertArrayEquals((double[])new double[]{114.0, 118.0, 122.0}, (double[])b.getDoubleArray(2, 0), (double)1.0E-10);
        d = (DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)180.0);
        d.setShape(new int[]{4, 3, 5, 3});
        a = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)d, (boolean)true);
        CompoundDataset c = a.sum(2, new boolean[0]);
        Assert.assertArrayEquals((double[])new double[]{30.0, 35.0, 40.0}, (double[])c.getDoubleArray(0, 0), (double)1.0E-10);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)a.sum(new int[]{2}, new boolean[0]));
        int[] nArray = new int[2];
        nArray[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c.sum(0, new boolean[0]), (Dataset)a.sum(nArray, new boolean[0]));
        c = a.sum(0, new boolean[0]);
        Assert.assertArrayEquals((double[])new double[]{270.0, 274.0, 278.0}, (double[])c.getDoubleArray(0, 0), (double)1.0E-10);
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)a.sum(new int[1], new boolean[0]));
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c.sum(1, new boolean[0]), (Dataset)a.sum(nArray2, new boolean[0]));
        c = a.product(2, new boolean[0]);
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c.product(0, new boolean[0]), (Dataset)a.product(nArray3, new boolean[0]));
        c = a.product(0, new boolean[0]);
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c.product(1, new boolean[0]), (Dataset)a.product(nArray4, new boolean[0]));
    }

    @Test
    public void testMaths() {
        DoubleDataset d = (DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)36.0);
        d.setShape(new int[]{3, 4, 3});
        CompoundDataset a = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)d, (boolean)true);
        Dataset r = Maths.add((Object)a, (Object)a);
        IndexIterator it = r.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(6.0 * (double)i), (double)r.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            Assert.assertEquals((double)(6.0 * (double)i + 2.0), (double)r.getElementDoubleAbs(it.index + 1), (double)(1.0E-5 * (double)i));
            Assert.assertEquals((double)(6.0 * (double)i + 4.0), (double)r.getElementDoubleAbs(it.index + 2), (double)(1.0E-5 * (double)i));
            ++i;
        }
    }

    @Test
    public void testPosition() {
        DoubleDataset d = (DoubleDataset)DatasetFactory.createRange(DoubleDataset.class, (double)36.0);
        d.setShape(new int[]{3, 4, 3});
        CompoundDataset a = DatasetUtils.createCompoundDatasetFromLastAxis((Dataset)d, (boolean)true);
        try {
            a.maxPos(new boolean[0]);
            Assert.fail((String)"Should have thrown an UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testZ() {
        double b;
        int n;
        int n2;
        double[] dArray;
        double a;
        double[] dArray2 = VALUES;
        int n3 = VALUES.length;
        int n4 = 0;
        while (n4 < n3) {
            a = dArray2[n4];
            dArray = VALUES;
            n2 = VALUES.length;
            n = 0;
            while (n < n2) {
                b = dArray[n];
                System.err.println(String.valueOf(a) + " + " + b + " = " + (a + b));
                ++n;
            }
            ++n4;
        }
        dArray2 = VALUES;
        n3 = VALUES.length;
        n4 = 0;
        while (n4 < n3) {
            a = dArray2[n4];
            dArray = VALUES;
            n2 = VALUES.length;
            n = 0;
            while (n < n2) {
                b = dArray[n];
                System.err.println(String.valueOf(a) + " * " + b + " = " + a * b);
                ++n;
            }
            ++n4;
        }
    }

    @Test
    public void testSubclassing() {
        double[] da = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5};
        CompoundDoubleDataset a = new CompoundDoubleDataset(2, da, new int[0]);
        CompoundDoubleDataset2 b = new CompoundDoubleDataset2(a);
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)b);
    }

    static class CompoundDoubleDataset2
    extends CompoundDoubleDataset {
        private static final long serialVersionUID = 1L;

        public CompoundDoubleDataset2(CompoundDoubleDataset dataset) {
            super(dataset);
        }
    }
}

