/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.DataEvent;
import org.eclipse.january.dataset.IDataListener;
import org.eclipse.january.dataset.IDynamicDataset;
import org.eclipse.january.dataset.LazyDynamicDataset;
import org.junit.Assert;
import org.junit.Test;

public class LazyDynamicDatasetTest {
    IDynamicDataset createDynamic() {
        int[] nArray = new int[2];
        nArray[1] = 4;
        LazyDynamicDataset lazy = new LazyDynamicDataset("test", 3, 1, nArray, new int[]{-1, 4}, null);
        return lazy;
    }

    @Test
    public void testPeriodicChecker() {
        IDynamicDataset lazy = this.createDynamic();
        CountingListener counter = new CountingListener();
        lazy.addDataListener((IDataListener)counter);
        int period = 200;
        int repeat = 5;
        long total = (long)(((double)repeat + 0.1) * (double)period);
        lazy.startUpdateChecker(period, null);
        try {
            Thread.sleep(total);
            lazy.startUpdateChecker(0, null);
        }
        catch (InterruptedException interruptedException) {
            Assert.fail((String)"Sleep interrupted!");
        }
        Assert.assertEquals((long)repeat, (long)counter.count);
    }

    @Test
    public void testShapeChecker() {
        IDynamicDataset lazy = this.createDynamic();
        CountingListener counter = new CountingListener();
        lazy.addDataListener((IDataListener)counter);
        int period = 200;
        int repeat = 5;
        int i = 1;
        while (i <= repeat) {
            try {
                lazy.resize(new int[]{i, 4});
                Thread.sleep(period);
            }
            catch (InterruptedException interruptedException) {
                Assert.fail((String)"Sleep interrupted!");
            }
            ++i;
        }
        Assert.assertEquals((long)repeat, (long)counter.count);
    }

    class CountingListener
    implements IDataListener {
        int count = 0;

        CountingListener() {
        }

        public void dataChangePerformed(DataEvent evt) {
            TestUtils.verbosePrintf((String)"New shape: %s\n", (Object[])new Object[]{Arrays.toString(evt.getShape())});
            ++this.count;
        }
    }
}

