/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.junit.Assert;
import org.junit.Test;

public class IntegerDatasetTest {
    @Test
    public void testConstructor() {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        int[] da = nArray;
        IntegerDataset a = new IntegerDataset(da, null);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i, (long)a.getElementLongAbs(it.index));
            ++i;
        }
        IntegerDataset b = new IntegerDataset(da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i2, (long)b.getElementLongAbs(it.index));
            ++i2;
        }
        a.hashCode();
        b.hashCode();
    }

    @Test
    public void testStats() {
        Dataset a = DatasetFactory.createRange((double)12.0, (int)3);
        Assert.assertEquals((double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
    }

    @Test
    public void testPosition() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        Assert.assertEquals((long)6L, (long)a.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)0L, (long)a.minPos(new boolean[0])[0]);
        Dataset b = DatasetFactory.zeros((int[])new int[]{100, 200}, (int)3);
        b.set((Object)100, new int[]{50, 100});
        b.set((Object)-100, new int[]{51, 101});
        Assert.assertEquals((long)50L, (long)b.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)100L, (long)b.maxPos(new boolean[0])[1]);
        Assert.assertEquals((long)51L, (long)b.minPos(new boolean[0])[0]);
        Assert.assertEquals((long)101L, (long)b.minPos(new boolean[0])[1]);
    }
}

