/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.SliceIterator;

public class RGBDataset
extends CompoundShortDataset
implements Cloneable {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final int ISIZE = 3;
    private static final double Wr = 0.299;
    private static final double Wg = 0.587;
    private static final double Wb = 0.114;

    @Override
    public int getDType() {
        return 203;
    }

    public RGBDataset() {
        super(3);
    }

    public RGBDataset(int ... shape) {
        super(3, shape);
    }

    public RGBDataset(short[] data, int ... shape) {
        super(3, data, shape);
    }

    public RGBDataset(RGBDataset dataset) {
        super(dataset);
    }

    @Override
    public RGBDataset clone() {
        return new RGBDataset(this);
    }

    public RGBDataset(int[] redData, int[] greenData, int[] blueData, int ... shape) {
        int dsize = redData.length > greenData.length ? greenData.length : redData.length;
        int n = dsize = dsize > blueData.length ? blueData.length : dsize;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 3;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = (short)redData[i];
            this.data[n2++] = (short)greenData[i];
            this.data[n2++] = (short)blueData[i];
            ++i;
        }
    }

    public RGBDataset(short[] redData, short[] greenData, short[] blueData, int ... shape) {
        int dsize = redData.length > greenData.length ? greenData.length : redData.length;
        int n = dsize = dsize > blueData.length ? blueData.length : dsize;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 3;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = redData[i];
            this.data[n2++] = greenData[i];
            this.data[n2++] = blueData[i];
            ++i;
        }
    }

    public RGBDataset(byte[] redData, byte[] greenData, byte[] blueData, int ... shape) {
        int dsize = redData.length > greenData.length ? greenData.length : redData.length;
        int n = dsize = dsize > blueData.length ? blueData.length : dsize;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 3;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = (short)(0xFF & redData[i]);
            this.data[n2++] = (short)(0xFF & greenData[i]);
            this.data[n2++] = (short)(0xFF & blueData[i]);
            ++i;
        }
    }

    public RGBDataset(Dataset red, Dataset green, Dataset blue) {
        super(3, red.getShapeRef());
        red.checkCompatibility(green);
        red.checkCompatibility(blue);
        if (red.max(new boolean[0]).doubleValue() > 32767.0 || red.min(new boolean[0]).doubleValue() < -32768.0 || green.max(new boolean[0]).doubleValue() > 32767.0 || green.min(new boolean[0]).doubleValue() < -32768.0 || blue.max(new boolean[0]).doubleValue() > 32767.0 || blue.min(new boolean[0]).doubleValue() < -32768.0) {
            logger.warn("Some values are out of range and will be ");
        }
        IndexIterator riter = red.getIterator();
        IndexIterator giter = green.getIterator();
        IndexIterator biter = blue.getIterator();
        int i = 0;
        while (riter.hasNext() && giter.hasNext() && biter.hasNext()) {
            this.data[i++] = (short)red.getElementLongAbs(riter.index);
            this.data[i++] = (short)green.getElementLongAbs(riter.index);
            this.data[i++] = (short)blue.getElementLongAbs(riter.index);
        }
    }

    public RGBDataset(Dataset grey) {
        super(3, grey.getShapeRef());
        IndexIterator giter = grey.getIterator();
        int i = 0;
        while (giter.hasNext()) {
            short g = (short)grey.getElementLongAbs(giter.index);
            this.data[i++] = g;
            this.data[i++] = g;
            this.data[i++] = g;
        }
    }

    public static RGBDataset createFromObject(Object obj) {
        CompoundShortDataset result = (CompoundShortDataset)DatasetUtils.createCompoundDataset((Dataset)ShortDataset.createFromObject(obj), 3);
        return new RGBDataset(result.data, result.shape);
    }

    public static RGBDataset createFromCompoundDataset(CompoundDataset a) {
        if (a instanceof RGBDataset) {
            return (RGBDataset)a;
        }
        int is = a.getElementsPerItem();
        if (is < 3) {
            return new RGBDataset((Dataset)a);
        }
        if (a instanceof CompoundShortDataset && is == 3) {
            return new RGBDataset((short[])a.getBuffer(), a.getShapeRef());
        }
        RGBDataset rgb = new RGBDataset(a.getShapeRef());
        IndexIterator it = a.getIterator();
        int n = 0;
        while (it.hasNext()) {
            rgb.data[n++] = (short)a.getElementLongAbs(it.index);
            rgb.data[n++] = (short)a.getElementLongAbs(it.index + 1);
            rgb.data[n++] = (short)a.getElementLongAbs(it.index + 2);
        }
        return rgb;
    }

    /*
     * Unable to fully structure code
     */
    public static RGBDataset createFromHSV(Dataset hue, Dataset saturation, Dataset value) {
        block3: {
            if (saturation != null && !hue.isCompatibleWith(saturation) || !hue.isCompatibleWith(value)) {
                throw new IllegalArgumentException("Hue, saturation and value datasets must have the same shape");
            }
            result = new RGBDataset(hue.getShapeRef());
            it = result.getIterator(true);
            pos = it.getPos();
            rgb = new short[3];
            if (saturation != null) ** GOTO lbl15
            while (it.hasNext()) {
                RGBDataset.convertHSVToRGB(hue.getDouble(pos), 1.0, value.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                RGBDataset.convertHSVToRGB(hue.getDouble(pos), saturation.getDouble(pos), value.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
lbl15:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static RGBDataset createFromHSL(Dataset hue, Dataset saturation, Dataset lightness) {
        block3: {
            if (saturation != null && !hue.isCompatibleWith(saturation) || !hue.isCompatibleWith(lightness)) {
                throw new IllegalArgumentException("Hue, saturation and lightness datasets must have the same shape");
            }
            result = new RGBDataset(hue.getShapeRef());
            it = result.getIterator(true);
            pos = it.getPos();
            rgb = new short[3];
            if (saturation != null) ** GOTO lbl15
            while (it.hasNext()) {
                RGBDataset.convertHSLToRGB(hue.getDouble(pos), 1.0, lightness.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                RGBDataset.convertHSLToRGB(hue.getDouble(pos), saturation.getDouble(pos), lightness.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
lbl15:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return result;
    }

    private static void convertHSVToRGB(double h, double s, double v, short[] rgb) {
        double m = 255.0 * v;
        double chroma = s * m;
        m -= chroma;
        double hprime = h / 60.0;
        if (hprime < 0.0) {
            hprime += 6.0;
        }
        short sx = (short)(chroma * (1.0 - Math.abs(hprime % 2.0 - 1.0)) + m);
        short sc = (short)(chroma + m);
        short sm = (short)m;
        if (hprime < 1.0) {
            rgb[0] = sc;
            rgb[1] = sx;
            rgb[2] = sm;
        } else if (hprime < 2.0) {
            rgb[0] = sx;
            rgb[1] = sc;
            rgb[2] = sm;
        } else if (hprime < 3.0) {
            rgb[0] = sm;
            rgb[1] = sc;
            rgb[2] = sx;
        } else if (hprime < 4.0) {
            rgb[0] = sm;
            rgb[1] = sx;
            rgb[2] = sc;
        } else if (hprime < 5.0) {
            rgb[0] = sx;
            rgb[1] = sm;
            rgb[2] = sc;
        } else if (hprime < 6.0) {
            rgb[0] = sc;
            rgb[1] = sm;
            rgb[2] = sx;
        } else {
            rgb[0] = sm;
            rgb[1] = sm;
            rgb[2] = sm;
        }
    }

    private static void convertHSLToRGB(double h, double s, double l, short[] rgb) {
        double m = l;
        double chroma = s * (1.0 - Math.abs(2.0 * m - 1.0));
        m -= chroma * 0.5;
        m *= 255.0;
        chroma *= 255.0;
        double hprime = h / 60.0;
        if (hprime < 0.0) {
            hprime += 6.0;
        }
        short sx = (short)(chroma * (1.0 - Math.abs(hprime % 2.0 - 1.0)) + m);
        short sc = (short)(chroma + m);
        short sm = (short)m;
        if (hprime < 1.0) {
            rgb[0] = sc;
            rgb[1] = sx;
            rgb[2] = sm;
        } else if (hprime < 2.0) {
            rgb[0] = sx;
            rgb[1] = sc;
            rgb[2] = sm;
        } else if (hprime < 3.0) {
            rgb[0] = sm;
            rgb[1] = sc;
            rgb[2] = sx;
        } else if (hprime < 4.0) {
            rgb[0] = sm;
            rgb[1] = sx;
            rgb[2] = sc;
        } else if (hprime < 5.0) {
            rgb[0] = sx;
            rgb[1] = sm;
            rgb[2] = sc;
        } else if (hprime < 6.0) {
            rgb[0] = sc;
            rgb[1] = sm;
            rgb[2] = sx;
        } else {
            rgb[0] = sm;
            rgb[1] = sm;
            rgb[2] = sm;
        }
    }

    @Override
    public RGBDataset getSlice(SliceIterator siter) {
        CompoundShortDataset base = super.getSlice(siter);
        RGBDataset slice = new RGBDataset();
        RGBDataset.copyToView(base, slice, false, false);
        slice.setData();
        return slice;
    }

    @Override
    public RGBDataset getView(boolean deepCopyMetadata) {
        RGBDataset view = new RGBDataset();
        RGBDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public short getRed() {
        return this.data[this.getFirst1DIndex()];
    }

    public short getRed(int i) {
        return this.data[this.get1DIndex(i)];
    }

    public short getRed(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    public short getRed(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    public short getGreen() {
        return this.data[this.getFirst1DIndex() + 1];
    }

    public short getGreen(int i) {
        return this.data[this.get1DIndex(i) + 1];
    }

    public short getGreen(int i, int j) {
        return this.data[this.get1DIndex(i, j) + 1];
    }

    public short getGreen(int ... pos) {
        return this.data[this.get1DIndex(pos) + 1];
    }

    public short getBlue() {
        return this.data[this.getFirst1DIndex() + 2];
    }

    public short getBlue(int i) {
        return this.data[this.get1DIndex(i) + 2];
    }

    public short getBlue(int i, int j) {
        return this.data[this.get1DIndex(i, j) + 2];
    }

    public short getBlue(int ... pos) {
        return this.data[this.get1DIndex(pos) + 2];
    }

    public short getRedAbs(int n) {
        return this.data[n * this.isize];
    }

    public short getGreenAbs(int n) {
        return this.data[n * this.isize + 1];
    }

    public short getBlueAbs(int n) {
        return this.data[n * this.isize + 2];
    }

    public Dataset createGreyDataset(int dtype) {
        return this.createGreyDataset(0.299, 0.587, 0.114, dtype);
    }

    public Dataset createGreyDataset(double red, double green, double blue, int dtype) {
        Dataset grey = DatasetFactory.zeros(this.shape, dtype);
        IndexIterator it = this.getIterator();
        int i = 0;
        while (it.hasNext()) {
            grey.setObjectAbs(i++, red * (double)this.data[it.index] + green * (double)this.data[it.index + 1] + blue * (double)this.data[it.index + 2]);
        }
        return grey;
    }

    public Dataset createRedDataset(int dtype) {
        return this.createColourChannelDataset(0, dtype, "red");
    }

    public Dataset createGreenDataset(int dtype) {
        return this.createColourChannelDataset(1, dtype, "green");
    }

    public Dataset createBlueDataset(int dtype) {
        return this.createColourChannelDataset(2, dtype, "blue");
    }

    private Dataset createColourChannelDataset(int channelOffset, int dtype, String cName) {
        StringBuilder cname;
        Dataset channel = DatasetFactory.zeros(this.shape, dtype);
        StringBuilder stringBuilder = cname = this.name == null ? new StringBuilder() : new StringBuilder(this.name);
        if (cname.length() > 0) {
            cname.append('.');
        }
        cname.append(cName);
        channel.setName(cname.toString());
        IndexIterator it = this.getIterator();
        int i = 0;
        while (it.hasNext()) {
            channel.setObjectAbs(i++, this.data[it.index + channelOffset]);
        }
        return channel;
    }

    public ShortDataset getRedView() {
        return this.getColourChannelView(0, "red");
    }

    public ShortDataset getGreenView() {
        return this.getColourChannelView(1, "green");
    }

    public ShortDataset getBlueView() {
        return this.getColourChannelView(2, "blue");
    }

    private ShortDataset getColourChannelView(int channelOffset, String cName) {
        ShortDataset view = this.getElements(channelOffset);
        view.setName(cName);
        return view;
    }

    @Override
    public Number max(boolean ... ignored) {
        short max = Short.MIN_VALUE;
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            int i = 0;
            while (i < 3) {
                short value = this.data[it.index + i];
                if (value > max) {
                    max = value;
                }
                ++i;
            }
        }
        return max;
    }

    @Override
    public Number min(boolean ... ignored) {
        short max = Short.MAX_VALUE;
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            int i = 0;
            while (i < 3) {
                short value = this.data[it.index + i];
                if (value < max) {
                    max = value;
                }
                ++i;
            }
        }
        return max;
    }

    public static /* bridge */ /* synthetic */ CompoundShortDataset createFromObject(Object object) {
        return RGBDataset.createFromObject(object);
    }
}

