/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.Stats;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class StatsTest {
    private static final String msg = "This test is statistical in nature and can fail. Try re-running.";

    @Test
    public void testRand() {
        Random.seed((int)103);
        DoubleDataset ta = Random.rand((int[])new int[]{100000});
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)ta.stdDeviation(), (double)0.04);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.skewness((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.015);
        Assert.assertEquals((String)msg, (double)-1.2, (double)((Number)Stats.kurtosis((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.001);
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)Stats.median((Dataset)ta)).doubleValue(), (double)0.004);
        DoubleDataset tb = Random.rand((int[])new int[]{100000});
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)tb.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)tb.stdDeviation(), (double)0.04);
        double res = 0.0;
        long start = -System.nanoTime();
        int i = 0;
        while (i < 5) {
            res = Stats.residual((Dataset)ta, (Dataset)tb);
            ++i;
        }
        TestUtils.verbosePrintf((String)"New residual takes %.3fms\n", (Object[])new Object[]{(double)(start += System.nanoTime()) * 1.0E-6});
        DoubleDataset tw = (DoubleDataset)DatasetFactory.zeros(DoubleDataset.class, (int[])new int[]{ta.getSize()});
        double wv = 2.5;
        tw.fill((Object)wv);
        double wres = Stats.weightedResidual((Dataset)ta, (Dataset)tb, (Dataset)tw);
        Assert.assertEquals((String)msg, (double)(wv * res), (double)wres, (double)(1.0E-14 * res));
        Number ores = null;
        start = -System.nanoTime();
        int i2 = 0;
        while (i2 < 5) {
            ores = (Number)Maths.square((Object)Maths.subtract((Object)ta, (Object)tb)).sum(new boolean[0]);
            ++i2;
        }
        TestUtils.verbosePrintf((String)"Old residual takes %.3fms\n", (Object[])new Object[]{(double)(start += System.nanoTime()) * 1.0E-6});
        Assert.assertEquals((String)msg, (double)res, (double)ores.doubleValue(), (double)(1.0E-14 * res));
        Number owres = (Number)Maths.multiply((Object)Maths.square((Object)Maths.subtract((Object)ta, (Object)tb)), (Object)tw).sum(new boolean[0]);
        Assert.assertEquals((String)msg, (double)(wv * ores.doubleValue()), (double)owres.doubleValue(), (double)(1.0E-13 * owres.doubleValue()));
        Assert.assertEquals((String)msg, (double)wres, (double)owres.doubleValue(), (double)(1.0E-14 * wres));
    }

    @Test
    public void testRandn() {
        Random.seed((int)103);
        DoubleDataset ta = Random.randn((int[])new int[]{100000});
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)1.0, (double)ta.stdDeviation(), (double)0.04);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.skewness((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.015);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.kurtosis((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.06);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)Stats.median((Dataset)ta)).doubleValue(), (double)0.04);
        Assert.assertEquals((String)"0-percentile not min!", (double)ta.min(new boolean[0]).doubleValue(), (double)Stats.quantile((Dataset)ta, (double)0.0), (double)1.0E-5);
        Assert.assertEquals((String)"100-percentile not max!", (double)ta.max(new boolean[0]).doubleValue(), (double)Stats.quantile((Dataset)ta, (double)1.0), (double)1.0E-5);
    }

    @Test
    public void testRandExp() {
        Random.seed((int)103);
        double beta = 0.3;
        DoubleDataset ta = Random.exponential((double)beta, (int[])new int[]{100000});
        Assert.assertEquals((String)msg, (double)beta, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)beta, (double)ta.stdDeviation(), (double)0.04);
        Assert.assertEquals((String)msg, (double)2.0, (double)((Number)Stats.skewness((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)6.0, (double)((Number)Stats.kurtosis((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.3);
        Assert.assertEquals((String)msg, (double)(Math.log(2.0) * beta), (double)((Number)Stats.median((Dataset)ta)).doubleValue(), (double)0.004);
        Assert.assertEquals((String)"0-percentile not min!", (double)ta.min(new boolean[0]).doubleValue(), (double)Stats.quantile((Dataset)ta, (double)0.0), (double)1.0E-5);
        Assert.assertEquals((String)"100-percentile not max!", (double)ta.max(new boolean[0]).doubleValue(), (double)Stats.quantile((Dataset)ta, (double)1.0), (double)1.0E-5);
    }

    @Test
    public void testRandPois() {
        Random.seed((int)103);
        double lam = 0.3;
        IntegerDataset ta = Random.poisson((double)lam, (int[])new int[]{100000});
        Assert.assertEquals((String)msg, (double)lam, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)Math.sqrt(lam), (double)ta.stdDeviation(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(1.0 / Math.sqrt(lam)), (double)((Number)Stats.skewness((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.05);
        Assert.assertEquals((String)msg, (double)(1.0 / lam), (double)((Number)Stats.kurtosis((Dataset)ta, (boolean[])new boolean[0])).doubleValue(), (double)0.35);
        Assert.assertEquals((String)msg, (double)Math.floor(lam + 0.3333333333333333 - 0.02 / lam), (double)((Number)Stats.median((Dataset)ta)).doubleValue(), (double)0.004);
        Assert.assertEquals((String)"0-percentile not min!", (double)ta.min(new boolean[0]).doubleValue(), (double)Stats.quantile((Dataset)ta, (double)0.0), (double)1.0E-5);
        Assert.assertEquals((String)"100-percentile not max!", (double)ta.max(new boolean[0]).doubleValue(), (double)Stats.quantile((Dataset)ta, (double)1.0), (double)1.0E-5);
    }

    @Test
    public void testNaNs() {
        Dataset a = DatasetFactory.createRange((double)1.0, (double)7.0, (double)1.0, (int)6);
        Assert.assertEquals((String)"Sum", (double)21.0, (double)((Number)a.sum(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[0])), (double)1.0E-6);
        a.set((Object)Double.NaN, 0);
        Assert.assertTrue((String)"Sum", (boolean)Double.isNaN(((Number)a.sum(new boolean[0])).doubleValue()));
        Assert.assertTrue((String)"Product", (boolean)Double.isNaN((Double)Stats.product((Dataset)a, (boolean[])new boolean[0])));
        Assert.assertTrue((String)"Sum", (boolean)Double.isNaN(((Number)a.sum(new boolean[]{false, true})).doubleValue()));
        Assert.assertTrue((String)"Product", (boolean)Double.isNaN((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{false, true})));
        Assert.assertEquals((String)"Sum", (double)20.0, (double)((Number)a.sum(new boolean[]{true})).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{true})), (double)1.0E-6);
        Assert.assertEquals((String)"Sum", (double)20.0, (double)((Number)a.sum(new boolean[]{true, false})).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{true, false})), (double)1.0E-6);
    }

    @Test
    public void testInfs() {
        Dataset a = DatasetFactory.createRange((double)1.0, (double)7.0, (double)1.0, (int)6);
        Assert.assertEquals((String)"Sum", (double)21.0, (double)((Number)a.sum(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[0])), (double)1.0E-6);
        a.set((Object)Double.POSITIVE_INFINITY, 0);
        Assert.assertTrue((String)"Sum", (boolean)Double.isInfinite(((Number)a.sum(new boolean[0])).doubleValue()));
        Assert.assertTrue((String)"Product", (boolean)Double.isInfinite((Double)Stats.product((Dataset)a, (boolean[])new boolean[0])));
        Assert.assertTrue((String)"Sum", (boolean)Double.isInfinite(((Number)a.sum(new boolean[]{true, false})).doubleValue()));
        Assert.assertTrue((String)"Product", (boolean)Double.isInfinite((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{true, false})));
        Assert.assertEquals((String)"Sum", (double)20.0, (double)((Number)a.sum(new boolean[]{true})).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{true})), (double)1.0E-6);
        Assert.assertEquals((String)"Sum", (double)20.0, (double)((Number)a.sum(new boolean[]{true, true})).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{true, true})), (double)1.0E-6);
        Assert.assertEquals((String)"Sum", (double)20.0, (double)((Number)a.sum(new boolean[]{false, true})).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((String)"Product", (double)720.0, (double)((Double)Stats.product((Dataset)a, (boolean[])new boolean[]{false, true})), (double)1.0E-6);
    }

    @Test
    public void testQuantile() {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        double[] q = Stats.quantile((Dataset)a, (double[])new double[]{0.0, 0.25, 0.5, 0.75, 1.0});
        Assert.assertArrayEquals((double[])new double[]{0.0, 24.75, 49.5, 74.25, 99.0}, (double[])q, (double)1.0E-12);
        Dataset b = a.reshape(new int[]{10, 10});
        Dataset[] qds = Stats.quantile((Dataset)b, (int)1, (double[])new double[]{0.0, 0.25, 0.5, 0.75, 1.0});
        int i = 0;
        while (i < 5) {
            TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createRange(DoubleDataset.class, (double)(2.25 * (double)i), (double)100.0, (double)10.0), (Dataset)qds[i]);
            ++i;
        }
        a = DatasetFactory.createRange((double)81.0);
        q = Stats.quantile((Dataset)a, (double[])new double[]{0.0, 0.25, 0.5, 0.75, 1.0});
        Assert.assertArrayEquals((double[])new double[]{0.0, 20.0, 40.0, 60.0, 80.0}, (double[])q, (double)1.0E-12);
        b = a.reshape(new int[]{9, 9});
        qds = Stats.quantile((Dataset)b, (int)1, (double[])new double[]{0.0, 0.25, 0.5, 0.75, 1.0});
        i = 0;
        while (i < 5) {
            TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createRange(DoubleDataset.class, (double)(2 * i), (double)81.0, (double)9.0), (Dataset)qds[i]);
            ++i;
        }
    }

    @Test
    public void testIqr() {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        Assert.assertEquals((double)49.5, (double)((Double)Stats.iqr((Dataset)a)), (double)1.0E-12);
        Dataset b = a.reshape(new int[]{10, 10});
        Dataset ids = Stats.iqr((Dataset)b, (int)1);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((int[])new int[]{10}).fill((Object)4.5), (Dataset)ids);
        a = DatasetFactory.createRange((double)81.0);
        Assert.assertEquals((double)40.0, (double)((Double)Stats.iqr((Dataset)a)), (double)1.0E-12);
        b = a.reshape(new int[]{9, 9});
        ids = Stats.iqr((Dataset)b, (int)1);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((int[])new int[]{9}).fill((Object)4.0), (Dataset)ids);
    }

    @Test
    public void testSkewness() {
        Dataset a = Maths.abs((Object)DatasetFactory.createRange(DoubleDataset.class, (double)60.0, (double)-40.0, (double)-1.0));
        Assert.assertEquals((double)0.3002253, (double)((Double)Stats.skewness((Dataset)a, (boolean[])new boolean[0])), (double)1.0E-6);
        Dataset b = a.reshape(new int[]{10, 10});
        Dataset sds = Stats.skewness((Dataset)b, (int)1, (boolean[])new boolean[0]);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((int[])new int[]{10}), (Dataset)sds);
    }

    @Test
    public void testKurtosis() {
        DoubleDataset a = DatasetFactory.createRange((double)100.0);
        Assert.assertEquals((double)-1.19999999, (double)((Double)Stats.kurtosis((Dataset)a, (boolean[])new boolean[0])), (double)1.0E-6);
        Dataset b = a.reshape(new int[]{10, 10});
        Dataset sds = Stats.kurtosis((Dataset)b, (int)1, (boolean[])new boolean[0]);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((int[])new int[]{10}).fill((Object)-1.2), (Dataset)sds);
    }

    @Ignore
    @Test
    public void testQuantileSpeed() {
        int i;
        int l;
        int[] ls;
        int REPEAT = 5;
        int LENGTH = 0x400000;
        double LOW = 0.01;
        double HIGH = 0.99;
        Random.seed((int)12371);
        DoubleDataset a = Random.exponential((double)3.75, (int[])new int[]{LENGTH});
        long[] times = new long[REPEAT];
        TestUtils.verbosePrintf((String)"Dataset: mean = %g (%g, %g)\n", (Object[])new Object[]{a.mean(new boolean[0]), a.min(new boolean[0]).doubleValue(), a.max(new boolean[0]).doubleValue()});
        double[] vs = Stats.quantile((Dataset)a, (double[])new double[]{LOW, HIGH});
        int i2 = 0;
        while (i2 < REPEAT) {
            times[i2] = -System.nanoTime();
            Stats.quantile((Dataset)a, (double[])new double[]{LOW, HIGH});
            int n = i2++;
            times[n] = times[n] + System.nanoTime();
        }
        Arrays.sort(times);
        TestUtils.verbosePrintf((String)"Low/High (%g/%g) took %.2fms\n", (Object[])new Object[]{vs[0], vs[1], (double)times[0] / 1000000.0});
        double s = a.getSize();
        double lx = s * LOW;
        double hx = s * (1.0 - HIGH);
        int[] nArray = ls = new int[]{256, 640};
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            l = nArray[n2];
            vs = Stats.outlierValuesList((Dataset)a, (int)l, (int)l);
            i = 0;
            while (i < REPEAT) {
                times[i] = -System.nanoTime();
                Stats.outlierValuesList((Dataset)a, (int)l, (int)l);
                int n3 = i++;
                times[n3] = times[n3] + System.nanoTime();
            }
            Arrays.sort(times);
            TestUtils.verbosePrintf((String)"%4d: Low/High (%g/%g - %.4f/%.4f) took %.2fms\n", (Object[])new Object[]{l, vs[0], vs[1], vs[2] / s, 1.0 - vs[3] / s, (double)times[0] / 1000000.0});
            ++n2;
        }
        nArray = ls = new int[]{640, 1024, 8192};
        n = ls.length;
        n2 = 0;
        while (n2 < n) {
            l = nArray[n2];
            vs = Stats.outlierValuesMap((Dataset)a, (int)l, (int)l);
            i = 0;
            while (i < REPEAT) {
                times[i] = -System.nanoTime();
                Stats.outlierValuesMap((Dataset)a, (int)l, (int)l);
                int n4 = i++;
                times[n4] = times[n4] + System.nanoTime();
            }
            Arrays.sort(times);
            TestUtils.verbosePrintf((String)"%4d: Low/High (%g/%g - %.4f/%.4f) took %.2fms\n", (Object[])new Object[]{l, vs[0], vs[1], vs[2] / s, 1.0 - vs[3] / s, (double)times[0] / 1000000.0});
            ++n2;
        }
        vs = Stats.outlierValuesMap((Dataset)a, (int)((int)lx), (int)((int)hx));
        int i3 = 0;
        while (i3 < REPEAT) {
            times[i3] = -System.nanoTime();
            Stats.outlierValuesMap((Dataset)a, (int)((int)lx), (int)((int)hx));
            int n5 = i3++;
            times[n5] = times[n5] + System.nanoTime();
        }
        Arrays.sort(times);
        TestUtils.verbosePrintf((String)"Low/High (%g/%g - %.4f/%.4f) took %.2fms\n", (Object[])new Object[]{vs[0], vs[1], vs[2] / s, 1.0 - vs[3] / s, (double)times[0] / 1000000.0});
        double[] qs = Stats.quantile((Dataset)a, (double[])new double[]{LOW, HIGH});
        Assert.assertEquals((String)"Lower quantile", (double)qs[0], (double)vs[0], (double)(1.0E-4 * qs[0]));
        Assert.assertEquals((String)"Upper quantile", (double)qs[1], (double)vs[1], (double)(1.0E-4 * qs[1]));
    }

    @Test
    public void testOutlierValues() {
        Dataset a = DatasetFactory.zeros((int[])new int[]{20}, (int)6);
        double[] o = Stats.outlierValues((Dataset)a, (double)0.01, (double)99.9, (int)10);
        Assert.assertEquals((double)0.0, (double)o[0], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)o[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)o[2], (double)1.0E-4);
        Assert.assertEquals((double)100.0, (double)o[3], (double)1.0E-4);
    }

    @Test
    public void testCovarianceRanks() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{-3.5, 6.0, 8.0, 14.0, -2.2, 1.6, 4.0, 7.0});
        DoubleDataset cova = (DoubleDataset)Stats.covariance((Dataset)a);
        Assert.assertEquals((double)32.6283928, (double)cova.getDouble(), (double)1.0E-7);
        Dataset b = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 2.0, 2.0, 1.0, 0.0}, (int[])new int[]{2, 3});
        DoubleDataset covb = (DoubleDataset)Stats.covariance((Dataset)b);
        DoubleDataset bexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{1.0, -1.0, -1.0, 1.0}, (int[])new int[]{2, 2});
        Assert.assertArrayEquals((double[])bexpect.getData(), (double[])covb.getData(), (double)1.0E-7);
        Dataset c = b.transpose(new int[0]);
        DoubleDataset covc = (DoubleDataset)Stats.covariance((Dataset)c);
        DoubleDataset cexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{2.0, 0.0, -2.0, 0.0, 0.0, 0.0, -2.0, 0.0, 2.0}, (int[])new int[]{3, 3});
        Assert.assertArrayEquals((double[])cexpect.getData(), (double[])covc.getData(), (double)1.0E-7);
        Dataset d = DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0}, (int[])new int[]{2, 2, 2});
        DoubleDataset covd = (DoubleDataset)Stats.covariance((Dataset)d);
        DoubleDataset dexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{-2.0, -24.0, -3.0, -48.0, 2.0, 24.0, 3.0, 48.0, -48.0, -576.0, -72.0, -1152.0, 48.0, 576.0, 72.0, 1152.0}, (int[])new int[]{2, 2, 2, 2});
        Assert.assertArrayEquals((double[])dexpect.getData(), (double[])covd.getData(), (double)1.0E-7);
    }

    @Test
    public void testCovarianceArgs() {
        Dataset a = DatasetFactory.createFromObject((Object)new double[]{-3.5, 6.0, 8.0, 14.0, -2.2, 1.6, 4.0, 7.0});
        Dataset b = DatasetFactory.createFromObject((Object)new double[]{8.5, 9.0, 13.0, -2.3, 1.6, 7.2, 3.0, -2.9});
        Dataset c = DatasetUtils.concatenate((IDataset[])new Dataset[]{a, b}, (int)0);
        c.setShape(new int[]{2, 8});
        DoubleDataset covab = (DoubleDataset)Stats.covariance((Dataset)a, (Dataset)b);
        DoubleDataset abexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{32.6283928, -9.4426785, -9.4426785, 32.47125}, (int[])new int[]{2, 2});
        Assert.assertArrayEquals((double[])abexpect.getData(), (double[])covab.getData(), (double)1.0E-7);
        a.setShape(new int[]{4, 2});
        b.setShape(new int[]{4, 2});
        DoubleDataset covabrs = (DoubleDataset)Stats.covariance((Dataset)a, (Dataset)b);
        DoubleDataset abresexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{45.125, 28.5, 18.05, 14.25, 2.375, -72.675, 26.6, -28.025, 28.5, 18.0, 11.4, 9.0, 1.5, -45.9, 16.8, -17.7, 18.05, 11.4, 7.22, 5.7, 0.95, -29.07, 10.64, -11.21, 14.25, 9.0, 5.7, 4.5, 0.75, -22.95, 8.4, -8.85, 2.375, 1.5, 0.95, 0.75, 0.125, -3.825, 1.4, -1.475, -72.675, -45.9, -29.07, -22.95, -3.825, 117.045, -42.84, 45.135, 26.6, 16.8, 10.64, 8.4, 1.4, -42.84, 15.68, -16.52, -28.025, -17.7, -11.21, -8.85, -1.475, 45.135, -16.52, 17.405}, (int[])new int[]{8, 8});
        Assert.assertArrayEquals((double[])abresexpect.getData(), (double[])covabrs.getData(), (double)1.0E-7);
        DoubleDataset covcrv = (DoubleDataset)Stats.covariance((Dataset)c, (boolean)false, (boolean)false, null);
        DoubleDataset crvexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{72.0, 18.0, 30.0, -97.8, 22.8, 33.6, -6.0, -59.4, 18.0, 4.5, 7.5, -24.45, 5.7, 8.4, -1.5, -14.85, 30.0, 7.5, 12.5, -40.75, 9.5, 14.0, -2.5, -24.75, -97.8, -24.45, -40.75, 132.845, -30.97, -45.64, 8.15, 80.685, 22.8, 5.7, 9.5, -30.97, 7.22, 10.64, -1.9, -18.81, 33.6, 8.4, 14.0, -45.64, 10.64, 15.68, -2.8, -27.72, -6.0, -1.5, -2.5, 8.15, -1.9, -2.8, 0.5, 4.95, -59.4, -14.85, -24.75, 80.685, -18.81, -27.72, 4.95, 49.005}, (int[])new int[]{8, 8});
        Assert.assertArrayEquals((double[])crvexpect.getData(), (double[])covcrv.getData(), (double)1.0E-7);
        DoubleDataset covcbias = (DoubleDataset)Stats.covariance((Dataset)c, (boolean)true, (boolean)true, null);
        DoubleDataset cbiasexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{28.54984375, -8.26234375, -8.26234375, 28.41234375}, (int[])new int[]{2, 2});
        Assert.assertArrayEquals((double[])cbiasexpect.getData(), (double[])covcbias.getData(), (double)1.0E-7);
        DoubleDataset covcddof = (DoubleDataset)Stats.covariance((Dataset)c, (boolean)true, (boolean)false, (Integer)2);
        DoubleDataset cddofexpect = (DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{38.06645833, -11.01645833, -11.01645833, 37.883125}, (int[])new int[]{2, 2});
        Assert.assertArrayEquals((double[])cddofexpect.getData(), (double[])covcddof.getData(), (double)1.0E-7);
    }
}

