/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class LongDatasetTest {
    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new LongDataset().getSize());
        Assert.assertEquals((long)0L, (long)DatasetFactory.createFromObject((Object)1).getRank());
        long[] lArray = new long[12];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        lArray[6] = 6L;
        lArray[7] = 7L;
        lArray[8] = 8L;
        lArray[9] = 9L;
        lArray[10] = 10L;
        lArray[11] = 11L;
        long[] da = lArray;
        LongDataset a = new LongDataset(da, new int[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i, (long)a.getElementLongAbs(it.index));
            ++i;
        }
        LongDataset b = new LongDataset(da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((long)i2, (long)b.getElementLongAbs(it.index));
            ++i2;
        }
        a.hashCode();
        b.hashCode();
    }

    @Test
    public void testGetter() {
        long[] lArray = new long[12];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        lArray[6] = 6L;
        lArray[7] = 7L;
        lArray[8] = 8L;
        lArray[9] = 9L;
        lArray[10] = 10L;
        lArray[11] = 11L;
        long[] da = lArray;
        LongDataset a = new LongDataset(da, new int[0]);
        int l = da.length;
        int i = 0;
        while (i < l) {
            Assert.assertEquals((long)i, (long)a.getLong(i));
            ++i;
        }
        i = 0;
        while (i < l) {
            int r = l - 1 - i;
            Assert.assertEquals((long)r, (long)a.getLong(-(i + 1)));
            ++i;
        }
        Dataset sv = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        Dataset sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        l = sc.getSize();
        int i2 = 0;
        while (i2 < l) {
            long r = sc.getLong(-(i2 + 1));
            Assert.assertEquals((long)r, (long)sv.getLong(-(i2 + 1)));
            ++i2;
        }
    }

    @Test
    public void testStats() {
        Dataset a = DatasetFactory.createRange(LongDataset.class, (double)12.0);
        Assert.assertEquals((Object)11L, (Object)a.max(new boolean[0]));
        Assert.assertEquals((double)0.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
    }
}

