/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Date;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DateDataset;
import org.eclipse.january.dataset.DateDatasetImpl;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.junit.Assert;
import org.junit.Test;

public class DateDatasetTest {
    static final long START_DATE = 1443657600000L;
    static final int INTERVAL = 86400000;

    private int[] createOffsets(int pts) {
        int[] times = new int[pts];
        int i = 0;
        while (i < pts) {
            times[i] = 86400000 * i;
            ++i;
        }
        return times;
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new DateDatasetImpl().getSize());
        Assert.assertEquals((long)0L, (long)DatasetFactory.createFromObject((Object)new Date(0L)).getRank());
        int numDates = 10;
        int[] times = this.createOffsets(numDates);
        Date[] dates = new Date[numDates];
        int i = 0;
        while (i < numDates) {
            dates[i] = new Date((long)times[i] + 1443657600000L);
            ++i;
        }
        DateDatasetImpl dataset = new DateDatasetImpl(dates, new int[0]);
        IndexIterator it = dataset.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((Object)dates[i2], (Object)dataset.getDateAbs(i2));
            ++i2;
        }
    }

    @Test
    public void testCreateFromObject() {
        Date date = new Date(1443657600000L);
        DateDatasetImpl dataset = DateDatasetImpl.createFromObject((Object)date);
        Assert.assertEquals((Object)date, (Object)dataset.getDateAbs(0));
        Dataset d = DatasetFactory.createFromObject((Object)date);
        Assert.assertTrue((boolean)(d instanceof DateDataset));
    }

    @Test
    public void testOtherImplementation() {
        int numDates = 10;
        int[] times = this.createOffsets(numDates);
        Date[] dates = new Date[numDates];
        int i = 0;
        while (i < numDates) {
            dates[i] = new Date((long)times[i] + 1443657600000L);
            ++i;
        }
        DateDatasetImpl d = new DateDatasetImpl(dates, new int[0]);
        Assert.assertTrue((boolean)(d instanceof DateDataset));
        Assert.assertEquals((Object)dates[0], (Object)d.getDateAbs(0));
        TimeDataset t = TimeDataset.createDateDataset(new Date(1443657600000L), times);
        Assert.assertTrue((boolean)(t instanceof DateDataset));
        TestUtils.assertDatasetEquals((Dataset)d, (Dataset)t);
        TimeDataset2 t2 = TimeDataset2.createDateDataset(new Date(1443657600000L), times);
        Assert.assertTrue((boolean)(t2 instanceof DateDataset));
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)t2);
    }

    static class TimeDataset
    extends IntegerDataset
    implements DateDataset {
        private static final long serialVersionUID = 1L;
        long start;

        public TimeDataset(int[] times) {
            super(times, null);
        }

        static TimeDataset createDateDataset(Date start, int[] times) {
            TimeDataset t = new TimeDataset(times);
            t.setEpoch(start);
            return t;
        }

        public void setEpoch(Date start) {
            this.start = start.getTime();
        }

        public Date getDate() {
            long t = this.getLong();
            return new Date(this.start + t);
        }

        public Date getDate(int i) {
            long t = this.getLong(i);
            return new Date(this.start + t);
        }

        public Date getDate(int i, int j) {
            long t = this.getLong(i, j);
            return new Date(this.start + t);
        }

        public Date getDate(int ... pos) {
            long t = this.getLong(pos);
            return new Date(this.start + t);
        }

        public Date getDateAbs(int index) {
            long t = this.getElementLongAbs(index);
            return new Date(this.start + t);
        }

        public Object getObject() {
            return this.getDate();
        }

        public Object getObject(int i) {
            return this.getDate(i);
        }

        public Object getObject(int i, int j) {
            return this.getDate(i, j);
        }

        public Object getObject(int ... pos) {
            return this.getDate(pos);
        }

        public Object getObjectAbs(int index) {
            return this.getDateAbs(index);
        }
    }

    static class TimeDataset2
    extends TimeDataset {
        private static final long serialVersionUID = 1L;

        public TimeDataset2(int[] times) {
            super(times);
        }

        static TimeDataset2 createDateDataset(Date start, int[] times) {
            TimeDataset2 t = new TimeDataset2(times);
            t.setEpoch(start);
            return t;
        }
    }
}

