/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.january.dataset.BooleanIteratorBase;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;

public class BooleanBroadcastIterator
extends BooleanIteratorBase {
    private int[] cShape;
    private int[] cStride;
    private final int[] cDelta;
    private final int cStep;
    private int cMax;
    private int cStart;

    public BooleanBroadcastIterator(boolean v, Dataset a, Dataset c, Dataset o, boolean createIfNull) {
        super(v, a, c, o);
        List<int[]> fullShapes = BroadcastUtils.broadcastShapes(a.getShapeRef(), c.getShapeRef(), o == null ? null : o.getShapeRef());
        this.maxShape = fullShapes.remove(0);
        this.oStride = null;
        if (o != null && !Arrays.equals(this.maxShape, o.getShapeRef())) {
            throw new IllegalArgumentException("Output does not match broadcasted shape");
        }
        this.aShape = fullShapes.remove(0);
        this.cShape = fullShapes.remove(0);
        int rank = this.maxShape.length;
        this.endrank = rank - 1;
        this.aDataset = a.reshape(this.aShape);
        this.cDataset = c.reshape(this.cShape);
        this.aStride = BroadcastUtils.createBroadcastStrides(this.aDataset, this.maxShape);
        this.cStride = BroadcastUtils.createBroadcastStrides(this.cDataset, this.maxShape);
        if (this.outputA) {
            this.oStride = this.aStride;
            this.oDelta = null;
            this.oStep = 0;
        } else if (o != null) {
            this.oStride = BroadcastUtils.createBroadcastStrides(o, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = o.getElementsPerItem();
        } else if (createIfNull) {
            this.oDataset = BroadcastUtils.createDataset(a, c, this.maxShape);
            this.oStride = BroadcastUtils.createBroadcastStrides(this.oDataset, this.maxShape);
            this.oDelta = new int[rank];
            this.oStep = this.oDataset.getElementsPerItem();
        } else {
            this.oDelta = null;
            this.oStep = 0;
        }
        this.pos = new int[rank];
        this.aDelta = new int[rank];
        this.cDelta = new int[rank];
        this.cStep = this.cDataset.getElementsPerItem();
        int j = this.endrank;
        while (j >= 0) {
            this.aDelta[j] = this.aStride[j] * this.aShape[j];
            this.cDelta[j] = this.cStride[j] * this.cShape[j];
            if (this.oDelta != null) {
                this.oDelta[j] = this.oStride[j] * this.maxShape[j];
            }
            --j;
        }
        this.aStart = this.aDataset.getOffset();
        this.cStart = this.cDataset.getOffset();
        this.aMax = this.endrank < 0 ? this.aStep + this.aStart : Integer.MIN_VALUE;
        this.cMax = this.endrank < 0 ? this.cStep + this.cStart : Integer.MIN_VALUE;
        this.oStart = this.oDelta == null ? 0 : this.oDataset.getOffset();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        do {
            int j = this.endrank;
            while (j >= 0) {
                int n = j;
                this.pos[n] = this.pos[n] + 1;
                this.index += this.aStride[j];
                this.cIndex += this.cStride[j];
                if (this.oDelta != null) {
                    this.oIndex += this.oStride[j];
                }
                if (this.pos[j] < this.maxShape[j]) break;
                this.pos[j] = 0;
                this.index -= this.aDelta[j];
                this.cIndex -= this.cDelta[j];
                if (this.oDelta != null) {
                    this.oIndex -= this.oDelta[j];
                }
                --j;
            }
            if (j == -1) {
                if (this.endrank >= 0) {
                    return false;
                }
                this.index += this.aStep;
                this.cIndex += this.cStep;
                if (this.oDelta != null) {
                    this.oIndex += this.oStep;
                }
            }
            if (this.outputA) {
                this.oIndex = this.index;
            }
            if (this.index != this.aMax && this.cIndex != this.cMax) continue;
            return false;
        } while (this.cDataset.getElementBooleanAbs(this.cIndex) != this.value);
        return true;
    }

    @Override
    public int[] getFirstShape() {
        return this.aShape;
    }

    public int[] getMaskShape() {
        return this.cShape;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i <= this.endrank) {
            this.pos[i] = 0;
            ++i;
        }
        if (this.endrank >= 0) {
            this.pos[this.endrank] = -1;
            this.index = this.aStart - this.aStride[this.endrank];
            this.cIndex = this.cStart - this.cStride[this.endrank];
            this.oIndex = this.oStart - (this.oStride == null ? 0 : this.oStride[this.endrank]);
        } else {
            this.index = this.aStart - this.aStep;
            this.cIndex = this.cStart - this.cStep;
            this.oIndex = this.oStart - this.oStep;
        }
    }
}

