/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.january.DatasetException;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.internal.SliceableTestMetadata;
import org.eclipse.january.metadata.internal.SubMetadata;
import org.junit.Assert;
import org.junit.Test;

public class SliceableMetadataTest {
    @Test
    public void testSlicingMetadata() {
        SubMetadata tmd;
        int[] shape = new int[]{1, 2, 3, 4};
        ILazyDataset ld = Random.lazyRand((int)3, (String)"Metadata1", (int[])shape);
        DoubleDataset[] dda = new DoubleDataset[]{Random.randn((int[])shape), Random.randn((int[])shape)};
        ArrayList<ShortDataset> sdl = new ArrayList<ShortDataset>();
        sdl.add((ShortDataset)Random.randn((int[])shape).cast(2));
        sdl.add((ShortDataset)Random.randn((int[])shape).cast(2));
        HashMap<String, BooleanDataset> bdm = new HashMap<String, BooleanDataset>();
        bdm.put("1", (BooleanDataset)Random.randn((int[])shape).cast(0));
        bdm.put("2", (BooleanDataset)Random.randn((int[])shape).cast(0));
        ArrayList<DoubleDataset[]> l2 = new ArrayList<DoubleDataset[]>();
        l2.add(new DoubleDataset[]{Random.randn((int[])shape)});
        l2.add(new DoubleDataset[]{Random.randn((int[])shape)});
        SliceableTestMetadata md = new SliceableTestMetadata(ld, dda, sdl, bdm, l2);
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)md);
        try {
            SliceableTestMetadata tmd2 = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((Object)md, (Object)tmd2);
            Assert.assertEquals((long)2L, (long)tmd2.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd2.getList().size());
            Assert.assertEquals((long)2L, (long)tmd2.getMap().size());
            Assert.assertEquals((long)2L, (long)tmd2.getListOfArrays().size());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        Slice[] sliceArray = new Slice[4];
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[3] = new Slice(null, null, Integer.valueOf(2));
        Slice[] slice = sliceArray;
        ILazyDataset sliced = dataset.getSliceView(slice);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 3, 2}, (int[])sliced.getShape());
        try {
            SliceableTestMetadata tmd3 = (SliceableTestMetadata)sliced.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd3.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd3.getList().size());
            Assert.assertEquals((long)2L, (long)tmd3.getMap().size());
            Assert.assertEquals((long)2L, (long)tmd3.getListOfArrays().size());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getListOfArrays().get(0)[0].getShape());
            tmd3 = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd3.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd3.getList().size());
            Assert.assertEquals((long)2L, (long)tmd3.getMap().size());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getListOfArrays().get(0)[0].getShape());
            IDataset slice2 = sliced.getSlice(new Slice[0]);
            tmd3 = (SliceableTestMetadata)slice2.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd3.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd3.getList().size());
            Assert.assertEquals((long)2L, (long)tmd3.getMap().size());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd3.getListOfArrays().get(0)[0].getShape());
            tmd3 = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd3.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd3.getList().size());
            Assert.assertEquals((long)2L, (long)tmd3.getMap().size());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])shape, (int[])tmd3.getListOfArrays().get(0)[0].getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        SubMetadata smd = new SubMetadata(ld, dda, sdl, bdm, l2);
        dataset.setMetadata((MetadataType)smd);
        sliced = dataset.getSliceView(slice);
        try {
            tmd = (SubMetadata)dataset.getMetadata(SubMetadata.class).get(0);
            Assert.assertEquals((Object)smd, (Object)tmd);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertEquals((long)2L, (long)tmd.getListOfArrays().size());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        Assert.assertArrayEquals((int[])new int[]{1, 1, 3, 2}, (int[])sliced.getShape());
        try {
            tmd = (SubMetadata)sliced.getMetadata(SubMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd.getLazyDataset2().getShape());
            Assert.assertArrayEquals((int[])sliced.getShape(), (int[])tmd.getListOfArrays().get(0)[0].getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
    }

    @Test
    public void testSlicingSqueezedMetadata() throws DatasetException {
        SliceableTestMetadata tmd;
        int[] shape = new int[]{1, 1, 128};
        ILazyDataset ld = Random.lazyRand((int)3, (String)"Metadata1", (int[])shape);
        SliceableTestMetadata md = new SliceableTestMetadata(ld, null, null, null, null);
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)md);
        Slice[] sliceArray = new Slice[3];
        sliceArray[2] = new Slice(Integer.valueOf(64));
        Slice[] slice = sliceArray;
        ILazyDataset sliced = dataset.getSliceView(slice);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 64}, (int[])sliced.getShape());
        dataset.squeezeEnds();
        Assert.assertEquals((long)1L, (long)dataset.getRank());
        Assert.assertArrayEquals((int[])new int[]{128}, (int[])dataset.getShape());
        try {
            tmd = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)1L, (long)tmd.getLazyDataset().getRank());
            Assert.assertArrayEquals((int[])new int[]{128}, (int[])tmd.getLazyDataset().getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        slice = new Slice[]{new Slice(Integer.valueOf(64))};
        sliced = dataset.getSliceView(slice);
        Assert.assertEquals((long)1L, (long)sliced.getRank());
        Assert.assertArrayEquals((int[])new int[]{64}, (int[])sliced.getShape());
        try {
            tmd = (SliceableTestMetadata)sliced.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)1L, (long)tmd.getLazyDataset().getRank());
            Assert.assertArrayEquals((int[])new int[]{64}, (int[])tmd.getLazyDataset().getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        slice = new Slice[]{new Slice(Integer.valueOf(64))};
        sliced = dataset.getSlice(slice);
        Assert.assertEquals((long)1L, (long)sliced.getRank());
        Assert.assertArrayEquals((int[])new int[]{64}, (int[])sliced.getShape());
        try {
            tmd = (SliceableTestMetadata)sliced.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)1L, (long)tmd.getLazyDataset().getRank());
            Assert.assertArrayEquals((int[])new int[]{64}, (int[])tmd.getLazyDataset().getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
    }

    @Test
    public void testSlicingSameRankDifferentShapeMetadata() {
        int[] result1 = new int[]{1, 1, 1, 1};
        int[] result2 = new int[]{1, 1, 3, 1};
        int[] shape = new int[]{1, 2, 3, 4};
        ILazyDataset ld = Random.lazyRand((int)3, (String)"Metadata1", (int[])shape);
        int[] partial1 = new int[]{1, 1, 1, 4};
        DoubleDataset[] dda = new DoubleDataset[]{Random.randn((int[])partial1), Random.randn((int[])partial1)};
        int[] partial2 = new int[]{1, 1, 3, 1};
        ArrayList<ShortDataset> sdl = new ArrayList<ShortDataset>();
        sdl.add((ShortDataset)Random.randn((int[])partial2).cast(2));
        sdl.add((ShortDataset)Random.randn((int[])partial2).cast(2));
        int[] partial3 = new int[]{1, 2, 1, 1};
        HashMap<String, BooleanDataset> bdm = new HashMap<String, BooleanDataset>();
        bdm.put("1", (BooleanDataset)Random.randn((int[])partial3).cast(0));
        bdm.put("2", (BooleanDataset)Random.randn((int[])partial3).cast(0));
        ArrayList<DoubleDataset[]> l2 = new ArrayList<DoubleDataset[]>();
        l2.add(new DoubleDataset[]{Random.randn((int[])partial1)});
        l2.add(new DoubleDataset[]{Random.randn((int[])partial1)});
        SliceableTestMetadata md = new SliceableTestMetadata(ld, dda, sdl, bdm, l2);
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)md);
        try {
            SliceableTestMetadata tmd = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((Object)md, (Object)tmd);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertEquals((long)2L, (long)tmd.getListOfArrays().size());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        Slice[] sliceArray = new Slice[4];
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[3] = new Slice(Integer.valueOf(1));
        Slice[] slice = sliceArray;
        ILazyDataset sliced = dataset.getSliceView(slice);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 3, 1}, (int[])sliced.getShape());
        try {
            SliceableTestMetadata tmd = (SliceableTestMetadata)sliced.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertArrayEquals((int[])result2, (int[])tmd.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])result2, (int[])tmd.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getListOfArrays().get(0)[0].getShape());
            tmd = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertArrayEquals((int[])shape, (int[])tmd.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])partial1, (int[])tmd.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])partial2, (int[])tmd.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])partial3, (int[])tmd.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])partial1, (int[])tmd.getListOfArrays().get(0)[0].getShape());
            IDataset slice2 = sliced.getSlice(new Slice[0]);
            tmd = (SliceableTestMetadata)slice2.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertArrayEquals((int[])result2, (int[])tmd.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])result2, (int[])tmd.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getListOfArrays().get(0)[0].getShape());
            tmd = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertArrayEquals((int[])shape, (int[])tmd.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])partial1, (int[])tmd.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])partial2, (int[])tmd.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])partial3, (int[])tmd.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])partial1, (int[])tmd.getListOfArrays().get(0)[0].getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
    }

    @Test
    public void testSlicingSameRankDifferentShapeMetadataFail() {
        ILazyDataset sliced;
        int[] result1 = new int[]{1, 1, 1, 2};
        int[] result2 = new int[]{1, 1, 3, 2};
        int[] shape = new int[]{1, 2, 3, 4};
        ILazyDataset ld = Random.lazyRand((int)3, (String)"Metadata1", (int[])shape);
        int[] partial1 = new int[]{1, 1, 1, 4};
        DoubleDataset[] dda = new DoubleDataset[]{Random.randn((int[])partial1), Random.randn((int[])partial1)};
        int[] partial2 = new int[]{1, 1, 3, 4};
        ArrayList<ShortDataset> sdl = new ArrayList<ShortDataset>();
        sdl.add((ShortDataset)Random.randn((int[])partial2).cast(2));
        sdl.add((ShortDataset)Random.randn((int[])partial2).cast(2));
        int[] partial3 = new int[]{1, 1, 1, 3};
        HashMap<String, BooleanDataset> bdm = new HashMap<String, BooleanDataset>();
        bdm.put("1", (BooleanDataset)Random.randn((int[])partial3).cast(0));
        bdm.put("2", (BooleanDataset)Random.randn((int[])partial3).cast(0));
        ArrayList<DoubleDataset[]> l2 = new ArrayList<DoubleDataset[]>();
        l2.add(new DoubleDataset[]{Random.randn((int[])shape)});
        l2.add(new DoubleDataset[]{Random.randn((int[])shape)});
        SliceableTestMetadata md = new SliceableTestMetadata(ld, dda, sdl, bdm, l2);
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)md);
        try {
            SliceableTestMetadata tmd = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((Object)md, (Object)tmd);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        Slice[] sliceArray = new Slice[4];
        sliceArray[1] = new Slice(Integer.valueOf(1));
        sliceArray[3] = new Slice(Integer.valueOf(0), Integer.valueOf(2));
        Slice[] slice = sliceArray;
        try {
            sliced = dataset.getSliceView(slice);
            Assert.fail((String)"Should not get here");
        }
        catch (Exception exception) {}
        int[] partial4 = new int[]{1, 2, 1, 1};
        int[] result3 = new int[]{1, 1, 1, 1};
        bdm.put("1", (BooleanDataset)Random.randn((int[])partial4).cast(0));
        bdm.put("2", (BooleanDataset)Random.randn((int[])partial4).cast(0));
        sliced = dataset.getSliceView(slice);
        Assert.assertArrayEquals((int[])new int[]{1, 1, 3, 2}, (int[])sliced.getShape());
        try {
            SliceableTestMetadata tmd = (SliceableTestMetadata)sliced.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertArrayEquals((int[])new int[]{1, 1, 3, 2}, (int[])tmd.getLazyDataset().getShape());
            Assert.assertArrayEquals((int[])result1, (int[])tmd.getArray()[0].getShape());
            Assert.assertArrayEquals((int[])result2, (int[])tmd.getList().get(0).getShape());
            Assert.assertArrayEquals((int[])result3, (int[])tmd.getMap().get("1").getShape());
            Assert.assertArrayEquals((int[])result3, (int[])tmd.getMap().get("2").getShape());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
    }

    @Test
    public void testSlicingSameRankDifferentShapeSqueezeMetadata() {
        SliceableTestMetadata tmd;
        int[] shape = new int[]{1, 2, 3, 4};
        ILazyDataset ld = Random.lazyRand((int)3, (String)"Metadata1", (int[])shape);
        int[] partial1 = new int[]{1, 1, 1, 4};
        DoubleDataset[] dda = new DoubleDataset[]{Random.randn((int[])partial1), Random.randn((int[])partial1)};
        int[] partial2 = new int[]{1, 1, 3, 1};
        ArrayList<ShortDataset> sdl = new ArrayList<ShortDataset>();
        sdl.add((ShortDataset)Random.randn((int[])partial2).cast(2));
        sdl.add((ShortDataset)Random.randn((int[])partial2).cast(2));
        int[] partial3 = new int[]{1, 2, 1, 1};
        HashMap<String, BooleanDataset> bdm = new HashMap<String, BooleanDataset>();
        bdm.put("1", (BooleanDataset)Random.randn((int[])partial3).cast(0));
        bdm.put("2", (BooleanDataset)Random.randn((int[])partial3).cast(0));
        ArrayList<DoubleDataset[]> l2 = new ArrayList<DoubleDataset[]>();
        l2.add(new DoubleDataset[]{Random.randn((int[])partial1)});
        l2.add(new DoubleDataset[]{Random.randn((int[])partial1)});
        SliceableTestMetadata md = new SliceableTestMetadata(ld, dda, sdl, bdm, l2);
        ILazyDataset dataset = Random.lazyRand((int)3, (String)"Main", (int[])shape);
        dataset.addMetadata((MetadataType)md);
        try {
            SliceableTestMetadata tmd2 = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((Object)md, (Object)tmd2);
            Assert.assertEquals((long)2L, (long)tmd2.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd2.getList().size());
            Assert.assertEquals((long)2L, (long)tmd2.getMap().size());
            Assert.assertEquals((long)2L, (long)tmd2.getListOfArrays().size());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        Slice[] sliceArray = new Slice[4];
        sliceArray[0] = new Slice(Integer.valueOf(1));
        sliceArray[1] = new Slice(Integer.valueOf(1));
        Slice[] slice = sliceArray;
        ILazyDataset sliced = dataset.getSliceView(slice);
        sliced.squeezeEnds();
        int rank = sliced.getRank();
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])sliced.getShape());
        try {
            tmd = (SliceableTestMetadata)sliced.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertEquals((long)rank, (long)tmd.getLazyDataset().getRank());
            Assert.assertEquals((long)rank, (long)tmd.getArray()[0].getRank());
            Assert.assertEquals((long)rank, (long)tmd.getList().get(0).getRank());
            Assert.assertEquals((long)rank, (long)tmd.getMap().get("1").getRank());
            Assert.assertEquals((long)rank, (long)tmd.getListOfArrays().get(0)[0].getRank());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
        dataset = Random.randn((int[])shape).cast(3);
        md = new SliceableTestMetadata(null, dda, sdl, bdm, l2);
        dataset.addMetadata((MetadataType)md);
        try {
            dataset.setShape(new int[]{2, 4, 3});
            Assert.fail((String)"Should fail!");
        }
        catch (Exception exception) {}
        dataset.setShape(new int[]{1, 2, 3, 2, 2});
        rank = dataset.getRank();
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 2, 2}, (int[])dataset.getShape());
        try {
            tmd = (SliceableTestMetadata)dataset.getMetadata(SliceableTestMetadata.class).get(0);
            Assert.assertEquals((long)2L, (long)tmd.getArray().length);
            Assert.assertEquals((long)2L, (long)tmd.getList().size());
            Assert.assertEquals((long)2L, (long)tmd.getMap().size());
            Assert.assertEquals((long)rank, (long)tmd.getArray()[0].getRank());
            Assert.assertEquals((long)rank, (long)tmd.getList().get(0).getRank());
            Assert.assertEquals((long)rank, (long)tmd.getMap().get("1").getRank());
            Assert.assertEquals((long)rank, (long)tmd.getListOfArrays().get(0)[0].getRank());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not fail: " + e));
        }
    }
}

