/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.junit.Assert;
import org.junit.Test;

public class BooleanDatasetTest {
    private static final double ABSERRD = 1.0E-8;

    @Test
    public void testConstructor() {
        boolean[] blArray = new boolean[12];
        blArray[1] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[11] = true;
        boolean[] da = blArray;
        BooleanDataset a = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)da);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((Object)(i % 2 != 0 ? 1 : 0), (Object)a.getElementBooleanAbs(it.index));
            ++i;
        }
        BooleanDataset b = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)da, (int[])new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((Object)(i2 % 2 != 0 ? 1 : 0), (Object)b.getElementBooleanAbs(it.index));
            ++i2;
        }
        a.hashCode();
        b.hashCode();
    }

    @Test
    public void testGetter() {
        boolean[] blArray = new boolean[12];
        blArray[1] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[7] = true;
        blArray[9] = true;
        blArray[11] = true;
        boolean[] da = blArray;
        BooleanDataset a = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)da);
        int l = da.length;
        int i = 0;
        while (i < l) {
            Assert.assertEquals((Object)da[i], (Object)a.getBoolean(i));
            ++i;
        }
        i = 0;
        while (i < l) {
            boolean r = da[l - 1 - i];
            Assert.assertEquals((Object)r, (Object)a.getBoolean(-(i + 1)));
            ++i;
        }
        Dataset sv = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        Dataset sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        l = sc.getSize();
        int i2 = 0;
        while (i2 < l) {
            boolean r = sc.getBoolean(-(i2 + 1));
            Assert.assertEquals((Object)r, (Object)sv.getBoolean(-(i2 + 1)));
            ++i2;
        }
    }

    @Test
    public void testISubstract() {
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] obj = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[2] = true;
        blArray2[3] = true;
        boolean[] objToSubstract = blArray2;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)obj);
        boolean[] result = new boolean[4];
        int index = 0;
        while (index < 4) {
            result[index] = obj[index] ^ objToSubstract[index];
            ++index;
        }
        Dataset output = DatasetFactory.createFromObject(BooleanDataset.class, (Object)result);
        input.isubtract((Object)objToSubstract);
        TestUtils.assertDatasetEquals((Dataset)output, (Dataset)input);
    }

    @Test
    public void testGetElementBooleanAbs() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] values = nArray;
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        int[] nArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray2[n2];
            boolean actualResult = input.getElementBooleanAbs(val);
            boolean result = value[val];
            Assert.assertEquals((Object)result, (Object)actualResult);
            ++n2;
        }
    }

    @Test
    public void testGetElementbooleanAbs() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] values = nArray;
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        int[] nArray2 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray2[n2];
            boolean actualResult = input.getElementBooleanAbs(val);
            boolean result = value[val];
            Assert.assertEquals((Object)result, (Object)actualResult);
            ++n2;
        }
    }

    @Test
    public void testGetElementLongAbs() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] values = nArray;
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] value = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        boolean[] results = new boolean[4];
        boolean[] expectedResults = new boolean[4];
        int i = 0;
        while (i < value.length) {
            results[i] = input.getElementLongAbs(values[i]) > 0L;
            expectedResults[i] = value[i];
            ++i;
        }
        Assert.assertArrayEquals((boolean[])expectedResults, (boolean[])results);
    }

    @Test
    public void testEquals() {
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArray2[2] = true;
        boolean[] value2 = blArray2;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        Dataset checkerTrue = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        Dataset checkerFalse = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value2);
        boolean checkInput1 = input.equals(checkerTrue);
        boolean checkInput2 = input.equals(checkerFalse);
        Assert.assertEquals((Object)checkInput1, (Object)true);
        Assert.assertEquals((Object)checkInput2, (Object)false);
    }

    @Test
    public void testGetSlice() {
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[6] = true;
        boolean[] value = blArray;
        boolean[] blArray2 = new boolean[5];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[4] = true;
        boolean[] expectedObj = blArray2;
        Dataset dataset = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)expectedObj);
        Dataset actual = dataset.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testFillDataset() {
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        IndexIterator iter = input.getIterator();
        DoubleDataset n = DatasetFactory.zeros((int[])new int[]{4});
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)n);
        input.fillDataset(expected, iter);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input);
    }

    @Test
    public void testFill() {
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        DoubleDataset output = DatasetFactory.ones((int[])new int[]{4});
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)output);
        input.fill((Object)1);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input);
    }

    @Test
    public void testIAdd() {
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        boolean[] valueToAdd = new boolean[]{true, true, true, true};
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        boolean[] result = new boolean[4];
        int index = 0;
        while (index < 4) {
            result[index] = value[index] | valueToAdd[index];
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)result);
        input.iadd((Object)valueToAdd);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input);
    }

    @Test
    public void testIdivide() {
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] value = blArray;
        boolean[] valueToAdd = new boolean[]{true, true, true, true};
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        boolean[] result = new boolean[4];
        int index = 0;
        while (index < 4) {
            result[index] = value[index] & valueToAdd[index];
            ++index;
        }
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)result);
        input.idivide((Object)valueToAdd);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input);
    }

    @Test
    public void testSetByBoolean() {
        boolean[] value = new boolean[]{true, true, true, true};
        boolean[] newObj = new boolean[]{true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] bool = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        Dataset newInput = DatasetFactory.createFromObject(BooleanDataset.class, (Object)newObj);
        Dataset boolInput = DatasetFactory.createFromObject(BooleanDataset.class, (Object)bool);
        Dataset output = input.setByBoolean((Object)newInput, boolInput);
        boolean[] expectedObj = new boolean[]{true, true, true, true};
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)expectedObj);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)output);
    }

    @Test
    public void testSetby1DIndex() {
        boolean[] valuesIn = new boolean[]{true, true, true, true};
        boolean[] valueExpected = new boolean[]{true, true, true, true};
        boolean[] valueOut = new boolean[]{true, true};
        Dataset out = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valueOut);
        Dataset in = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valuesIn);
        int[] nArray = new int[2];
        nArray[1] = 2;
        Dataset index = DatasetFactory.createFromObject((Object)nArray);
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valueExpected);
        Dataset actual = in.setBy1DIndex((Object)out, index);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testSetSlice() {
        boolean[] value = new boolean[]{true, true, true, true};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] valueExpected = blArray;
        Dataset input = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valueExpected);
        DoubleDataset tdata = DatasetFactory.zeros((int[])new int[]{2});
        SliceIterator siter = (SliceIterator)input.getSliceIterator(new int[]{2}, new int[]{4}, null);
        input.setSlice((Object)tdata, (IndexIterator)siter);
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)input);
    }

    @Test
    public void testSetByIndexes() {
        boolean[][] valuesIn = new boolean[][]{{true, true, true, true}, {true, true, true, true}};
        boolean[] valueOut = new boolean[]{true, true};
        boolean[][] valueExpected = new boolean[][]{{true, true, true, true}, {true, true, true, true}};
        Dataset expected = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valueExpected);
        Dataset in = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valuesIn);
        Dataset out = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valueOut);
        int[] nArray = new int[2];
        nArray[1] = 1;
        Dataset index1 = DatasetFactory.createFromObject((Object)nArray);
        Dataset index2 = DatasetFactory.createFromObject((Object)new int[]{1, 3});
        Dataset actual = in.setByIndexes((Object)out, new Object[]{index1, index2});
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)actual);
    }

    @Test
    public void testResidual() {
        boolean[] blArray = new boolean[4];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        boolean[] value = blArray;
        boolean[] value2 = new boolean[]{true, true, true, true};
        boolean[] blArray2 = new boolean[4];
        blArray2[0] = true;
        blArray2[2] = true;
        blArray2[3] = true;
        boolean[] valueW = blArray2;
        Dataset in = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value);
        Dataset in2 = DatasetFactory.createFromObject(BooleanDataset.class, (Object)value2);
        Dataset w = DatasetFactory.createFromObject(BooleanDataset.class, (Object)valueW);
        double sumExpected = 1.0;
        double sum = in.residual((Object)in2, w, true);
        Assert.assertEquals((double)sumExpected, (double)sum, (double)1.0E-8);
        sum = in.residual((Object)in2, null, true);
        sumExpected = 1.0;
        Assert.assertEquals((double)sumExpected, (double)sum, (double)1.0E-8);
    }
}

