/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.AbstractCompoundDataset;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;

public class CompoundIntegerDataset
extends AbstractCompoundDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected int[] data;

    @Override
    protected void setData() {
        this.data = (int[])this.odata;
    }

    protected int[] createArray(int size) {
        int[] array = null;
        try {
            array = new int[this.isize * size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)size);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return array;
    }

    @Override
    public int getDType() {
        return 300;
    }

    CompoundIntegerDataset() {
    }

    CompoundIntegerDataset(int itemSize) {
        this.isize = itemSize;
    }

    CompoundIntegerDataset(int itemSize, int[] shape) {
        this.isize = itemSize;
        if (shape != null) {
            this.size = ShapeUtils.calcSize(shape);
            this.shape = (int[])shape.clone();
            try {
                this.data = this.createArray(this.size);
                this.odata = this.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    CompoundIntegerDataset(CompoundIntegerDataset dataset) {
        this.isize = dataset.isize;
        CompoundIntegerDataset.copyToView(dataset, this, true, true);
        try {
            if (dataset.stride == null) {
                if (dataset.data != null) {
                    this.data = (int[])dataset.data.clone();
                    this.odata = this.data;
                }
            } else {
                this.offset = 0;
                this.stride = null;
                this.base = null;
                this.data = this.createArray(this.size);
                this.odata = this.data;
                IndexIterator iter = dataset.getIterator();
                int j = 0;
                while (iter.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        this.data[j++] = dataset.data[iter.index + i];
                        ++i;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
    }

    CompoundIntegerDataset(CompoundDataset dataset) {
        CompoundIntegerDataset.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        this.isize = dataset.getElementsPerItem();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        int j = 0;
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                this.data[j++] = (int)dataset.getElementLongAbs(iter.index + i);
                ++i;
            }
        }
    }

    CompoundIntegerDataset(int itemSize, int[] data, int ... shape) {
        this.isize = itemSize;
        if (data != null) {
            if (shape == null || shape.length == 0 && data.length > this.isize) {
                shape = new int[]{data.length / this.isize};
            }
            this.size = ShapeUtils.calcSize(shape);
            if (this.size * this.isize != data.length) {
                throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), data.length / this.isize));
            }
            this.shape = this.size == 0 ? null : (int[])shape.clone();
            this.data = data;
            this.odata = data;
        }
    }

    CompoundIntegerDataset(Dataset ... datasets) {
        if (datasets.length < 1) {
            throw new IllegalArgumentException("Array of datasets must have length greater than zero");
        }
        int i = 1;
        while (i < datasets.length) {
            datasets[0].checkCompatibility(datasets[i]);
            ++i;
        }
        this.isize = datasets.length;
        this.size = ShapeUtils.calcSize(datasets[0].getShapeRef());
        this.shape = datasets[0].getShape();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator[] iters = new IndexIterator[this.isize];
        int i2 = 0;
        while (i2 < datasets.length) {
            iters[i2] = datasets[i2].getIterator();
            ++i2;
        }
        int j = 0;
        while (iters[0].hasNext()) {
            this.data[j++] = (int)datasets[0].getElementLongAbs(iters[0].index);
            int i3 = 1;
            while (i3 < datasets.length) {
                iters[i3].hasNext();
                this.data[j++] = (int)datasets[i3].getElementLongAbs(iters[i3].index);
                ++i3;
            }
        }
    }

    CompoundIntegerDataset(int itemSize, boolean repeat, Dataset dataset) {
        this.isize = itemSize;
        this.size = dataset.getSize();
        this.shape = dataset.getShape();
        this.name = new String(dataset.getName());
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int os = dataset.getElementsPerItem();
        IndexIterator iter = dataset.getIterator();
        if (repeat) {
            int i = 0;
            while (iter.hasNext()) {
                int v = (int)dataset.getElementLongAbs(iter.index);
                int k = 0;
                while (k < this.isize) {
                    this.data[i++] = v;
                    ++k;
                }
            }
        } else {
            int kmax = Math.min(this.isize, os);
            int i = 0;
            while (iter.hasNext()) {
                int k = 0;
                while (k < kmax) {
                    this.data[i + k] = (int)dataset.getElementLongAbs(iter.index + k);
                    ++k;
                }
                i += this.isize;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getRank() == 0 && !this.getClass().equals(obj.getClass())) {
            return true;
        }
        CompoundIntegerDataset other = (CompoundIntegerDataset)obj;
        IndexIterator iter = this.getIterator();
        IndexIterator oiter = other.getIterator();
        while (iter.hasNext() && oiter.hasNext()) {
            int j = 0;
            while (j < this.isize) {
                if (this.data[iter.index + j] != other.data[oiter.index + j]) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public CompoundIntegerDataset clone() {
        return new CompoundIntegerDataset(this);
    }

    static CompoundIntegerDataset createFromObject(Object obj) {
        IntegerDataset result = IntegerDataset.createFromObject(obj);
        return (CompoundIntegerDataset)DatasetUtils.createCompoundDatasetFromLastAxis(result, true);
    }

    public static CompoundIntegerDataset createFromObject(int itemSize, Object obj) {
        IntegerDataset result = IntegerDataset.createFromObject(obj);
        return new CompoundIntegerDataset(itemSize, result.getData(), null);
    }

    static CompoundIntegerDataset createRange(int itemSize, double stop) {
        return CompoundIntegerDataset.createRange(itemSize, 0.0, stop, 1.0);
    }

    static CompoundIntegerDataset createRange(int itemSize, double start, double stop, double step) {
        int size = CompoundIntegerDataset.calcSteps(start, stop, step);
        CompoundIntegerDataset result = new CompoundIntegerDataset(itemSize, new int[]{size});
        int i = 0;
        while (i < size) {
            result.data[i * result.isize] = (int)(start + (double)i * step);
            ++i;
        }
        return result;
    }

    static CompoundIntegerDataset ones(int itemSize, int ... shape) {
        return new CompoundIntegerDataset(itemSize, shape).fill(1);
    }

    public static CompoundIntegerDataset createCompoundDatasetWithLastDimension(Dataset a, boolean shareData) {
        int[] nArray;
        if (a.getElementsPerItem() != 1) {
            logger.error("Need a single-element dataset");
            throw new IllegalArgumentException("Need a single-element dataset");
        }
        if (a.getDType() != 3) {
            logger.error("Dataset type must be int");
            throw new IllegalArgumentException("Dataset type must be int");
        }
        int[] shape = a.getShapeRef();
        if (shape == null) {
            return new CompoundIntegerDataset(0);
        }
        int rank = shape.length - 1;
        int is = rank < 0 ? 1 : shape[rank];
        CompoundIntegerDataset result = new CompoundIntegerDataset(is);
        if (rank > 0) {
            nArray = Arrays.copyOf(shape, rank);
        } else if (rank < 0) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        }
        result.shape = nArray;
        result.size = ShapeUtils.calcSize(result.shape);
        result.odata = shareData ? a.getBuffer() : a.clone().getBuffer();
        result.setName(a.getName());
        result.setData();
        return result;
    }

    @Override
    public IntegerDataset asNonCompoundDataset(boolean shareData) {
        IntegerDataset result = new IntegerDataset();
        int is = this.getElementsPerItem();
        int rank = is == 1 ? this.shape.length : this.shape.length + 1;
        int[] nshape = Arrays.copyOf(this.shape, rank);
        if (is != 1) {
            nshape[rank - 1] = is;
        }
        result.shape = nshape;
        result.size = ShapeUtils.calcSize(nshape);
        result.odata = shareData ? this.data : (int[])this.data.clone();
        result.setName(this.name);
        result.setData();
        return result;
    }

    @Override
    public CompoundIntegerDataset fill(Object obj) {
        this.setDirty();
        int[] vr = DTypeUtils.toIntegerArray(obj, this.isize);
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                this.data[iter.index + i] = vr[i];
                ++i;
            }
        }
        return this;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    protected int getBufferLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public CompoundIntegerDataset getView(boolean deepCopyMetadata) {
        CompoundIntegerDataset view = new CompoundIntegerDataset(this.isize);
        CompoundIntegerDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public int[] getAbs(int index) {
        int[] result = new int[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = this.data[index + i];
            ++i;
        }
        return result;
    }

    public void getAbs(int index, int[] values) {
        int i = 0;
        while (i < this.isize) {
            values[i] = this.data[index + i];
            ++i;
        }
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        return this.data[index] != 0;
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return this.data[index];
    }

    @Override
    public long getElementLongAbs(int index) {
        return this.data[index];
    }

    @Override
    protected void setItemDirect(int dindex, int sindex, Object src) {
        this.setDirty();
        int[] dsrc = (int[])src;
        int i = 0;
        while (i < this.isize) {
            this.data[dindex + i] = dsrc[sindex + i];
            ++i;
        }
    }

    public void setAbs(int index, int[] val) {
        this.setDirty();
        int i = 0;
        while (i < this.isize) {
            this.data[index + i] = val[i];
            ++i;
        }
    }

    public void setAbs(int index, int val) {
        this.setDirty();
        this.data[index] = val;
    }

    @Override
    public Object getObject() {
        return this.getIntArray();
    }

    @Override
    public Object getObject(int i) {
        return this.getIntArray(i);
    }

    @Override
    public Object getObject(int i, int j) {
        return this.getIntArray(i, j);
    }

    @Override
    public Object getObject(int ... pos) {
        return this.getIntArray(pos);
    }

    @Override
    public byte[] getByteArray() {
        byte[] result = new byte[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public byte[] getByteArray(int i) {
        byte[] result = new byte[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public byte[] getByteArray(int i, int j) {
        byte[] result = new byte[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public byte[] getByteArray(int ... pos) {
        byte[] result = new byte[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (byte)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray() {
        short[] result = new short[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray(int i) {
        short[] result = new short[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray(int i, int j) {
        short[] result = new short[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public short[] getShortArray(int ... pos) {
        short[] result = new short[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = (short)this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray() {
        int[] result = new int[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray(int i) {
        int[] result = new int[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray(int i, int j) {
        int[] result = new int[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public int[] getIntArray(int ... pos) {
        int[] result = new int[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray() {
        long[] result = new long[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray(int i) {
        long[] result = new long[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray(int i, int j) {
        long[] result = new long[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public long[] getLongArray(int ... pos) {
        long[] result = new long[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray() {
        float[] result = new float[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int i) {
        float[] result = new float[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int i, int j) {
        float[] result = new float[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int ... pos) {
        float[] result = new float[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray() {
        double[] result = new double[this.isize];
        int index = this.getFirst1DIndex();
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int i) {
        double[] result = new double[this.isize];
        int index = this.get1DIndex(i);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int i, int j) {
        double[] result = new double[this.isize];
        int index = this.get1DIndex(i, j);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int ... pos) {
        double[] result = new double[this.isize];
        int index = this.get1DIndex(pos);
        int k = 0;
        while (k < this.isize) {
            result[k] = this.data[index + k];
            ++k;
        }
        return result;
    }

    @Override
    public void getDoubleArrayAbs(int index, double[] darray) {
        int i = 0;
        while (i < this.isize) {
            darray[i] = this.data[index + i];
            ++i;
        }
    }

    @Override
    public String getString() {
        return this.getStringAbs(this.getFirst1DIndex());
    }

    @Override
    public String getString(int i) {
        return this.getStringAbs(this.get1DIndex(i));
    }

    @Override
    public String getString(int i, int j) {
        return this.getStringAbs(this.get1DIndex(i, j));
    }

    @Override
    public String getString(int ... pos) {
        return this.getStringAbs(this.get1DIndex(pos));
    }

    @Override
    protected double getFirstValue() {
        return this.data[this.getFirst1DIndex()];
    }

    @Override
    protected double getFirstValue(int i) {
        return this.data[this.get1DIndex(i)];
    }

    @Override
    protected double getFirstValue(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    @Override
    protected double getFirstValue(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    @Override
    public Object getObjectAbs(int index) {
        int[] result = new int[this.isize];
        int i = 0;
        while (i < this.isize) {
            result[i] = this.data[index + i];
            ++i;
        }
        return result;
    }

    @Override
    public String getStringAbs(int index) {
        StringBuilder s = new StringBuilder();
        s.append('(');
        s.append(this.stringFormat == null ? String.format("%d", this.data[index]) : this.stringFormat.format(this.data[index]));
        int i = 1;
        while (i < this.isize) {
            s.append(' ');
            s.append(this.stringFormat == null ? String.format("%d", this.data[index + i]) : this.stringFormat.format(this.data[index + i]));
            ++i;
        }
        s.append(')');
        return s.toString();
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        int[] oa = DTypeUtils.toIntegerArray(obj, this.isize);
        this.setAbs(index, oa);
    }

    @Override
    public void set(Object obj) {
        this.setItem(DTypeUtils.toIntegerArray(obj, this.isize));
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem(DTypeUtils.toIntegerArray(obj, this.isize), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem(DTypeUtils.toIntegerArray(obj, this.isize), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem(DTypeUtils.toIntegerArray(obj, this.isize), pos);
    }

    public void setItem(int[] d) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.getFirst1DIndex(), d);
    }

    public void setItem(int[] d, int i) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.get1DIndex(i), d);
    }

    public void setItem(int[] d, int i, int j) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.get1DIndex(i, j), d);
    }

    public void setItem(int[] d, int ... pos) {
        if (d.length > this.isize) {
            throw new IllegalArgumentException("Array is larger than number of elements in an item");
        }
        this.setAbs(this.get1DIndex(pos), d);
    }

    private void setDoubleArrayAbs(int index, double[] d) {
        int i = 0;
        while (i < this.isize) {
            this.data[index + i] = (int)d[i];
            ++i;
        }
    }

    @Override
    public void resize(int ... newShape) {
        int[] ndata;
        this.setDirty();
        IndexIterator iter = this.getIterator();
        int nsize = ShapeUtils.calcSize(newShape);
        try {
            ndata = this.createArray(nsize);
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        while (iter.hasNext() && i < nsize) {
            int j = 0;
            while (j < this.isize) {
                ndata[i++] = this.data[iter.index + j];
                ++j;
            }
        }
        this.data = ndata;
        this.odata = ndata;
        this.size = nsize;
        this.shape = newShape;
        this.stride = null;
        this.offset = 0;
        this.base = null;
    }

    @Override
    public CompoundIntegerDataset getSlice(SliceIterator siter) {
        CompoundIntegerDataset result = new CompoundIntegerDataset(this.isize, siter.getShape());
        int[] rdata = result.data;
        IndexIterator riter = result.getIterator();
        while (siter.hasNext() && riter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                rdata[riter.index + i] = this.data[siter.index + i];
                ++i;
            }
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    @Override
    public IntegerDataset getElementsView(int element) {
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", element, this.isize));
        }
        IntegerDataset view = new IntegerDataset(this.shape);
        CompoundIntegerDataset.copyToView(this, view, true, true);
        view.setData();
        if (view.stride == null) {
            int[] offset = new int[1];
            view.stride = CompoundIntegerDataset.createStrides(this, offset);
            view.offset = offset[0] + element;
            view.base = this.base == null ? this : this.base;
        } else {
            view.offset += element;
        }
        return view;
    }

    @Override
    public IntegerDataset getElements(int element) {
        IntegerDataset elements = new IntegerDataset(this.shape);
        this.copyElements(elements, element);
        return elements;
    }

    @Override
    public void copyElements(Dataset destination, int element) {
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", element, this.isize));
        }
        if (this.getElementClass() != destination.getElementClass()) {
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator it = this.getIterator(element);
        int[] elements = ((IntegerDataset)destination).data;
        destination.setDirty();
        int n = 0;
        while (it.hasNext()) {
            elements[n] = this.data[it.index];
            ++n;
        }
    }

    @Override
    public void setElements(Dataset source, int element) {
        this.setDirty();
        if (element < 0) {
            element += this.isize;
        }
        if (element < 0 || element > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", element, this.isize));
        }
        if (this.getElementClass() != source.getElementClass()) {
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator it = this.getIterator(element);
        int[] elements = ((IntegerDataset)source).data;
        int n = 0;
        while (it.hasNext()) {
            this.data[it.index] = elements[n];
            ++n;
        }
    }

    @Override
    public void fillDataset(Dataset result, IndexIterator iter) {
        IndexIterator riter = result.getIterator();
        result.setDirty();
        int[] rdata = ((CompoundIntegerDataset)result).data;
        while (riter.hasNext() && iter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                rdata[riter.index + i] = this.data[iter.index + i];
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setByBoolean(Object o, Dataset selection) {
        block10: {
            block9: {
                this.setDirty();
                if (!(o instanceof Dataset)) break block9;
                ds = (Dataset)o;
                length = ((Number)selection.sum(new boolean[0])).intValue();
                if (length != ds.getSize()) {
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                iter = ds.getIterator();
                biter = this.getBooleanIterator(selection);
                if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl25
                if (this.isize == ds.getElementsPerItem()) ** GOTO lbl17
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    i = 0;
                    while (i < this.isize) {
                        this.data[biter.index + i] = (int)ds.getElementLongAbs(iter.index + i);
                        ++i;
                    }
lbl17:
                    // 2 sources

                    ** while (biter.hasNext() && iter.hasNext())
                }
lbl18:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[biter.index] = (int)ds.getElementLongAbs(iter.index);
                    i = 1;
                    while (i < this.isize) {
                        this.data[biter.index + i] = 0;
                        ++i;
                    }
lbl25:
                    // 2 sources

                    ** while (biter.hasNext() && iter.hasNext())
                }
lbl26:
                // 1 sources

                break block10;
            }
            try {
                vr = DTypeUtils.toIntegerArray(o, this.isize);
                biter = this.getBooleanIterator(selection);
                while (biter.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        this.data[biter.index + i] = vr[i];
                        ++i;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setBy1DIndex(Object o, Dataset index) {
        block11: {
            block10: {
                this.setDirty();
                if (!(o instanceof Dataset)) break block10;
                ds = (Dataset)o;
                if (index.getSize() != ds.getSize()) {
                    throw new IllegalArgumentException("Number of items in selection does not match number of items in dataset");
                }
                oiter = ds.getIterator();
                iter = new IntegerIterator(index, this.size, this.isize);
                if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl30
                if (this.isize != ds.getElementsPerItem()) {
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
                }
                temp = new double[this.isize];
                while (iter.hasNext() && oiter.hasNext()) {
                    ((AbstractCompoundDataset)ds).getDoubleArrayAbs(oiter.index, temp);
                    this.setDoubleArrayAbs(iter.index, temp);
                }
                while (iter.hasNext() && oiter.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        this.data[iter.index + i] = (int)ds.getElementLongAbs(oiter.index + i);
                        ++i;
                    }
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    this.data[iter.index] = (int)ds.getElementLongAbs(oiter.index);
                    i = 1;
                    while (i < this.isize) {
                        this.data[iter.index + i] = 0;
                        ++i;
                    }
lbl30:
                    // 2 sources

                    ** while (iter.hasNext() && oiter.hasNext())
                }
lbl31:
                // 1 sources

                break block11;
            }
            try {
                vr = DTypeUtils.toIntegerArray(o, this.isize);
                iter = new IntegerIterator(index, this.size, this.isize);
                while (iter.hasNext()) {
                    this.setAbs(iter.index, vr);
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setByIndexes(Object o, Object ... indexes) {
        block9: {
            block8: {
                this.setDirty();
                iter = new IntegersIterator(this.shape, indexes);
                pos = iter.getPos();
                if (!(o instanceof Dataset)) break block8;
                ds = (Dataset)o;
                if (ShapeUtils.calcSize(iter.getShape()) != ds.getSize()) {
                    throw new IllegalArgumentException("Number of items in selection does not match number of items in dataset");
                }
                oiter = ds.getIterator();
                if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl25
                if (this.isize != ds.getElementsPerItem()) {
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
                }
                temp = new double[this.isize];
                while (iter.hasNext() && oiter.hasNext()) {
                    ((AbstractCompoundDataset)ds).getDoubleArray(temp, pos);
                    this.setDoubleArrayAbs(this.get1DIndex(pos), temp);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    n = this.get1DIndex(pos);
                    this.data[n] = (int)ds.getElementLongAbs(oiter.index);
                    i = 1;
                    while (i < this.isize) {
                        this.data[n + i] = 0;
                        ++i;
                    }
lbl25:
                    // 2 sources

                    ** while (iter.hasNext() && oiter.hasNext())
                }
lbl26:
                // 1 sources

                break block9;
            }
            try {
                vr = DTypeUtils.toIntegerArray(o, this.isize);
                while (iter.hasNext()) {
                    this.setAbs(this.get1DIndex(pos), vr);
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    CompoundIntegerDataset setSlicedView(Dataset view, Dataset d) {
        block5: {
            this.setDirty();
            it = BroadcastSelfIterator.createIterator(view, d);
            is = view.getElementsPerItem();
            if (is <= 1) ** GOTO lbl24
            if (d.getElementsPerItem() != 1) ** GOTO lbl21
            while (it.hasNext()) {
                this.data[it.aIndex] = bv = (int)it.bLong;
                j = 1;
                while (j < is) {
                    this.data[it.aIndex + j] = bv;
                    ++j;
                }
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                this.data[it.aIndex] = (int)it.bLong;
                j = 1;
                while (j < is) {
                    this.data[it.aIndex + j] = (int)d.getElementLongAbs(it.bIndex + j);
                    ++j;
                }
lbl21:
                // 2 sources

                ** while (it.hasNext())
            }
lbl22:
            // 1 sources

            break block5;
lbl-1000:
            // 1 sources

            {
                this.data[it.aIndex] = (int)it.bLong;
lbl24:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setSlice(Object o, IndexIterator siter) {
        block15: {
            block13: {
                block14: {
                    this.setDirty();
                    if (!(o instanceof IDataset)) break block13;
                    ds = (IDataset)o;
                    oshape = ds.getShape();
                    if (!ShapeUtils.areShapesCompatible(siter.getShape(), oshape)) {
                        throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", new Object[]{Arrays.toString(oshape), Arrays.toString(siter.getShape())}));
                    }
                    if (!(ds instanceof Dataset)) break block14;
                    ads = (Dataset)ds;
                    oiter = ads.getIterator();
                    if (!(ds instanceof AbstractCompoundDataset)) ** GOTO lbl26
                    if (this.isize == ads.getElementsPerItem()) ** GOTO lbl18
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                    // 1 sources

                    {
                        i = 0;
                        while (i < this.isize) {
                            this.data[siter.index + i] = (int)ads.getElementLongAbs(oiter.index + i);
                            ++i;
                        }
lbl18:
                        // 2 sources

                        ** while (siter.hasNext() && oiter.hasNext())
                    }
lbl19:
                    // 1 sources

                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        this.data[siter.index] = (int)ads.getElementLongAbs(oiter.index);
                        i = 1;
                        while (i < this.isize) {
                            this.data[siter.index + i] = 0;
                            ++i;
                        }
lbl26:
                        // 2 sources

                        ** while (siter.hasNext() && oiter.hasNext())
                    }
lbl27:
                    // 1 sources

                    break block15;
                }
                oiter = new PositionIterator(oshape);
                pos = oiter.getPos();
                if (ds.getElementsPerItem() != 1) ** GOTO lbl47
                while (siter.hasNext() && oiter.hasNext()) {
                    this.data[siter.index] = ds.getInt(pos);
                    i = 1;
                    while (i < this.isize) {
                        this.data[siter.index + i] = 0;
                        ++i;
                    }
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    val = DTypeUtils.toIntegerArray(ds.getObject(pos), this.isize);
                    i = 0;
                    while (i < this.isize) {
                        this.data[siter.index + i] = val[i];
                        ++i;
                    }
lbl47:
                    // 2 sources

                    ** while (siter.hasNext() && oiter.hasNext())
                }
lbl48:
                // 1 sources

                break block15;
            }
            try {
                vr = DTypeUtils.toIntegerArray(o, this.isize);
                while (siter.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        this.data[siter.index + i] = vr[i];
                        ++i;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        return this;
    }

    @Override
    public void copyItemsFromAxes(int[] pos, boolean[] axes, Dataset dest) {
        int[] ddata = (int[])dest.getBuffer();
        if (dest.getElementsPerItem() != this.isize) {
            throw new IllegalArgumentException(String.format("Destination dataset is incompatible as it has %d elements per item not %d", dest.getElementsPerItem(), this.isize));
        }
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        int[] sshape = ShapeUtils.squeezeShape(siter.getShape(), false);
        IndexIterator diter = dest.getSliceIterator(null, sshape, null);
        if (ddata.length < ShapeUtils.calcSize(sshape)) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        dest.setDirty();
        while (siter.hasNext() && diter.hasNext()) {
            int i = 0;
            while (i < this.isize) {
                ddata[diter.index + i] = this.data[siter.index + i];
                ++i;
            }
        }
    }

    @Override
    public void setItemsOnAxes(int[] pos, boolean[] axes, Object src) {
        this.setDirty();
        int[] sdata = (int[])src;
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        if (sdata.length < ShapeUtils.calcSize(siter.getShape())) {
            throw new IllegalArgumentException("source array is not large enough");
        }
        int i = 0;
        while (siter.hasNext()) {
            int j = 0;
            while (j < this.isize) {
                this.data[siter.index + j] = sdata[this.isize * i + j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset iadd(Object b) {
        block20: {
            block23: {
                block22: {
                    block18: {
                        block21: {
                            block19: {
                                this.setDirty();
                                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                useLong = bds.getElementClass().equals(Long.class);
                                is = bds.getElementsPerItem();
                                if (bds.getSize() != 1) break block18;
                                it = this.getIterator();
                                bOffset = bds.getOffset();
                                if (is != 1) break block19;
                                if (useLong) {
                                    lb = bds.getElementLongAbs(bOffset);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v0 = it.index + i;
                                            this.data[v0] = (int)((long)this.data[v0] + lb);
                                            ++i;
                                        }
                                    }
                                } else {
                                    db = bds.getElementDoubleAbs(bOffset);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v1 = it.index + i;
                                            this.data[v1] = (int)((double)this.data[v1] + db);
                                            ++i;
                                        }
                                    }
                                }
                                break block20;
                            }
                            if (is != this.isize) break block21;
                            if (!useLong) ** GOTO lbl48
                            while (it.hasNext()) {
                                i = 0;
                                while (i < this.isize) {
                                    v2 = it.index + i;
                                    this.data[v2] = (int)((long)this.data[v2] + bds.getElementLongAbs(i));
                                    ++i;
                                }
                            }
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                i = 0;
                                while (i < this.isize) {
                                    v3 = it.index + i;
                                    this.data[v3] = (int)((double)this.data[v3] + bds.getElementDoubleAbs(i));
                                    ++i;
                                }
lbl48:
                                // 2 sources

                                ** while (it.hasNext())
                            }
lbl49:
                            // 1 sources

                            break block20;
                        }
                        throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    }
                    it = BroadcastSelfIterator.createIterator(this, bds);
                    it.setOutputDouble(useLong == false);
                    if (is != 1) break block22;
                    if (!useLong) ** GOTO lbl78
                    while (it.hasNext()) {
                        lb = it.bLong;
                        v4 = it.aIndex;
                        this.data[v4] = (int)((long)this.data[v4] + lb);
                        i = 1;
                        while (i < this.isize) {
                            v5 = it.aIndex + i;
                            this.data[v5] = (int)((long)this.data[v5] + lb);
                            ++i;
                        }
                    }
                    break block20;
lbl-1000:
                    // 1 sources

                    {
                        db = it.bDouble;
                        v6 = it.aIndex;
                        this.data[v6] = (int)((double)this.data[v6] + db);
                        i = 1;
                        while (i < this.isize) {
                            v7 = it.aIndex + i;
                            this.data[v7] = (int)((double)this.data[v7] + db);
                            ++i;
                        }
lbl78:
                        // 2 sources

                        ** while (it.hasNext())
                    }
lbl79:
                    // 1 sources

                    break block20;
                }
                if (is != this.isize) break block23;
                if (!useLong) ** GOTO lbl102
                while (it.hasNext()) {
                    v8 = it.aIndex;
                    this.data[v8] = (int)((long)this.data[v8] + it.bLong);
                    i = 1;
                    while (i < this.isize) {
                        v9 = it.aIndex + i;
                        this.data[v9] = (int)((long)this.data[v9] + bds.getElementLongAbs(it.bIndex + i));
                        ++i;
                    }
                }
                break block20;
lbl-1000:
                // 1 sources

                {
                    v10 = it.aIndex;
                    this.data[v10] = (int)((double)this.data[v10] + it.bDouble);
                    i = 1;
                    while (i < this.isize) {
                        v11 = it.aIndex + i;
                        this.data[v11] = (int)((double)this.data[v11] + bds.getElementDoubleAbs(it.bIndex + i));
                        ++i;
                    }
lbl102:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl103:
                // 1 sources

                break block20;
            }
            throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset isubtract(Object b) {
        block20: {
            block23: {
                block22: {
                    block18: {
                        block21: {
                            block19: {
                                this.setDirty();
                                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                useLong = bds.getElementClass().equals(Long.class);
                                is = bds.getElementsPerItem();
                                if (bds.getSize() != 1) break block18;
                                it = this.getIterator();
                                bOffset = bds.getOffset();
                                if (is != 1) break block19;
                                if (useLong) {
                                    lb = bds.getElementLongAbs(bOffset);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v0 = it.index + i;
                                            this.data[v0] = (int)((long)this.data[v0] - lb);
                                            ++i;
                                        }
                                    }
                                } else {
                                    db = bds.getElementDoubleAbs(bOffset);
                                    while (it.hasNext()) {
                                        i = 0;
                                        while (i < this.isize) {
                                            v1 = it.index + i;
                                            this.data[v1] = (int)((double)this.data[v1] - db);
                                            ++i;
                                        }
                                    }
                                }
                                break block20;
                            }
                            if (is != this.isize) break block21;
                            if (!useLong) ** GOTO lbl48
                            while (it.hasNext()) {
                                i = 0;
                                while (i < this.isize) {
                                    v2 = it.index + i;
                                    this.data[v2] = (int)((long)this.data[v2] - bds.getElementLongAbs(i));
                                    ++i;
                                }
                            }
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                i = 0;
                                while (i < this.isize) {
                                    v3 = it.index + i;
                                    this.data[v3] = (int)((double)this.data[v3] - bds.getElementDoubleAbs(i));
                                    ++i;
                                }
lbl48:
                                // 2 sources

                                ** while (it.hasNext())
                            }
lbl49:
                            // 1 sources

                            break block20;
                        }
                        throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    }
                    it = BroadcastSelfIterator.createIterator(this, bds);
                    it.setOutputDouble(useLong == false);
                    if (is != 1) break block22;
                    if (!useLong) ** GOTO lbl78
                    while (it.hasNext()) {
                        lb = it.bLong;
                        v4 = it.aIndex;
                        this.data[v4] = (int)((long)this.data[v4] + lb);
                        i = 1;
                        while (i < this.isize) {
                            v5 = it.aIndex + i;
                            this.data[v5] = (int)((long)this.data[v5] - lb);
                            ++i;
                        }
                    }
                    break block20;
lbl-1000:
                    // 1 sources

                    {
                        db = it.bDouble;
                        v6 = it.aIndex;
                        this.data[v6] = (int)((double)this.data[v6] + db);
                        i = 1;
                        while (i < this.isize) {
                            v7 = it.aIndex + i;
                            this.data[v7] = (int)((double)this.data[v7] - db);
                            ++i;
                        }
lbl78:
                        // 2 sources

                        ** while (it.hasNext())
                    }
lbl79:
                    // 1 sources

                    break block20;
                }
                if (is != this.isize) break block23;
                if (!useLong) ** GOTO lbl102
                while (it.hasNext()) {
                    v8 = it.aIndex;
                    this.data[v8] = (int)((long)this.data[v8] + it.bLong);
                    i = 1;
                    while (i < this.isize) {
                        v9 = it.aIndex + i;
                        this.data[v9] = (int)((long)this.data[v9] - bds.getElementLongAbs(it.bIndex + i));
                        ++i;
                    }
                }
                break block20;
lbl-1000:
                // 1 sources

                {
                    v10 = it.aIndex;
                    this.data[v10] = (int)((double)this.data[v10] + it.bDouble);
                    i = 1;
                    while (i < this.isize) {
                        v11 = it.aIndex + i;
                        this.data[v11] = (int)((double)this.data[v11] - bds.getElementDoubleAbs(it.bIndex + i));
                        ++i;
                    }
lbl102:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl103:
                // 1 sources

                break block20;
            }
            throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset imultiply(Object b) {
        this.setDirty();
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        int is = bds.getElementsPerItem();
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            int bOffset = bds.getOffset();
            if (useLong) {
                if (is == 1) {
                    long lb = bds.getElementLongAbs(bOffset);
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = (int)((long)this.data[n] * lb);
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.index + i;
                            this.data[n] = (int)((long)this.data[n] * bds.getElementLongAbs(i));
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                double db = bds.getElementDoubleAbs(bOffset);
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = (int)((double)this.data[n] * db);
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.index + i;
                        this.data[n] = (int)((double)this.data[n] * bds.getElementDoubleAbs(i));
                        ++i;
                    }
                }
            }
            return this;
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(!useLong);
            if (useLong) {
                if (is == 1) {
                    while (it.hasNext()) {
                        double lb = it.bLong;
                        int i = 0;
                        while (i < this.isize) {
                            int n = it.aIndex + i;
                            this.data[n] = (int)((double)this.data[n] * lb);
                            ++i;
                        }
                    }
                    return this;
                } else {
                    if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                    while (it.hasNext()) {
                        int n = it.aIndex;
                        this.data[n] = (int)((long)this.data[n] * it.bLong);
                        int i = 1;
                        while (i < this.isize) {
                            int n2 = it.aIndex + i;
                            this.data[n2] = (int)((long)this.data[n2] * bds.getElementLongAbs(it.bIndex + i));
                            ++i;
                        }
                    }
                }
                return this;
            } else if (is == 1) {
                while (it.hasNext()) {
                    double db = it.bDouble;
                    int i = 0;
                    while (i < this.isize) {
                        int n = it.aIndex + i;
                        this.data[n] = (int)((double)this.data[n] * db);
                        ++i;
                    }
                }
                return this;
            } else {
                if (is != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = (int)((double)this.data[n] * it.bDouble);
                    int i = 1;
                    while (i < this.isize) {
                        int n3 = it.aIndex + i;
                        this.data[n3] = (int)((double)this.data[n3] * bds.getElementDoubleAbs(it.bIndex + i));
                        ++i;
                    }
                }
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset idivide(Object b) {
        block39: {
            block36: {
                block42: {
                    block41: {
                        block37: {
                            block40: {
                                block38: {
                                    this.setDirty();
                                    bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                    useLong = bds.getElementClass().equals(Long.class);
                                    is = bds.getElementsPerItem();
                                    if (bds.getSize() != 1) break block36;
                                    it = this.getIterator();
                                    bOffset = bds.getOffset();
                                    if (!useLong) break block37;
                                    if (is != 1) break block38;
                                    lb = bds.getElementLongAbs(bOffset);
                                    if (lb != 0L) ** GOTO lbl21
                                    this.fill(0);
                                    break block39;
lbl-1000:
                                    // 1 sources

                                    {
                                        i = 0;
                                        while (i < this.isize) {
                                            v0 = it.index + i;
                                            this.data[v0] = (int)((long)this.data[v0] / lb);
                                            ++i;
                                        }
lbl21:
                                        // 2 sources

                                        ** while (it.hasNext())
                                    }
lbl22:
                                    // 1 sources

                                    break block39;
                                }
                                if (is != this.isize) break block40;
                                while (it.hasNext()) {
                                    i = 0;
                                    while (i < this.isize) {
                                        lb = bds.getElementLongAbs(i);
                                        try {
                                            v1 = it.index + i;
                                            this.data[v1] = (int)((long)this.data[v1] / lb);
                                        }
                                        catch (ArithmeticException v2) {
                                            this.data[it.index + i] = 0;
                                        }
                                        ++i;
                                    }
                                }
                                break block39;
                            }
                            throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                        }
                        if (is != 1) break block41;
                        db = bds.getElementDoubleAbs(bOffset);
                        if (db != 0.0) ** GOTO lbl54
                        this.fill(0);
                        break block39;
lbl-1000:
                        // 1 sources

                        {
                            i = 0;
                            while (i < this.isize) {
                                v3 = it.index + i;
                                this.data[v3] = (int)((double)this.data[v3] / db);
                                ++i;
                            }
lbl54:
                            // 2 sources

                            ** while (it.hasNext())
                        }
lbl55:
                        // 1 sources

                        break block39;
                    }
                    if (is != this.isize) break block42;
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            db = bds.getElementDoubleAbs(i);
                            try {
                                v4 = it.index + i;
                                this.data[v4] = (int)((double)this.data[v4] / db);
                            }
                            catch (ArithmeticException v5) {
                                this.data[it.index + i] = 0;
                            }
                            ++i;
                        }
                    }
                    break block39;
                }
                throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl112
            if (is == 1) {
                while (it.hasNext()) {
                    lb = it.bLong;
                    if (lb == 0L) {
                        i = 0;
                        while (i < this.isize) {
                            this.data[it.aIndex + i] = 0;
                            ++i;
                        }
                        continue;
                    }
                    i = 0;
                    while (i < this.isize) {
                        v6 = it.aIndex + i;
                        this.data[v6] = (int)((long)this.data[v6] / lb);
                        ++i;
                    }
                }
            } else if (is == this.isize) {
                while (it.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        lb = bds.getElementLongAbs(it.bIndex + i);
                        try {
                            v7 = it.aIndex + i;
                            this.data[v7] = (int)((long)this.data[v7] / lb);
                        }
                        catch (ArithmeticException v8) {
                            this.data[it.aIndex + i] = 0;
                        }
                        ++i;
                    }
                }
            } else {
                throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
lbl112:
                // 1 sources

                if (is == 1) {
                    while (it.hasNext()) {
                        db = it.bDouble;
                        if (db == 0.0) {
                            i = 0;
                            while (i < this.isize) {
                                this.data[it.aIndex + i] = 0;
                                ++i;
                            }
                            continue;
                        }
                        i = 0;
                        while (i < this.isize) {
                            v9 = it.aIndex + i;
                            this.data[v9] = (int)((double)this.data[v9] / db);
                            ++i;
                        }
                    }
                } else if (is == this.isize) {
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            db = bds.getElementDoubleAbs(it.bIndex + i);
                            try {
                                v10 = it.aIndex + i;
                                this.data[v10] = (int)((double)this.data[v10] / db);
                            }
                            catch (ArithmeticException v11) {
                                this.data[it.aIndex + i] = 0;
                            }
                            ++i;
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                }
            }
        }
        return this;
    }

    @Override
    public CompoundIntegerDataset ifloor() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset iremainder(Object b) {
        block39: {
            block36: {
                block42: {
                    block41: {
                        block37: {
                            block40: {
                                block38: {
                                    this.setDirty();
                                    bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                                    useLong = bds.getElementClass().equals(Long.class);
                                    is = bds.getElementsPerItem();
                                    if (bds.getSize() != 1) break block36;
                                    it = this.getIterator();
                                    bOffset = bds.getOffset();
                                    if (!useLong) break block37;
                                    if (is != 1) break block38;
                                    lb = bds.getElementLongAbs(bOffset);
                                    if (lb != 0L) ** GOTO lbl21
                                    this.fill(0);
                                    break block39;
lbl-1000:
                                    // 1 sources

                                    {
                                        i = 0;
                                        while (i < this.isize) {
                                            v0 = it.index + i;
                                            this.data[v0] = (int)((long)this.data[v0] % lb);
                                            ++i;
                                        }
lbl21:
                                        // 2 sources

                                        ** while (it.hasNext())
                                    }
lbl22:
                                    // 1 sources

                                    break block39;
                                }
                                if (is != this.isize) break block40;
                                while (it.hasNext()) {
                                    i = 0;
                                    while (i < this.isize) {
                                        try {
                                            v1 = it.index + i;
                                            this.data[v1] = (int)((long)this.data[v1] % bds.getElementLongAbs(i));
                                        }
                                        catch (ArithmeticException v2) {
                                            this.data[it.index + i] = 0;
                                        }
                                        ++i;
                                    }
                                }
                                break block39;
                            }
                            throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                        }
                        if (is != 1) break block41;
                        db = bds.getElementDoubleAbs(bOffset);
                        if (db != 0.0) ** GOTO lbl53
                        this.fill(0);
                        break block39;
lbl-1000:
                        // 1 sources

                        {
                            i = 0;
                            while (i < this.isize) {
                                v3 = it.index + i;
                                this.data[v3] = (int)((double)this.data[v3] % db);
                                ++i;
                            }
lbl53:
                            // 2 sources

                            ** while (it.hasNext())
                        }
lbl54:
                        // 1 sources

                        break block39;
                    }
                    if (is != this.isize) break block42;
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            try {
                                v4 = it.index + i;
                                this.data[v4] = (int)((double)this.data[v4] % bds.getElementDoubleAbs(i));
                            }
                            catch (ArithmeticException v5) {
                                this.data[it.index + i] = 0;
                            }
                            ++i;
                        }
                    }
                    break block39;
                }
                throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl110
            if (is == 1) {
                while (it.hasNext()) {
                    lb = it.bLong;
                    if (lb == 0L) {
                        i = 0;
                        while (i < this.isize) {
                            this.data[it.aIndex + i] = 0;
                            ++i;
                        }
                        continue;
                    }
                    i = 0;
                    while (i < this.isize) {
                        v6 = it.aIndex + i;
                        this.data[v6] = (int)((long)this.data[v6] % lb);
                        ++i;
                    }
                }
            } else if (is == this.isize) {
                while (it.hasNext()) {
                    i = 0;
                    while (i < this.isize) {
                        lb = bds.getElementLongAbs(it.bIndex + i);
                        try {
                            v7 = it.aIndex + i;
                            this.data[v7] = (int)((long)this.data[v7] % lb);
                        }
                        catch (ArithmeticException v8) {
                            this.data[it.aIndex + i] = 0;
                        }
                        ++i;
                    }
                }
            } else {
                throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
lbl110:
                // 1 sources

                if (is == 1) {
                    while (it.hasNext()) {
                        db = it.bDouble;
                        if (db == 0.0) {
                            i = 0;
                            while (i < this.isize) {
                                this.data[it.aIndex + i] = 0;
                                ++i;
                            }
                            continue;
                        }
                        i = 0;
                        while (i < this.isize) {
                            v9 = it.aIndex + i;
                            this.data[v9] = (int)((double)this.data[v9] % db);
                            ++i;
                        }
                    }
                } else if (is == this.isize) {
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            db = bds.getElementDoubleAbs(it.bIndex + i);
                            try {
                                v10 = it.aIndex + i;
                                this.data[v10] = (int)((double)this.data[v10] % db);
                            }
                            catch (ArithmeticException v11) {
                                this.data[it.aIndex + i] = 0;
                            }
                            ++i;
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                }
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset ipower(Object b) {
        block20: {
            block19: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                is = bds.getElementsPerItem();
                if (bds.getSize() != 1) break block19;
                bOffset = bds.getOffset();
                vr = bds.getElementDoubleAbs(bOffset);
                it = this.getIterator();
                if (bds.isComplex()) {
                    vi = bds.getElementDoubleAbs(bOffset + 1);
                    if (vi == 0.0) {
                        while (it.hasNext()) {
                            i = 0;
                            while (i < this.isize) {
                                v = Math.pow(this.data[it.index + i], vr);
                                this.data[it.index + i] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                                ++i;
                            }
                        }
                    } else {
                        zv = new Complex(vr, vi);
                        while (it.hasNext()) {
                            i = 0;
                            while (i < this.isize) {
                                zd = new Complex((double)this.data[it.index + i], 0.0);
                                v = zd.pow(zv).getReal();
                                this.data[it.index + i] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                                ++i;
                            }
                        }
                    }
                } else if (is == 1) {
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            v = Math.pow(this.data[it.index + i], vr);
                            this.data[it.index + i] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                            ++i;
                        }
                    }
                } else if (is == this.isize) {
                    while (it.hasNext()) {
                        i = 0;
                        while (i < this.isize) {
                            v = Math.pow(this.data[it.index + i], bds.getElementDoubleAbs(i));
                            this.data[it.index + i] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                            ++i;
                        }
                    }
                }
                break block20;
            }
            it = BroadcastIterator.createIterator(this, bds);
            it.setOutputDouble(true);
            if (!bds.isComplex()) ** GOTO lbl75
            while (it.hasNext()) {
                zv = new Complex(it.bDouble, bds.getElementDoubleAbs(it.bIndex + 1));
                v = new Complex(it.aDouble, 0.0).pow(zv).getReal();
                this.data[it.aIndex] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                i = 1;
                while (i < this.isize) {
                    v = new Complex((double)this.data[it.aIndex + i], 0.0).pow(zv).getReal();
                    this.data[it.aIndex + i] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                    ++i;
                }
            }
            break block20;
lbl-1000:
            // 1 sources

            {
                v = Math.pow(it.aDouble, it.bDouble);
                this.data[it.aIndex] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                i = 1;
                while (i < this.isize) {
                    v = Math.pow(this.data[it.aIndex + i], bds.getElementDoubleAbs(it.bIndex + i));
                    this.data[it.aIndex + i] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (int)v;
                    ++i;
                }
lbl75:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastIterator it = BroadcastIterator.createIterator(this, bds);
        it.setOutputDouble(true);
        double sum = 0.0;
        double comp = 0.0;
        int bis = bds.getElementsPerItem();
        if (bis == 1) {
            if (w == null) {
                while (it.hasNext()) {
                    double db = it.bDouble;
                    double diff = it.aDouble - db;
                    double err = diff * diff - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    int i = 1;
                    while (i < this.isize) {
                        diff = (double)this.data[it.aIndex + i] - db;
                        err = diff * diff - comp;
                        temp = sum + err;
                        comp = temp - sum - err;
                        sum = temp;
                        ++i;
                    }
                }
            } else {
                IndexIterator itw = w.getIterator();
                while (it.hasNext() && itw.hasNext()) {
                    double db = it.bDouble;
                    double diff = it.aDouble - db;
                    double dw = w.getElementDoubleAbs(itw.index);
                    double err = diff * diff * dw - comp;
                    double temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    int i = 1;
                    while (i < this.isize) {
                        diff = (double)this.data[it.aIndex + i] - db;
                        err = diff * diff * dw - comp;
                        temp = sum + err;
                        comp = temp - sum - err;
                        sum = temp;
                        ++i;
                    }
                }
            }
        } else if (w == null) {
            while (it.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
                int i = 1;
                while (i < this.isize) {
                    diff = (double)this.data[it.aIndex + i] - bds.getElementDoubleAbs(it.bIndex + i);
                    err = diff * diff - comp;
                    temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    ++i;
                }
            }
        } else {
            IndexIterator itw = w.getIterator();
            while (it.hasNext() && itw.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double dw = w.getElementDoubleAbs(itw.index);
                double err = diff * diff * dw - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
                int i = 1;
                while (i < this.isize) {
                    diff = (double)this.data[it.aIndex + i] - bds.getElementDoubleAbs(it.bIndex + i);
                    err = diff * diff * dw - comp;
                    temp = sum + err;
                    comp = temp - sum - err;
                    sum = temp;
                    ++i;
                }
            }
        }
        return sum;
    }
}

