/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.SliceNDIterator;
import org.junit.Assert;
import org.junit.Test;

public class SliceNDIteratorTest {
    @Test
    public void testScanIterations() {
        SliceND sa = new SliceND(new int[]{4, 5, 6, 7});
        SliceNDIterator it = new SliceNDIterator(sa, new int[]{2, 3});
        Assert.assertArrayEquals((int[])new int[]{4, 5, 1, 1}, (int[])it.getShape());
        this.myAssertEquals(new SliceND(new int[]{6, 7}), it.getOmittedSlice());
        int size = 0;
        while (it.hasNext()) {
            TestUtils.verbosePrintln((String)(String.valueOf(size) + ": " + Arrays.toString(it.getPos()) + " or " + Arrays.toString(it.getUsedPos())));
            TestUtils.verbosePrintln((String)("use: " + it.getUsedSlice() + ", cur: " + it.getCurrentSlice() + ", out: " + it.getOutputSlice()));
            if (size == 13) {
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = 3;
                Assert.assertArrayEquals((int[])nArray, (int[])it.getPos());
                Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])it.getUsedPos());
                this.myAssertEquals(new SliceND(new int[]{4, 5}, new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(3)), new Slice(Integer.valueOf(3), Integer.valueOf(4))}), it.getUsedSlice());
                this.myAssertEquals(new SliceND(new int[]{4, 5, 6, 7}, new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(3)), new Slice(Integer.valueOf(3), Integer.valueOf(4))}), it.getOutputSlice());
                this.myAssertEquals(new SliceND(new int[]{4, 5, 6, 7}, new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(3)), new Slice(Integer.valueOf(3), Integer.valueOf(4))}), it.getCurrentSlice());
            }
            ++size;
        }
        Assert.assertEquals((long)20L, (long)size);
    }

    @Test
    public void testIterations() {
        SliceND sa = new SliceND(new int[]{4, 5, 6, 7}, new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(5), Integer.valueOf(2)), null, null, null});
        SliceNDIterator it = new SliceNDIterator(sa, new int[]{1});
        Assert.assertArrayEquals((int[])new int[]{2, 1, 6, 7}, (int[])it.getShape());
        this.myAssertEquals(new SliceND(new int[]{5}), it.getOmittedSlice());
        int size = 0;
        while (it.hasNext()) {
            TestUtils.verbosePrintln((String)(String.valueOf(size) + ": " + Arrays.toString(it.getPos()) + " or " + Arrays.toString(it.getUsedPos())));
            TestUtils.verbosePrintln((String)("use: " + it.getUsedSlice() + ", cur: " + it.getCurrentSlice() + ", out: " + it.getOutputSlice()));
            if (size == 68) {
                int[] nArray = new int[4];
                nArray[0] = 3;
                nArray[2] = 3;
                nArray[3] = 5;
                Assert.assertArrayEquals((int[])nArray, (int[])it.getPos());
                Assert.assertArrayEquals((int[])new int[]{3, 3, 5}, (int[])it.getUsedPos());
                this.myAssertEquals(new SliceND(new int[]{4, 6, 7}, new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2)), new Slice(Integer.valueOf(3), Integer.valueOf(4)), new Slice(Integer.valueOf(5), Integer.valueOf(6))}), it.getUsedSlice());
                this.myAssertEquals(new SliceND(new int[]{2, 5, 6, 7}, new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2)), null, new Slice(Integer.valueOf(3), Integer.valueOf(4)), new Slice(Integer.valueOf(5), Integer.valueOf(6))}), it.getOutputSlice());
            }
            ++size;
        }
        Assert.assertEquals((long)84L, (long)size);
    }

    private void myAssertEquals(SliceND a, SliceND b) {
        Assert.assertArrayEquals((int[])a.getSourceShape(), (int[])b.getSourceShape());
        Assert.assertArrayEquals((int[])a.getShape(), (int[])b.getShape());
    }
}

