/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.january.geometry.BoundingBox;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Pipe;
import org.eclipse.january.geometry.Reactor;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class ReactorImpl
extends ShapeImpl
implements Reactor {
    protected EList<Pipe> pipes;

    protected ReactorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.REACTOR;
    }

    @Override
    public EList<Pipe> getPipes() {
        if (this.pipes == null) {
            this.pipes = new EObjectContainmentEList(Pipe.class, (InternalEObject)this, 8);
        }
        return this.pipes;
    }

    @Override
    public EList<Triangle> getTriangles() {
        this.triangles = new BasicEList();
        if (this.getPipes().isEmpty()) {
            return this.triangles;
        }
        BoundingBox bounds = ((Pipe)this.pipes.get(0)).getLowerEdge();
        for (Pipe channel : this.pipes) {
            bounds.addArea(channel.getLowerEdge());
            bounds.addArea(channel.getUpperEdge());
        }
        double thickness = 5.0;
        int samples = 50;
        double sizeX = bounds.getMaxX() - bounds.getMinX();
        double sizeY = bounds.getMaxY() - bounds.getMinY();
        double sizeZ = bounds.getMaxZ() - bounds.getMinZ();
        ArrayList<Double> sizes = new ArrayList<Double>();
        sizes.add(sizeX);
        sizes.add(sizeY);
        sizes.add(sizeZ);
        Collections.sort(sizes);
        double depth = (Double)sizes.get(0);
        double width = (Double)sizes.get(1);
        double height = (Double)sizes.get(2);
        double origWidth = width;
        double[] sideVertices = MeshUtils.createRectangularPrism(thickness, height, depth);
        Vertex sideCenter1 = GeometryFactory.eINSTANCE.createVertex();
        sideCenter1.setX((width += thickness) / 2.0);
        double[] sideVerticesLeft = MeshUtils.centerPoints(sideVertices, sideCenter1);
        Vertex sideCenter2 = GeometryFactory.eINSTANCE.createVertex();
        sideCenter2.setX(width / -2.0);
        double[] sideVerticesRight = MeshUtils.centerPoints(sideVertices, sideCenter2);
        double[] innerVertices = MeshUtils.createSemiCircle(width / 2.0 - thickness / 2.0, samples, true);
        double[] outerVertices = MeshUtils.createSemiCircle(width / 2.0 + thickness / 2.0, samples, true);
        int blockSize = samples * 2 * 3;
        int archSize = blockSize * 2 / 3;
        double[] coordinates = new double[archSize * 2 * 3];
        int i = 0;
        while (i < samples) {
            coordinates[i * 6] = innerVertices[i * 2];
            coordinates[i * 6 + 1] = innerVertices[i * 2 + 1] + height / 2.0;
            coordinates[i * 6 + 2] = (float)(depth / -2.0);
            coordinates[i * 6 + 3] = innerVertices[i * 2];
            coordinates[i * 6 + 4] = innerVertices[i * 2 + 1] + height / 2.0;
            coordinates[i * 6 + 5] = (float)(depth / 2.0);
            coordinates[blockSize + i * 6] = outerVertices[i * 2];
            coordinates[blockSize + i * 6 + 1] = outerVertices[i * 2 + 1] + height / 2.0;
            coordinates[blockSize + i * 6 + 2] = (float)(depth / -2.0);
            coordinates[blockSize + i * 6 + 3] = outerVertices[i * 2];
            coordinates[blockSize + i * 6 + 4] = outerVertices[i * 2 + 1] + height / 2.0;
            coordinates[blockSize + i * 6 + 5] = (float)(depth / 2.0);
            ++i;
        }
        i = 0;
        while (i < coordinates.length / 2) {
            coordinates[archSize * 3 + i] = i % 3 != 1 ? coordinates[i] : -coordinates[i];
            ++i;
        }
        double xRotation = 0.0;
        double yRotation = 0.0;
        double zRotation = 0.0;
        if (sizeX > sizeY && sizeX > sizeZ || sizeZ > sizeY && sizeY > sizeX) {
            zRotation = 1.5707963267948966;
        }
        if (sizeY != height && sizeX != height && sizeZ == height) {
            xRotation = 1.5707963267948966;
        } else if (sizeY != origWidth && sizeX != origWidth && sizeZ == origWidth) {
            yRotation = 1.5707963267948966;
        }
        sideVerticesLeft = MeshUtils.rotatePoints(sideVerticesLeft, xRotation, yRotation, zRotation);
        sideVerticesRight = MeshUtils.rotatePoints(sideVerticesRight, xRotation, yRotation, zRotation);
        coordinates = MeshUtils.rotatePoints(coordinates, xRotation, yRotation, zRotation);
        this.triangles.addAll(MeshUtils.createRectangularPrismMesh(sideVerticesLeft));
        this.triangles.addAll(MeshUtils.createRectangularPrismMesh(sideVerticesRight));
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        int i2 = 0;
        while (i2 < coordinates.length / 3) {
            Vertex vertex = GeometryFactory.eINSTANCE.createVertex();
            vertex.setX(coordinates[i2 * 3]);
            vertex.setY(coordinates[i2 * 3 + 1]);
            vertex.setZ(coordinates[i2 * 3 + 2]);
            vertices.add(vertex);
            ++i2;
        }
        int faceBlockSize = samples * 2;
        int halfFaces = samples * 4;
        int i3 = 0;
        while (i3 < halfFaces - 2) {
            int[] indices = new int[3];
            if (i3 < faceBlockSize - 2 || i3 >= faceBlockSize) {
                int j;
                int n;
                int n2;
                int[] nArray;
                Triangle bottom;
                Triangle top;
                if (i3 < faceBlockSize - 2) {
                    top = GeometryFactory.eINSTANCE.createTriangle();
                    bottom = GeometryFactory.eINSTANCE.createTriangle();
                    indices[0] = i3 % 2 != 0 ? i3 + 2 : i3;
                    indices[1] = i3 + 1;
                    indices[2] = i3 % 2 == 0 ? i3 + 2 : i3;
                    nArray = indices;
                    n2 = indices.length;
                    n = 0;
                    while (n < n2) {
                        j = nArray[n];
                        top.getVertices().add((Object)((Vertex)((Vertex)vertices.get(j)).clone()));
                        bottom.getVertices().add((Object)((Vertex)((Vertex)vertices.get(archSize + j)).clone()));
                        ++n;
                    }
                    this.triangles.add((Object)top);
                    this.triangles.add((Object)bottom);
                } else {
                    top = GeometryFactory.eINSTANCE.createTriangle();
                    bottom = GeometryFactory.eINSTANCE.createTriangle();
                    indices[0] = i3 % 2 == 0 ? i3 : i3 + 2;
                    indices[1] = i3 + 1;
                    indices[2] = i3 % 2 != 0 ? i3 : i3 + 2;
                    nArray = indices;
                    n2 = indices.length;
                    n = 0;
                    while (n < n2) {
                        j = nArray[n];
                        top.getVertices().add((Object)((Vertex)((Vertex)vertices.get(j)).clone()));
                        bottom.getVertices().add((Object)((Vertex)((Vertex)vertices.get(archSize + j)).clone()));
                        ++n;
                    }
                    this.triangles.add((Object)top);
                    this.triangles.add((Object)bottom);
                }
                if (i3 < faceBlockSize) {
                    top = GeometryFactory.eINSTANCE.createTriangle();
                    bottom = GeometryFactory.eINSTANCE.createTriangle();
                    indices[0] = i3 % 2 == 0 ? i3 : i3 + faceBlockSize + 2;
                    indices[1] = i3 + 2;
                    indices[2] = i3 % 2 != 0 ? i3 : i3 + faceBlockSize + 2;
                    nArray = indices;
                    n2 = indices.length;
                    n = 0;
                    while (n < n2) {
                        j = nArray[n];
                        top.getVertices().add((Object)((Vertex)((Vertex)vertices.get(j)).clone()));
                        bottom.getVertices().add((Object)((Vertex)((Vertex)vertices.get(archSize + j)).clone()));
                        ++n;
                    }
                    this.triangles.add((Object)top);
                    this.triangles.add((Object)bottom);
                } else {
                    top = GeometryFactory.eINSTANCE.createTriangle();
                    bottom = GeometryFactory.eINSTANCE.createTriangle();
                    indices[0] = i3 % 2 != 0 ? i3 : i3 - faceBlockSize;
                    indices[1] = i3 + 2;
                    indices[2] = i3 % 2 == 0 ? i3 : i3 - faceBlockSize;
                    nArray = indices;
                    n2 = indices.length;
                    n = 0;
                    while (n < n2) {
                        j = nArray[n];
                        top.getVertices().add((Object)((Vertex)((Vertex)vertices.get(j)).clone()));
                        bottom.getVertices().add((Object)((Vertex)((Vertex)vertices.get(archSize + j)).clone()));
                        ++n;
                    }
                    this.triangles.add((Object)top);
                    this.triangles.add((Object)bottom);
                }
            }
            ++i3;
        }
        this.center.setX((bounds.getMaxX() - bounds.getMinX()) / 2.0 + bounds.getMinX());
        this.center.setY((bounds.getMaxY() - bounds.getMinY()) / 2.0 + bounds.getMinY());
        this.center.setZ((bounds.getMaxZ() - bounds.getMinZ()) / 2.0 + bounds.getMinZ());
        return this.triangles;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getPipes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getPipes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getPipes().clear();
                this.getPipes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getPipes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.pipes != null && !this.pipes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object clone() {
        Reactor clone = GeometryFactory.eINSTANCE.createReactor();
        clone.copy(this);
        return clone;
    }
}

