/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form.emf;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.january.form.StringEntry;

public class EMFEntry
extends StringEntry {
    @XmlTransient
    private EObject containingEcoreNode;
    @XmlTransient
    private EAttribute entryMetaData;
    @XmlTransient
    private String typeName;

    public EMFEntry() {
    }

    public EMFEntry(EAttribute attribute, EObject ecoreNode) {
        this.entryMetaData = attribute;
        this.containingEcoreNode = ecoreNode;
        this.setName(this.entryMetaData.getName());
        this.typeName = attribute.getEType().getInstanceClassName();
        Object initialValue = this.containingEcoreNode.eGet((EStructuralFeature)this.entryMetaData);
        if (initialValue != null && this.typeName != null) {
            try {
                if (this.typeName.equals("java.math.BigInteger")) {
                    BigInteger b = (BigInteger)initialValue;
                    this.setValue(b.toString());
                } else if (this.typeName.equals("java.math.BigDecimal")) {
                    BigDecimal d = (BigDecimal)initialValue;
                    this.setValue(d.toString());
                } else if (this.typeName.equals("java.lang.String")) {
                    this.setValue((String)initialValue);
                }
            }
            catch (ClassCastException classCastException) {
                return;
            }
        }
    }

    @Override
    public boolean setValue(String newValue) {
        if (super.setValue(newValue)) {
            block6: {
                try {
                    if (this.typeName.equals("java.lang.String")) {
                        this.containingEcoreNode.eSet((EStructuralFeature)this.entryMetaData, (Object)newValue);
                        break block6;
                    }
                    if (this.typeName.equals("java.math.BigInteger")) {
                        BigInteger b = new BigInteger(newValue);
                        this.containingEcoreNode.eSet((EStructuralFeature)this.entryMetaData, (Object)b);
                        break block6;
                    }
                    if (this.typeName.equals("java.math.BigDecimal")) {
                        BigDecimal d = new BigDecimal(newValue);
                        this.containingEcoreNode.eSet((EStructuralFeature)this.entryMetaData, (Object)d);
                        break block6;
                    }
                    throw new IllegalArgumentException("Unsupported Data Type for the EMFEntry.");
                }
                catch (IllegalArgumentException e) {
                    this.logger.error(String.valueOf(this.getClass().getName()) + " Exception!", (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void copy(EMFEntry otherEntry) {
        if (otherEntry == null) {
            return;
        }
        super.copy(otherEntry);
        this.typeName = otherEntry.typeName;
    }

    @Override
    public Object clone() {
        EMFEntry entry = new EMFEntry(this.entryMetaData, EcoreUtil.create((EClass)this.entryMetaData.getEContainingClass()));
        entry.copy(this);
        return entry;
    }
}

