/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.january.form.Material;

@XmlRootElement(name="MaterialStack")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MaterialStack
implements Comparable<MaterialStack> {
    private Material material;
    private int number;

    public MaterialStack() {
        this.material = null;
        this.number = 0;
    }

    public MaterialStack(Material material, int amount) {
        this.material = material;
        this.number = amount;
    }

    @XmlElement(name="stackMaterial")
    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    @XmlElement
    public int getAmount() {
        return this.number;
    }

    public void setAmount(int amount) {
        this.number = amount;
    }

    public void incrementAmount() {
        ++this.number;
    }

    public void addAmount(int amount) {
        this.number += amount;
    }

    public boolean equals(Object toCompare) {
        boolean isEqual = false;
        if (toCompare instanceof MaterialStack) {
            MaterialStack stack;
            isEqual = this == toCompare ? true : this.number == (stack = (MaterialStack)toCompare).getAmount() && this.material.equals(stack.getMaterial());
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = 8;
        hash = 31 * hash + this.number;
        hash = 31 * hash + this.material.hashCode();
        return hash;
    }

    @Override
    public int compareTo(MaterialStack stack) {
        int retVal = 0;
        retVal = this.material.getName().toLowerCase().equals(stack.getMaterial().getName().toLowerCase()) ? (this.number < stack.getAmount() ? -1 : (this.number == stack.getAmount() ? 0 : 1)) : this.material.compareTo(stack.getMaterial());
        return retVal;
    }

    public String toString() {
        String str = "Material Stack:[ of Material[" + this.material.getName() + "] and amount[" + this.number + "]";
        return str;
    }
}

