/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ClassCorrector
implements Transformer {
    protected ClassHierarchy classHierarchy = null;
    private Log log;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ClassCorrector.class);

    public ClassCorrector(Log log) {
        this.log = log;
    }

    @Override
    public ClassDescription transform(ClassDescription cl) throws ClassNotFoundException {
        this.classHierarchy = cl.getClassHierarchy();
        this.replaceInvisibleExceptions(cl);
        this.replaceInvisibleInMembers(cl);
        this.fixMethods(cl);
        this.removeInvisibleInterfaces(cl);
        this.fixInvisibleSuperclasses(cl);
        this.removeDuplicatedConstants(cl);
        this.checkClassTypeParameters(cl);
        this.removeInvisibleAnnotations(cl);
        this.additionalChecks(cl);
        return cl;
    }

    private void additionalChecks(ClassDescription cl) throws ClassNotFoundException {
        if (this.classHierarchy.isClassVisibleOutside(cl)) {
            if (!cl.hasModifier(Modifier.ABSTRACT)) {
                return;
            }
            boolean ctorExists = false;
            ConstructorDescr[] ctors = cl.getDeclaredConstructors();
            for (int i = 0; i < ctors.length; ++i) {
                ConstructorDescr c = ctors[i];
                if (!c.hasModifier(Modifier.PUBLIC) && !c.hasModifier(Modifier.PROTECTED)) continue;
                ctorExists = true;
                break;
            }
            if (!ctorExists) {
                return;
            }
            MethodDescr[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                MethodDescr mr = methods[i];
                if (!mr.isMethod() || mr.hasModifier(Modifier.PUBLIC) || mr.hasModifier(Modifier.PROTECTED) || !mr.hasModifier(Modifier.ABSTRACT)) continue;
                Object[] invargs = new String[]{cl.getQualifiedName(), mr.toString()};
                this.log.storeWarning(i18n.getString("ClassCorrector.error.class.useless_abst_public_class", invargs), null);
            }
        }
    }

    private void replaceInvisibleExceptions(ClassDescription c) throws ClassNotFoundException {
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isMethod() && !mr.isConstructor()) continue;
            this.replaceInvisibleExceptions(mr);
        }
    }

    private void replaceInvisibleExceptions(MemberDescription mr) throws ClassNotFoundException {
        String throwables = mr.getThrowables();
        if (!"".equals(throwables)) {
            int pos;
            boolean mustCorrect = false;
            StringBuffer sb = new StringBuffer();
            int startPos = 0;
            do {
                String exceptionName;
                if (sb.length() != 0) {
                    sb.append(",");
                }
                if ((pos = throwables.indexOf(",", startPos)) != -1) {
                    exceptionName = throwables.substring(startPos, pos);
                    startPos = pos + 1;
                } else {
                    exceptionName = throwables.substring(startPos);
                }
                if (this.isInvisibleClass(exceptionName)) {
                    List supers = this.classHierarchy.getSuperClasses(exceptionName);
                    exceptionName = this.findVisibleReplacement(exceptionName, supers, "java.lang.Throwable", true);
                    mustCorrect = true;
                }
                sb.append(exceptionName);
            } while (pos != -1);
            if (mustCorrect) {
                Object[] invargs = new String[]{mr.getQualifiedName(), throwables, sb.toString()};
                this.log.storeWarning(i18n.getString("ClassCorrector.message.throwslist.changed", invargs), null);
                mr.setThrowables(sb.toString());
            }
        }
    }

    private String findVisibleReplacementAndCheckInterfaces(String clName, List supers, String replaceWithClassName) throws ClassNotFoundException {
        if (this.isPublicInner(clName)) {
            return null;
        }
        String replacement = this.findVisibleReplacement(clName, supers, replaceWithClassName, true);
        Set oldInt = this.classHierarchy.getAllImplementedInterfaces(clName);
        if (oldInt.size() != 0) {
            Set newInt = this.classHierarchy.getAllImplementedInterfaces(replacement);
            oldInt.removeAll(newInt);
            this.removeSuperInterfaces(oldInt);
            int visibleInterfaces = 0;
            String iName = null;
            for (String nextInt : oldInt) {
                if (this.isInvisibleClass(nextInt)) continue;
                ++visibleInterfaces;
                iName = nextInt;
            }
            if ("java.lang.Object".equals(replacement) && visibleInterfaces == 1) {
                return iName;
            }
            if (visibleInterfaces > 0) {
                return null;
            }
        }
        return replacement;
    }

    private void getPaths2(List<ArrayList<String>> paths, List<String> currentPath, String intFrom, String intTo) {
        String[] sis = new String[]{};
        try {
            sis = this.classHierarchy.getSuperInterfaces(intFrom);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        currentPath.add(intFrom);
        for (int i = 0; i < sis.length; ++i) {
            if (!sis[i].equals(intTo)) {
                this.getPaths2(paths, currentPath, sis[i], intTo);
                currentPath.remove(currentPath.size() - 1);
                continue;
            }
            paths.add(new ArrayList<String>(currentPath));
        }
    }

    private void getPaths(List<ArrayList<String>> paths, List<String> currentPath, String intFrom, String intTo) {
        this.getPaths2(paths, currentPath, intFrom, intTo);
        for (ArrayList<String> path : paths) {
            Iterator<String> it2 = path.iterator();
            while (it2.hasNext()) {
                String cl = it2.next();
                try {
                    if (this.classHierarchy.isAccessible(cl)) continue;
                    it2.remove();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(paths, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer s1 = new Integer(((ArrayList)o1).size());
                Integer s2 = new Integer(((ArrayList)o2).size());
                return s1.compareTo(s2);
            }
        });
    }

    private String findVisibleReplacement(String clName, List supers, String replaceWithClassName, boolean findToSuper) {
        block9: {
            try {
                if (this.classHierarchy.isInterface(clName)) {
                    ArrayList<String> shorterPath;
                    ArrayList<ArrayList<String>> paths = new ArrayList<ArrayList<String>>();
                    ArrayList<String> currentPath = new ArrayList<String>();
                    this.getPaths(paths, currentPath, replaceWithClassName, clName);
                    if (paths.size() > 0 && (shorterPath = paths.get(0)).size() > 0) {
                        return shorterPath.get(shorterPath.size() - 1);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (supers.size() <= 0) break block9;
            if (!findToSuper) {
                int i = supers.indexOf(clName);
                if (i <= 0) {
                    return replaceWithClassName;
                }
                for (int pos = i - 1; pos >= 0; --pos) {
                    String name = (String)supers.get(pos);
                    if (this.isInvisibleClass(name)) continue;
                    return name;
                }
            } else {
                for (int pos = 0; pos < supers.size(); ++pos) {
                    String name = (String)supers.get(pos);
                    if (this.isInvisibleClass(name)) continue;
                    return name;
                }
            }
        }
        return replaceWithClassName;
    }

    private void fixMethods(ClassDescription cl) throws ClassNotFoundException {
        Iterator e = cl.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (mr.isMethod() || mr.isField()) {
                this.fixType(cl, mr);
            }
            if (!mr.isConstructor() && !mr.isMethod()) continue;
            this.checkMethodParameters(cl, mr);
        }
    }

    private void fixType(ClassDescription cl, MemberDescription mr) throws ClassNotFoundException {
        String returnType = mr.getType();
        if (!"".equals(returnType) && this.isInvisibleClass(returnType)) {
            String newName;
            String cleanReturnType = ClassCorrector.stripTypesAndArrays(returnType);
            List supers = Collections.EMPTY_LIST;
            if (!this.classHierarchy.isInterface(cleanReturnType)) {
                supers = this.classHierarchy.getSuperClasses(cleanReturnType);
            }
            if ((newName = this.findVisibleReplacementAndCheckInterfaces(cleanReturnType, supers, "java.lang.Object")) != null) {
                newName = ClassCorrector.wrapTypesAndArrays(returnType, newName);
                mr.setType(newName);
                if (!mr.isField()) {
                    Object[] invargs = new String[]{cl.getName(), mr.getName(), returnType, newName};
                    this.log.storeWarning(i18n.getString("ClassCorrector.message.returntype.changed", invargs), null);
                } else {
                    Object[] invargs = new String[]{cl.getName(), mr.getName(), returnType, newName};
                    this.log.storeWarning(i18n.getString("ClassCorrector.message.fieldtype.changed", invargs), null);
                }
            } else if (!mr.isField()) {
                Object[] invargs = new String[]{returnType, mr.toString()};
                this.log.storeError(i18n.getString("ClassCorrector.error.returntype.hidden", invargs), null);
            } else {
                Object[] invargs = new String[]{returnType, mr.toString()};
                this.log.storeError(i18n.getString("ClassCorrector.error.fieldtype.hidden", invargs), null);
            }
        }
        this.checkType(cl, mr);
    }

    private void checkMethodParameters(ClassDescription cl, MemberDescription mr) {
        String args = mr.getArgs();
        if ("".equals(args)) {
            return;
        }
        this.checkActualParameters(cl, mr, args);
    }

    private void checkType(ClassDescription cl, MemberDescription mr) {
        String type = mr.getType();
        int pos = type.indexOf(60);
        if (pos != -1) {
            this.checkActualParameters(cl, mr, type.substring(pos));
        }
    }

    private void checkActualParameters(ClassDescription cl, MemberDescription mr, String actualParameters) {
        StringTokenizer tz = new StringTokenizer(actualParameters, ",<>[]&", false);
        boolean firstParameter = true;
        while (tz.hasMoreTokens()) {
            boolean isInner;
            String param = tz.nextToken().trim();
            if (param.length() <= 0) continue;
            String prefix = "? super ";
            if (param.indexOf(prefix) == 0) {
                param = param.substring(prefix.length());
            }
            if (param.indexOf(prefix = "? extends ") == 0) {
                param = param.substring(prefix.length());
            }
            if (!this.isInvisibleClass(param)) continue;
            boolean bl = isInner = cl.getQualifiedName().indexOf(36) >= 0;
            if (mr.isConstructor() && isInner && !cl.hasModifier(Modifier.STATIC) && firstParameter) {
                firstParameter = false;
                continue;
            }
            Object[] invargs = new String[]{param, mr.toString(), cl.getQualifiedName()};
            this.log.storeError(i18n.getString("ClassCorrector.error.parametertype.hidden", invargs), null);
        }
    }

    private void replaceInvisibleInMembers(ClassDescription c) throws ClassNotFoundException {
        String className = c.getQualifiedName();
        List supers = this.classHierarchy.getSuperClasses(c.getQualifiedName());
        ArrayList<MemberDescription> newMembers = new ArrayList<MemberDescription>();
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (mr.isSuperClass() || mr.isSuperInterface() || !this.isInvisibleClass(mr.getDeclaringClassName())) continue;
            String newPar = this.findVisibleReplacement(mr.getDeclaringClassName(), supers, className, false);
            MemberDescription newMember = (MemberDescription)mr.clone();
            newMember.setDeclaringClass(newPar);
            e.remove();
            if (c.containsMember(newMember)) continue;
            newMembers.add(newMember);
        }
        for (int i = 0; i < newMembers.size(); ++i) {
            c.add((MemberDescription)newMembers.get(i));
        }
    }

    private void removeInvisibleInterfaces(ClassDescription c) throws ClassNotFoundException {
        MemberDescription mr;
        ArrayList<String> makeThemDirect = null;
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            mr = (MemberDescription)e.next();
            if (!mr.isSuperInterface()) continue;
            SuperInterface si = (SuperInterface)mr;
            String siName = si.getQualifiedName();
            if (this.isInvisibleClass(siName)) {
                e.remove();
                if (si.isDirect()) {
                    if (makeThemDirect == null) {
                        makeThemDirect = new ArrayList<String>();
                    }
                    String[] intfs = this.classHierarchy.getSuperInterfaces(siName);
                    for (int i = 0; i < intfs.length; ++i) {
                        makeThemDirect.add(intfs[i]);
                    }
                }
            }
            if (mr.getTypeParameters() == null) continue;
            this.checkActualParameters(c, mr, mr.getTypeParameters());
        }
        if (makeThemDirect != null) {
            Iterator it = c.getMembersIterator();
            while (it.hasNext()) {
                mr = (MemberDescription)it.next();
                if (!mr.isSuperInterface() || !makeThemDirect.contains(mr.getQualifiedName())) continue;
                ((SuperInterface)mr).setDirect(true);
            }
        }
    }

    private void fixInvisibleSuperclasses(ClassDescription c) throws ClassNotFoundException {
        SuperInterface[] intfs = null;
        MemberDescription newMember = null;
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isSuperClass()) continue;
            if (this.isInvisibleClass(mr.getQualifiedName())) {
                ClassDescription cS = this.classHierarchy.load(mr.getQualifiedName());
                List supers = this.classHierarchy.getSuperClasses(cS.getQualifiedName());
                String newName = this.findVisibleReplacement(mr.getQualifiedName(), supers, "java.lang.Object", true);
                newMember = (MemberDescription)mr.clone();
                newMember.setupClassName(newName);
                e.remove();
                intfs = cS.getInterfaces();
            }
            if (mr.getTypeParameters() == null) break;
            this.checkActualParameters(c, mr, mr.getTypeParameters());
            break;
        }
        if (newMember != null) {
            c.add(newMember);
        }
        if (intfs != null) {
            for (int i = 0; i < intfs.length; ++i) {
                SuperInterface m = (SuperInterface)c.findMember((MemberDescription)intfs[i]);
                if (m == null) continue;
                m.setDirect(true);
                m.setDeclaringClass(c.getQualifiedName());
            }
        }
    }

    protected void removeSuperInterfaces(Set interfaces) throws ClassNotFoundException {
        int i;
        ArrayList intfs = new ArrayList(interfaces);
        ArrayList su = new ArrayList();
        for (i = 0; i < intfs.size(); ++i) {
            String intfName = (String)intfs.get(i);
            if (intfName == null || this.isInvisibleClass(intfName)) continue;
            su.clear();
            su.addAll(this.classHierarchy.getAllImplementedInterfaces(intfName));
            for (int j = 0; j < su.size(); ++j) {
                int pos;
                String sui = (String)su.get(j);
                if (sui.equals(intfName)) continue;
                while ((pos = intfs.indexOf(sui)) >= 0) {
                    intfs.set(pos, null);
                }
            }
        }
        interfaces.clear();
        for (i = 0; i < intfs.size(); ++i) {
            if (intfs.get(i) == null || interfaces.contains(intfs.get(i))) continue;
            interfaces.add(intfs.get(i));
        }
    }

    private void removeDuplicatedConstants(ClassDescription c) {
        MemberDescription mr;
        HashSet<String> constantNames = new HashSet<String>();
        Iterator e = c.getMembersIterator();
        while (e.hasNext()) {
            String constName;
            mr = (MemberDescription)e.next();
            if (!mr.isField() || !mr.isPublic() || !((FieldDescr)mr).isConstant() || c.getMembersCount(MemberType.FIELD, constName = mr.getQualifiedName()) <= 1) continue;
            constantNames.add(constName);
        }
        e = c.getMembersIterator();
        while (e.hasNext()) {
            mr = (MemberDescription)e.next();
            if (!mr.isField() || !((FieldDescr)mr).isConstant() || !constantNames.contains(mr.getQualifiedName())) continue;
            e.remove();
        }
    }

    private void checkClassTypeParameters(ClassDescription cl) {
        this.checkTypeParameters(cl, cl);
        Iterator e = cl.getMembersIterator();
        while (e.hasNext()) {
            MemberDescription mr = (MemberDescription)e.next();
            if (!mr.isMethod() && !mr.isConstructor()) continue;
            this.checkTypeParameters(cl, mr);
        }
    }

    private void checkTypeParameters(ClassDescription cl, MemberDescription mr) {
        String ext = "extends";
        String typeparams = mr.getTypeParameters();
        if (typeparams != null) {
            ArrayList<String> params = Erasurator.splitParameters(typeparams);
            for (int i = 0; i < params.size(); ++i) {
                String param = params.get(i);
                String temp = param.substring(param.indexOf("extends") + "extends".length());
                StringTokenizer st = new StringTokenizer(temp, "&");
                while (st.hasMoreTokens()) {
                    Object[] invargs;
                    String className = st.nextToken().trim();
                    int pos = className.indexOf(60);
                    if (pos != -1) {
                        this.checkActualParameters(cl, mr, className.substring(pos));
                    }
                    if (!this.isInvisibleClass(className) || className.equals(mr.getDeclaringClassName())) continue;
                    if (mr.isMethod() || mr.isConstructor()) {
                        invargs = new String[]{className, mr.toString(), mr.getDeclaringClassName()};
                        this.log.storeError(i18n.getString("ClassCorrector.error.parametertype.hidden", invargs), null);
                        continue;
                    }
                    invargs = new String[]{className, mr.getQualifiedName()};
                    this.log.storeError(i18n.getString("ClassCorrector.error.parametertype.hidden2", invargs), null);
                }
            }
        }
    }

    private static String wrapTypesAndArrays(String oldT, String newT) {
        int pos = ClassCorrector.minPos(oldT.indexOf(91), oldT.indexOf(60));
        if (pos != -1) {
            return newT + oldT.substring(pos);
        }
        return newT;
    }

    private static String stripTypesAndArrays(String name) {
        int pos = ClassCorrector.minPos(name.indexOf(91), name.indexOf(60));
        if (pos != -1) {
            return name.substring(0, pos);
        }
        return name;
    }

    private static int minPos(int i, int j) {
        if (i < 0 && j < 0) {
            return -1;
        }
        if (i < 0 && j >= 0) {
            return j;
        }
        if (i >= 0 && j < 0) {
            return i;
        }
        return Math.min(i, j);
    }

    private boolean isPublicInner(String clName) throws ClassNotFoundException {
        if (clName.indexOf(36) < 0) {
            return false;
        }
        ClassDescription cd = this.classHierarchy.load(clName);
        return cd.isPublic() || cd.isProtected();
    }

    private boolean isInvisibleClass(String fqname) {
        if (fqname.length() == 0) {
            return false;
        }
        if (fqname.startsWith("{")) {
            return false;
        }
        if (fqname.startsWith("?")) {
            return false;
        }
        String pname = ClassCorrector.stripTypesAndArrays(fqname);
        if (PrimitiveTypes.isPrimitive(pname)) {
            return false;
        }
        boolean accessible = true;
        try {
            accessible = this.classHierarchy.isAccessible(pname);
        }
        catch (ClassNotFoundException e) {
            this.log.storeError(i18n.getString("ClassCorrector.error.missingclass", new String[]{pname}), null);
        }
        return !accessible;
    }

    private void removeInvisibleAnnotations(ClassDescription cl) throws ClassNotFoundException {
        int count = 0;
        AnnotationItem[] annotations = cl.getAnnoList();
        int len = annotations.length;
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            String annoName = annotations[i].getName();
            boolean documented = this.classHierarchy.isDocumentedAnnotation(annoName);
            if (this.isInvisibleClass(annoName)) {
                if (documented) {
                    System.out.println(i18n.getString("ClassCorrector.error.invisible_documented_annotation", annoName));
                }
                annotations[i] = null;
                continue;
            }
            ++count;
        }
        if (count == len) {
            return;
        }
        AnnotationItem[] visibleAnnotations = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        if (count != 0) {
            visibleAnnotations = new AnnotationItem[count];
            count = 0;
            for (int i = 0; i < len; ++i) {
                if (annotations[i] == null) continue;
                visibleAnnotations[count++] = annotations[i];
            }
        }
        cl.setAnnoList(visibleAnnotations);
    }
}

