/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.errors.Chain;
import com.sun.tdk.signaturetest.errors.ClassPairedHandler;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.FieldPairedHandler;
import com.sun.tdk.signaturetest.errors.Handler;
import com.sun.tdk.signaturetest.errors.HumanErrorFormatter;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.errors.MethodPairedHandler;
import com.sun.tdk.signaturetest.errors.PairedHandler;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.FieldDescr;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.model.SuperInterface;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.Level;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class BCProcessor
extends HumanErrorFormatter {
    private boolean bin;
    private boolean extensibleInterfaces;
    private ClassHierarchy clHier;
    private ClassHierarchy sfHier;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(BCProcessor.class);
    private ClassDescription objectClass;

    public BCProcessor(PrintWriter out, boolean isv, boolean binMode, ClassHierarchy classHierarchy, ClassHierarchy sigFileClassHierarchy, Level l, boolean extensibleInterfaces) {
        super(out, isv, l);
        this.bin = binMode;
        this.clHier = classHierarchy;
        this.sfHier = sigFileClassHierarchy;
        this.extensibleInterfaces = extensibleInterfaces;
    }

    @Override
    protected Handler constructHandlerChain() {
        Handler[] handlers = new Handler[]{new Rule1_1(), new Rule1_2(), new Rule1_3(), new Rule2_1(), new Rule2_2(), new Rule2_3(), new Rule2_4(), new Rule2_5(), new Rule2_7(), new Rule2_8(), new Rule3_1(), new Rule3_3(), new Rule3_4(), new Rule3_6(), new Rule3_8(), new Rule3_10(), new Rule3_11(), new Rule3_12(), new Rule4_1(), new Rule4_2(), new Rule4_6(), new Rule4_7(), new Rule4_8(), new Rule5_1_2(), new Rule5_2_3(), new Rule5_4(), new Rule5_6(), new Rule5_12(), new Rule5_14(), new Terminator()};
        for (int i = 0; i < handlers.length - 1; ++i) {
            handlers[i].setNext(handlers[i + 1]);
        }
        return handlers[0];
    }

    @Override
    protected void outProcessedErrors() {
        String cl = "";
        for (int i = 0; i < this.failedMessages.size(); ++i) {
            ErrorFormatter.Message current = (ErrorFormatter.Message)this.failedMessages.get(i);
            if (current == null) continue;
            String ccl = current.className;
            if (!cl.equals(ccl)) {
                cl = ccl;
                this.out.println("\nClass " + cl);
            }
            String prefix = "";
            if (current.getLevel().intValue() < Level.SEVERE.intValue()) {
                prefix = "warn: ";
            }
            this.out.println("  " + prefix + current.definition + " : " + current.errorObject);
        }
        if (this.failedMessages.size() > 0) {
            this.out.println("");
        }
    }

    private boolean isDefender(MethodDescr md, String className) throws ClassNotFoundException {
        return !md.isAbstract() && this.clHier.isInterface(className);
    }

    private void initObject() throws ClassNotFoundException {
        if (this.objectClass == null) {
            this.objectClass = this.clHier.load("java.lang.Object");
        }
    }

    private boolean fromObject(MethodDescr md) throws ClassNotFoundException {
        if (md.isAbstract()) {
            this.initObject();
            MethodDescr[] objectMethods = this.objectClass.getDeclaredMethods();
            for (int i = 0; i < objectMethods.length; ++i) {
                MethodDescr mdo = objectMethods[i];
                if (mdo.isPrivate() || !md.getSignature().equals(mdo.getSignature())) continue;
                return true;
            }
        }
        return false;
    }

    static class Terminator
    extends Handler {
        Terminator() {
        }

        @Override
        boolean acceptMessageList(List l) {
            return true;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            ch.setMessagesProcessed(l);
        }
    }

    static class Rule5_14
    extends ClassPairedHandler {
        Rule5_14() {
        }

        @Override
        protected boolean proc() {
            if (!this.c1.isFinal() && this.c2.isFinal()) {
                this.newM.definition = i18n.getString("BCProcessor.error.5_14");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule5_12
    extends ClassPairedHandler {
        Rule5_12() {
        }

        @Override
        protected boolean proc() {
            if (!this.c1.isAbstract() && !this.c1.hasModifier(Modifier.ENUM) && this.c2.isAbstract() && this.canBeSubclassed(this.c1.getQualifiedName(), BCProcessor.this.sfHier)) {
                this.newM.definition = i18n.getString("BCProcessor.error.5_12");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule5_6
    extends Handler {
        private ErrorFormatter.Message m;

        Rule5_6() {
            this.setLevel(Level.WARNING);
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_FLD) {
                try {
                    ClassDescription cd = BCProcessor.this.clHier.load(this.m.className);
                    if (cd.isClass() && !cd.isFinal() && !cd.isInterface()) {
                        return true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.5_6");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    static class Rule5_4
    extends Handler {
        private ErrorFormatter.Message m;

        Rule5_4() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            return this.m.messageType == MessageType.MISS_CONSTRUCTORS;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.5_4");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    class Rule5_2_3
    extends Handler {
        private ErrorFormatter.Message m;

        Rule5_2_3() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_METHS && this.m.errorObject instanceof MethodDescr) {
                try {
                    return !BCProcessor.this.clHier.isInterface(this.m.className) && !BCProcessor.this.clHier.isAnnotation(this.m.className);
                }
                catch (ClassNotFoundException e) {
                    SwissKnife.reportThrowable(e);
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            try {
                ClassDescription cd = BCProcessor.this.clHier.load(this.m.className);
                MethodDescr md = (MethodDescr)this.m.errorObject;
                if (this.canBeSubclassed(this.m.className, BCProcessor.this.sfHier)) {
                    if (md.isAbstract()) {
                        this.m.definition = i18n.getString("BCProcessor.error.5_2");
                        ch.addMessage(this.m);
                        this.setMessageLevel(this.m);
                        return;
                    }
                    if (md.isStatic() && !cd.hasModifier(Modifier.FINAL) && !BCProcessor.this.bin) {
                        this.m.definition = i18n.getString("BCProcessor.error.5_3");
                        ch.addMessage(this.m);
                        this.setMessageLevel(this.m);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                SwissKnife.reportThrowable(e);
            }
        }
    }

    class Rule5_1_2
    extends Handler {
        private ErrorFormatter.Message m;

        Rule5_1_2() {
            this.setLevel(Level.WARNING);
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_METHS && this.m.errorObject instanceof MethodDescr) {
                try {
                    return !BCProcessor.this.clHier.isInterface(this.m.className) && !BCProcessor.this.clHier.isAnnotation(this.m.className);
                }
                catch (ClassNotFoundException e) {
                    SwissKnife.reportThrowable(e);
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            try {
                ClassDescription cd = BCProcessor.this.clHier.load(this.m.className);
                MethodDescr md = (MethodDescr)this.m.errorObject;
                if (!md.isStatic() && !md.isAbstract()) {
                    if (cd.hasModifier(Modifier.FINAL)) {
                        return;
                    }
                    if (BCProcessor.this.bin) {
                        return;
                    }
                    this.m.definition = i18n.getString("BCProcessor.error.5_1_2");
                    ch.addMessage(this.m);
                    this.setMessageLevel(this.m);
                }
            }
            catch (ClassNotFoundException e) {
                SwissKnife.reportThrowable(e);
            }
        }
    }

    static class Rule4_8
    extends FieldPairedHandler {
        Rule4_8() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (!super.acceptMessageList(l)) {
                return false;
            }
            this.init(l);
            return !this.f1.hasModifier(Modifier.STATIC) && this.f2.hasModifier(Modifier.STATIC);
        }

        @Override
        protected boolean proc() {
            this.newM.definition = i18n.getString("BCProcessor.error.4_8");
            this.setMessageLevel(this.newM);
            return true;
        }
    }

    static class Rule4_7
    extends FieldPairedHandler {
        Rule4_7() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (!super.acceptMessageList(l)) {
                return false;
            }
            this.init(l);
            return this.f1.hasModifier(Modifier.STATIC) && !this.f2.hasModifier(Modifier.STATIC);
        }

        @Override
        protected boolean proc() {
            this.newM.definition = i18n.getString("BCProcessor.error.4_7");
            this.setMessageLevel(this.newM);
            return true;
        }
    }

    static class Rule4_6
    extends FieldPairedHandler {
        Rule4_6() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (!super.acceptMessageList(l)) {
                return false;
            }
            this.init(l);
            return !this.f1.hasModifier(Modifier.FINAL) && this.f2.hasModifier(Modifier.FINAL);
        }

        @Override
        protected boolean proc() {
            this.newM.definition = i18n.getString("BCProcessor.error.4_6");
            this.setMessageLevel(this.newM);
            return true;
        }
    }

    static class Rule4_2
    extends FieldPairedHandler {
        Handler r46 = new Rule4_6();
        Handler r47 = new Rule4_7();
        Handler r48 = new Rule4_8();

        Rule4_2() {
            this.setLevel(Level.WARNING);
        }

        @Override
        boolean acceptMessageList(List l) {
            if (!super.acceptMessageList(l) || this.r46.acceptMessageList(l) || this.r47.acceptMessageList(l) || this.r48.acceptMessageList(l)) {
                return false;
            }
            return this.f1.getConstantValue() != null || this.f2.getConstantValue() != null;
        }

        @Override
        protected boolean proc() {
            if (!this.conValEquals(this.f1, this.f2)) {
                this.newM.definition = i18n.getString("BCProcessor.error.4_2");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }

        private boolean conValEquals(FieldDescr f1, FieldDescr f2) {
            String v2;
            String v1 = f1.getConstantValue() == null ? "" : f1.getConstantValue();
            String string = v2 = f2.getConstantValue() == null ? "" : f2.getConstantValue();
            if (!f1.getType().equals(f2.getType())) {
                return true;
            }
            return v1.equals(v2);
        }
    }

    static class Rule4_1
    extends PairedHandler {
        Rule4_1() {
        }

        @Override
        protected boolean proc() {
            String t2;
            String t1;
            if (this.m1 instanceof FieldDescr && this.m2 instanceof FieldDescr && !(t1 = this.m1.getType()).equals(t2 = this.m2.getType())) {
                this.newM.definition = i18n.getString("BCProcessor.error.4_1");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    static class Rule3_12
    extends MethodPairedHandler {
        Rule3_12() {
        }

        @Override
        protected boolean proc() {
            if (!this.meth1.isStatic() && this.meth2.isStatic()) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_12");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    static class Rule3_11
    extends MethodPairedHandler {
        Rule3_11() {
        }

        @Override
        protected boolean proc() {
            if (this.meth1.isStatic() && !this.meth2.isStatic()) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_11");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule3_10
    extends MethodPairedHandler {
        Rule3_10() {
        }

        @Override
        protected boolean proc() {
            if (!this.meth1.isFinal() && this.meth2.isFinal() && this.canBeSubclassed(this.me1.className, BCProcessor.this.sfHier)) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_10");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule3_8
    extends MethodPairedHandler {
        Rule3_8() {
        }

        @Override
        protected boolean proc() {
            if (!this.meth1.isAbstract() && this.meth2.isAbstract() && this.canBeSubclassed(this.me1.className, BCProcessor.this.sfHier)) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_8");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule3_6
    extends MethodPairedHandler {
        Rule3_6() {
            this.setLevel(Level.WARNING);
        }

        @Override
        protected boolean proc() {
            boolean problem;
            boolean bl = problem = this.meth1.isProtected() && this.meth2.isPublic() && !this.meth1.isFinal();
            if (problem && !BCProcessor.this.bin && this.canBeSubclassed(this.me1.className, BCProcessor.this.sfHier)) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_6");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule3_4
    extends PairedHandler {
        Rule3_4() {
        }

        @Override
        boolean acceptMessageList(List l) {
            return super.acceptMessageList(l) && !BCProcessor.this.bin;
        }

        @Override
        protected boolean proc() {
            ArrayList c2;
            ArrayList c1 = Handler.stringToArrayList(this.m1.getThrowables(), ",");
            if (!c1.equals(c2 = Handler.stringToArrayList(this.m2.getThrowables(), ","))) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_4");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule3_3
    extends MethodPairedHandler {
        Rule3_3() {
        }

        @Override
        boolean acceptMessageList(List l) {
            return !BCProcessor.this.bin && super.acceptMessageList(l);
        }

        @Override
        protected boolean proc() {
            boolean problem;
            boolean bl = problem = this.meth1.hasModifier(Modifier.VARARGS) && !this.meth2.hasModifier(Modifier.VARARGS);
            if (problem) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_3");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule3_1
    extends MethodPairedHandler {
        Rule3_1() {
        }

        @Override
        protected boolean proc() {
            if (!(this.meth1.getType().equals(this.meth2.getType()) && this.meth1.getSignature().equals(this.meth2.getSignature()) || this.isAssignableTo(this.meth1.getType(), this.meth2.getType(), BCProcessor.this.sfHier))) {
                this.newM.definition = i18n.getString("BCProcessor.error.3_1");
                return true;
            }
            return false;
        }
    }

    static class Rule2_8
    extends MethodPairedHandler {
        Rule2_8() {
        }

        @Override
        protected boolean proc() {
            if (this.me1.messageType == MessageType.MISS_METHS && this.me2.messageType == MessageType.ADD_METHS && this.meth1.getSignature().equals(this.meth2.getSignature()) && this.meth1.hasModifier(Modifier.HASDEFAULT) && !this.meth2.hasModifier(Modifier.HASDEFAULT)) {
                this.newM.definition = i18n.getString("BCProcessor.error.2_8");
                return true;
            }
            return false;
        }
    }

    class Rule2_7
    extends Handler {
        private ErrorFormatter.Message m;

        Rule2_7() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.MISS_METHS && this.m.errorObject instanceof MethodDescr) {
                MethodDescr md = (MethodDescr)this.m.errorObject;
                try {
                    String dcn = md.getDeclaringClassName();
                    return BCProcessor.this.clHier.isInterface(dcn) && BCProcessor.this.clHier.isAnnotation(dcn);
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.2_7");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    class Rule2_5
    extends Handler {
        private ErrorFormatter.Message m;

        Rule2_5() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1 || BCProcessor.this.bin) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_METHS && this.m.errorObject instanceof MethodDescr) {
                MethodDescr md = (MethodDescr)this.m.errorObject;
                try {
                    String dcn = md.getDeclaringClassName();
                    return BCProcessor.this.clHier.isInterface(dcn) && BCProcessor.this.clHier.isAnnotation(dcn) && !md.hasModifier(Modifier.HASDEFAULT);
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.2_5");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    static class Rule2_4
    extends Handler {
        private ErrorFormatter.Message m;

        Rule2_4() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            return this.m.messageType == MessageType.MISS_SUPERCLASSES && this.m.errorObject instanceof SuperInterface;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.2_4");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    class Rule2_3
    extends Handler {
        private ErrorFormatter.Message m;

        Rule2_3() {
        }

        @Override
        boolean acceptMessageList(List l) {
            FieldDescr md;
            if (l.size() != 1) {
                return false;
            }
            if (BCProcessor.this.bin) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_FLD && this.m.errorObject instanceof FieldDescr && !this.m.className.equals((md = (FieldDescr)this.m.errorObject).getDeclaringClassName())) {
                try {
                    return BCProcessor.this.clHier.isInterface(md.getDeclaringClassName());
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.2_3");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    class Rule2_2
    extends Handler {
        private ErrorFormatter.Message m;

        Rule2_2() {
            this.setLevel(Level.WARNING);
        }

        @Override
        boolean acceptMessageList(List l) {
            FieldDescr md;
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_FLD && this.m.errorObject instanceof FieldDescr && this.m.className.equals((md = (FieldDescr)this.m.errorObject).getDeclaringClassName())) {
                try {
                    return BCProcessor.this.clHier.isInterface(md.getDeclaringClassName());
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.2_2");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    class Rule2_1
    extends Handler {
        private ErrorFormatter.Message m;

        Rule2_1() {
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_METHS && this.m.errorObject instanceof MethodDescr) {
                MethodDescr md = (MethodDescr)this.m.errorObject;
                try {
                    if (!BCProcessor.this.isDefender(md, this.m.className)) {
                        String dcn = md.getDeclaringClassName();
                        if (!BCProcessor.this.extensibleInterfaces && BCProcessor.this.clHier.isInterface(dcn) && !BCProcessor.this.clHier.isAnnotation(dcn)) {
                            if (!BCProcessor.this.clHier.isInterface(this.m.className) && !this.canBeSubclassed(this.m.className, BCProcessor.this.clHier)) {
                                return false;
                            }
                            return !BCProcessor.this.fromObject(md);
                        }
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.2_1");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    static class Rule1_3
    extends PairedHandler {
        Rule1_3() {
        }

        @Override
        protected boolean proc() {
            boolean problem;
            boolean bl = problem = this.m1.hasModifier(Modifier.PUBLIC) && !this.m2.hasModifier(Modifier.PUBLIC);
            if (problem) {
                this.newM.definition = i18n.getString("BCProcessor.error.1_3");
                this.setMessageLevel(this.newM);
                return true;
            }
            return false;
        }
    }

    class Rule1_2
    extends Handler {
        private ErrorFormatter.Message m;

        Rule1_2() {
        }

        @Override
        boolean acceptMessageList(List l) {
            boolean retval;
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            boolean bl = retval = this.m.messageType == MessageType.MISS_CLASSES || this.m.messageType == MessageType.MISS_FIELDS || this.m.messageType == MessageType.MISS_METHS;
            if (retval && this.m.errorObject.isProtected() && !this.canBeSubclassed(this.m.className, BCProcessor.this.sfHier)) {
                retval = false;
            }
            return retval;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            this.m.definition = i18n.getString("BCProcessor.error.1_2");
            this.setMessageLevel(this.m);
            ch.addMessage(this.m);
        }
    }

    class Rule1_1
    extends Handler {
        private ErrorFormatter.Message m;
        private Handler r5;

        Rule1_1() {
            this.r5 = new Rule5_2_3();
            this.setLevel(Level.WARNING);
        }

        @Override
        boolean acceptMessageList(List l) {
            if (l.size() != 1) {
                return false;
            }
            this.m = (ErrorFormatter.Message)l.get(0);
            if (this.m.messageType == MessageType.ADD_METHS && this.m.errorObject instanceof MethodDescr) {
                MethodDescr md = (MethodDescr)this.m.errorObject;
                try {
                    if (BCProcessor.this.isDefender(md, this.m.className)) {
                        return false;
                    }
                    if (BCProcessor.this.fromObject(md)) {
                        return false;
                    }
                    String dcn = md.getDeclaringClassName();
                    if (BCProcessor.this.clHier.isInterface(dcn) && BCProcessor.this.clHier.isAnnotation(dcn)) {
                        return false;
                    }
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            if (this.r5.acceptMessageList(l)) {
                return false;
            }
            if (this.m.messageType == MessageType.ADD_CONSTRUCTORS) {
                return false;
            }
            return this.m.messageType == MessageType.ADD_CLASSES || this.m.messageType == MessageType.ADD_METHS;
        }

        @Override
        protected void writeMessage(List l, Chain ch) {
            if (!BCProcessor.this.bin) {
                this.m.definition = i18n.getString("BCProcessor.error.1_1");
                this.setMessageLevel(this.m);
                ch.addMessage(this.m);
            }
        }
    }
}

