/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.xml;

import com.sun.ant.taskdefs.xml.BaseProcessor;
import com.sun.ant.taskdefs.xml.NameSpace;
import com.sun.ant.taskdefs.xml.NodeProcessorIntf;
import com.sun.ant.taskdefs.xml.TaskDataIntf;
import com.sun.ant.taskdefs.xml.XMLFragment;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.jdom.Document;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class ModifyXML
extends Task
implements TaskDataIntf {
    private File infile;
    private File outfile;
    private String xpathexpr;
    private String value;
    private boolean validate;
    private String[] schemapaths;
    private String defaultnsprefix = "j";
    private boolean overwriteoutfile = true;
    private List namespaces = new ArrayList();
    private NameSpace docdefaultnamespace;
    private XMLFragment fragment;
    private boolean deletenodes;
    private String property;
    private Document xmldoc;
    private NodeProcessorIntf processor;

    public Project getProject() {
        return this.project;
    }

    public void setInfile(File infile) {
        this.infile = infile;
    }

    public void setOutfile(File outfile) {
        this.outfile = outfile;
    }

    public String getOutfile() {
        return this.outfile.getPath();
    }

    public void setXPathexpr(String xpathexpr) {
        this.xpathexpr = xpathexpr;
    }

    public void setOverwriteoutfile(boolean overwriteoutfile) {
        this.overwriteoutfile = overwriteoutfile;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setSchemapaths(String schemapaths) {
        String delimiters = " \t\n\r\f,";
        StringTokenizer tokens = new StringTokenizer(schemapaths, delimiters);
        this.schemapaths = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            this.schemapaths[i] = Project.translatePath((String)tokens.nextToken().trim());
            ++i;
        }
    }

    public void setDefaultnsprefix(String defaultnsprefix) {
        this.defaultnsprefix = defaultnsprefix;
    }

    public void addConfiguredNamespace(NameSpace namespace) {
        namespace.init();
        this.namespaces.add(namespace);
        if (namespace.isDocdefault()) {
            this.docdefaultnamespace = namespace;
        }
    }

    public void addConfiguredXmlfragment(XMLFragment fragment) {
        fragment.init();
        this.fragment = fragment;
    }

    public XMLFragment getFragment() {
        return this.fragment;
    }

    public void setDeletenodes(boolean deletenodes) {
        this.deletenodes = deletenodes;
    }

    public boolean getDeletenodes() {
        return this.deletenodes;
    }

    private void printNamespaces() {
        int numNS = this.namespaces.size();
        NameSpace ns = null;
        this.log("User specified namespaces:", 3);
        for (int i = 0; i < numNS; ++i) {
            ns = (NameSpace)this.namespaces.get(i);
            this.log("  namespace " + i + "   : " + ns, 3);
        }
    }

    private void dumpState() {
        this.printNamespaces();
        this.log("infile          : \"" + this.infile + "\"", 3);
        this.log("outfile         : \"" + this.outfile + "\"", 3);
        this.log("xpathexpr       : \"" + this.xpathexpr + "\"", 3);
        this.log("value           : \"" + this.value + "\"", 3);
        this.log("deletenodes     : \"" + this.deletenodes + "\"", 3);
        this.log("property        : \"" + this.property + "\"", 3);
        if (this.fragment != null) {
            this.log("xmlfragment     : \"" + this.fragment.getContainingElementName() + "\"", 3);
        } else {
            this.log("xmlfragment     : \"null\"", 3);
        }
        this.log("defaultnsprefix : \"" + this.defaultnsprefix + "\"", 3);
        this.log("overwriteoutfile: \"" + this.overwriteoutfile + "\"", 3);
        this.log("validate XML    : \"" + this.validate + "\"", 3);
        if (this.schemapaths != null) {
            this.log("schemapaths     : \"" + Arrays.asList(this.schemapaths) + "\"", 3);
        }
    }

    public void execute() throws BuildException {
        this.dumpState();
        this.checkPreConditions();
        this.parseInputDoc();
        this.modifyInputDoc();
        if (this.processor.getMode() != 3) {
            this.writeOutputDoc();
        }
    }

    private void checkPreConditions() throws BuildException {
        if (this.infile == null) {
            throw new BuildException("Error: you must specify a valid file for attribute infile");
        }
        if (!this.infile.isFile()) {
            throw new BuildException("Error: infile is not a valid file.");
        }
        if (this.property == null) {
            if (this.outfile == null) {
                throw new BuildException("Error: you must specify a file for attribute outfile");
            }
            if (this.outfile.isFile() && !this.overwriteoutfile) {
                throw new BuildException("Error: outfile already exists, to overwrite specify overwriteoutfile=\"false\" or omit the overwriteoutfile attribute.");
            }
        }
        if (this.xpathexpr == null || this.xpathexpr.length() == 0) {
            throw new BuildException("Error: xpathexpr must contain a valid XPath expression.");
        }
        if (this.schemapaths != null) {
            boolean foundError = false;
            for (int i = 0; i < this.schemapaths.length; ++i) {
                File currentDir = new File(this.schemapaths[i]);
                if (currentDir.isDirectory()) continue;
                this.log("Error in schema path: \"" + this.schemapaths[i] + "\" is not a valid directory", 0);
                foundError = true;
            }
            if (foundError) {
                throw new BuildException("Error: one or more schema paths are invalid directories.");
            }
        }
        this.processor = BaseProcessor.getProcessor(this);
    }

    private void parseInputDoc() throws BuildException {
        try {
            SAXBuilder builder = new SAXBuilder(this.validate);
            if (this.schemapaths != null) {
                MyResolver resolver = new MyResolver(this.schemapaths);
                builder.setEntityResolver((EntityResolver)resolver);
            }
            this.xmldoc = builder.build(this.infile);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void addDefautNamespace(XPath xpath) {
        String nsURI = this.xmldoc.getRootElement().getNamespaceURI();
        String nsPrefix = this.xmldoc.getRootElement().getNamespacePrefix();
        this.log("Root Element NameSpace URI   : \"" + nsURI + "\"", 3);
        this.log("Root Element NameSpace Prefix: \"" + nsPrefix + "\"", 3);
        if (nsURI.length() > 0) {
            if (nsPrefix.length() > 0) {
                xpath.addNamespace(nsPrefix, nsURI);
                this.log("Added NameSpace              : \"[" + nsPrefix + " -> " + nsURI + "]\"", 3);
            } else {
                xpath.addNamespace(this.defaultnsprefix, nsURI);
                this.log("Added NameSpace              : \"[" + this.defaultnsprefix + " -> " + nsURI + "]\"", 3);
            }
        }
    }

    private void addUserSpecifiedNamespaces(XPath xpath) {
        int numNS = this.namespaces.size();
        NameSpace ns = null;
        for (int i = 0; i < numNS; ++i) {
            ns = (NameSpace)this.namespaces.get(i);
            xpath.addNamespace(ns.getPrefix(), ns.getUri());
        }
    }

    public Namespace getDefaultNamespace() {
        Namespace ns = null;
        ns = this.docdefaultnamespace != null ? Namespace.getNamespace((String)this.docdefaultnamespace.getUri()) : this.xmldoc.getRootElement().getNamespace();
        return ns;
    }

    private void modifyInputDoc() throws BuildException {
        try {
            XPath xpath = XPath.newInstance((String)this.xpathexpr);
            if (this.namespaces.size() == 0) {
                this.addDefautNamespace(xpath);
            } else {
                this.addUserSpecifiedNamespaces(xpath);
            }
            List elements = xpath.selectNodes((Object)this.xmldoc);
            int numElements = elements == null ? 0 : elements.size();
            this.processor.process(elements, this);
            if (numElements == 0) {
                this.log("XPath expression \"" + this.xpathexpr + "\" returned no nodes.", 1);
            } else {
                this.log("XPath expression \"" + this.xpathexpr + "\" " + this.processor.getModeStr() + " " + numElements + " node(s)", 1);
            }
            this.log(this.processor.getMessage(), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private void writeOutputDoc() throws BuildException {
        Writer writer = null;
        try {
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            writer = new FileWriter(this.outfile);
            out.output(this.xmldoc, writer);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
    }

    class MyResolver
    implements EntityResolver {
        private String[] paths;

        public MyResolver(String[] paths) {
            this.paths = paths;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String result = null;
            String schemaName = systemId.substring(systemId.lastIndexOf("/") + 1);
            for (int i = 0; i < this.paths.length; ++i) {
                String schemaLocation = this.paths[i] + File.separator + schemaName;
                File possibleSchema = new File(schemaLocation);
                if (!possibleSchema.isFile()) continue;
                result = schemaLocation;
                break;
            }
            if (result == null) {
                throw new BuildException("Error could not resolve schema \"" + schemaName + "\"");
            }
            return new InputSource(result);
        }
    }
}

