/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.observerMethod;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Event;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.ObservesLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Banana;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Cherry;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Delicious;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.FruitObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Kiwi;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Melon;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Orange;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Papaya;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Peach;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Pear;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Pineapple;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.ProcessObserverMethodObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.ProcessSyntheticObserverMethodObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Ripe;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0")
public class ObserverMethodConfiguratorTest
extends AbstractTest {
    @Inject
    Event<Pear> pearEvent;
    @Inject
    ProcessSyntheticObserverMethodObserver extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ObserverMethodConfiguratorTest.class)).withClass(ObservesLiteral.class)).withExtensions(ProcessObserverMethodObserver.class, AfterBeanDiscoveryObserver.class, ProcessSyntheticObserverMethodObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="bg"), @SpecAssertion(section="observer_method_configurator", id="bd"), @SpecAssertion(section="observer_method_configurator", id="bi")})
    public void addQualifiersAndSetPriorityAndChangeToAsync() throws InterruptedException {
        Set pearEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Pear(), new Annotation[]{Any.Literal.INSTANCE, Ripe.RipeLiteral.INSTANCE, Delicious.DeliciousLiteral.INSTANCE});
        Assert.assertEquals((int)pearEventObservers.size(), (int)1);
        Assert.assertEquals((int)((ObserverMethod)pearEventObservers.iterator().next()).getPriority(), (int)2600);
        Assert.assertEquals((boolean)((ObserverMethod)pearEventObservers.iterator().next()).isAsync(), (boolean)true);
        Assert.assertEquals((Set)((ObserverMethod)pearEventObservers.iterator().next()).getObservedQualifiers(), Stream.of(Ripe.RipeLiteral.INSTANCE, Delicious.DeliciousLiteral.INSTANCE).collect(Collectors.toSet()));
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.pearEvent.select(new Annotation[]{Any.Literal.INSTANCE, Ripe.RipeLiteral.INSTANCE, Delicious.DeliciousLiteral.INSTANCE}).fireAsync((Object)new Pear()).thenAccept(queue::offer);
        Pear pear = (Pear)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)pear);
        Assert.assertTrue((boolean)FruitObserver.pearObserverNotified.get());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="be"), @SpecAssertion(section="observer_method_configurator", id="bf")})
    public void setReceptionAndTransactionPhase() {
        Set orangeEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Orange(), new Annotation[]{Any.Literal.INSTANCE, Delicious.DeliciousLiteral.INSTANCE});
        Assert.assertEquals((int)orangeEventObservers.size(), (int)1);
        Assert.assertEquals((Object)((ObserverMethod)orangeEventObservers.iterator().next()).getReception(), (Object)Reception.IF_EXISTS);
        Assert.assertEquals((Object)((ObserverMethod)orangeEventObservers.iterator().next()).getTransactionPhase(), (Object)TransactionPhase.AFTER_SUCCESS);
        Assert.assertEquals((Set)((ObserverMethod)orangeEventObservers.iterator().next()).getObservedQualifiers(), Collections.singleton(Delicious.DeliciousLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="bc"), @SpecAssertion(section="observer_method_configurator", id="bh")})
    public void notifyAcceptingConsumerNotified() {
        this.getCurrentManager().fireEvent((Object)new Pineapple(), new Annotation[]{Any.Literal.INSTANCE, Delicious.DeliciousLiteral.INSTANCE});
        Assert.assertTrue((boolean)ProcessObserverMethodObserver.consumerNotified.get());
        Assert.assertEquals(ProcessObserverMethodObserver.pineAppleQualifiers, Arrays.asList(Any.Literal.INSTANCE, Delicious.DeliciousLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="aa"), @SpecAssertion(section="observer_method_configurator", id="ab"), @SpecAssertion(section="observer_method_configurator", id="ac"), @SpecAssertion(section="observer_method_configurator", id="ba"), @SpecAssertion(section="observer_method_configurator", id="bb"), @SpecAssertion(section="after_bean_discovery", id="ed")})
    public void addNewObserverMethodFromReadingExistingOne() {
        AfterBeanDiscoveryObserver.reset();
        this.getCurrentManager().fireEvent((Object)new Banana(), new Annotation[]{Any.Literal.INSTANCE, Ripe.RipeLiteral.INSTANCE});
        this.getCurrentManager().fireEvent((Object)new Melon(), new Annotation[]{Any.Literal.INSTANCE});
        this.getCurrentManager().fireEvent((Object)new Peach(), new Annotation[]{Any.Literal.INSTANCE});
        Set peachEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Peach(), new Annotation[]{Any.Literal.INSTANCE});
        Set bananaEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Banana(), new Annotation[]{Any.Literal.INSTANCE, Ripe.RipeLiteral.INSTANCE});
        Assert.assertEquals((int)peachEventObservers.size(), (int)2);
        Assert.assertEquals((int)bananaEventObservers.size(), (int)2);
        Assert.assertTrue((boolean)AfterBeanDiscoveryObserver.newBananaObserverNotified.get());
        Assert.assertTrue((boolean)AfterBeanDiscoveryObserver.newMelonObserverNotified.get());
        Assert.assertTrue((boolean)AfterBeanDiscoveryObserver.newPeachObserverNotified.get());
        Assert.assertTrue((boolean)FruitObserver.melonObserverNotified.get());
        Assert.assertTrue((boolean)FruitObserver.peachObserverNotified.get());
        Assert.assertTrue((boolean)FruitObserver.bananaObserverNotified.get());
    }

    @Test
    @SpecAssertion(section="process_observer_method", id="dab")
    public void configuratorInitializedWithOriginalObserverMethod() {
        ObserverMethod configuredOne = (ObserverMethod)this.getCurrentManager().resolveObserverMethods((Object)new Kiwi(), new Annotation[]{Ripe.RipeLiteral.INSTANCE}).iterator().next();
        ObserverMethod<Kiwi> originalOne = ((ProcessObserverMethodObserver)this.getCurrentManager().getExtension(ProcessObserverMethodObserver.class)).getOriginalOM();
        Assert.assertEquals((Object)configuredOne.getObservedType(), (Object)originalOne.getObservedType());
        Assert.assertEquals((Set)configuredOne.getObservedQualifiers(), (Set)originalOne.getObservedQualifiers());
        Assert.assertEquals((int)configuredOne.getPriority(), (int)originalOne.getPriority());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_observer_method", id="aab"), @SpecAssertion(section="process_observer_method", id="dae")})
    public void syntheticEventInvokedAndReturningSourceTest() {
        Assert.assertEquals((Object)this.extension.timesInvoked(), (Object)new Integer(4));
        Map<Type, Extension> map = this.extension.getSources();
        Assert.assertEquals(map.get(Peach.class).getClass(), AfterBeanDiscoveryObserver.class);
        Assert.assertEquals(map.get(Banana.class).getClass(), AfterBeanDiscoveryObserver.class);
        Assert.assertEquals(map.get(Melon.class).getClass(), AfterBeanDiscoveryObserver.class);
        Assert.assertEquals(map.get(Cherry.class).getClass(), AfterBeanDiscoveryObserver.class);
    }

    @Test
    @SpecAssertion(section="observer_method_configurator", id="baa")
    public void defaultBeanClassIsExtensionClass() {
        Set papayaEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Papaya(), new Annotation[]{Any.Literal.INSTANCE});
        ObserverMethod papayaObserver = (ObserverMethod)papayaEventObservers.iterator().next();
        Assert.assertNotNull((Object)papayaObserver, (String)"There is no Papaya Observer available!");
        Assert.assertEquals((Object)papayaObserver.getBeanClass(), AfterBeanDiscoveryObserver.class);
    }
}

