/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.report;

import com.sun.javatest.report.HTMLReport;
import com.sun.javatest.report.ReportSettings;
import com.sun.javatest.report.ReportWriter;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

abstract class HTMLSection {
    protected String name;
    protected File reportDir;
    protected ReportSettings settings;
    protected HTMLReport parent;
    protected File workDirRoot;

    HTMLSection(String name, ReportSettings settings, File reportDir, HTMLReport parent) {
        String reportDirPath;
        String workPath;
        this.name = name;
        this.settings = settings;
        this.reportDir = reportDir;
        this.parent = parent;
        this.workDirRoot = this.settings.getInterview().getWorkDirectory().getRoot();
        try {
            workPath = this.workDirRoot.getCanonicalPath();
            reportDirPath = this.reportDir.getCanonicalPath();
        }
        catch (IOException e) {
            workPath = this.workDirRoot.getPath();
            reportDirPath = this.reportDir.getPath();
        }
        if (!workPath.endsWith(File.separator)) {
            workPath = workPath + File.separator;
        }
        if (reportDirPath.startsWith(workPath)) {
            File d;
            StringBuilder sb = new StringBuilder();
            try {
                for (d = this.reportDir; d != null && !d.getCanonicalPath().equals(this.workDirRoot.getCanonicalPath()); d = d.getParentFile()) {
                    sb.append("../");
                }
            }
            catch (IOException e) {
                d = null;
            }
            if (d != null) {
                this.workDirRoot = new File(sb.toString());
            }
        }
    }

    Writer openWriter(int reportCode) throws IOException {
        return this.parent.openWriter(this.reportDir, reportCode);
    }

    String getName() {
        return this.name;
    }

    void writeContents(ReportWriter repWriter) throws IOException {
        repWriter.writeLink('#' + this.name, this.name);
    }

    void writeSummary(ReportWriter repWriter) throws IOException {
        repWriter.startTag("h2");
        repWriter.writeLinkDestination(this.name, this.name);
        repWriter.endTag("h2");
    }

    void writeExtraFiles() throws IOException {
    }

    protected ReportWriter openAuxFile(int reportCode, String title, I18NResourceBundle i18n) throws IOException {
        return new ReportWriter(this.openWriter(reportCode), title, i18n);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {name='" + this.name + "'}";
    }
}

