/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.mrep;

import com.sun.javatest.report.ReportDirChooser;
import com.sun.javatest.tool.IconFactory;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;

class FilesPane
extends JPanel {
    static final String OK = "OK";
    static final String REPORT_DIR = "reportDir";
    private UIFactory uif;
    private Listener listener;
    private List<JTextField> merged;
    private JButton resultBtn;
    private JButton[] buttons;
    private JButton nextBtn;
    private JTextField resultField;
    private JFileChooser xmlFileChooser;
    private ReportDirChooser reportDirChooser;

    FilesPane(UIFactory uif, ActionListener nextListener) {
        this.uif = uif;
        this.listener = new Listener();
        this.setName("files");
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel title = uif.createLabel("files.title");
        GridBagConstraints lc = new GridBagConstraints();
        lc.gridwidth = 0;
        lc.weightx = 1.0;
        lc.fill = 2;
        lc.anchor = 17;
        lc.insets = new Insets(5, 5, 15, 5);
        this.add((Component)title, lc);
        JLabel wdLabel = uif.createLabel("files.resultLabel", true);
        lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.insets = new Insets(5, 5, 0, 5);
        this.add((Component)wdLabel, lc);
        this.resultField = uif.createInputField("files.result", wdLabel);
        this.resultField.addActionListener(this.listener);
        this.resultField.addKeyListener(this.listener);
        this.resultField.addFocusListener(this.listener);
        GridBagConstraints fc = new GridBagConstraints();
        fc.insets = new Insets(5, 0, 0, 5);
        fc.weightx = 1.0;
        fc.fill = 2;
        this.add((Component)this.resultField, fc);
        this.resultBtn = uif.createButton("files.result.browse", this.listener);
        GridBagConstraints bc = new GridBagConstraints();
        bc.insets = new Insets(5, 0, 0, 5);
        bc.gridwidth = 0;
        this.add((Component)this.resultBtn, bc);
        GridBagConstraints pan = new GridBagConstraints();
        pan.gridwidth = 0;
        pan.fill = 1;
        pan.insets = new Insets(10, 0, 5, 0);
        pan.weightx = 1.0;
        pan.weighty = 1.0;
        JScrollPane js = new JScrollPane();
        js.setBorder(uif.createTitledBorder("files.merged"));
        js.setName("files.in");
        js.setViewportView(new MergedSubPanel(uif));
        js.createVerticalScrollBar();
        js.getViewport().setName("files.inview");
        this.add((Component)js, pan);
        Dimension d = this.getPreferredSize();
        int dpi = uif.getDotsPerInch();
        this.setPreferredSize(new Dimension(Math.max(d.width, 5 * dpi), d.height));
        this.nextBtn = uif.createButton("files.next", e -> {
            if (this.checkInput()) {
                nextListener.actionPerformed(e);
            }
        });
        this.nextBtn.setEnabled(false);
        JButton cancelBtn = uif.createCancelButton("files.cancel");
        JButton helpBtn = uif.createHelpButton("files.help", "mergeReports.window.csh");
        this.buttons = new JButton[]{this.nextBtn, cancelBtn, helpBtn};
        JPanel buttonsPanel = uif.createPanel("files.but");
        GridBagConstraints co = new GridBagConstraints();
        co.anchor = 13;
        co.weightx = 1.0;
        co.gridwidth = 3;
        co.insets = new Insets(5, 0, 0, 0);
        this.add((Component)buttonsPanel, co);
        buttonsPanel.setLayout(new GridLayout(1, 3, 5, 5));
        for (JButton button : this.buttons) {
            buttonsPanel.add(button);
        }
    }

    static boolean isXMLReport(File f) {
        boolean bl;
        String schemaLocation = "xsi:noNamespaceSchemaLocation=\"Report.xsd\"";
        String formatVersion = "formatVersion=\"v1\"";
        if (!f.getName().endsWith(".xml")) {
            return false;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
        try {
            boolean hasVersion = false;
            String line = r.readLine();
            boolean hasSchema = FilesPane.hasLineContent(line, schemaLocation);
            hasVersion = FilesPane.hasLineContent(line, formatVersion);
            line = r.readLine();
            hasSchema = hasSchema || FilesPane.hasLineContent(line, schemaLocation);
            hasVersion = hasVersion || FilesPane.hasLineContent(line, formatVersion);
            bl = hasSchema && hasVersion;
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        r.close();
        return bl;
    }

    private static boolean hasLineContent(String line, String target) {
        if (line == null || target == null) {
            return false;
        }
        return line.contains(target);
    }

    boolean checkInput() {
        String[] merged;
        for (String aMerged : merged = this.getXmlFiles()) {
            if (FilesPane.isXMLReport(new File(aMerged))) continue;
            this.uif.showError("files.wrongfileformat", (Object)aMerged);
            return false;
        }
        if (this.getResultDir() != null && this.getResultDir().isEmpty()) {
            this.uif.showError("files.nooutfile");
            return false;
        }
        ArrayList<String> mergedList = new ArrayList<String>();
        for (int i = 0; i < merged.length; ++i) {
            merged[i] = merged[i].trim();
            if (merged[i] == null || merged[i].isEmpty()) continue;
            if (mergedList.contains(merged[i])) {
                this.uif.showError("files.duplicateinputfiles", (Object)merged[i]);
                return false;
            }
            mergedList.add(merged[i]);
        }
        if (mergedList.size() < 1) {
            this.uif.showError("files.noinputfiles");
            return false;
        }
        return true;
    }

    private void enableNext() {
        this.nextBtn.setEnabled(this.isNextEnabled());
    }

    private boolean isNextEnabled() {
        boolean resDirEnabled = true;
        this.resultField.setBackground(UIFactory.getDefaultInputColor());
        if (this.getResultDir() != null && this.getResultDir().isEmpty() && this.resultField.getText().trim() != null && this.resultField.getText().trim().isEmpty()) {
            if (!this.resultField.hasFocus()) {
                this.resultField.setBackground(UIFactory.getInvalidInputColor());
            }
            resDirEnabled = false;
        }
        boolean error = false;
        ArrayList<String> used = new ArrayList<String>();
        for (JTextField tField : this.merged) {
            String s = tField.getText().trim();
            tField.setBackground(UIFactory.getDefaultInputColor());
            if (s == null || s.isEmpty()) continue;
            if (!used.contains(s)) {
                used.add(s);
                if (!FilesPane.isXMLReport(new File(s))) {
                    error = true;
                    if (tField.hasFocus()) continue;
                    tField.setBackground(UIFactory.getInvalidInputColor());
                    continue;
                }
                tField.setBackground(UIFactory.getValidInputColor());
                continue;
            }
            error = true;
            tField.setBackground(UIFactory.getInvalidInputColor());
            this.merged.get(used.indexOf(s)).setBackground(UIFactory.getInvalidInputColor());
        }
        if (used.isEmpty()) {
            return false;
        }
        return !error && resDirEnabled;
    }

    private void chooseXmlReportFile(JTextField field) {
        String cfp;
        int action;
        File entered;
        if (this.xmlFileChooser == null) {
            this.xmlFileChooser = new JFileChooser();
            this.xmlFileChooser.setFileView(new XMLReportView());
            this.xmlFileChooser.setCurrentDirectory(null);
            this.xmlFileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || FilesPane.isXMLReport(f);
                }

                @Override
                public String getDescription() {
                    return FilesPane.this.uif.getI18NString("files.xmlFiles");
                }
            });
        }
        if (!field.getText().trim().isEmpty() && (entered = new File(field.getText())).exists()) {
            this.xmlFileChooser.setCurrentDirectory(entered);
        }
        if ((action = this.xmlFileChooser.showOpenDialog(null)) != 0) {
            return;
        }
        File cf = this.xmlFileChooser.getSelectedFile();
        if (cf == null) {
            cfp = "";
        } else {
            cfp = cf.getPath();
            if (!cfp.endsWith(".xml")) {
                cfp = cfp + ".xml";
            }
        }
        field.setText(cfp);
    }

    JButton[] getButtons() {
        return this.buttons;
    }

    private void showReportChooserDialog() {
        int option;
        if (this.reportDirChooser == null) {
            this.reportDirChooser = new ReportDirChooser();
        }
        this.reportDirChooser.setMode(0);
        File f = new File(this.getResultDir());
        if (f.exists() && f.isDirectory()) {
            this.reportDirChooser.setCurrentDirectory(f);
        }
        if ((option = this.reportDirChooser.showDialog(this.resultField)) != 0) {
            return;
        }
        this.resultField.setText(this.reportDirChooser.getSelectedFile().getAbsolutePath());
    }

    String getResultDir() {
        return this.resultField.getText();
    }

    String[] getXmlFiles() {
        int l = 0;
        for (JTextField aMerged1 : this.merged) {
            String s = aMerged1.getText().trim();
            if (s == null || s.isEmpty()) continue;
            ++l;
        }
        String[] result = new String[l];
        l = 0;
        for (JTextField aMerged : this.merged) {
            String s = aMerged.getText().trim();
            if (s == null || s.isEmpty()) continue;
            result[l++] = s;
        }
        return result;
    }

    private class Listener
    extends ComponentAdapter
    implements ActionListener,
    FocusListener,
    KeyListener {
        private Listener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == FilesPane.this.resultBtn) {
                FilesPane.this.showReportChooserDialog();
                FilesPane.this.enableNext();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            FilesPane.this.enableNext();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FilesPane.this.enableNext();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            FilesPane.this.enableNext();
        }
    }

    class MergedSubPanel
    extends JPanel {
        private List<JButton> mergedBtns;
        private JButton addMore;

        MergedSubPanel(UIFactory uif) {
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.setName("tool.merged");
            this.setLayout(new GridBagLayout());
            FilesPane.this.merged = new ArrayList();
            this.mergedBtns = new ArrayList<JButton>();
            this.addMore = uif.createButton("files.addmore", e -> this.addXmlToMerge());
            GridBagConstraints bc = new GridBagConstraints();
            bc.gridwidth = 0;
            bc.anchor = 11;
            bc.insets.top = 5;
            bc.gridx = 1;
            this.add((Component)this.addMore, bc);
            this.addXmlToMerge();
            this.addXmlToMerge();
        }

        private void addXmlToMerge() {
            int num = FilesPane.this.merged.size();
            GridBagConstraints fc = new GridBagConstraints();
            fc.fill = 1;
            fc.weightx = 1.0;
            fc.insets.top = 5;
            fc.insets.left = 5;
            GridBagConstraints bc = new GridBagConstraints();
            bc.gridwidth = 0;
            bc.insets.top = 5;
            bc.insets.left = 10;
            bc.insets.right = 5;
            bc.fill = 2;
            JTextField mergedField = FilesPane.this.uif.createInputField("files.input");
            FilesPane.this.uif.setAccessibleName(mergedField, "files.input");
            mergedField.addKeyListener(FilesPane.this.listener);
            mergedField.addFocusListener(FilesPane.this.listener);
            this.add((Component)mergedField, fc);
            JButton xmlBtn = FilesPane.this.uif.createButton("files.result.browse", e -> {
                Object src = e.getSource();
                for (int i = 0; i < this.mergedBtns.size(); ++i) {
                    if (src != this.mergedBtns.get(i)) continue;
                    FilesPane.this.chooseXmlReportFile((JTextField)FilesPane.this.merged.get(i));
                }
                FilesPane.this.enableNext();
            });
            xmlBtn.setMnemonic(49 + num);
            this.add((Component)xmlBtn, bc);
            FilesPane.this.merged.add(mergedField);
            this.mergedBtns.add(xmlBtn);
            this.remove(this.addMore);
            bc.anchor = 11;
            bc.gridy = num + 1;
            bc.gridx = 1;
            bc.weighty = 1.0;
            this.add((Component)this.addMore, bc);
            this.updateUI();
        }
    }

    private static class XMLReportView
    extends FileView {
        private Icon icon = IconFactory.getReportIcon();

        @Override
        public Icon getIcon(File f) {
            return FilesPane.isXMLReport(f) ? this.icon : null;
        }
    }
}

