/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFOS;
import com.sun.javatest.cof.COFSWEntity;
import com.sun.javatest.cof.Main;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class COFEnvironment
extends COFItem {
    static String[] propOrder = new String[]{"machine", "os", "jdk", "systemLocale", "userLocale", "encoding", "timezone", "bits", "displaydepth", "description", "sw"};
    static String[] propTags = new String[]{"machine", "os", "jdk", "system-locale", "user-locale", "encoding", "timezone", "bits", "displaydepth", "description", "sw"};
    static LinkedHashMap<String, String> xmlAttributes;
    static LinkedHashMap<String, String> xmlElements;
    static String xmlTagName;
    private static I18NResourceBundle i18n;
    protected Integer bits;
    protected String description;
    protected Integer displaydepth;
    protected String encoding;
    protected String id = "env:0";
    protected String jdk;
    protected String machine;
    protected COFOS os;
    protected List<COFSWEntity> sw;
    protected String systemLocale;
    protected String timezone;
    protected String userLocale;
    protected COFData data;
    private String domainName;
    private String hostName;

    COFEnvironment(COFData data) {
        this.data = data;
        this.initDefaultHostInfo();
        this.initDefaultOSInfo();
        this.hostName = data.get("environment.host", this.hostName);
        this.domainName = data.get("environment.domain", this.domainName);
        this.setMachine(data.get("environment.machine", this.hostName + "." + this.domainName));
        this.os.setName(data.get("environment.os.name", this.os.getName()));
        this.os.setVersion(data.get("environment.os.version", this.os.getVersion()));
        this.os.setArch(data.get("environment.os.arch", this.os.getArch()));
        this.setJdk(data.get("environment.jdk", this.jdk));
        this.setUserLocale(data.get("environment.user-locale", Locale.getDefault().toString()));
        this.setSystemLocale(data.get("environment.system-locale", data.get("LOCALE")));
        this.setEncoding(data.get("environment.encoding", new InputStreamReader(System.in).getEncoding()));
        this.setTimezone(data.get("environment.timezone", TimeZone.getDefault().getID()));
        this.setBits(data.get("environment.bits", null) == null ? null : Integer.valueOf(data.get("environment.bits")));
        this.setDisplaydepth(data.get("environment.displaydepth", null) == null ? null : Integer.valueOf(data.get("environment.displaydepth")));
        this.setDescription(data.get("environment.description"));
    }

    public COFEnvironment(COFData data, String id) {
        this(data);
        this.id = id;
    }

    public Integer getBits() {
        return this.bits;
    }

    public void setBits(Integer value) {
        this.bits = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCalderaLinuxVersionInfo() {
        String res = "N/A";
        RandomAccessFile raf = null;
        try {
            String line;
            raf = new RandomAccessFile("/etc/issue", "r");
            while ((line = raf.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " ");
                if (st.countTokens() < 2 || !st.nextToken().toUpperCase().equals("VERSION")) continue;
                res = st.nextToken();
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public Integer getDisplaydepth() {
        return this.displaydepth;
    }

    public void setDisplaydepth(Integer value) {
        this.displaydepth = value;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGenericLinuxVersionInfo(String fileName) {
        String res = "N/A";
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(fileName, "r");
            StringTokenizer st = new StringTokenizer(raf.readLine(), " ");
            while (st.hasMoreElements()) {
                String ele = st.nextToken();
                if (!Character.isDigit(ele.charAt(0))) continue;
                res = ele;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    LinkedHashMap<String, String> getItemAttributes() {
        return xmlAttributes;
    }

    @Override
    LinkedHashMap<String, String> getItemElements() {
        return xmlElements;
    }

    @Override
    String getItemTagName() {
        return xmlTagName;
    }

    public String getJdk() {
        return this.jdk;
    }

    public void setJdk(String value) {
        this.jdk = value;
    }

    public String getMachine() {
        return this.machine;
    }

    public void setMachine(String value) {
        if (value.endsWith(".unknown")) {
            try {
                this.machine = InetAddress.getLocalHost().getCanonicalHostName();
                if (!this.machine.contains(".")) {
                    if ("false".equals(this.data.get("showWarnings"))) {
                        System.err.println(i18n.getString("environment.badMachineName", (Object)this.machine));
                    } else {
                        String warningMessage = this.data.get("warning", "");
                        this.data.put("warning", warningMessage + i18n.getString("environment.badMachineName") + "\n");
                    }
                }
                return;
            }
            catch (UnknownHostException e) {
                if ("false".equals(this.data.get("showWarnings"))) {
                    System.err.println(i18n.getString("environment.cantGetLocalhostName", (Object)e.getMessage()));
                    value = value.substring(0, value.indexOf(".unknown") - 1);
                    System.err.println(i18n.getString("environment.badMachineName", (Object)value));
                }
                String warningMessage = this.data.get("warning", "");
                value = value.substring(0, value.indexOf(".unknown") - 1);
                this.data.put("warning", warningMessage + i18n.getString("environment.cantGetLocalhostName", (Object)e.getMessage()) + "\n" + i18n.getString("environment.badMachineName", (Object)value) + "\n");
            }
        }
        this.machine = value;
    }

    public COFOS getOs() {
        return this.os;
    }

    public void setOs(COFOS value) {
        this.os = value;
    }

    String[] getPropOrder() {
        return propOrder;
    }

    public List<COFSWEntity> getSw() {
        if (this.sw == null) {
            this.sw = new ArrayList<COFSWEntity>();
        }
        return this.sw;
    }

    public String getSystemLocale() {
        return this.systemLocale;
    }

    public void setSystemLocale(String value) {
        this.systemLocale = value;
    }

    String getTagName() {
        return this.itemTagName;
    }

    String[] getTags() {
        return propTags;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String value) {
        this.timezone = value;
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(String value) {
        this.userLocale = value;
    }

    private void initDefaultHostInfo() {
        this.domainName = "unknown";
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "unknown";
        }
    }

    private void initDefaultOSInfo() {
        this.os = new COFOS();
        this.os.setName(System.getProperty("os.name"));
        this.os.setVersion(System.getProperty("os.version"));
        this.os.setArch(System.getProperty("os.arch"));
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(Main.class);
        xmlElements = new LinkedHashMap();
        for (int i = 0; i < propOrder.length; ++i) {
            xmlElements.put(propOrder[i], propTags[i]);
        }
        xmlAttributes = new LinkedHashMap();
        xmlAttributes.put("id", "id");
        xmlTagName = "environment";
    }
}

