/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.audit.AuditPane;
import com.sun.javatest.tool.UIFactory;
import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;

abstract class ListPane
extends AuditPane {
    protected JList<Object> list;
    private ListModel model = new ListModel();

    ListPane(String uiKey, UIFactory uif) {
        super(uiKey, uif);
        this.list = uif.createList(uiKey + ".lst", this.model);
        this.list.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.list.setCellRenderer(new Renderer());
        JScrollPane sp = uif.createScrollPane(this.list, 20, 31);
        this.setBody(sp);
    }

    void setData(Object ... data) {
        if (data == null || data.length == 0) {
            this.show(this.uif.getI18NString("list.noEntries"));
        } else {
            this.model.setData(data);
            this.showBody();
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
            String name;
            if (o instanceof TestResult) {
                TestResult tr = (TestResult)o;
                name = tr.getTestName();
            } else if (o instanceof TestDescription) {
                TestDescription td = (TestDescription)o;
                name = td.getRootRelativeURL();
            } else {
                name = String.valueOf(o);
            }
            return super.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
        }
    }

    private static class ListModel
    extends AbstractListModel<Object> {
        private Object[] data;

        private ListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return this.data[index];
        }

        @Override
        public int getSize() {
            return this.data == null ? 0 : this.data.length;
        }

        void setData(Object ... data) {
            this.data = data;
            this.fireContentsChanged(this, 0, data.length - 1);
        }
    }
}

