/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.Help;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.javatest.tool.jthelp.HelpID;
import com.sun.javatest.tool.jthelp.HelpSet;
import com.sun.javatest.tool.jthelp.JHelpContentViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class InfoPanel
extends JComponent {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static final int PREFERRED_WIDTH = 4;
    private static final int PREFERRED_HEIGHT = 3;
    private Interview interview;
    private HelpSet infoHelpSet;
    private JHelpContentViewer viewer;
    private Listener listener = new Listener();

    public InfoPanel(Interview interview) {
        this.interview = interview;
        this.infoHelpSet = Help.getHelpSet(interview);
        this.viewer = new JHelpContentViewer(this.infoHelpSet);
        this.viewer.setName("help");
        this.viewer.setToolTipText(i18n.getString("info.tip"));
        AccessibleContext v_ac = this.viewer.getAccessibleContext();
        v_ac.setAccessibleName(i18n.getString("info.name"));
        v_ac.setAccessibleDescription(this.viewer.getToolTipText());
        this.setName("info");
        this.setLayout(new BorderLayout());
        this.addAncestorListener(new Listener());
        this.add((Component)this.viewer, "Center");
    }

    public HelpSet getHelpSet() {
        return this.infoHelpSet;
    }

    public void setCurrentID(Question q) {
        HelpID helpId = Help.getHelpID(q);
        if (helpId == null) {
            System.err.println("WARNING: no help for " + q.getKey());
        } else {
            this.viewer.setCurrentID(helpId);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return new Dimension(4 * tk.getScreenResolution(), 3 * tk.getScreenResolution());
    }

    private class Listener
    implements AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            InfoPanel.this.interview.addObserver(this);
            this.currentQuestionChanged(InfoPanel.this.interview.getCurrentQuestion());
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
            InfoPanel.this.interview.removeObserver(this);
        }

        @Override
        public void pathUpdated() {
        }

        @Override
        public void currentQuestionChanged(Question q) {
            if (!(q instanceof ErrorQuestion)) {
                InfoPanel.this.setCurrentID(q);
            }
        }
    }
}

