/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.outline;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceElement;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.IContentAdapterProvider;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.handly.ui.IInputElementProvider;
import org.eclipse.handly.ui.outline.ICommonOutlinePage;
import org.eclipse.handly.ui.outline.OutlineLinkingHelper;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SourceElementLinkingHelper
extends OutlineLinkingHelper {
    protected final IInputElementProvider inputElementProvider;
    private LinkToOutlineJob linkToOutlineJob = new LinkToOutlineJob();

    public SourceElementLinkingHelper(ICommonOutlinePage outlinePage, IInputElementProvider inputElementProvider) {
        super(outlinePage);
        this.inputElementProvider = inputElementProvider;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cancelLinkToOutlineJob();
    }

    @Override
    protected final void linkToOutline(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        this.scheduleLinkToOutlineJob(selection);
    }

    @Override
    protected void linkToEditor(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IEditorPart editor = this.getTargetEditor();
        if (editor instanceof ITextEditor) {
            this.linkToEditor((ITextEditor)editor, (IStructuredSelection)selection);
        } else if (editor != null) {
            editor.getSite().getSelectionProvider().setSelection(selection);
        }
    }

    protected void linkToEditor(ITextEditor editor, IStructuredSelection selection) {
        IElement element = this.getContentAdapter().adapt(selection.getFirstElement());
        if (!(element instanceof ISourceElement)) {
            return;
        }
        ISourceElement sourceElement = (ISourceElement)element;
        if (!this.isInEditor((IElement)sourceElement, (IEditorPart)editor)) {
            return;
        }
        TextRange identifyingRange = Elements.getSourceElementInfo2((ISourceElement)sourceElement).getIdentifyingRange();
        if (identifyingRange == null) {
            return;
        }
        editor.selectAndReveal(identifyingRange.getOffset(), identifyingRange.getLength());
    }

    protected IStructuredSelection getLinkedSelection(ISelection selection, IProgressMonitor monitor) {
        if (selection instanceof ITextSelection) {
            return this.getLinkedSelection((ITextSelection)selection, monitor);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    protected IStructuredSelection getLinkedSelection(ITextSelection selection, IProgressMonitor monitor) {
        IElement input = this.getContentAdapter().adapt(this.getOutlinePage().getTreeViewer().getInput());
        if (!(input instanceof ISourceElement)) {
            return null;
        }
        ISourceElement sourceElement = (ISourceElement)input;
        if (!Elements.ensureReconciled((ISourceElement)sourceElement, (IProgressMonitor)monitor)) {
            return null;
        }
        Object element = this.getContentAdapter().getCorrespondingElement((IElement)Elements.getSourceElementAt2((ISourceElement)sourceElement, (int)selection.getOffset(), null));
        if (element == null) {
            return null;
        }
        return new StructuredSelection(element);
    }

    protected IEditorPart getTargetEditor() {
        IEditorPart editor = this.getOutlinePage().getEditor();
        while (editor instanceof IPageChangeProvider) {
            Object page = ((IPageChangeProvider)editor).getSelectedPage();
            if (!(page instanceof IEditorPart)) break;
            editor = (IEditorPart)page;
        }
        return editor;
    }

    protected boolean isInEditor(IElement element, IEditorPart editor) {
        IElement inputElement = this.inputElementProvider.getElement(editor.getEditorInput());
        return inputElement != null && Elements.isAncestorOf((IElement)inputElement, (IElement)element);
    }

    protected IContentAdapter getContentAdapter() {
        ICommonOutlinePage outlinePage = this.getOutlinePage();
        if (outlinePage instanceof IContentAdapterProvider) {
            return ((IContentAdapterProvider)outlinePage).getContentAdapter();
        }
        return NullContentAdapter.INSTANCE;
    }

    private void cancelLinkToOutlineJob() {
        this.linkToOutlineJob.cancel();
        this.linkToOutlineJob.setArgs(null);
    }

    private void scheduleLinkToOutlineJob(ISelection selection) {
        this.linkToOutlineJob.cancel();
        this.linkToOutlineJob.setArgs(new LinkToOutlineArgs(selection, this.isLinkingEnabled()));
        this.linkToOutlineJob.schedule();
    }

    private static class LinkToOutlineArgs {
        final ISelection selection;
        final boolean isLinkingEnabled;

        LinkToOutlineArgs(ISelection selection, boolean isLinkingEnabled) {
            this.selection = selection;
            this.isLinkingEnabled = isLinkingEnabled;
        }
    }

    private class LinkToOutlineJob
    extends Job {
        private volatile LinkToOutlineArgs args;

        public LinkToOutlineJob() {
            super(LinkToOutlineJob.class.getName());
            this.setSystem(true);
        }

        public void setArgs(LinkToOutlineArgs args) {
            this.args = args;
        }

        public boolean belongsTo(Object family) {
            return LinkToOutlineJob.class.getName().equals(family);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LinkToOutlineArgs args = this.args;
            if (args == null) {
                return Status.OK_STATUS;
            }
            final ISelection baseSelection = args.selection;
            if (baseSelection == null || baseSelection.isEmpty()) {
                return Status.OK_STATUS;
            }
            IElement input = SourceElementLinkingHelper.this.getContentAdapter().adapt(SourceElementLinkingHelper.this.getOutlinePage().getTreeViewer().getInput());
            if (!(input instanceof ISourceElement)) {
                return Status.OK_STATUS;
            }
            final IStructuredSelection linkedSelection = SourceElementLinkingHelper.this.getLinkedSelection(baseSelection, monitor);
            if (linkedSelection == null) {
                return Status.OK_STATUS;
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LinkToOutlineArgs args = LinkToOutlineJob.this.args;
                    if (args == null) {
                        return;
                    }
                    Control control = SourceElementLinkingHelper.this.getOutlinePage().getControl();
                    TreeViewer treeViewer = SourceElementLinkingHelper.this.getOutlinePage().getTreeViewer();
                    IEditorPart editor = SourceElementLinkingHelper.this.getOutlinePage().getEditor();
                    if (control == null || control.isDisposed() || !baseSelection.equals(args.selection) || !baseSelection.equals(editor.getSite().getSelectionProvider().getSelection())) {
                        return;
                    }
                    IStructuredSelection currentSelection = (IStructuredSelection)treeViewer.getSelection();
                    if (currentSelection == null || !currentSelection.toList().containsAll(linkedSelection.toList())) {
                        boolean isLinkingEnabled = SourceElementLinkingHelper.this.isLinkingEnabled();
                        try {
                            SourceElementLinkingHelper.this.setLinkingEnabled(args.isLinkingEnabled);
                            treeViewer.setSelection((ISelection)linkedSelection, true);
                        }
                        finally {
                            SourceElementLinkingHelper.this.setLinkingEnabled(isLinkingEnabled);
                        }
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

