/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.model.impl.IElementImplExtension;
import org.eclipse.handly.model.impl.support.IBodyCache;
import org.eclipse.handly.model.impl.support.IElementImplSupport;
import org.eclipse.handly.model.impl.support.ISourceFileImplSupport;
import org.eclipse.handly.model.impl.support.WorkingCopyInfo;

public class ElementManager {
    private static final ISourceFile[] NO_WORKING_COPIES = new ISourceFile[0];
    protected final IBodyCache cache;
    private ThreadLocal<TemporaryCache> temporaryCache = new ThreadLocal();
    private Map<ISourceFileImplSupport, WorkingCopyInfo> workingCopyInfos = new HashMap<ISourceFileImplSupport, WorkingCopyInfo>();

    public ElementManager(IBodyCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        this.cache = cache;
    }

    public final synchronized ISourceFile[] getWorkingCopies() {
        return this.workingCopyInfos.keySet().toArray(NO_WORKING_COPIES);
    }

    protected void close(IElement element, IContext context) {
        ((IElementImplExtension)element).close_(context);
    }

    synchronized Object get(IElementImplSupport element) {
        Object body;
        TemporaryCache tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(element)) != null) {
            return body;
        }
        return this.cache.get(element);
    }

    synchronized Object peek(IElementImplSupport element) {
        Object body;
        TemporaryCache tempCache = this.temporaryCache.get();
        if (tempCache != null && (body = tempCache.get(element)) != null) {
            return body;
        }
        return this.cache.peek(element);
    }

    synchronized void put(IElementImplSupport element, Map<IElement, Object> newElements) {
        WorkingCopyInfo info;
        Object body = this.cache.peek(element);
        if (body != null) {
            IElement[] iElementArray = element.getChildrenFromBody_(body);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.close(child, Contexts.of(IElementImplExtension.CLOSE_HINT, IElementImplExtension.CloseHint.PARENT_CLOSING));
                ++n2;
            }
        }
        this.cache.putAll(newElements);
        if (element instanceof ISourceFileImplSupport && (info = this.workingCopyInfos.get(element)) != null && !info.created) {
            info.created = true;
        }
    }

    synchronized Object putIfAbsent(IElementImplSupport element, Map<IElement, Object> newElements) {
        Object existingBody = this.cache.peek(element);
        if (existingBody != null) {
            return existingBody;
        }
        this.cache.putAll(newElements);
        return null;
    }

    synchronized void remove(IElementImplSupport element) {
        Object body = this.cache.peek(element);
        if (body != null) {
            element.removing_(body);
            IElement[] iElementArray = element.getChildrenFromBody_(body);
            int n = iElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IElement child = iElementArray[n2];
                this.close(child, Contexts.of(IElementImplExtension.CLOSE_HINT, IElementImplExtension.CloseHint.PARENT_CLOSING));
                ++n2;
            }
            this.cache.remove(element);
        }
    }

    void pushTemporaryCache(Map<IElement, Object> newElements) {
        TemporaryCache parent = this.temporaryCache.get();
        this.temporaryCache.set(new TemporaryCache(parent, newElements));
    }

    void popTemporaryCache() {
        TemporaryCache tempCache = this.temporaryCache.get();
        if (tempCache == null) {
            throw new IllegalStateException();
        }
        this.temporaryCache.set(tempCache.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkingCopyInfo putWorkingCopyInfoIfAbsent(ISourceFileImplSupport sourceFile, WorkingCopyInfo info) {
        if (sourceFile == null) {
            throw new IllegalArgumentException();
        }
        if (info == null) {
            throw new IllegalArgumentException();
        }
        IBuffer buffer = info.getBuffer();
        buffer.addRef();
        boolean releaseBuffer = true;
        try {
            ElementManager elementManager = this;
            synchronized (elementManager) {
                WorkingCopyInfo oldInfo = this.workingCopyInfos.get(sourceFile);
                if (oldInfo != null) {
                    ++oldInfo.refCount;
                } else {
                    if (info.refCount != 0) {
                        throw new IllegalArgumentException();
                    }
                    this.workingCopyInfos.put(sourceFile, info);
                    info.refCount = 1;
                    releaseBuffer = false;
                }
                WorkingCopyInfo workingCopyInfo = oldInfo;
                return workingCopyInfo;
            }
        }
        finally {
            if (releaseBuffer) {
                buffer.release();
            }
        }
    }

    synchronized WorkingCopyInfo getWorkingCopyInfo(ISourceFileImplSupport sourceFile) {
        WorkingCopyInfo info = this.workingCopyInfos.get(sourceFile);
        if (info != null) {
            ++info.refCount;
        }
        return info;
    }

    synchronized WorkingCopyInfo peekAtWorkingCopyInfo(ISourceFileImplSupport sourceFile) {
        return this.workingCopyInfos.get(sourceFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkingCopyInfo releaseWorkingCopyInfo(ISourceFileImplSupport sourceFile) {
        WorkingCopyInfo infoToDispose = null;
        try {
            ElementManager elementManager = this;
            synchronized (elementManager) {
                WorkingCopyInfo info = this.workingCopyInfos.get(sourceFile);
                if (info != null && --info.refCount == 0) {
                    infoToDispose = info;
                    this.workingCopyInfos.remove(sourceFile);
                    sourceFile.remove_(Contexts.EMPTY_CONTEXT);
                }
                WorkingCopyInfo workingCopyInfo = info;
                return workingCopyInfo;
            }
        }
        finally {
            if (infoToDispose != null) {
                IBuffer buffer = infoToDispose.getBuffer();
                try {
                    infoToDispose.dispose();
                }
                finally {
                    buffer.release();
                }
            }
        }
    }

    private static class TemporaryCache {
        final TemporaryCache parent;
        private final Map<IElement, Object> newElements;

        TemporaryCache(TemporaryCache parent, Map<IElement, Object> newElements) {
            this.parent = parent;
            this.newElements = newElements;
            if (this.newElements == null) {
                throw new IllegalArgumentException();
            }
        }

        Object get(IElement element) {
            Object body = this.newElements.get(element);
            if (body == null && this.parent != null) {
                body = this.parent.get(element);
            }
            return body;
        }
    }
}

