/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementChangeEvent;
import org.eclipse.handly.model.IElementChangeListener;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.adapter.IContentAdapter;
import org.eclipse.handly.model.adapter.NullContentAdapter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public abstract class AbstractWorkingSetUpdater
implements IWorkingSetUpdater {
    private final List<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();
    private final IElementChangeListener listener = new IElementChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(IElementChangeEvent event) {
            IWorkingSet[] workingSetsCopy;
            List list = AbstractWorkingSetUpdater.this.workingSets;
            synchronized (list) {
                workingSetsCopy = AbstractWorkingSetUpdater.this.workingSets.toArray(new IWorkingSet[AbstractWorkingSetUpdater.this.workingSets.size()]);
            }
            IWorkingSet[] iWorkingSetArray = workingSetsCopy;
            int n = workingSetsCopy.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSet);
                IElementDelta[] iElementDeltaArray = event.getDeltas();
                int n3 = iElementDeltaArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IElementDelta delta = iElementDeltaArray[n4];
                    AbstractWorkingSetUpdater.this.processElementDelta(delta, workingSetDelta);
                    ++n4;
                }
                workingSetDelta.apply();
                ++n2;
            }
        }
    };

    public AbstractWorkingSetUpdater() {
        this.addElementChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            this.workingSets.clear();
        }
        this.removeElementChangeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        this.checkElementExistence(workingSet);
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            this.workingSets.add(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            result = this.workingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List<IWorkingSet> list = this.workingSets;
        synchronized (list) {
            return this.workingSets.contains(workingSet);
        }
    }

    protected abstract void addElementChangeListener(IElementChangeListener var1);

    protected abstract void removeElementChangeListener(IElementChangeListener var1);

    protected IContentAdapter getContentAdapter() {
        return NullContentAdapter.INSTANCE;
    }

    protected void processElementDelta(IElementDelta delta, WorkingSetDelta result) {
        IElementDelta[] children;
        int n;
        IResourceDelta[] resourceDeltas;
        IElement element = ElementDeltas.getElement((IElementDelta)delta);
        IAdaptable wsElement = (IAdaptable)this.getContentAdapter().getCorrespondingElement(element);
        int index = result.indexOf(wsElement);
        int kind = ElementDeltas.getKind((IElementDelta)delta);
        long flags = ElementDeltas.getFlags((IElementDelta)delta);
        if (kind == 4 && (flags & 0x40L) != 0L) {
            IResource project = Elements.getResource((IElement)element);
            if (index != -1) {
                result.set(index, (IAdaptable)project);
            } else {
                index = result.indexOf(project);
                if (index != -1) {
                    result.set(index, wsElement);
                }
            }
        }
        if (index != -1 && kind == 2) {
            if ((flags & 8L) != 0L) {
                IAdaptable wsMovedToElement = (IAdaptable)this.getContentAdapter().getCorrespondingElement(ElementDeltas.getMovedToElement((IElementDelta)delta));
                result.set(index, wsMovedToElement);
            } else {
                result.remove(index);
            }
        }
        if ((resourceDeltas = ElementDeltas.getResourceDeltas((IElementDelta)delta)) != null) {
            IResourceDelta[] iResourceDeltaArray = resourceDeltas;
            n = resourceDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                this.processResourceDelta(resourceDelta, result);
                ++n2;
            }
        }
        IElementDelta[] iElementDeltaArray = children = ElementDeltas.getAffectedChildren((IElementDelta)delta);
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            IElementDelta child = iElementDeltaArray[n];
            this.processElementDelta(child, result);
            ++n;
        }
    }

    protected void processResourceDelta(IResourceDelta delta, WorkingSetDelta result) {
        IResourceDelta[] children;
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, (IAdaptable)resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        if (type == 4 && kind == 4 && (flags & 0x4000) != 0) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.processResourceDelta(child, result);
            ++n2;
        }
    }

    protected void checkElementExistence(IWorkingSet workingSet) {
        ArrayList<IAdaptable> wsElements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        boolean changed = false;
        Iterator iter = wsElements.iterator();
        while (iter.hasNext()) {
            IAdaptable wsElement = (IAdaptable)iter.next();
            boolean remove = false;
            if (wsElement instanceof IResource) {
                IResource resource = (IResource)wsElement;
                remove = !AbstractWorkingSetUpdater.isInClosedProject(resource) && !resource.exists();
            } else {
                IElement element = this.getContentAdapter().adapt((Object)wsElement);
                if (element != null) {
                    IResource resource = Elements.getResource((IElement)element);
                    boolean bl = remove = !AbstractWorkingSetUpdater.isInClosedProject(resource) && !Elements.exists((IElement)element);
                }
            }
            if (!remove) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            workingSet.setElements(wsElements.toArray(new IAdaptable[wsElements.size()]));
        }
    }

    private static boolean isInClosedProject(IResource resource) {
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        return project.exists() && !project.isOpen();
    }

    protected static class WorkingSetDelta {
        private IWorkingSet workingSet;
        private List<IAdaptable> elements;
        private boolean changed;

        WorkingSetDelta(IWorkingSet workingSet) {
            this.workingSet = workingSet;
            this.elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.elements.indexOf(element);
        }

        public void set(int index, IAdaptable element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            this.elements.set(index, element);
            this.changed = true;
        }

        public void remove(int index) {
            if (this.elements.remove(index) != null) {
                this.changed = true;
            }
        }

        void apply() {
            if (this.changed) {
                this.workingSet.setElements(this.elements.toArray(new IAdaptable[this.elements.size()]));
            }
        }
    }
}

