/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.internal.Activator;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.text.edits.MalformedTreeException;

public class Buffer
implements IBuffer {
    private final IDocument document = this.createEmptyDocument();
    private volatile long synchronizationStamp;

    public Buffer() {
        this(null);
    }

    public Buffer(String contents) {
        this.initWithContents(contents);
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    @Override
    public ISnapshot getSnapshot() {
        return new DocumentSnapshot(this.document);
    }

    @Override
    public IBufferChange applyChange(IBufferChange change, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BufferChangeOperation operation = new BufferChangeOperation(this, change);
            return operation.execute(monitor);
        }
        catch (MalformedTreeException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
        catch (BadLocationException e) {
            throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(IContext context, IProgressMonitor monitor) throws CoreException {
        Object lock = ((ISynchronizable)this.document).getLockObject();
        if (lock == null) {
            throw new IllegalStateException();
        }
        Object object = lock;
        synchronized (object) {
            if (!this.isDirty()) {
                return;
            }
            this.doSave(context, monitor);
            this.synchronizationStamp = ((IDocumentExtension4)this.document).getModificationStamp();
        }
    }

    @Override
    public boolean isDirty() {
        return ((IDocumentExtension4)this.document).getModificationStamp() != this.synchronizationStamp;
    }

    @Override
    public void addRef() {
    }

    @Override
    public void release() {
    }

    protected IDocument createEmptyDocument() {
        IDocument document = ITextFileBufferManager.DEFAULT.createEmptyDocument(null, LocationKind.NORMALIZE);
        ((ISynchronizable)document).setLockObject(new Object());
        return document;
    }

    protected void doSave(IContext context, IProgressMonitor monitor) throws CoreException {
    }

    final void initWithContents(String contents) {
        if (contents != null && !contents.isEmpty()) {
            this.document.set(contents);
        }
        this.synchronizationStamp = ((IDocumentExtension4)this.document).getModificationStamp();
    }
}

