/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.xtext.ui.callhierarchy;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.handly.snapshot.Snapshot;
import org.eclipse.handly.ui.callhierarchy.CallTextInfo;
import org.eclipse.handly.util.TextRange;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.ReferenceAcceptor;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class XtextCallHierarchyUtility {
    protected IReferenceFinder.IResourceAccess resourceAccess;
    protected IResourceDescriptions indexData;
    @Inject
    protected IReferenceFinder referenceFinder;
    @Inject
    protected Provider<TargetURIs> targetUrisProvider;
    @Inject
    protected IResourceServiceProvider.Registry resourceServiceProviderRegistry;
    @Inject
    protected ILocationInFileProvider locationInFileProvider;

    protected XtextCallHierarchyUtility() {
    }

    public void setResourceAccess(IReferenceFinder.IResourceAccess resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    public void setIndexData(IResourceDescriptions indexData) {
        this.indexData = indexData;
    }

    public void findCallerReferences(URI calleeUri, Consumer<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        if (calleeUri == null) {
            throw new IllegalArgumentException();
        }
        if (acceptor == null) {
            throw new IllegalArgumentException();
        }
        TargetURIs targetUris = (TargetURIs)this.targetUrisProvider.get();
        targetUris.addURI(calleeUri);
        this.referenceFinder.findAllReferences(targetUris, this.resourceAccess, this.indexData, (IReferenceFinder.Acceptor)this.getReferenceAcceptor(acceptor), monitor);
    }

    public void findCalleeReferences(URI callerUri, Consumer<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        if (callerUri == null) {
            throw new IllegalArgumentException();
        }
        if (acceptor == null) {
            throw new IllegalArgumentException();
        }
        this.readOnly(callerUri, caller -> {
            this.referenceFinder.findAllReferences(caller, (IReferenceFinder.Acceptor)this.getReferenceAcceptor(acceptor), monitor);
            return null;
        });
    }

    public CallTextInfo getCallTextInfo(IReferenceDescription callReference) {
        if (callReference == null) {
            throw new IllegalArgumentException();
        }
        CallTextInfo info = (CallTextInfo)this.readOnly(callReference.getSourceEObjectUri(), sourceObject -> {
            String callText = "";
            TextRange callRange = null;
            int lineNumber = -1;
            Snapshot snapshot = null;
            ITextRegion callRegion = this.getCallRegion((EObject)sourceObject, callReference.getEReference(), callReference.getIndexInList());
            if (callRegion != null && callRegion != ITextRegion.EMPTY_REGION) {
                callRange = new TextRange(callRegion.getOffset(), callRegion.getLength());
                ICompositeNode node = NodeModelUtils.getNode((EObject)sourceObject);
                if (node != null) {
                    final String text = node.getRootNode().getText();
                    callText = text.substring(callRange.getOffset(), callRange.getEndOffset());
                    lineNumber = NodeModelUtils.getLineAndColumn((INode)node, (int)callRange.getOffset()).getLine() - 1;
                    snapshot = new Snapshot(){

                        public String getContents() {
                            return text;
                        }
                    };
                }
            }
            return new CallTextInfo(callText, callRange, lineNumber, snapshot);
        });
        if (info == null) {
            info = new CallTextInfo("", null, -1, null);
        }
        return info;
    }

    protected boolean isCallReference(IReferenceDescription reference) {
        return reference != null;
    }

    protected ITextRegion getCallRegion(EObject owner, EReference callReference, int indexInList) {
        return this.locationInFileProvider.getSignificantTextRegion(owner, (EStructuralFeature)callReference, indexInList);
    }

    protected <R> R readOnly(URI objectUri, IUnitOfWork<R, EObject> work) {
        return (R)this.resourceAccess.readOnly(objectUri, resourceSet -> {
            EObject object = resourceSet.getEObject(objectUri, true);
            if (object == null) {
                return null;
            }
            return work.exec((Object)object);
        });
    }

    private ReferenceAcceptor getReferenceAcceptor(Consumer<IReferenceDescription> acceptor) {
        return new ReferenceAcceptor(this.resourceServiceProviderRegistry, reference -> {
            if (this.isCallReference((IReferenceDescription)reference)) {
                acceptor.accept((IReferenceDescription)reference);
            }
        });
    }
}

