/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.glsp.ide.editor.DiagramWebsocketEndpoint;
import org.eclipse.glsp.ide.editor.internal.utils.SystemUtils;
import org.eclipse.glsp.server.di.ServerModule;
import org.eclipse.glsp.server.utils.LaunchUtil;
import org.eclipse.glsp.server.websocket.GLSPConfigurator;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.AliasCheck;
import org.eclipse.jetty.server.AllowedResourceAliasChecker;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;

public abstract class GLSPServerManager {
    protected Server server;
    protected ServerContainer container;
    protected Injector injector;
    protected int localPort;

    public synchronized void start() throws Exception {
        if (this.server == null || !this.server.isRunning()) {
            this.server = new Server(new InetSocketAddress("localhost", 0));
            this.configure(this.server);
            this.server.start();
            this.localPort = Arrays.stream(this.server.getConnectors()).findFirst().map(ServerConnector.class::cast).map(ServerConnector::getLocalPort).orElse(-1);
        }
    }

    public abstract String getGlspId();

    public abstract URL getResourceURL();

    protected void preConfigure() {
    }

    protected void configure(Server server) throws URISyntaxException, IOException, ServletException, DeploymentException {
        this.preConfigure();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        server.setHandler((Handler)context);
        ServletHolder defaultServletHolder = new ServletHolder("default", (Servlet)new DefaultServlet());
        String resourceBase = this.resolveResourceBase();
        if (SystemUtils.isWindows()) {
            Resource resource = new PathResourceFactory().newResource(resourceBase);
            context.addAliasCheck((AliasCheck)new AllowedResourceAliasChecker((ContextHandler)context, resource));
        }
        defaultServletHolder.setInitParameter("resourceBase", resourceBase);
        defaultServletHolder.setInitParameter("dirAllowed", "false");
        context.addServlet(defaultServletHolder, "/");
        JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)context, (servletContext, wsContainer) -> {
            this.container = wsContainer;
            ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(DiagramWebsocketEndpoint.class, (String)("/" + this.getGlspId()));
            Injector injector = this.createInjector();
            builder.configurator((ServerEndpointConfig.Configurator)new GLSPConfigurator(() -> injector));
            wsContainer.addEndpoint(builder.build());
            wsContainer.setDefaultMaxSessionIdleTimeout(-1L);
        });
    }

    protected abstract ServerModule configureServerModule();

    protected List<Module> configureAdditionalModules() {
        return Collections.emptyList();
    }

    protected Injector createInjector() {
        ArrayList<ServerModule> modules = new ArrayList<ServerModule>();
        modules.add(this.configureServerModule());
        this.configureAdditionalModules().forEach(modules::add);
        return Guice.createInjector(modules);
    }

    protected String resolveResourceBase() throws IOException {
        String resourceBase = FileLocator.resolve((URL)this.getResourceURL()).getFile();
        if (SystemUtils.isWindows() && resourceBase.startsWith("/")) {
            resourceBase = resourceBase.substring(1);
        }
        return resourceBase;
    }

    public synchronized void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Server getServer() {
        return this.server;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public static void configureLogger(Level level) {
        LaunchUtil.configureLogger((boolean)true, (Level)level);
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        RootLoggerComponentBuilder rootLogger = builder.newRootLogger(level);
        LayoutComponentBuilder patternLayout = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d{DEFAULT_NANOS} [%t] %-5level %logger{1} - %msg%n");
        AppenderComponentBuilder consoleAppender = ((AppenderComponentBuilder)builder.newAppender("ConsoleLogger", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT)).add(patternLayout);
        builder.add(consoleAppender);
        rootLogger.add(builder.newAppenderRef("ConsoleLogger"));
        builder.add(rootLogger);
        Configurator.reconfigure((Configuration)((Configuration)builder.build()));
    }
}

