/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class StepExecutedEventArguments {
  /**
   * The name of the engine
   */
  private ExecutionEngineDto engine;

  /**
   * step executed
   */
  private StepDto stepToExecute;

  /**
   * The name of the engine
   */
  @Pure
  public ExecutionEngineDto getEngine() {
    return this.engine;
  }

  /**
   * The name of the engine
   */
  public void setEngine(final ExecutionEngineDto engine) {
    this.engine = engine;
  }

  /**
   * step executed
   */
  @Pure
  public StepDto getStepToExecute() {
    return this.stepToExecute;
  }

  /**
   * step executed
   */
  public void setStepToExecute(final StepDto stepToExecute) {
    this.stepToExecute = stepToExecute;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("engine", this.engine);
    b.add("stepToExecute", this.stepToExecute);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    StepExecutedEventArguments other = (StepExecutedEventArguments) obj;
    if (this.engine == null) {
      if (other.engine != null)
        return false;
    } else if (!this.engine.equals(other.engine))
      return false;
    if (this.stepToExecute == null) {
      if (other.stepToExecute != null)
        return false;
    } else if (!this.stepToExecute.equals(other.stepToExecute))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.engine== null) ? 0 : this.engine.hashCode());
    return prime * result + ((this.stepToExecute== null) ? 0 : this.stepToExecute.hashCode());
  }
}
