/**
 * ---------------------------------------------------------------------------------------------
 * Copyright (c) 2020 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * --------------------------------------------------------------------------------------------
 */
package org.eclipse.gemoc.protocols.eaop.api.data;

import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SuppressWarnings("all")
public class GetStateResponse {
  private StateDto state;

  @Pure
  public StateDto getState() {
    return this.state;
  }

  public void setState(final StateDto state) {
    this.state = state;
  }

  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("state", this.state);
    return b.toString();
  }

  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    GetStateResponse other = (GetStateResponse) obj;
    if (this.state == null) {
      if (other.state != null)
        return false;
    } else if (!this.state.equals(other.state))
      return false;
    return true;
  }

  @Override
  @Pure
  public int hashCode() {
    return 31 * 1 + ((this.state== null) ? 0 : this.state.hashCode());
  }
}
