/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.util.ProposalUtil;
import org.eclipse.m2e.core.ui.internal.wizards.MavenModuleWizard;
import org.eclipse.m2e.core.ui.internal.wizards.WidthGroup;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.composites.ListEditorComposite;
import org.eclipse.m2e.editor.composites.ListEditorContentProvider;
import org.eclipse.m2e.editor.composites.StringLabelProvider;
import org.eclipse.m2e.editor.dialogs.MavenModuleSelectionDialog;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.ElementValueProvider;
import org.eclipse.m2e.editor.pom.FormUtils;
import org.eclipse.m2e.editor.pom.MavenPomEditor;
import org.eclipse.m2e.editor.pom.MavenPomEditorPage;
import org.eclipse.m2e.editor.pom.PropertiesSection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ResourceTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverviewPage
extends MavenPomEditorPage {
    static final Logger LOG = LoggerFactory.getLogger(OverviewPage.class);
    private static final int RELOAD_MODULES = 1;
    private static final int RELOAD_BASE = 2;
    private static final int RELOAD_CI = 4;
    private static final int RELOAD_SCM = 8;
    private static final int RELOAD_IM = 16;
    private static final int RELOAD_PROPERTIES = 32;
    private static final int RELOAD_PARENT = 64;
    private static final int RELOAD_ORG = 128;
    private static final int RELOAD_ALL = 255;
    private static final String COMPONENTS_PATH = "META-INF/plexus/components.xml";
    Text artifactIdText;
    Text artifactVersionText;
    Text artifactGroupIdText;
    CCombo artifactPackagingCombo;
    Text parentVersionText;
    Text parentArtifactIdText;
    Text parentGroupIdText;
    Text parentRelativePathText;
    Text projectUrlText;
    Text projectNameText;
    Text projectDescriptionText;
    Text inceptionYearText;
    Text organizationUrlText;
    Text organizationNameText;
    Text scmUrlText;
    Text scmDevConnectionText;
    Text scmConnectionText;
    Text scmTagText;
    CCombo issueManagementSystemCombo;
    CCombo issueManagementUrlCombo;
    CCombo ciManagementUrlCombo;
    CCombo ciManagementSystemCombo;
    ListEditorComposite<String> modulesEditor;
    PropertiesSection propertiesSection;
    Section modulesSection;
    Section parentSection;
    Section projectSection;
    Section organizationSection;
    Section scmSection;
    Section issueManagementSection;
    Section ciManagementSection;
    private Action newModuleElementAction;
    private Action parentSelectAction;
    private Action parentOpenAction;
    private StackLayout modulesStack;
    private Composite noModules;
    private Composite modulesSectionComposite;
    protected GridData projectSectionData;

    public OverviewPage(MavenPomEditor pomEditor) {
        super(pomEditor, "org.eclipse.m2e.core.pom.overview", Messages.OverviewPage_title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(Messages.OverviewPage_form);
        Composite body = form.getBody();
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.horizontalSpacing = 7;
        body.setLayout((Layout)gridLayout);
        toolkit.paintBordersFor(body);
        Composite leftComposite = toolkit.createComposite(body, 0);
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout leftCompositeLayout = new GridLayout();
        leftCompositeLayout.marginWidth = 0;
        leftCompositeLayout.marginHeight = 0;
        leftComposite.setLayout((Layout)leftCompositeLayout);
        WidthGroup leftWidthGroup = new WidthGroup();
        leftComposite.addControlListener((ControlListener)leftWidthGroup);
        this.createArtifactSection(toolkit, leftComposite, leftWidthGroup);
        this.createParentsection(toolkit, leftComposite, leftWidthGroup);
        this.createPropertiesSection(toolkit, leftComposite, leftWidthGroup);
        this.createModulesSection(toolkit, leftComposite, leftWidthGroup);
        Composite rightComposite = toolkit.createComposite(body, 0);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout rightCompositeLayout = new GridLayout();
        rightCompositeLayout.marginWidth = 0;
        rightCompositeLayout.marginHeight = 0;
        rightComposite.setLayout((Layout)rightCompositeLayout);
        WidthGroup rightWidthGroup = new WidthGroup();
        rightComposite.addControlListener((ControlListener)rightWidthGroup);
        this.createProjectSection(toolkit, rightComposite, rightWidthGroup);
        this.createOrganizationSection(toolkit, rightComposite, rightWidthGroup);
        this.createScmSection(toolkit, rightComposite, rightWidthGroup);
        this.createIssueManagementSection(toolkit, rightComposite, rightWidthGroup);
        this.createCiManagementSection(toolkit, rightComposite, rightWidthGroup);
        toolkit.paintBordersFor(leftComposite);
        toolkit.paintBordersFor(rightComposite);
        super.createFormContent(managedForm);
    }

    private void createArtifactSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        Section artifactSection = toolkit.createSection(composite, 256);
        artifactSection.setLayoutData((Object)new GridData(4, 128, true, false));
        artifactSection.setText(Messages.OverviewPage_section_artifact);
        Composite artifactComposite = toolkit.createComposite((Composite)artifactSection, 0);
        toolkit.adapt(artifactComposite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 1;
        artifactComposite.setLayout((Layout)gridLayout);
        artifactSection.setClient((Control)artifactComposite);
        Label groupIdLabel = toolkit.createLabel(artifactComposite, Messages.OverviewPage_lblGroupId, 0);
        this.artifactGroupIdText = toolkit.createText(artifactComposite, null, 0);
        this.artifactGroupIdText.setData("name", (Object)"groupId");
        GridData gd_artifactGroupIdText = new GridData(4, 0x1000000, true, false);
        gd_artifactGroupIdText.horizontalIndent = 4;
        this.artifactGroupIdText.setLayoutData((Object)gd_artifactGroupIdText);
        ProposalUtil.addGroupIdProposal((IProject)this.getProject(), (Text)this.artifactGroupIdText, (Packaging)Packaging.ALL);
        this.createEvaluatorInfo((Control)this.artifactGroupIdText);
        this.setElementValueProvider((Control)this.artifactGroupIdText, new ElementValueProvider("groupId"));
        this.setModifyListener((Control)this.artifactGroupIdText);
        Label artifactIdLabel = toolkit.createLabel(artifactComposite, Messages.OverviewPage_lblArtifactId, 0);
        this.artifactIdText = toolkit.createText(artifactComposite, null, 0);
        this.artifactIdText.setData("name", (Object)"artifactId");
        GridData gd_artifactIdText = new GridData(4, 0x1000000, true, false);
        gd_artifactIdText.horizontalIndent = 4;
        this.artifactIdText.setLayoutData((Object)gd_artifactIdText);
        M2EUIUtils.addRequiredDecoration((Control)this.artifactIdText);
        this.createEvaluatorInfo((Control)this.artifactIdText);
        this.setElementValueProvider((Control)this.artifactIdText, new ElementValueProvider("artifactId"));
        this.setModifyListener((Control)this.artifactIdText);
        Label versionLabel = toolkit.createLabel(artifactComposite, Messages.OverviewPage_lblVersion, 0);
        this.artifactVersionText = toolkit.createText(artifactComposite, null, 0);
        GridData gd_versionText = new GridData(4, 0x1000000, true, false);
        gd_versionText.horizontalIndent = 4;
        gd_versionText.widthHint = 200;
        this.artifactVersionText.setLayoutData((Object)gd_versionText);
        this.artifactVersionText.setData("name", (Object)"version");
        this.createEvaluatorInfo((Control)this.artifactVersionText);
        this.setElementValueProvider((Control)this.artifactVersionText, new ElementValueProvider("version"));
        this.setModifyListener((Control)this.artifactVersionText);
        Label packagingLabel = toolkit.createLabel(artifactComposite, Messages.OverviewPage_lblPackaging, 0);
        this.artifactPackagingCombo = new CCombo(artifactComposite, 0x800000);
        LinkedHashSet<String> packagingTypes = new LinkedHashSet<String>();
        packagingTypes.add("jar");
        packagingTypes.add("war");
        packagingTypes.add("ejb");
        packagingTypes.add("ear");
        packagingTypes.add("pom");
        packagingTypes.add("maven-plugin");
        this.updateAvailablePackagingTypes(packagingTypes);
        packagingTypes.forEach(type -> this.artifactPackagingCombo.add(type));
        toolkit.adapt((Control)this.artifactPackagingCombo, true, true);
        GridData gd_packagingText = new GridData(16384, 0x1000000, true, false);
        gd_packagingText.horizontalIndent = 4;
        gd_packagingText.widthHint = 120;
        this.artifactPackagingCombo.setLayoutData((Object)gd_packagingText);
        this.artifactPackagingCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.artifactPackagingCombo.setData("name", (Object)"packaging");
        toolkit.paintBordersFor((Composite)this.artifactPackagingCombo);
        ElementValueProvider provider = new ElementValueProvider("packaging");
        provider.setDefaultValue("jar");
        this.setElementValueProvider((Control)this.artifactPackagingCombo, provider);
        this.setModifyListener((Control)this.artifactPackagingCombo);
        widthGroup.addControl((Control)groupIdLabel);
        widthGroup.addControl((Control)artifactIdLabel);
        widthGroup.addControl((Control)versionLabel);
        widthGroup.addControl((Control)packagingLabel);
        toolkit.paintBordersFor(artifactComposite);
    }

    private void createParentsection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.parentSection = toolkit.createSection(composite, 322);
        this.parentSection.setLayoutData((Object)new GridData(4, 128, true, false));
        this.parentSection.setText(Messages.OverviewPage_section_parent);
        this.parentSection.setData("name", (Object)"parentSection");
        this.parentSelectAction = new Action(Messages.OverviewPage_action_selectParent, MavenEditorImages.SELECT_ARTIFACT){

            public void run() {
                IndexedArtifactFile af;
                HashSet<ArtifactKey> current = new HashSet<ArtifactKey>();
                String parentGroup = OverviewPage.this.parentGroupIdText.getText();
                String parentArtifact = OverviewPage.this.parentArtifactIdText.getText();
                String parentVersion = OverviewPage.this.parentVersionText.getText();
                if (parentGroup != null && parentArtifact != null && parentVersion != null) {
                    current.add(new ArtifactKey(parentGroup, parentArtifact, parentVersion, null));
                }
                MavenRepositorySearchDialog dialog = MavenRepositorySearchDialog.createSearchParentDialog((Shell)OverviewPage.this.getEditorSite().getShell(), (String)Messages.OverviewPage_searchDialog_selectParent, (MavenProject)OverviewPage.this.getPomEditor().getMavenProject(), (IProject)OverviewPage.this.getProject());
                if (parentGroup != null && parentGroup.trim().length() != 0) {
                    dialog.setQuery(OverviewPage.this.parentGroupIdText.getText());
                } else if (OverviewPage.this.artifactGroupIdText.getText() != null && OverviewPage.this.artifactGroupIdText.getText().trim().length() != 0) {
                    dialog.setQuery(OverviewPage.this.artifactGroupIdText.getText());
                }
                if (dialog.open() == 0 && (af = (IndexedArtifactFile)dialog.getFirstResult()) != null) {
                    String grid = FormUtils.nvl(af.group);
                    String ver = FormUtils.nvl(af.version);
                    OverviewPage.this.parentGroupIdText.setText(grid);
                    OverviewPage.this.parentArtifactIdText.setText(FormUtils.nvl(af.artifact));
                    OverviewPage.this.parentVersionText.setText(ver);
                    if (grid.equals(OverviewPage.this.artifactGroupIdText.getText())) {
                        OverviewPage.this.artifactGroupIdText.setText("");
                    }
                    if (ver.equals(OverviewPage.this.artifactVersionText.getText())) {
                        OverviewPage.this.artifactVersionText.setText("");
                    }
                    OverviewPage.this.parentSection.setExpanded(true);
                }
            }
        };
        this.parentSelectAction.setEnabled(false);
        this.parentOpenAction = new Action(Messages.OverviewPage_job_open, MavenEditorImages.PARENT_POM){

            public void run() {
                final String groupId = OverviewPage.this.parentGroupIdText.getText();
                final String artifactId = OverviewPage.this.parentArtifactIdText.getText();
                final String version = OverviewPage.this.parentVersionText.getText();
                new Job(NLS.bind((String)Messages.OverviewPage_job, (Object[])new Object[]{groupId, artifactId, version})){

                    protected IStatus run(IProgressMonitor monitor) {
                        OpenPomAction.openEditor((String)groupId, (String)artifactId, (String)version, (MavenProject)OverviewPage.this.getPomEditor().getMavenProject(), (IProgressMonitor)monitor);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
        this.parentOpenAction.setEnabled(false);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.add((IAction)this.parentOpenAction);
        toolBarManager.add((IAction)this.parentSelectAction);
        Composite toolbarComposite = toolkit.createComposite((Composite)this.parentSection);
        GridLayout toolbarLayout = new GridLayout(1, true);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setBackground(null);
        toolBarManager.createControl(toolbarComposite);
        this.parentSection.setTextClient((Control)toolbarComposite);
        Composite parentComposite = toolkit.createComposite((Composite)this.parentSection, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginBottom = 5;
        gridLayout.marginWidth = 1;
        gridLayout.marginHeight = 2;
        parentComposite.setLayout((Layout)gridLayout);
        this.parentSection.setClient((Control)parentComposite);
        Label parentGroupIdLabel = toolkit.createLabel(parentComposite, Messages.OverviewPage_lblGroupId2, 0);
        this.parentGroupIdText = toolkit.createText(parentComposite, null, 0);
        GridData gd_parentGroupIdText = new GridData(4, 0x1000000, true, false);
        gd_parentGroupIdText.horizontalIndent = 4;
        this.parentGroupIdText.setLayoutData((Object)gd_parentGroupIdText);
        this.parentGroupIdText.setData("name", (Object)"parentGroupId");
        ProposalUtil.addGroupIdProposal((IProject)this.getProject(), (Text)this.parentGroupIdText, (Packaging)Packaging.POM);
        M2EUIUtils.addRequiredDecoration((Control)this.parentGroupIdText);
        this.createEvaluatorInfo((Control)this.parentGroupIdText);
        this.setElementValueProvider((Control)this.parentGroupIdText, new ElementValueProvider("parent", "groupId"));
        this.setModifyListener((Control)this.parentGroupIdText);
        Label parentArtifactIdLabel = toolkit.createLabel(parentComposite, Messages.OverviewPage_lblArtifactId, 0);
        this.parentArtifactIdText = toolkit.createText(parentComposite, null, 0);
        GridData gd_parentArtifactIdText = new GridData(4, 0x1000000, true, false);
        gd_parentArtifactIdText.horizontalIndent = 4;
        this.parentArtifactIdText.setLayoutData((Object)gd_parentArtifactIdText);
        this.parentArtifactIdText.setData("name", (Object)"parentArtifactId");
        ProposalUtil.addArtifactIdProposal((IProject)this.getProject(), (Text)this.parentGroupIdText, (Text)this.parentArtifactIdText, (Packaging)Packaging.POM);
        M2EUIUtils.addRequiredDecoration((Control)this.parentArtifactIdText);
        this.createEvaluatorInfo((Control)this.parentArtifactIdText);
        this.setElementValueProvider((Control)this.parentArtifactIdText, new ElementValueProvider("parent", "artifactId"));
        this.setModifyListener((Control)this.parentArtifactIdText);
        Label parentVersionLabel = toolkit.createLabel(parentComposite, Messages.OverviewPage_lblVersion2, 0);
        parentVersionLabel.setLayoutData((Object)new GridData());
        this.parentVersionText = toolkit.createText(parentComposite, null, 0);
        GridData parentVersionTextData = new GridData(16384, 0x1000000, true, false);
        parentVersionTextData.horizontalIndent = 4;
        parentVersionTextData.widthHint = 200;
        this.parentVersionText.setLayoutData((Object)parentVersionTextData);
        this.parentVersionText.setData("name", (Object)"parentVersion");
        ProposalUtil.addVersionProposal((IProject)this.getProject(), null, (Text)this.parentGroupIdText, (Text)this.parentArtifactIdText, (Text)this.parentVersionText, (Packaging)Packaging.POM);
        M2EUIUtils.addRequiredDecoration((Control)this.parentVersionText);
        this.createEvaluatorInfo((Control)this.parentVersionText);
        this.setElementValueProvider((Control)this.parentVersionText, new ElementValueProvider("parent", "version"));
        this.setModifyListener((Control)this.parentVersionText);
        ModifyListener ml = e -> {
            String text1 = this.parentArtifactIdText.getText().trim();
            String text2 = this.parentGroupIdText.getText().trim();
            String text3 = this.parentVersionText.getText().trim();
            if (text1.length() > 0 && text2.length() > 0 && text3.length() > 0) {
                this.parentOpenAction.setEnabled(true);
            } else {
                this.parentOpenAction.setEnabled(false);
            }
        };
        this.parentArtifactIdText.addModifyListener(ml);
        this.parentVersionText.addModifyListener(ml);
        this.parentGroupIdText.addModifyListener(ml);
        Label parentRealtivePathLabel = toolkit.createLabel(parentComposite, Messages.OverviewPage_lblRelPath, 0);
        this.parentRelativePathText = toolkit.createText(parentComposite, null, 0);
        GridData gd_parentRelativePathText = new GridData(4, 0x1000000, true, false);
        gd_parentRelativePathText.horizontalIndent = 4;
        this.parentRelativePathText.setLayoutData((Object)gd_parentRelativePathText);
        this.parentRelativePathText.setData("name", (Object)"parentRelativePath");
        this.createEvaluatorInfo((Control)this.parentRelativePathText);
        this.setElementValueProvider((Control)this.parentRelativePathText, new ElementValueProvider("parent", "relativePath"));
        this.setModifyListener((Control)this.parentRelativePathText);
        widthGroup.addControl((Control)parentGroupIdLabel);
        widthGroup.addControl((Control)parentArtifactIdLabel);
        widthGroup.addControl((Control)parentVersionLabel);
        widthGroup.addControl((Control)parentRealtivePathLabel);
        toolkit.paintBordersFor(parentComposite);
        parentComposite.setTabList(new Control[]{this.parentGroupIdText, this.parentArtifactIdText, this.parentVersionText, this.parentRelativePathText});
    }

    private void createPropertiesSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.propertiesSection = new PropertiesSection(toolkit, composite, this);
    }

    private void createModulesSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.modulesSection = toolkit.createSection(composite, 322);
        final GridData moduleSectionData = new GridData(4, 4, true, true);
        this.modulesSection.setLayoutData((Object)moduleSectionData);
        this.modulesSection.setText(Messages.OverviewPage_section_modules);
        this.modulesSection.setData("name", (Object)"modulesSection");
        this.modulesSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                moduleSectionData.grabExcessVerticalSpace = e.getState();
                OverviewPage.this.modulesSection.getParent().layout();
            }
        });
        this.modulesSectionComposite = toolkit.createComposite((Composite)this.modulesSection);
        this.modulesStack = new StackLayout();
        this.modulesSectionComposite.setLayout((Layout)this.modulesStack);
        this.modulesSection.setClient((Control)this.modulesSectionComposite);
        this.noModules = toolkit.createComposite(this.modulesSectionComposite);
        this.noModules.setLayout((Layout)new GridLayout(1, false));
        Label label = toolkit.createLabel(this.noModules, Messages.OverviewPage_msg_not_pom_packaging);
        GridData gd_label = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_label.verticalIndent = 12;
        gd_label.horizontalIndent = 12;
        label.setLayoutData((Object)gd_label);
        this.modulesEditor = new ListEditorComposite(this.modulesSectionComposite, 0, true);
        this.modulesEditor.getViewer().getTable().setData("name", (Object)"modulesEditor");
        toolkit.paintBordersFor(this.modulesEditor);
        toolkit.adapt(this.modulesEditor);
        this.modulesEditor.setContentProvider(new ListEditorContentProvider());
        this.modulesEditor.setLabelProvider((ILabelProvider)new ModulesLabelProvider(this));
        this.modulesEditor.setOpenListener(openevent -> {
            final List<String> selection = this.modulesEditor.getSelection();
            new Job(Messages.OverviewPage_opening_editors){

                protected IStatus run(IProgressMonitor monitor) {
                    for (String module : selection) {
                        IMavenProjectFacade projectFacade = OverviewPage.this.findModuleProject(module);
                        if (projectFacade != null) {
                            ArtifactKey key = projectFacade.getArtifactKey();
                            OpenPomAction.openEditor((String)key.getGroupId(), (String)key.getArtifactId(), (String)key.getVersion(), (MavenProject)OverviewPage.this.getPomEditor().getMavenProject(), (IProgressMonitor)monitor);
                            continue;
                        }
                        IFile modulePom = OverviewPage.this.findModuleFile(module);
                        if (modulePom == null || !modulePom.isAccessible()) continue;
                        OpenPomAction.openEditor((IEditorInput)new FileEditorInput(modulePom), (String)"pom.xml");
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        });
        this.modulesEditor.setAddButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            HashSet<Object> moduleContainers = new HashSet<Object>();
            ArrayList modules = new ArrayList();
            try {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.getPomEditor().getDocument(), document -> {
                    Element modsEl = PomEdits.findChild((Element)document.getDocumentElement(), (String)"modules");
                    for (Element el : PomEdits.findChilds((Element)modsEl, (String)"module")) {
                        String m = PomEdits.getTextValue((Node)el);
                        if (m == null) continue;
                        modules.add(m);
                    }
                }, true)});
            }
            catch (Exception e1) {
                LOG.error("Cannot load modules", (Throwable)e1);
            }
            for (String module : modules) {
                IFile file;
                IMavenProjectFacade facade = this.findModuleProject(module);
                if (facade != null) {
                    moduleContainers.add(facade.getProject().getLocation());
                }
                if ((file = this.findModuleFile(module)) == null) continue;
                moduleContainers.add(file.getParent().getLocation());
            }
            moduleContainers.add(this.getProject().getLocation());
            MavenModuleSelectionDialog dialog = new MavenModuleSelectionDialog(this.getSite().getShell(), moduleContainers);
            if (dialog.open() == 0) {
                this.addSelectedModules(dialog.getResult(), dialog.isPomUpdateRequired());
            }
        }));
        this.modulesEditor.setCreateButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            IEditorInput editorInput = this.pomEditor.getEditorInput();
            if (editorInput instanceof FileEditorInput) {
                MavenModuleWizard wizard = new MavenModuleWizard(true);
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)((FileEditorInput)editorInput).getFile()));
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                int res = dialog.open();
                if (res == 0) {
                    this.createNewModule(wizard.getModuleName());
                }
            }
        }));
        this.modulesEditor.setRemoveButtonListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                this.performEditOperation(document -> {
                    Element root = document.getDocumentElement();
                    Element modules = PomEdits.findChild((Element)root, (String)"modules");
                    if (modules != null) {
                        for (String module : this.modulesEditor.getSelection()) {
                            Element modEl = PomEdits.findChild((Element)modules, (String)"module", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.textEquals((String)module)});
                            if (modEl == null) continue;
                            modules.removeChild(modEl);
                        }
                        PomEdits.removeIfNoChildElement((Element)modules);
                    }
                }, LOG, "error removing module entry");
            }
            finally {
                this.loadThis(1);
            }
        }));
        this.modulesEditor.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                return element;
            }

            public void modify(Object element, String property, Object value) {
                int n = OverviewPage.this.modulesEditor.getViewer().getTable().getSelectionIndex();
                try {
                    OverviewPage.this.performEditOperation(document -> {
                        Element root = document.getDocumentElement();
                        Element module = PomEdits.findChild((Element)PomEdits.findChild((Element)root, (String)"modules"), (String)"module", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childAt((int)n)});
                        if (module != null && !value.equals(PomEdits.getTextValue((Node)module))) {
                            PomEdits.setText((Element)module, (String)value.toString());
                        }
                    }, LOG, "error changing module entry");
                }
                finally {
                    OverviewPage.this.loadThis(1);
                }
            }
        });
        this.modulesEditor.getViewer().addDropSupport(7, new Transfer[]{ResourceTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                event.detail = 4;
            }

            public void drop(DropTargetEvent event) {
                if (event.data instanceof Object[]) {
                    OverviewPage.this.addSelectedModules((Object[])event.data, true);
                }
            }
        });
        this.newModuleElementAction = new Action(Messages.OverviewPage_action_newModuleElement, MavenImages.NEW_POM){

            public void run() {
                OverviewPage.this.createNewModule("?");
            }
        };
        ToolBarManager modulesToolBarManager = new ToolBarManager(0x800000);
        modulesToolBarManager.add((IAction)this.newModuleElementAction);
        Composite toolbarComposite = toolkit.createComposite((Composite)this.modulesSection);
        GridLayout toolbarLayout = new GridLayout(1, true);
        toolbarLayout.marginHeight = 0;
        toolbarLayout.marginWidth = 0;
        toolbarComposite.setLayout((Layout)toolbarLayout);
        toolbarComposite.setBackground(null);
        modulesToolBarManager.createControl(toolbarComposite);
        this.modulesSection.setTextClient((Control)toolbarComposite);
        this.modulesEditor.setReadOnly(this.pomEditor.isReadOnly());
        this.newModuleElementAction.setEnabled(!this.pomEditor.isReadOnly());
    }

    private void createProjectSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.projectSection = toolkit.createSection(composite, 322);
        this.projectSectionData = new GridData(4, 4, true, true);
        this.projectSection.setLayoutData((Object)this.projectSectionData);
        this.projectSection.setText(Messages.OverviewPage_section_project);
        this.projectSection.setData("name", (Object)"projectSection");
        this.projectSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OverviewPage.this.projectSectionData.grabExcessVerticalSpace = e.getState();
                OverviewPage.this.projectSection.getParent().layout();
            }
        });
        Composite projectComposite = toolkit.createComposite((Composite)this.projectSection, 0);
        projectComposite.setLayout((Layout)new GridLayout(2, false));
        this.projectSection.setClient((Control)projectComposite);
        Label nameLabel = toolkit.createLabel(projectComposite, Messages.OverviewPage_lblName, 0);
        this.projectNameText = toolkit.createText(projectComposite, null, 0);
        GridData gd_projectNameText = new GridData(4, 0x1000000, true, false);
        gd_projectNameText.widthHint = 150;
        this.projectNameText.setLayoutData((Object)gd_projectNameText);
        this.projectNameText.setData("name", (Object)"projectName");
        this.createEvaluatorInfo((Control)this.projectNameText);
        this.setElementValueProvider((Control)this.projectNameText, new ElementValueProvider("name"));
        this.setModifyListener((Control)this.projectNameText);
        Hyperlink urlLabel = toolkit.createHyperlink(projectComposite, Messages.OverviewPage_lblUrl, 0);
        urlLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FormUtils.openHyperlink(OverviewPage.this.projectUrlText.getText());
            }
        });
        this.projectUrlText = toolkit.createText(projectComposite, null, 0);
        GridData gd_projectUrlText = new GridData(4, 0x1000000, true, false);
        gd_projectUrlText.widthHint = 150;
        this.projectUrlText.setLayoutData((Object)gd_projectUrlText);
        this.projectUrlText.setData("name", (Object)"projectUrl");
        this.createEvaluatorInfo((Control)this.projectUrlText);
        this.setElementValueProvider((Control)this.projectUrlText, new ElementValueProvider("url"));
        this.setModifyListener((Control)this.projectUrlText);
        Label descriptionLabel = toolkit.createLabel(projectComposite, Messages.OverviewPage_lblDesc, 0);
        descriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.projectDescriptionText = toolkit.createText(projectComposite, null, 578);
        GridData gd_descriptionText = new GridData(4, 4, true, true);
        gd_descriptionText.widthHint = 150;
        gd_descriptionText.heightHint = 100;
        gd_descriptionText.minimumHeight = 100;
        this.projectDescriptionText.setLayoutData((Object)gd_descriptionText);
        this.projectDescriptionText.setData("name", (Object)"projectDescription");
        this.createEvaluatorInfo((Control)this.projectDescriptionText);
        this.setElementValueProvider((Control)this.projectDescriptionText, new ElementValueProvider("description"));
        this.setModifyListener((Control)this.projectDescriptionText);
        Label inceptionYearLabel = toolkit.createLabel(projectComposite, Messages.OverviewPage_lblInception, 0);
        this.inceptionYearText = toolkit.createText(projectComposite, null, 0);
        GridData gd_inceptionYearText = new GridData(4, 0x1000000, true, false);
        gd_inceptionYearText.widthHint = 150;
        this.inceptionYearText.setLayoutData((Object)gd_inceptionYearText);
        this.inceptionYearText.setData("name", (Object)"projectInceptionYear");
        this.createEvaluatorInfo((Control)this.inceptionYearText);
        this.setElementValueProvider((Control)this.inceptionYearText, new ElementValueProvider("inceptionYear"));
        this.setModifyListener((Control)this.inceptionYearText);
        widthGroup.addControl((Control)nameLabel);
        widthGroup.addControl((Control)urlLabel);
        widthGroup.addControl((Control)descriptionLabel);
        widthGroup.addControl((Control)inceptionYearLabel);
        toolkit.paintBordersFor(projectComposite);
        projectComposite.setTabList(new Control[]{this.projectNameText, this.projectUrlText, this.projectDescriptionText, this.inceptionYearText});
    }

    private void createOrganizationSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.organizationSection = toolkit.createSection(composite, 322);
        this.organizationSection.setLayoutData((Object)new GridData(4, 128, false, false));
        this.organizationSection.setText(Messages.OverviewPage_section_org);
        this.organizationSection.setData("name", (Object)"organizationSection");
        Composite organizationComposite = toolkit.createComposite((Composite)this.organizationSection, 0);
        organizationComposite.setLayout((Layout)new GridLayout(2, false));
        this.organizationSection.setClient((Control)organizationComposite);
        Label organizationNameLabel = toolkit.createLabel(organizationComposite, Messages.OverviewPage_lblName, 0);
        this.organizationNameText = toolkit.createText(organizationComposite, null, 0);
        GridData gd_organizationNameText = new GridData(4, 0x1000000, true, false);
        gd_organizationNameText.widthHint = 150;
        this.organizationNameText.setLayoutData((Object)gd_organizationNameText);
        this.organizationNameText.setData("name", (Object)"organizationName");
        this.createEvaluatorInfo((Control)this.organizationNameText);
        this.setElementValueProvider((Control)this.organizationNameText, new ElementValueProvider("organization", "name"));
        this.setModifyListener((Control)this.organizationNameText);
        Hyperlink organizationUrlLabel = toolkit.createHyperlink(organizationComposite, Messages.OverviewPage_lblUrl, 0);
        organizationUrlLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FormUtils.openHyperlink(OverviewPage.this.organizationUrlText.getText());
            }
        });
        this.organizationUrlText = toolkit.createText(organizationComposite, null, 0);
        GridData gd_organizationUrlText = new GridData(4, 0x1000000, true, false);
        gd_organizationUrlText.widthHint = 150;
        this.organizationUrlText.setLayoutData((Object)gd_organizationUrlText);
        this.organizationUrlText.setData("name", (Object)"organizationUrl");
        this.createEvaluatorInfo((Control)this.organizationUrlText);
        this.setElementValueProvider((Control)this.organizationUrlText, new ElementValueProvider("organization", "url"));
        this.setModifyListener((Control)this.organizationUrlText);
        widthGroup.addControl((Control)organizationNameLabel);
        widthGroup.addControl((Control)organizationUrlLabel);
        toolkit.paintBordersFor(organizationComposite);
        organizationComposite.setTabList(new Control[]{this.organizationNameText, this.organizationUrlText});
    }

    private void createScmSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.scmSection = toolkit.createSection(composite, 322);
        GridData gd_scmSection = new GridData(4, 128, false, false);
        this.scmSection.setLayoutData((Object)gd_scmSection);
        this.scmSection.setText(Messages.OverviewPage_section_scm);
        this.scmSection.setData("name", (Object)"scmSection");
        Composite scmComposite = toolkit.createComposite((Composite)this.scmSection, 0);
        scmComposite.setLayout((Layout)new GridLayout(2, false));
        this.scmSection.setClient((Control)scmComposite);
        Hyperlink scmUrlLabel = toolkit.createHyperlink(scmComposite, Messages.OverviewPage_lblUrl, 0);
        scmUrlLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FormUtils.openHyperlink(OverviewPage.this.scmUrlText.getText());
            }
        });
        this.scmUrlText = toolkit.createText(scmComposite, null, 0);
        GridData gd_scmUrlText = new GridData(4, 0x1000000, true, false);
        gd_scmUrlText.widthHint = 150;
        this.scmUrlText.setLayoutData((Object)gd_scmUrlText);
        this.scmUrlText.setData("name", (Object)"scmUrl");
        this.createEvaluatorInfo((Control)this.scmUrlText);
        this.setElementValueProvider((Control)this.scmUrlText, new ElementValueProvider("scm", "url"));
        this.setModifyListener((Control)this.scmUrlText);
        Label scmConnectionLabel = toolkit.createLabel(scmComposite, Messages.OverviewPage_lblConnection, 0);
        this.scmConnectionText = toolkit.createText(scmComposite, null, 0);
        GridData gd_scmConnectionText = new GridData(4, 0x1000000, true, false);
        gd_scmConnectionText.widthHint = 150;
        this.scmConnectionText.setLayoutData((Object)gd_scmConnectionText);
        this.scmConnectionText.setData("name", (Object)"scmConnection");
        this.createEvaluatorInfo((Control)this.scmConnectionText);
        this.setElementValueProvider((Control)this.scmConnectionText, new ElementValueProvider("scm", "connection"));
        this.setModifyListener((Control)this.scmConnectionText);
        Label scmDevConnectionLabel = toolkit.createLabel(scmComposite, Messages.OverviewPage_lblDev, 0);
        this.scmDevConnectionText = toolkit.createText(scmComposite, null, 0);
        GridData gd_scmDevConnectionText = new GridData(4, 0x1000000, true, false);
        gd_scmDevConnectionText.widthHint = 150;
        this.scmDevConnectionText.setLayoutData((Object)gd_scmDevConnectionText);
        this.scmDevConnectionText.setData("name", (Object)"scmDevConnection");
        this.createEvaluatorInfo((Control)this.scmDevConnectionText);
        this.setElementValueProvider((Control)this.scmDevConnectionText, new ElementValueProvider("scm", "developerConnection"));
        this.setModifyListener((Control)this.scmDevConnectionText);
        Label scmTagLabel = toolkit.createLabel(scmComposite, Messages.OverviewPage_lblTag, 0);
        this.scmTagText = toolkit.createText(scmComposite, null, 0);
        GridData gd_scmTagText = new GridData(4, 0x1000000, true, false);
        gd_scmTagText.widthHint = 150;
        this.scmTagText.setLayoutData((Object)gd_scmTagText);
        this.scmTagText.setData("name", (Object)"scmTag");
        this.createEvaluatorInfo((Control)this.scmTagText);
        this.setElementValueProvider((Control)this.scmTagText, new ElementValueProvider("scm", "tag"));
        this.setModifyListener((Control)this.scmTagText);
        widthGroup.addControl((Control)scmUrlLabel);
        widthGroup.addControl((Control)scmConnectionLabel);
        widthGroup.addControl((Control)scmDevConnectionLabel);
        widthGroup.addControl((Control)scmTagLabel);
        toolkit.paintBordersFor(scmComposite);
    }

    private void createIssueManagementSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.issueManagementSection = toolkit.createSection(composite, 322);
        this.issueManagementSection.setLayoutData((Object)new GridData(4, 128, false, false));
        this.issueManagementSection.setText(Messages.OverviewPage_section_issueMan);
        this.issueManagementSection.setData("name", (Object)"issueManagementSection");
        Composite issueManagementComposite = toolkit.createComposite((Composite)this.issueManagementSection, 0);
        issueManagementComposite.setLayout((Layout)new GridLayout(2, false));
        this.issueManagementSection.setClient((Control)issueManagementComposite);
        Label issueManagementSystemLabel = toolkit.createLabel(issueManagementComposite, Messages.OverviewPage_lblSystem, 0);
        this.issueManagementSystemCombo = new CCombo(issueManagementComposite, 0x800000);
        GridData gd_issueManagementSystemText = new GridData(4, 0x1000000, true, false);
        gd_issueManagementSystemText.widthHint = 150;
        this.issueManagementSystemCombo.setLayoutData((Object)gd_issueManagementSystemText);
        this.issueManagementSystemCombo.setData("name", (Object)"issueManagementSystem");
        this.issueManagementSystemCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.addToHistory((Control)this.issueManagementSystemCombo);
        toolkit.paintBordersFor((Composite)this.issueManagementSystemCombo);
        toolkit.adapt((Control)this.issueManagementSystemCombo, true, true);
        this.createEvaluatorInfo((Control)this.issueManagementSystemCombo);
        this.setElementValueProvider((Control)this.issueManagementSystemCombo, new ElementValueProvider("issueManagement", "system"));
        this.setModifyListener((Control)this.issueManagementSystemCombo);
        Hyperlink issueManagementUrlLabel = toolkit.createHyperlink(issueManagementComposite, Messages.OverviewPage_lblUrl, 0);
        issueManagementUrlLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FormUtils.openHyperlink(OverviewPage.this.issueManagementUrlCombo.getText());
            }
        });
        this.issueManagementUrlCombo = new CCombo(issueManagementComposite, 0x800000);
        GridData gd_issueManagementUrlText = new GridData(4, 0x1000000, true, false);
        gd_issueManagementUrlText.widthHint = 150;
        this.issueManagementUrlCombo.setLayoutData((Object)gd_issueManagementUrlText);
        this.issueManagementUrlCombo.setData("name", (Object)"issueManagementUrl");
        this.issueManagementUrlCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.addToHistory((Control)this.issueManagementUrlCombo);
        toolkit.paintBordersFor((Composite)this.issueManagementUrlCombo);
        toolkit.adapt((Control)this.issueManagementUrlCombo, true, true);
        this.createEvaluatorInfo((Control)this.issueManagementUrlCombo);
        this.setElementValueProvider((Control)this.issueManagementUrlCombo, new ElementValueProvider("issueManagement", "url"));
        this.setModifyListener((Control)this.issueManagementUrlCombo);
        widthGroup.addControl((Control)issueManagementSystemLabel);
        widthGroup.addControl((Control)issueManagementUrlLabel);
        toolkit.paintBordersFor(issueManagementComposite);
        issueManagementComposite.setTabList(new Control[]{this.issueManagementSystemCombo, this.issueManagementUrlCombo});
    }

    private void createCiManagementSection(FormToolkit toolkit, Composite composite, WidthGroup widthGroup) {
        this.ciManagementSection = toolkit.createSection(composite, 322);
        this.ciManagementSection.setLayoutData((Object)new GridData(4, 128, false, false));
        this.ciManagementSection.setText(Messages.OverviewPage_section_ci);
        this.ciManagementSection.setData("name", (Object)"continuousIntegrationSection");
        Composite ciManagementComposite = toolkit.createComposite((Composite)this.ciManagementSection, 0);
        ciManagementComposite.setLayout((Layout)new GridLayout(2, false));
        this.ciManagementSection.setClient((Control)ciManagementComposite);
        Label ciManagementSystemLabel = toolkit.createLabel(ciManagementComposite, Messages.OverviewPage_lblSystem, 0);
        this.ciManagementSystemCombo = new CCombo(ciManagementComposite, 0x800000);
        GridData gd_ciManagementSystemText = new GridData(4, 0x1000000, true, false);
        gd_ciManagementSystemText.widthHint = 150;
        this.ciManagementSystemCombo.setLayoutData((Object)gd_ciManagementSystemText);
        this.ciManagementSystemCombo.setData("name", (Object)"ciManagementSystem");
        this.ciManagementSystemCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.addToHistory((Control)this.ciManagementSystemCombo);
        toolkit.paintBordersFor((Composite)this.ciManagementSystemCombo);
        toolkit.adapt((Control)this.ciManagementSystemCombo, true, true);
        this.createEvaluatorInfo((Control)this.ciManagementSystemCombo);
        this.setElementValueProvider((Control)this.ciManagementSystemCombo, new ElementValueProvider("ciManagement", "system"));
        this.setModifyListener((Control)this.ciManagementSystemCombo);
        Hyperlink ciManagementUrlLabel = toolkit.createHyperlink(ciManagementComposite, Messages.OverviewPage_lblUrl, 0);
        ciManagementUrlLabel.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FormUtils.openHyperlink(OverviewPage.this.ciManagementUrlCombo.getText());
            }
        });
        this.ciManagementUrlCombo = new CCombo(ciManagementComposite, 0x800000);
        GridData gd_ciManagementUrlText = new GridData(4, 0x1000000, true, false);
        gd_ciManagementUrlText.widthHint = 150;
        this.ciManagementUrlCombo.setLayoutData((Object)gd_ciManagementUrlText);
        this.ciManagementUrlCombo.setData("name", (Object)"ciManagementUrl");
        this.ciManagementUrlCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.addToHistory((Control)this.ciManagementUrlCombo);
        toolkit.paintBordersFor((Composite)this.ciManagementUrlCombo);
        toolkit.adapt((Control)this.ciManagementUrlCombo, true, true);
        this.createEvaluatorInfo((Control)this.ciManagementUrlCombo);
        this.setElementValueProvider((Control)this.ciManagementUrlCombo, new ElementValueProvider("ciManagement", "url"));
        this.setModifyListener((Control)this.ciManagementUrlCombo);
        widthGroup.addControl((Control)ciManagementSystemLabel);
        widthGroup.addControl((Control)ciManagementUrlLabel);
        toolkit.paintBordersFor(ciManagementComposite);
        ciManagementComposite.setTabList(new Control[]{this.ciManagementSystemCombo, this.ciManagementUrlCombo});
    }

    public void updateView(Notification notification) {
    }

    @Override
    public void loadData() {
        this.loadThis(255);
    }

    private void loadThis(int mask) {
        Display.getDefault().asyncExec(() -> {
            this.removeNotifyListener(this.parentGroupIdText);
            this.removeNotifyListener(this.parentArtifactIdText);
            this.removeNotifyListener(this.parentVersionText);
            this.removeNotifyListener(this.parentRelativePathText);
            this.removeNotifyListener(this.artifactGroupIdText);
            this.removeNotifyListener(this.artifactIdText);
            this.removeNotifyListener(this.artifactVersionText);
            this.removeNotifyListener(this.artifactPackagingCombo);
            this.removeNotifyListener(this.projectNameText);
            this.removeNotifyListener(this.projectDescriptionText);
            this.removeNotifyListener(this.projectUrlText);
            this.removeNotifyListener(this.inceptionYearText);
            this.removeNotifyListener(this.organizationNameText);
            this.removeNotifyListener(this.organizationUrlText);
            this.removeNotifyListener(this.scmUrlText);
            this.removeNotifyListener(this.scmConnectionText);
            this.removeNotifyListener(this.scmDevConnectionText);
            this.removeNotifyListener(this.scmTagText);
            this.removeNotifyListener(this.ciManagementUrlCombo);
            this.removeNotifyListener(this.ciManagementSystemCombo);
            this.removeNotifyListener(this.issueManagementUrlCombo);
            this.removeNotifyListener(this.issueManagementSystemCombo);
            try {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.getPomEditor().getDocument(), document -> {
                    Element root = document.getDocumentElement();
                    String pack = FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"packaging")));
                    String string = pack = "".equals(pack) ? "jar" : pack;
                    if ((mask & 2) != 0) {
                        boolean expandProjectSection;
                        FormUtils.setText(this.artifactGroupIdText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"groupId"))));
                        FormUtils.setText(this.artifactIdText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"artifactId"))));
                        FormUtils.setText(this.artifactVersionText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"version"))));
                        FormUtils.setText(this.artifactPackagingCombo, pack);
                        String name = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"name"));
                        FormUtils.setText(this.projectNameText, FormUtils.nvl(name));
                        String desc = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"description"));
                        FormUtils.setText(this.projectDescriptionText, FormUtils.nvl(desc));
                        String url = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"url"));
                        FormUtils.setText(this.projectUrlText, FormUtils.nvl(url));
                        String incep = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"inceptionYear"));
                        FormUtils.setText(this.inceptionYearText, FormUtils.nvl(incep));
                        this.projectSectionData.grabExcessVerticalSpace = expandProjectSection = name != null || desc != null || url != null || incep != null;
                        this.projectSection.setExpanded(expandProjectSection);
                    }
                    if ((mask & 0x40) != 0) {
                        Element parent = PomEdits.findChild((Element)root, (String)"parent");
                        String parentGrId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"groupId"));
                        String parentArtId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"artifactId"));
                        String parentVers = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"version"));
                        FormUtils.setText(this.parentGroupIdText, FormUtils.nvl(parentGrId));
                        FormUtils.setText(this.parentArtifactIdText, FormUtils.nvl(parentArtId));
                        FormUtils.setText(this.parentVersionText, FormUtils.nvl(parentVers));
                        FormUtils.setText(this.parentRelativePathText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"relativePath"))));
                        this.parentSelectAction.setEnabled(!this.isReadOnly());
                        this.parentOpenAction.setEnabled(root != null && parentGrId != null && parentArtId != null && parentVers != null);
                        this.parentSection.setExpanded(parent != null);
                    }
                    if ((mask & 0x80) != 0) {
                        Element org = PomEdits.findChild((Element)root, (String)"organization");
                        FormUtils.setText(this.organizationNameText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)org, (String)"name"))));
                        FormUtils.setText(this.organizationUrlText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)org, (String)"url"))));
                        this.organizationSection.setExpanded(org != null);
                    }
                    if ((mask & 8) != 0) {
                        Element scm = PomEdits.findChild((Element)root, (String)"scm");
                        FormUtils.setText(this.scmUrlText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)scm, (String)"url"))));
                        FormUtils.setText(this.scmConnectionText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)scm, (String)"connection"))));
                        FormUtils.setText(this.scmDevConnectionText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)scm, (String)"developerConnection"))));
                        FormUtils.setText(this.scmTagText, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)scm, (String)"tag"))));
                        this.scmSection.setExpanded(scm != null);
                    }
                    if ((mask & 4) != 0) {
                        Element ci = PomEdits.findChild((Element)root, (String)"ciManagement");
                        FormUtils.setText(this.ciManagementSystemCombo, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)ci, (String)"system"))));
                        FormUtils.setText(this.ciManagementUrlCombo, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)ci, (String)"url"))));
                        this.ciManagementSection.setExpanded(ci != null);
                    }
                    if ((mask & 0x10) != 0) {
                        Element im = PomEdits.findChild((Element)root, (String)"issueManagement");
                        FormUtils.setText(this.issueManagementSystemCombo, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)im, (String)"system"))));
                        FormUtils.setText(this.issueManagementUrlCombo, FormUtils.nvl(PomEdits.getTextValue((Node)PomEdits.findChild((Element)im, (String)"url"))));
                        this.issueManagementSection.setExpanded(im != null);
                    }
                    if ((mask & 1) != 0) {
                        List moduleEls = PomEdits.findChilds((Element)PomEdits.findChild((Element)root, (String)"modules"), (String)"module");
                        ArrayList<String> modules = new ArrayList<String>();
                        for (Element moduleEl : moduleEls) {
                            String text = PomEdits.getTextValue((Node)moduleEl);
                            if (text == null) continue;
                            modules.add(text);
                        }
                        this.loadModules(modules, pack);
                        this.artifactPackagingCombo.setEnabled(modules.isEmpty());
                    }
                    if ((mask & 0x20) != 0) {
                        this.propertiesSection.refresh();
                        Element props = PomEdits.findChild((Element)root, (String)"properties");
                        this.propertiesSection.setExpanded(props != null);
                    }
                }, true)});
            }
            catch (Exception e) {
                LOG.error("Failed to populate overview panel", (Throwable)e);
            }
            this.addNotifyListener(this.artifactGroupIdText);
            this.addNotifyListener(this.artifactIdText);
            this.addNotifyListener(this.artifactVersionText);
            this.addNotifyListener(this.artifactPackagingCombo);
            this.addNotifyListener(this.projectNameText);
            this.addNotifyListener(this.projectDescriptionText);
            this.addNotifyListener(this.projectUrlText);
            this.addNotifyListener(this.inceptionYearText);
            this.addNotifyListener(this.parentGroupIdText);
            this.addNotifyListener(this.parentArtifactIdText);
            this.addNotifyListener(this.parentVersionText);
            this.addNotifyListener(this.parentRelativePathText);
            this.addNotifyListener(this.organizationNameText);
            this.addNotifyListener(this.organizationUrlText);
            this.addNotifyListener(this.scmUrlText);
            this.addNotifyListener(this.scmConnectionText);
            this.addNotifyListener(this.scmDevConnectionText);
            this.addNotifyListener(this.scmTagText);
            this.addNotifyListener(this.ciManagementUrlCombo);
            this.addNotifyListener(this.ciManagementSystemCombo);
            this.addNotifyListener(this.issueManagementUrlCombo);
            this.addNotifyListener(this.issueManagementSystemCombo);
        });
    }

    private void loadModules(List<String> modules, String packaging) {
        this.modulesEditor.setInput(modules);
        this.modulesEditor.setReadOnly(this.isReadOnly());
        if ("pom".equals(packaging) && this.modulesStack.topControl != this.modulesEditor) {
            this.modulesStack.topControl = this.modulesEditor;
            this.modulesSection.setExpanded(true);
            this.newModuleElementAction.setEnabled(!this.isReadOnly());
        } else if (!"pom".equals(packaging) && this.modulesStack.topControl != this.noModules) {
            this.newModuleElementAction.setEnabled(false);
            this.modulesStack.topControl = this.noModules;
            this.modulesSection.setExpanded(false);
        }
        this.modulesSectionComposite.layout();
    }

    private void createNewModule(String moduleName) {
        try {
            this.performEditOperation(document -> {
                Element root = document.getDocumentElement();
                Element modules = PomEdits.getChild((Element)root, (String[])new String[]{"modules"});
                if (PomEdits.findChild((Element)modules, (String)"module", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.textEquals((String)moduleName)}) == null) {
                    PomEdits.format((Node)PomEdits.createElementWithText((Element)modules, (String)"module", (String)moduleName));
                }
            }, LOG, "error updating modules list for pom file");
        }
        finally {
            this.loadThis(1);
        }
    }

    private void addSelectedModules(Object[] result, boolean updateParentSection) {
        String[] vals = new String[3];
        try {
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(this.getPomEditor().getDocument(), document -> {
                Element root = document.getDocumentElement();
                String grid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"groupId"));
                Element parent = PomEdits.findChild((Element)root, (String)"parent");
                if (grid == null) {
                    grid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"groupId"));
                }
                String artifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"artifactId"));
                String version = PomEdits.getTextValue((Node)PomEdits.findChild((Element)root, (String)"version"));
                if (version == null) {
                    version = PomEdits.getTextValue((Node)PomEdits.findChild((Element)parent, (String)"version"));
                }
                stringArray[0] = grid;
                stringArray[1] = artifactId;
                stringArray[2] = version;
            }, true)});
        }
        catch (Exception ex) {
            LOG.error("Error getting values from document", (Throwable)ex);
        }
        String parentGroupId = vals[0];
        String parentArtifactId = vals[1];
        String parentVersion = vals[2];
        IPath projectPath = this.getProject().getLocation();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IFile pomFile;
                IContainer container;
                block10: {
                    Object selection;
                    block8: {
                        selection = objectArray[n2];
                        container = null;
                        pomFile = null;
                        if (!(selection instanceof IFile)) break block8;
                        pomFile = (IFile)selection;
                        if (!"pom.xml".equals(pomFile.getName())) break block9;
                        container = pomFile.getParent();
                        break block10;
                    }
                    if (selection instanceof IContainer && !selection.equals(this.getProject())) {
                        container = (IContainer)selection;
                        pomFile = container.getFile((IPath)new Path("pom.xml"));
                    }
                }
                if (pomFile != null && pomFile.exists() && container != null) {
                    IPath resultPath = container.getLocation();
                    String path = resultPath.makeRelativeTo(projectPath).toString();
                    if (updateParentSection) {
                        String relativePath = projectPath.makeRelativeTo(resultPath).toString();
                        try {
                            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(pomFile, document -> {
                                Element ver;
                                String verText;
                                Element root = document.getDocumentElement();
                                Element parent = PomEdits.getChild((Element)root, (String[])new String[]{"parent"});
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"groupId"}), (String)parentGroupId);
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"artifactId"}), (String)parentArtifactId);
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"version"}), (String)parentVersion);
                                PomEdits.setText((Element)PomEdits.getChild((Element)parent, (String[])new String[]{"relativePath"}), (String)relativePath);
                                Element grId = PomEdits.findChild((Element)root, (String)"groupId");
                                String grIdText = PomEdits.getTextValue((Node)grId);
                                if (grIdText != null && grIdText.equals(parentGroupId)) {
                                    PomEdits.removeChild((Element)root, (Element)grId);
                                }
                                if ((verText = PomEdits.getTextValue((Node)(ver = PomEdits.findChild((Element)root, (String)"version")))) != null && verText.equals(parentVersion)) {
                                    PomEdits.removeChild((Element)root, (Element)ver);
                                }
                            })});
                        }
                        catch (Exception e) {
                            LOG.error("Error updating parent reference in file:" + pomFile, (Throwable)e);
                        }
                    }
                    this.createNewModule(path);
                }
            }
            ++n2;
        }
    }

    public void updateAvailablePackagingTypes(Set<String> packagingTypes) {
        if (this.getPomEditor().getMavenProject() != null) {
            for (Plugin plugin : this.getPomEditor().getMavenProject().getBuildPlugins()) {
                if (!plugin.isExtensions()) continue;
                DefaultArtifact artifact = new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), null, "maven-plugin", null, (ArtifactHandler)new DefaultArtifactHandler());
                this.addPluginPackagingTypes(packagingTypes, (Artifact)artifact);
            }
        }
    }

    void addPluginPackagingTypes(Set<String> packagingTypes, Artifact artifact) {
        ArtifactRepository localRepository;
        try {
            localRepository = MavenPluginActivator.getDefault().getMaven().getLocalRepository();
        }
        catch (CoreException ex) {
            return;
        }
        Artifact found = localRepository.find(artifact);
        if (found != null && found.getFile() != null) {
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (JarFile jarFile = new JarFile(found.getFile().getAbsoluteFile() + ".jar");){
                    DocumentBuilder db = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder();
                    JarEntry componentsxml = jarFile.getJarEntry(COMPONENTS_PATH);
                    if (componentsxml != null) {
                        Document doc = db.parse(jarFile.getInputStream(componentsxml));
                        doc.getDocumentElement().normalize();
                        NodeList components = doc.getElementsByTagName("component");
                        int i = 0;
                        while (i < components.getLength()) {
                            Node config;
                            Element element;
                            String role;
                            Node component = components.item(i);
                            if (component.getNodeType() == 1 && ArtifactHandler.ROLE.equals(role = (element = (Element)component).getElementsByTagName("role").item(0).getTextContent()) && (config = element.getElementsByTagName("configuration").item(0)).getNodeType() == 1) {
                                Element configEl = (Element)config;
                                String name = configEl.getElementsByTagName("type").item(0).getTextContent();
                                packagingTypes.add(name);
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class ModulesLabelProvider
    extends StringLabelProvider {
        private final MavenPomEditorPage editorPage;

        public ModulesLabelProvider(MavenPomEditorPage editorPage) {
            super(MavenEditorImages.IMG_JAR);
            this.editorPage = editorPage;
        }

        @Override
        public Image getImage(Object element) {
            if (element instanceof String) {
                String moduleName = (String)element;
                IMavenProjectFacade projectFacade = this.editorPage.findModuleProject(moduleName);
                if (projectFacade != null) {
                    return MavenEditorImages.IMG_PROJECT;
                }
                IFile moduleFile = this.editorPage.findModuleFile(moduleName);
                if (moduleFile != null && moduleFile.isAccessible()) {
                    return MavenEditorImages.IMG_PROJECT;
                }
            }
            return super.getImage(element);
        }
    }
}

