/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.diagnostics;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Operator implements Enumerator
{
    SUBSTRACTION(0, "SUBSTRACTION", "SUBSTRACTION"),
    ADDITION(1, "ADDITION", "ADDITION"),
    LOWER_THAN(2, "LOWER_THAN", "LOWER_THAN"),
    GREATER_THAN(3, "GREATER_THAN", "GREATER_THAN"),
    EQUAL(4, "EQUAL", "EQUAL"),
    DOT(5, "DOT", "DOT"),
    LOWER_OR_EQUAL(6, "LOWER_OR_EQUAL", "LOWER_OR_EQUAL"),
    GREATER_OR_EQUAL(7, "GREATER_OR_EQUAL", "GREATER_OR_EQUAL"),
    ASSIGNMENT(8, "ASSIGNMENT", "ASSIGNMENT"),
    ADDITION_ASSIGNMENT(9, "ADDITION_ASSIGNMENT", "ADDITION_ASSIGNMENT"),
    SUBSTRACTION_ASSIGNMENT(10, "SUBSTRACTION_ASSIGNMENT", "SUBSTRACTION_ASSIGNMENT");

    public static final int SUBSTRACTION_VALUE = 0;
    public static final int ADDITION_VALUE = 1;
    public static final int LOWER_THAN_VALUE = 2;
    public static final int GREATER_THAN_VALUE = 3;
    public static final int EQUAL_VALUE = 4;
    public static final int DOT_VALUE = 5;
    public static final int LOWER_OR_EQUAL_VALUE = 6;
    public static final int GREATER_OR_EQUAL_VALUE = 7;
    public static final int ASSIGNMENT_VALUE = 8;
    public static final int ADDITION_ASSIGNMENT_VALUE = 9;
    public static final int SUBSTRACTION_ASSIGNMENT_VALUE = 10;
    private static final Operator[] VALUES_ARRAY;
    public static final List<Operator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Operator[]{SUBSTRACTION, ADDITION, LOWER_THAN, GREATER_THAN, EQUAL, DOT, LOWER_OR_EQUAL, GREATER_OR_EQUAL, ASSIGNMENT, ADDITION_ASSIGNMENT, SUBSTRACTION_ASSIGNMENT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Operator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Operator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Operator get(int value) {
        switch (value) {
            case 0: {
                return SUBSTRACTION;
            }
            case 1: {
                return ADDITION;
            }
            case 2: {
                return LOWER_THAN;
            }
            case 3: {
                return GREATER_THAN;
            }
            case 4: {
                return EQUAL;
            }
            case 5: {
                return DOT;
            }
            case 6: {
                return LOWER_OR_EQUAL;
            }
            case 7: {
                return GREATER_OR_EQUAL;
            }
            case 8: {
                return ASSIGNMENT;
            }
            case 9: {
                return ADDITION_ASSIGNMENT;
            }
            case 10: {
                return SUBSTRACTION_ASSIGNMENT;
            }
        }
        return null;
    }

    private Operator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

