/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.gui;

import fr.inria.aoste.timesquare.backend.codeexecution.gui.CodeExecutionGUI;
import fr.inria.aoste.timesquare.backend.codeexecution.gui.DialogClassFilter;
import fr.inria.aoste.timesquare.backend.codeexecution.gui.FileValidator;
import fr.inria.aoste.timesquare.backend.codeexecution.gui.JavaWorkbenchContentProvider;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class CodeSelectionAdapter
extends SelectionAdapter {
    private static final Status STATUS = new Status(0, "fr.inria.aoste.timesquare.backend.codeexecution", 0, "", null);
    private static final Status STATUSBadname = new Status(4, "org.eclipse.ui", 4, "bad name", null);
    private static final Status STATUSEmpty = new Status(4, "org.eclipse.ui", 4, "Class not found", null);
    private final CodeExecutionGUI codeExecutionGUI;

    public CodeSelectionAdapter(CodeExecutionGUI codeExecutionGUI) {
        this.codeExecutionGUI = codeExecutionGUI;
    }

    public void widgetSelected(SelectionEvent arg0) {
        Variable v;
        VariableTreeSelectionDialog dialog = new VariableTreeSelectionDialog(this.codeExecutionGUI._composite.getShell());
        dialog.setInput(ResourcesPlugin.getWorkspace().getRoot());
        dialog.setValidator(new FileValidator());
        dialog.addFilter(new DialogClassFilter());
        int r = dialog.open();
        if (r == 0 && (v = dialog.getResultVariable()) != null) {
            this.codeExecutionGUI.updateVariable();
            this.codeExecutionGUI.selectVariable(v);
            this.codeExecutionGUI.updateMethods();
        }
        this.codeExecutionGUI.updateOKStatus();
    }

    private final class VariableTreeSelectionDialog
    extends SelectionStatusDialog {
        private TreeViewer fViewer;
        private ILabelProvider fLabelProvider;
        private ITreeContentProvider fContentProvider;
        private ISelectionStatusValidator fValidator;
        private IStatus fCurrStatus;
        private List<ViewerFilter> fFilters;
        private Object fInput;
        private boolean fIsEmpty;
        private String name;
        private Text text;

        public VariableTreeSelectionDialog(Shell parent) {
            super(parent);
            this.fValidator = null;
            this.fCurrStatus = STATUS;
            this.fFilters = new ArrayList<ViewerFilter>();
            this.name = null;
            this.text = null;
            this.fLabelProvider = new WorkbenchLabelProvider();
            this.fContentProvider = new JavaWorkbenchContentProvider();
            this.setResult(Collections.emptyList());
            this.setStatusLineAboveButtons(true);
        }

        public void addFilter(ViewerFilter filter) {
            this.fFilters.add(filter);
        }

        public void setValidator(ISelectionStatusValidator validator) {
            this.fValidator = validator;
        }

        public void setInput(Object input) {
            this.fInput = input;
        }

        protected void updateOKStatus() {
            if (!this.fIsEmpty) {
                if (this.fValidator != null) {
                    this.fCurrStatus = this.fValidator.validate(this.getResult());
                    this.updateStatus(this.fCurrStatus);
                } else {
                    this.fCurrStatus = this.name != null && this.name.length() != 0 ? STATUS : STATUSBadname;
                }
            } else {
                this.fCurrStatus = STATUSEmpty;
            }
            this.updateStatus(this.fCurrStatus);
        }

        public int open() {
            this.fIsEmpty = this.evaluateIfTreeEmpty(this.fInput);
            super.open();
            return this.getReturnCode();
        }

        private void access$superCreate() {
            super.create();
        }

        protected void cancelPressed() {
            this.setResult(null);
            super.cancelPressed();
        }

        protected void computeResult() {
            this.setResult(((IStructuredSelection)this.fViewer.getSelection()).toList());
        }

        public void create() {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    VariableTreeSelectionDialog.this.access$superCreate();
                    VariableTreeSelectionDialog.this.fViewer.setSelection((ISelection)new StructuredSelection(VariableTreeSelectionDialog.this.getInitialElementSelections()), true);
                    VariableTreeSelectionDialog.this.updateOKStatus();
                }
            });
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new FormLayout());
            Label messageLabel = this.createMessageArea(composite);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 6);
            data.right = new FormAttachment(100, -6);
            data.top = new FormAttachment(0, 6);
            messageLabel.setLayoutData((Object)data);
            messageLabel.setText("Name :");
            this.text = new Text(composite, 12);
            this.text.setEditable(true);
            this.text.addModifyListener((ModifyListener)new TextSelectionListener());
            data = new FormData();
            data.left = new FormAttachment(0, 6);
            data.right = new FormAttachment(100, -6);
            data.top = new FormAttachment((Control)messageLabel, 6);
            this.text.setLayoutData((Object)data);
            TreeViewer treeViewer = this.createTreeViewer(composite);
            Tree treeWidget = treeViewer.getTree();
            FormData data2 = new FormData();
            data2.bottom = new FormAttachment(100, -6);
            data2.left = new FormAttachment(0, 6);
            data2.right = new FormAttachment(100, -6);
            data2.top = new FormAttachment((Control)this.text, 6);
            treeWidget.setLayoutData((Object)data2);
            treeWidget.setFont(parent.getFont());
            if (this.fIsEmpty) {
                messageLabel.setEnabled(false);
                treeWidget.setEnabled(false);
            }
            return composite;
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            int style = 2052;
            this.fViewer = new TreeViewer(new Tree(parent, style));
            this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener());
            int i = 0;
            while (i != this.fFilters.size()) {
                this.fViewer.addFilter(this.fFilters.get(i));
                ++i;
            }
            this.fViewer.addDoubleClickListener((IDoubleClickListener)new TreeDoubleClick());
            this.fViewer.setInput(this.fInput);
            return this.fViewer;
        }

        private boolean evaluateIfTreeEmpty(Object input) {
            Object[] elements = this.fContentProvider.getElements(input);
            if (elements.length > 0 && this.fFilters != null) {
                int i = 0;
                while (i < this.fFilters.size()) {
                    ViewerFilter curr = this.fFilters.get(i);
                    elements = curr.filter((Viewer)this.fViewer, input, elements);
                    ++i;
                }
            }
            return elements.length == 0;
        }

        protected void accesssetResult(List<?> result) {
            super.setResult(result);
        }

        protected void handleShellCloseEvent() {
            this.setResult(null);
            super.handleShellCloseEvent();
        }

        public Variable getResultVariable() {
            Variable v = null;
            IType t = null;
            Object[] results = this.getResult();
            if (results != null && results.length != 0 && results[0] instanceof IType) {
                t = (IType)results[0];
                v = CodeSelectionAdapter.this.codeExecutionGUI.getBehaviorManager().createVariable(this.name, t);
            }
            return v;
        }

        public final class TextSelectionListener
        implements SelectionListener,
        ModifyListener {
            public void widgetSelected(SelectionEvent e) {
                VariableTreeSelectionDialog.this.name = VariableTreeSelectionDialog.this.text.getText();
                VariableTreeSelectionDialog.this.updateOKStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                VariableTreeSelectionDialog.this.name = VariableTreeSelectionDialog.this.text.getText();
                VariableTreeSelectionDialog.this.updateOKStatus();
            }

            public void modifyText(ModifyEvent e) {
                VariableTreeSelectionDialog.this.name = VariableTreeSelectionDialog.this.text.getText();
                VariableTreeSelectionDialog.this.updateOKStatus();
            }
        }

        public final class TreeDoubleClick
        implements IDoubleClickListener {
            public void doubleClick(DoubleClickEvent event) {
                VariableTreeSelectionDialog.this.updateOKStatus();
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (VariableTreeSelectionDialog.this.fViewer.getExpandedState(item)) {
                        VariableTreeSelectionDialog.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        VariableTreeSelectionDialog.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        }

        public final class TreeSelectionChangedListener
        implements ISelectionChangedListener {
            public void selectionChanged(SelectionChangedEvent event) {
                VariableTreeSelectionDialog.this.accesssetResult(((IStructuredSelection)event.getSelection()).toList());
                VariableTreeSelectionDialog.this.updateOKStatus();
            }
        }
    }
}

