/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.lazystart;

import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.ui.lazystart.Utils;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompilationUnitFilter
extends ViewerFilter {
    public static final String ID = "org.eclipse.ajdt.javamodel.CompilationUnitFilter";
    public static final String FILTER_DIALOG_ID = "DontInformUserAboutFileFilter";

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!Utils.isBundleActive()) {
            return true;
        }
        if (AspectJPlugin.USING_CU_PROVIDER) {
            return true;
        }
        if (element instanceof ICompilationUnit && !(element instanceof AJCompilationUnit)) {
            try {
                IResource res = ((ICompilationUnit)element).getCorrespondingResource();
                AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache((IFile)res);
                if (unit != null) {
                    if (!AJCompilationUnitManager.INSTANCE.ensureUnitIsInModel(unit)) {
                        AJDTUtils.refreshPackageExplorer();
                    }
                    return false;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return true;
    }

    public static void checkIfFileFilterEnabledAndAsk() {
        IPreferenceStore store;
        IPreferenceStore javaStore = JavaPlugin.getDefault().getPreferenceStore();
        if (!(!CompilationUnitFilter.isRelevant(javaStore) || javaStore.contains(ID) && javaStore.getBoolean(ID) || (store = AspectJUIPlugin.getDefault().getPreferenceStore()).contains(FILTER_DIALOG_ID) && store.getBoolean(FILTER_DIALOG_ID))) {
            Job job = new Job(UIMessages.FileFilterDialog_JobTitle){

                public IStatus run(IProgressMonitor m) {
                    final Display display = AspectJUIPlugin.getDefault().getDisplay();
                    Runnable myRun = new Runnable(){

                        @Override
                        public void run() {
                            MessageDialogWithToggle md = MessageDialogWithToggle.openInformation((Shell)display.getActiveShell(), (String)UIMessages.FileFilterDialog_Title, (String)UIMessages.FileFilterDialog_Message, (String)UIMessages.FileFilterDialog_CheckboxCaption, (boolean)true, null, null);
                            store.setValue(CompilationUnitFilter.FILTER_DIALOG_ID, md.getToggleState());
                        }
                    };
                    display.asyncExec(myRun);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setRule(null);
            job.schedule();
        }
    }

    private static boolean isRelevant(IPreferenceStore javaStore) {
        return javaStore.contains("CustomFiltersActionGroup.org.eclipse.jdt.ui.PackageExplorer.TAG_DUMMY_TO_TEST_EXISTENCE");
    }
}

