/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.contentassist;

import com.google.common.base.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.BoolType;
import org.eclipse.emf.ecoretools.ale.ClassifierType;
import org.eclipse.emf.ecoretools.ale.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.IntType;
import org.eclipse.emf.ecoretools.ale.Operation;
import org.eclipse.emf.ecoretools.ale.RealType;
import org.eclipse.emf.ecoretools.ale.SeqType;
import org.eclipse.emf.ecoretools.ale.SetType;
import org.eclipse.emf.ecoretools.ale.StringType;
import org.eclipse.emf.ecoretools.ale.VarRef;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.ide.project.IAleProject;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.rType;
import org.eclipse.emf.ecoretools.ale.typeLiteral;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static IBehaviors getSemantics(EObject model) {
        IFile aleFile = WorkspaceSynchronizer.getFile((Resource)model.eResource());
        try (IAleEnvironment environment = null;){
            environment = IAleProject.from((IProject)aleFile.getProject()).getEnvironment();
            IBehaviors iBehaviors = environment.getBehaviors();
            return iBehaviors;
        }
    }

    public static EObject findType(VarRef reference, IBehaviors semantics) {
        BehavioredClass enclosingClass = TypeUtils.enclosingBehavioredClass((EObject)reference);
        String _iD = reference.getID();
        boolean _equals = Objects.equal((Object)_iD, (Object)"self");
        if (_equals) {
            BehavioredClass referenceType = enclosingClass;
            return TypeUtils.semanticAlterEgo(referenceType, semantics);
        }
        Operation operation = TypeUtils.enclosingMethod((EObject)reference);
        Functions.Function1 _function = ext -> {
            String _name = enclosingClass.getName();
            String _name_1 = enclosingClass.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        };
        Functions.Function1 _function_1 = m -> TypeUtils.matches(m, operation);
        Method method = (Method)IterableExtensions.findFirst((Iterable)((org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)semantics.getOpenClasses(), (Functions.Function1)_function)).getMethods(), (Functions.Function1)_function_1);
        ENamedElement inferredType = TypeUtils.typeOf(method, reference);
        return TypeUtils.semanticAlterEgo(inferredType, semantics);
    }

    private static BehavioredClass enclosingBehavioredClass(EObject element) {
        EObject clazz = element.eContainer();
        while (!(clazz instanceof BehavioredClass) && clazz != null) {
            clazz = clazz.eContainer();
        }
        return (BehavioredClass)clazz;
    }

    private static Operation enclosingMethod(EObject element) {
        EObject clazz = element.eContainer();
        while (!(clazz instanceof Operation) && clazz != null) {
            clazz = clazz.eContainer();
        }
        return (Operation)clazz;
    }

    private static ENamedElement typeOf(Method method, VarRef ref) {
        EList _eParameters = method.getOperationRef().getEParameters();
        for (EParameter param : _eParameters) {
            String _iD;
            String _name = param.getName();
            boolean _equals = Objects.equal((Object)_name, (Object)(_iD = ref.getID()));
            if (!_equals) continue;
            return param.getEType();
        }
        EList _statements = method.getBody().getStatements();
        for (Statement statement : _statements) {
            if (!(statement instanceof VariableDeclaration)) continue;
            VariableDeclaration decl = (VariableDeclaration)statement;
            return decl.getType();
        }
        return null;
    }

    private static boolean matches(Method method, Operation operation) {
        int _size_1;
        boolean _notEquals_1;
        String _name_1;
        boolean _notEquals;
        String _name = method.getOperationRef().getName();
        boolean bl = _notEquals = !Objects.equal((Object)_name, (Object)(_name_1 = operation.getName()));
        if (_notEquals) {
            return false;
        }
        int _size = method.getOperationRef().getEParameters().size();
        boolean bl2 = _notEquals_1 = _size != (_size_1 = operation.getParams().size());
        return !_notEquals_1;
    }

    private static EObject semanticAlterEgo(BehavioredClass syntacticalClass, IBehaviors semantics) {
        if (syntacticalClass instanceof ExtendedClass) {
            Functions.Function1 _function = root -> root.getClassExtensions();
            Functions.Function1 _function_1 = behavior -> {
                String _name = behavior.getBaseClass().getName();
                String _name_1 = ((ExtendedClass)syntacticalClass).getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass correspondingOpenClass = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap((Iterable)semantics.getUnits(), (Functions.Function1)_function), (Functions.Function1)_function_1);
            if (correspondingOpenClass != null) {
                return correspondingOpenClass;
            }
        }
        Functions.Function1 _function_2 = behavior -> {
            String _name = behavior.getName();
            String _name_1 = syntacticalClass.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        };
        RuntimeClass correspondingRuntimeClass = (RuntimeClass)IterableExtensions.findFirst((Iterable)semantics.getRuntimeClasses(), (Functions.Function1)_function_2);
        if (correspondingRuntimeClass != null) {
            return correspondingRuntimeClass;
        }
        return syntacticalClass;
    }

    private static ENamedElement semanticAlterEgo(ENamedElement syntacticalElement, IBehaviors semantics) {
        Object _xifexpression = null;
        _xifexpression = syntacticalElement instanceof ETypedElement ? ((ETypedElement)syntacticalElement).getEType() : syntacticalElement;
        ENamedElement syntacticalClass = _xifexpression;
        Functions.Function1 _function = root -> root.getClassExtensions();
        Functions.Function1 _function_1 = behavior -> EcoreUtil.equals((EObject)behavior.getBaseClass(), (EObject)syntacticalClass);
        org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass correspondingOpenClass = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)IterableExtensions.flatMap((Iterable)semantics.getUnits(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (correspondingOpenClass != null) {
            return correspondingOpenClass;
        }
        Functions.Function1 _function_2 = behavior -> {
            String _name = behavior.getName();
            String _name_1 = syntacticalClass.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        };
        RuntimeClass correspondingRuntimeClass = (RuntimeClass)IterableExtensions.findFirst((Iterable)semantics.getRuntimeClasses(), (Functions.Function1)_function_2);
        if (correspondingRuntimeClass != null) {
            return correspondingRuntimeClass;
        }
        return syntacticalClass;
    }

    public static String asString(rType type) {
        if (type instanceof ClassifierType) {
            return ((ClassifierType)type).getClassName();
        }
        if (type instanceof SetType) {
            String _asString = TypeUtils.asString((rType)((SetType)type).getType());
            String _plus = "Set(" + _asString;
            return String.valueOf(_plus) + ")";
        }
        if (type instanceof SeqType) {
            String _asString_1 = TypeUtils.asString((rType)((SeqType)type).getType());
            String _plus_1 = "Sequence(" + _asString_1;
            return String.valueOf(_plus_1) + ")";
        }
        if (type instanceof StringType) {
            return "EString";
        }
        if (type instanceof BoolType) {
            return "EBoolean";
        }
        if (type instanceof IntType) {
            return "EInteger";
        }
        if (type instanceof RealType) {
            return "EDouble";
        }
        if (type instanceof typeLiteral) {
            return ((typeLiteral)type).eClass().getName();
        }
        return type.getName();
    }

    public static String typeAsString(ETypedElement feature) {
        boolean _isMany = feature.isMany();
        if (_isMany) {
            boolean _isUnique = feature.isUnique();
            if (_isUnique) {
                String _asString = TypeUtils.asString(feature.getEType());
                String _plus = "Set(" + _asString;
                return String.valueOf(_plus) + ")";
            }
            String _asString_1 = TypeUtils.asString(feature.getEType());
            String _plus_1 = "Sequence(" + _asString_1;
            return String.valueOf(_plus_1) + ")";
        }
        return TypeUtils.asString(feature.getEType());
    }

    public static String asString(EClassifier type) {
        if (type == null) {
            return "void";
        }
        return type.getName();
    }
}

