/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.TaskLogger;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.tools.ajc.Main;
import org.aspectj.tools.ant.taskdefs.ICommandEditor;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;

public class AjcTask
extends MatchingTask {
    private static final int MAX_COMMANDLINE = 4096;
    private static final File DEFAULT_DESTDIR = new File("."){

        @Override
        public String toString() {
            return "(no destination dir specified)";
        }
    };
    private static final String USAGE_SUBSTRING = "AspectJ-specific options";
    private static final List VALID_XOPTIONS;
    private static final List VALID_WARNINGS;
    private static final List VALID_DEBUG;
    private static final List VALID_XLINT;
    public static final String COMMAND_EDITOR_NAME;
    static final String[] TARGET_INPUTS;
    static final String[] SOURCE_INPUTS;
    static final String[] COMPLIANCE_INPUTS;
    private static final ICommandEditor COMMAND_EDITOR;
    private boolean verbose;
    private boolean timers;
    private boolean listFileArgs;
    private boolean failonerror;
    private boolean fork;
    private String maxMem;
    private TaskLogger logger;
    protected GuardedCommand cmd;
    private Path srcdir;
    private Path injars;
    private Path inpath;
    private Path classpath;
    private Path bootclasspath;
    private Path forkclasspath;
    private Path extdirs;
    private Path aspectpath;
    private Path argfiles;
    private Path inxmlfiles;
    private List ignored;
    private Path sourceRoots;
    private File xweaveDir;
    private String xdoneSignal;
    private List<CompilerArg> compilerArgs;
    private List adapterFiles;
    private String[] adapterArguments;
    private IMessageHolder messageHolder;
    private ICommandEditor commandEditor;
    private boolean copyInjars;
    private boolean copyInpath;
    private String sourceRootCopyFilter;
    private String inpathDirCopyFilter;
    private File destDir;
    private File outjar;
    private boolean outjarFixedup;
    private File tmpOutjar;
    private boolean executing;
    private Main main;
    private boolean executingInOtherVM;
    private boolean inIncrementalMode;
    private boolean inIncrementalFileMode;
    private boolean logCommand;
    private CommandlineJava javaCmd = new CommandlineJava();

    public String setupAjc(Javac javac) {
        if (null == javac) {
            return "null javac";
        }
        AjcTask ajc = this;
        ajc.setProject(javac.getProject());
        ajc.setLocation(javac.getLocation());
        ajc.setTaskName("javac-iajc");
        ajc.setDebug(javac.getDebug());
        ajc.setDeprecation(javac.getDeprecation());
        ajc.setFailonerror(javac.getFailonerror());
        boolean fork = javac.isForkedJavac();
        ajc.setFork(fork);
        if (fork) {
            ajc.setMaxmem(javac.getMemoryMaximumSize());
        }
        ajc.setNowarn(javac.getNowarn());
        ajc.setListFileArgs(javac.getListfiles());
        ajc.setVerbose(javac.getVerbose());
        ajc.setTarget(javac.getTarget());
        ajc.setSource(javac.getSource());
        ajc.setEncoding(javac.getEncoding());
        File javacDestDir = javac.getDestdir();
        if (null != javacDestDir) {
            ajc.setDestdir(javacDestDir);
            ajc.setSourceRootCopyFilter("**/CVS/*,**/*.java,**/*.aj");
        }
        ajc.setBootclasspath(javac.getBootclasspath());
        ajc.setExtdirs(javac.getExtdirs());
        ajc.setClasspath(javac.getClasspath());
        ajc.addFiles(javac.getFileList());
        ajc.readArguments(javac.getCurrentCompilerArgs());
        return null;
    }

    public static File findAspectjtoolsJar() {
        File result = null;
        ClassLoader loader = AjcTask.class.getClassLoader();
        if (loader instanceof AntClassLoader) {
            AntClassLoader taskLoader = (AntClassLoader)loader;
            String cp = taskLoader.getClasspath();
            String[] cps = LangUtil.splitClasspath((String)cp);
            for (int i = 0; i < cps.length && null == result; ++i) {
                result = AjcTask.isAspectjtoolsjar(cps[i]);
            }
        }
        if (null == result) {
            Path classpath = Path.systemClasspath;
            String[] paths = classpath.list();
            for (int i = 0; i < paths.length && null == result; ++i) {
                result = AjcTask.isAspectjtoolsjar(paths[i]);
            }
        }
        return null == result ? null : result.getAbsoluteFile();
    }

    private static File isAspectjtoolsjar(String path) {
        if (null == path) {
            return null;
        }
        String prefix = "aspectj";
        String infix = "tools";
        String altInfix = "-tools";
        String suffix = ".jar";
        int prefixLength = 7;
        int minLength = 16;
        if (!path.endsWith(".jar")) {
            return null;
        }
        int loc = path.lastIndexOf("aspectj");
        if (-1 != loc && loc + 16 <= path.length()) {
            File result;
            String rest = path.substring(loc + 7);
            if (-1 != rest.indexOf(File.pathSeparator)) {
                return null;
            }
            if ((rest.startsWith("tools") || rest.startsWith("-tools")) && (result = new File(path)).canRead() && result.isFile()) {
                return result;
            }
        }
        return null;
    }

    public AjcTask() {
        this.reset();
    }

    public void reset() {
        this.adapterArguments = null;
        this.adapterFiles = new ArrayList();
        this.compilerArgs = null;
        this.argfiles = null;
        this.inxmlfiles = null;
        this.executing = false;
        this.aspectpath = null;
        this.bootclasspath = null;
        this.classpath = null;
        this.cmd = new GuardedCommand();
        this.copyInjars = false;
        this.copyInpath = false;
        this.destDir = DEFAULT_DESTDIR;
        this.executing = false;
        this.executingInOtherVM = false;
        this.extdirs = null;
        this.failonerror = true;
        this.forkclasspath = null;
        this.inIncrementalMode = false;
        this.inIncrementalFileMode = false;
        this.ignored = new ArrayList();
        this.injars = null;
        this.inpath = null;
        this.listFileArgs = false;
        this.maxMem = null;
        this.messageHolder = null;
        this.outjar = null;
        this.sourceRootCopyFilter = null;
        this.inpathDirCopyFilter = null;
        this.sourceRoots = null;
        this.srcdir = null;
        this.tmpOutjar = null;
        this.verbose = false;
        this.timers = false;
        this.xweaveDir = null;
        this.xdoneSignal = null;
        this.logCommand = false;
        this.javaCmd = new CommandlineJava();
    }

    protected void ignore(String ignored) {
        this.ignored.add(ignored + " at " + this.getLocation());
    }

    protected String validCommaList(String list, List valid, String label) {
        return this.validCommaList(list, valid, label, valid.size());
    }

    protected String validCommaList(String list, List valid, String label, int max) {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(list, ",");
        int num = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (++num > max) {
                this.ignore("too many entries for -" + label + ": " + token);
                break;
            }
            if (!valid.contains(token)) {
                this.ignore("bad commaList entry for -" + label + ": " + token);
                continue;
            }
            if (0 < result.length()) {
                result.append(",");
            }
            result.append(token);
        }
        return 0 == result.length() ? null : result.toString();
    }

    public void setProc(String proc) {
        if (proc.equals("none")) {
            this.cmd.addFlag("-proc:none", true);
        } else if (proc.equals("only")) {
            this.cmd.addFlag("-proc:only", true);
        }
    }

    public void setProcessor(String processors) {
        this.cmd.addFlagged("-processor", processors);
    }

    public void setProcessorpath(String processorpath) {
        this.cmd.addFlagged("-processorpath", processorpath);
    }

    public void setS(String s) {
        this.cmd.addFlagged("-s", s);
    }

    public void setIncremental(boolean incremental) {
        this.cmd.addFlag("-incremental", incremental);
        this.inIncrementalMode = incremental;
    }

    public void setLogCommand(boolean logCommand) {
        this.logCommand = logCommand;
    }

    public void setHelp(boolean help) {
        this.cmd.addFlag("-help", help);
    }

    public void setVersion(boolean version) {
        this.cmd.addFlag("-version", version);
    }

    public void setXTerminateAfterCompilation(boolean b) {
        this.cmd.addFlag("-XterminateAfterCompilation", b);
    }

    public void setXReweavable(boolean reweavable) {
        this.cmd.addFlag("-Xreweavable", reweavable);
    }

    public void setXmlConfigured(boolean xmlConfigured) {
        this.cmd.addFlag("-xmlConfigured", xmlConfigured);
    }

    public void setXJoinpoints(String optionalJoinpoints) {
        this.cmd.addFlag("-Xjoinpoints:" + optionalJoinpoints, true);
    }

    public void setCheckRuntimeVersion(boolean b) {
        this.cmd.addFlag("-checkRuntimeVersion:" + b, true);
    }

    public void setXNoWeave(boolean b) {
        if (this.logger != null) {
            this.logger.warning("the noweave option is no longer required and is being ignored");
        }
    }

    public void setNoWeave(boolean b) {
        if (this.logger != null) {
            this.logger.warning("the noweave option is no longer required and is being ignored");
        }
    }

    public void setXNotReweavable(boolean notReweavable) {
        this.cmd.addFlag("-XnotReweavable", notReweavable);
    }

    public void setXaddSerialVersionUID(boolean addUID) {
        this.cmd.addFlag("-XaddSerialVersionUID", addUID);
    }

    public void setXNoInline(boolean noInline) {
        this.cmd.addFlag("-XnoInline", noInline);
    }

    public void setShowWeaveInfo(boolean showweaveinfo) {
        this.cmd.addFlag("-showWeaveInfo", showweaveinfo);
    }

    public void setNowarn(boolean nowarn) {
        this.cmd.addFlag("-nowarn", nowarn);
    }

    public void setDeprecation(boolean deprecation) {
        this.cmd.addFlag("-deprecation", deprecation);
    }

    public void setWarn(String warnings) {
        warnings = this.validCommaList(warnings, VALID_WARNINGS, "warn");
        this.cmd.addFlag("-warn:" + warnings, null != warnings);
    }

    public void setDebug(boolean debug) {
        this.cmd.addFlag("-g", debug);
    }

    public void setDebugLevel(String level) {
        level = this.validCommaList(level, VALID_DEBUG, "g");
        this.cmd.addFlag("-g:" + level, null != level);
    }

    public void setEmacssym(boolean emacssym) {
        this.cmd.addFlag("-emacssym", emacssym);
    }

    public void setCrossrefs(boolean on) {
        this.cmd.addFlag("-crossrefs", on);
    }

    public void setXlintwarnings(boolean xlintwarnings) {
        this.cmd.addFlag("-Xlint", xlintwarnings);
    }

    public void setXlint(String xlint) {
        xlint = this.validCommaList(xlint, VALID_XLINT, "Xlint", 1);
        this.cmd.addFlag("-Xlint:" + xlint, null != xlint);
    }

    public void setXlintfile(File xlintFile) {
        this.cmd.addFlagged("-Xlintfile", xlintFile.getAbsolutePath());
    }

    public void setPreserveAllLocals(boolean preserveAllLocals) {
        this.cmd.addFlag("-preserveAllLocals", preserveAllLocals);
    }

    public void setNoImportError(boolean noImportError) {
        this.cmd.addFlag("-warn:-unusedImport", noImportError);
    }

    public void setEncoding(String encoding) {
        this.cmd.addFlagged("-encoding", encoding);
    }

    public void setLog(File file) {
        this.cmd.addFlagged("-log", file.getAbsolutePath());
    }

    public void setProceedOnError(boolean proceedOnError) {
        this.cmd.addFlag("-proceedOnError", proceedOnError);
    }

    public void setVerbose(boolean verbose) {
        this.cmd.addFlag("-verbose", verbose);
        this.verbose = verbose;
    }

    public void setTimers(boolean timers) {
        this.cmd.addFlag("-timers", timers);
        this.timers = timers;
    }

    public void setListFileArgs(boolean listFileArgs) {
        this.listFileArgs = listFileArgs;
    }

    public void setReferenceInfo(boolean referenceInfo) {
        this.cmd.addFlag("-referenceInfo", referenceInfo);
    }

    public void setTime(boolean time) {
        this.cmd.addFlag("-time", time);
    }

    public void setNoExit(boolean noExit) {
        this.cmd.addFlag("-noExit", noExit);
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public boolean isForked() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setMaxmem(String maxMem) {
        this.maxMem = maxMem;
    }

    public Commandline.Argument createJvmarg() {
        return this.javaCmd.createVmArgument();
    }

    public CompilerArg createCompilerarg() {
        CompilerArg compilerArg = new CompilerArg();
        if (this.compilerArgs == null) {
            this.compilerArgs = new ArrayList<CompilerArg>();
        }
        this.compilerArgs.add(compilerArg);
        return compilerArg;
    }

    public void setTagFile(File file) {
        this.inIncrementalMode = true;
        this.cmd.addFlagged(Main.CommandController.TAG_FILE_OPTION, file.getAbsolutePath());
        this.inIncrementalFileMode = true;
    }

    public void setOutjar(File file) {
        if (DEFAULT_DESTDIR != this.destDir) {
            String e = "specifying both output jar (" + file + ") and destination dir (" + this.destDir + ")";
            throw new BuildException(e);
        }
        this.outjar = file;
        this.outjarFixedup = false;
        this.tmpOutjar = null;
    }

    public void setOutxml(boolean outxml) {
        this.cmd.addFlag("-outxml", outxml);
    }

    public void setOutxmlfile(String name) {
        this.cmd.addFlagged("-outxmlfile", name);
    }

    public void setDestdir(File dir) {
        if (null != this.outjar) {
            String e = "specifying both output jar (" + this.outjar + ") and destination dir (" + dir + ")";
            throw new BuildException(e);
        }
        this.cmd.addFlagged("-d", dir.getAbsolutePath());
        this.destDir = dir;
    }

    public void setTarget(String input) {
        String ignore = this.cmd.addOption("-target", TARGET_INPUTS, input);
        if (null != ignore) {
            this.ignore(ignore);
        }
    }

    public void setCompliance(String input) {
        String ignore = this.cmd.addOption(null, COMPLIANCE_INPUTS, input);
        if (null != ignore) {
            this.ignore(ignore);
        }
    }

    public void setSource(String input) {
        String ignore = this.cmd.addOption("-source", SOURCE_INPUTS, input);
        if (null != ignore) {
            this.ignore(ignore);
        }
    }

    public void setParameters(boolean b) {
        this.cmd.addFlag("-parameters", b);
    }

    public void setCopyInjars(boolean doCopy) {
        this.ignore("copyInJars");
        this.log("copyInjars not required since 1.1.1.\n", 1);
    }

    public void setSourceRootCopyFilter(String filter) {
        this.sourceRootCopyFilter = filter;
    }

    public void setInpathDirCopyFilter(String filter) {
        if (null != filter && -1 == filter.indexOf("**/*.class")) {
            filter = "**/*.class," + filter;
        }
        this.inpathDirCopyFilter = filter;
    }

    public void setX(String input) {
        StringTokenizer tokens = new StringTokenizer(input, ",", false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (1 >= token.length()) continue;
            if (VALID_XOPTIONS.contains(token) || token.indexOf("set:") == 0 || token.indexOf("joinpoints:") == 0) {
                this.cmd.addFlag("-X" + token, true);
                continue;
            }
            this.ignore("-X" + token);
        }
    }

    public void setXDoneSignal(String doneSignal) {
        this.xdoneSignal = doneSignal;
    }

    public void setMessageHolder(IMessageHolder holder) {
        this.messageHolder = holder;
    }

    public void setMessageHolderClass(String className) {
        try {
            Class<?> mclass = Class.forName(className);
            IMessageHolder holder = (IMessageHolder)mclass.newInstance();
            this.setMessageHolder(holder);
        }
        catch (Throwable t) {
            String m = "unable to instantiate message holder: " + className;
            throw new BuildException(m, t);
        }
    }

    public void setCommandEditor(ICommandEditor editor) {
        this.commandEditor = editor;
    }

    public void setCommandEditorClass(String className) {
        try {
            Class<?> mclass = Class.forName(className);
            this.setCommandEditor((ICommandEditor)mclass.newInstance());
        }
        catch (Throwable t) {
            String m = "unable to instantiate command editor: " + className;
            throw new BuildException(m, t);
        }
    }

    protected Path incPath(Path source, Path toAdd) {
        if (null == source) {
            source = new Path(this.project);
        }
        if (null != toAdd) {
            source.append(toAdd);
        }
        return source;
    }

    public void setSourcerootsref(Reference ref) {
        this.createSourceRoots().setRefid(ref);
    }

    public void setSourceRoots(Path roots) {
        this.sourceRoots = this.incPath(this.sourceRoots, roots);
    }

    public Path createSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new Path(this.project);
        }
        return this.sourceRoots.createPath();
    }

    public void setXWeaveDir(File file) {
        if (null != file && file.isDirectory() && file.canRead()) {
            this.xweaveDir = file;
        }
    }

    public void setInjarsref(Reference ref) {
        this.createInjars().setRefid(ref);
    }

    public void setInpathref(Reference ref) {
        this.createInpath().setRefid(ref);
    }

    public void setInjars(Path path) {
        this.injars = this.incPath(this.injars, path);
    }

    public void setInpath(Path path) {
        this.inpath = this.incPath(this.inpath, path);
    }

    public Path createInjars() {
        if (this.injars == null) {
            this.injars = new Path(this.project);
        }
        return this.injars.createPath();
    }

    public Path createInpath() {
        if (this.inpath == null) {
            this.inpath = new Path(this.project);
        }
        return this.inpath.createPath();
    }

    public void setClasspath(Path path) {
        this.classpath = this.incPath(this.classpath, path);
    }

    public void setClasspathref(Reference classpathref) {
        this.createClasspath().setRefid(classpathref);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setBootclasspath(Path path) {
        this.bootclasspath = this.incPath(this.bootclasspath, path);
    }

    public void setBootclasspathref(Reference bootclasspathref) {
        this.createBootclasspath().setRefid(bootclasspathref);
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public void setForkclasspath(Path path) {
        this.forkclasspath = this.incPath(this.forkclasspath, path);
    }

    public void setForkclasspathref(Reference forkclasspathref) {
        this.createForkclasspath().setRefid(forkclasspathref);
    }

    public Path createForkclasspath() {
        if (this.forkclasspath == null) {
            this.forkclasspath = new Path(this.project);
        }
        return this.forkclasspath.createPath();
    }

    public void setExtdirs(Path path) {
        this.extdirs = this.incPath(this.extdirs, path);
    }

    public void setExtdirsref(Reference ref) {
        this.createExtdirs().setRefid(ref);
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.project);
        }
        return this.extdirs.createPath();
    }

    public void setAspectpathref(Reference ref) {
        this.createAspectpath().setRefid(ref);
    }

    public void setAspectpath(Path path) {
        this.aspectpath = this.incPath(this.aspectpath, path);
    }

    public Path createAspectpath() {
        if (this.aspectpath == null) {
            this.aspectpath = new Path(this.project);
        }
        return this.aspectpath.createPath();
    }

    public void setSrcDir(Path path) {
        this.srcdir = this.incPath(this.srcdir, path);
    }

    public Path createSrc() {
        return this.createSrcdir();
    }

    public Path createSrcdir() {
        if (this.srcdir == null) {
            this.srcdir = new Path(this.project);
        }
        return this.srcdir.createPath();
    }

    public boolean isInIncrementalMode() {
        return this.inIncrementalMode;
    }

    public boolean isInIncrementalFileMode() {
        return this.inIncrementalFileMode;
    }

    public void setArgfilesref(Reference ref) {
        this.createArgfiles().setRefid(ref);
    }

    public void setArgfiles(Path path) {
        this.argfiles = this.incPath(this.argfiles, path);
    }

    public Path createArgfiles() {
        if (this.argfiles == null) {
            this.argfiles = new Path(this.project);
        }
        return this.argfiles.createPath();
    }

    public void setInxmlref(Reference ref) {
        this.createArgfiles().setRefid(ref);
    }

    public void setInxml(Path path) {
        this.inxmlfiles = this.incPath(this.inxmlfiles, path);
    }

    public Path createInxml() {
        if (this.inxmlfiles == null) {
            this.inxmlfiles = new Path(this.project);
        }
        return this.inxmlfiles.createPath();
    }

    public void execute() throws BuildException {
        this.logger = new TaskLogger((Task)this);
        if (this.executing) {
            throw new IllegalStateException("already executing");
        }
        this.executing = true;
        this.setupOptions();
        this.verifyOptions();
        try {
            String[] args = this.makeCommand();
            if (this.logCommand) {
                this.log("ajc " + Arrays.asList(args));
            } else {
                this.logVerbose("ajc " + Arrays.asList(args));
            }
            if (!this.fork) {
                this.executeInSameVM(args);
            } else {
                this.executeInOtherVM(args);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Throwable x) {
            this.logger.error(Main.renderExceptionForUser(x));
            throw new BuildException("IGNORE -- See " + LangUtil.unqualifiedClassName((Object)x) + " rendered to ant logger");
        }
        finally {
            this.executing = false;
            if (null != this.tmpOutjar) {
                this.tmpOutjar.delete();
            }
        }
    }

    public boolean quit() {
        if (this.executingInOtherVM) {
            return false;
        }
        Main me = this.main;
        if (null != me) {
            me.quit();
        }
        return true;
    }

    String[] makeCommand() {
        ArrayList<String> result = new ArrayList<String>();
        if (0 < this.ignored.size()) {
            Iterator iter = this.ignored.iterator();
            while (iter.hasNext()) {
                this.logVerbose("ignored: " + iter.next());
            }
        }
        if (null != this.outjar && !this.outjarFixedup) {
            if (this.copyInjars || this.copyInpath || null != this.sourceRootCopyFilter || null != this.inpathDirCopyFilter) {
                String path = this.outjar.getAbsolutePath();
                int len = FileUtil.zipSuffixLength((String)path);
                path = path.substring(0, path.length() - len) + ".tmp.jar";
                this.tmpOutjar = new File(path);
            }
            if (null == this.tmpOutjar) {
                this.cmd.addFlagged("-outjar", this.outjar.getAbsolutePath());
            } else {
                this.cmd.addFlagged("-outjar", this.tmpOutjar.getAbsolutePath());
            }
            this.outjarFixedup = true;
        }
        result.addAll(this.cmd.extractArguments());
        this.addListArgs(result);
        String[] command = result.toArray(new String[0]);
        if (null != this.commandEditor) {
            command = this.commandEditor.editCommand(command);
        } else if (null != COMMAND_EDITOR) {
            command = COMMAND_EDITOR.editCommand(command);
        }
        return command;
    }

    protected void setupOptions() {
        if (null != this.xweaveDir) {
            if (DEFAULT_DESTDIR != this.destDir) {
                throw new BuildException("weaveDir forces destdir");
            }
            if (null != this.outjar) {
                throw new BuildException("weaveDir forces outjar");
            }
            if (null != this.injars) {
                throw new BuildException("weaveDir incompatible with injars now");
            }
            if (null != this.inpath) {
                throw new BuildException("weaveDir incompatible with inpath now");
            }
            File injar = this.zipDirectory(this.xweaveDir);
            this.setInjars(new Path(this.getProject(), injar.getAbsolutePath()));
            this.setDestdir(this.xweaveDir);
        }
    }

    protected File zipDirectory(File dir) {
        File tempDir = new File(".");
        try {
            tempDir = File.createTempFile("AjcTest", ".tmp");
            tempDir.mkdirs();
            tempDir.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String filename = "AjcTask-" + System.currentTimeMillis() + ".zip";
        File result = new File(filename);
        Zip zip = new Zip();
        zip.setProject(this.getProject());
        zip.setDestFile(result);
        zip.setTaskName(this.getTaskName() + " - zip");
        FileSet fileset = new FileSet();
        fileset.setDir(dir);
        zip.addFileset(fileset);
        zip.execute();
        Delete delete = new Delete();
        delete.setProject(this.getProject());
        delete.setTaskName(this.getTaskName() + " - delete");
        delete.setDir(dir);
        delete.execute();
        Mkdir mkdir = new Mkdir();
        mkdir.setProject(this.getProject());
        mkdir.setTaskName(this.getTaskName() + " - mkdir");
        mkdir.setDir(dir);
        mkdir.execute();
        return result;
    }

    protected void verifyOptions() {
        StringBuffer sb = new StringBuffer();
        if (this.fork && this.isInIncrementalMode() && !this.isInIncrementalFileMode()) {
            sb.append("can fork incremental only using tag file.\n");
        }
        if ((null != this.inpathDirCopyFilter || null != this.sourceRootCopyFilter) && null == this.outjar && DEFAULT_DESTDIR == this.destDir) {
            String REQ = " requires dest dir or output jar.\n";
            if (null == this.inpathDirCopyFilter) {
                sb.append("sourceRootCopyFilter");
            } else if (null == this.sourceRootCopyFilter) {
                sb.append("inpathDirCopyFilter");
            } else {
                sb.append("sourceRootCopyFilter and inpathDirCopyFilter");
            }
            sb.append(" requires dest dir or output jar.\n");
        }
        if (0 < sb.length()) {
            throw new BuildException(sb.toString());
        }
    }

    protected void executeInSameVM(String[] args) {
        Object[] fails;
        int numPreviousErrors;
        IMessageHolder holder;
        if (null != this.maxMem) {
            this.log("maxMem ignored unless forked: " + this.maxMem, 1);
        }
        if (null == (holder = this.messageHolder)) {
            MessageHandler mhandler = new MessageHandler(true);
            AntMessageHandler delegate = new AntMessageHandler(this.logger, this.verbose, false);
            mhandler.setInterceptor((IMessageHandler)delegate);
            holder = mhandler;
            numPreviousErrors = 0;
        } else {
            numPreviousErrors = holder.numMessages(IMessage.ERROR, true);
        }
        Main newmain = new Main();
        newmain.setHolder(holder);
        newmain.setCompletionRunner(new Runnable(){

            @Override
            public void run() {
                AjcTask.this.doCompletionTasks();
            }
        });
        if (null != this.main) {
            MessageUtil.fail((IMessageHandler)holder, (String)"still running prior main");
            return;
        }
        this.main = newmain;
        this.main.runMain(args, false);
        if (this.failonerror) {
            int errs = holder.numMessages(IMessage.ERROR, false);
            if (0 < (errs -= numPreviousErrors)) {
                String m = errs + " errors";
                MessageUtil.print((PrintStream)System.err, (IMessageHolder)holder, (String)"", (MessageUtil.IMessageRenderer)MessageUtil.MESSAGE_ALL, (IMessageHandler)MessageUtil.PICK_ERROR, (boolean)true);
                throw new BuildException(m);
            }
        }
        if (!LangUtil.isEmpty((Object[])(fails = holder.getMessages(IMessage.FAIL, true)))) {
            StringBuffer sb = new StringBuffer();
            String prefix = "fail due to ";
            int numThrown = 0;
            for (Object fail : fails) {
                String message = fail.getMessage();
                if (LangUtil.isEmpty((String)message)) {
                    message = "<no message>";
                } else if (-1 != message.indexOf(USAGE_SUBSTRING)) continue;
                Throwable t = fail.getThrown();
                if (null != t) {
                    ++numThrown;
                    sb.append(prefix);
                    sb.append(LangUtil.unqualifiedClassName(t.getClass()));
                    String thrownMessage = t.getMessage();
                    if (!LangUtil.isEmpty((String)thrownMessage)) {
                        sb.append(" \"" + thrownMessage + "\"");
                    }
                }
                sb.append("\"" + message + "\"");
                prefix = ", ";
            }
            if (0 < sb.length()) {
                sb.append(" (" + numThrown + " exceptions)");
                throw new BuildException(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeInOtherVM(String[] args) {
        this.javaCmd.setClassname(Main.class.getName());
        Path vmClasspath = this.javaCmd.createClasspath(this.getProject());
        File aspectjtools = null;
        int vmClasspathSize = vmClasspath.size();
        if (null != this.forkclasspath && 0 != this.forkclasspath.size()) {
            vmClasspath.addExisting(this.forkclasspath);
        } else {
            aspectjtools = AjcTask.findAspectjtoolsJar();
            if (null != aspectjtools) {
                vmClasspath.createPathElement().setLocation(aspectjtools);
            }
        }
        int newVmClasspathSize = vmClasspath.size();
        if (vmClasspathSize == newVmClasspathSize) {
            String m = "unable to find aspectjtools to fork - ";
            m = null != aspectjtools ? m + "tried " + aspectjtools.toString() : (null != this.forkclasspath ? m + "tried " + this.forkclasspath.toString() : m + "define forkclasspath or put aspectjtools on classpath");
            throw new BuildException(m);
        }
        if (null != this.maxMem) {
            this.javaCmd.setMaxmemory(this.maxMem);
        }
        File tempFile = null;
        int numArgs = args.length;
        if ((args = GuardedCommand.limitTo(args, 4096, this.getLocation())).length != numArgs) {
            tempFile = new File(args[1]);
        }
        try {
            boolean setMessageHolderOnForking = this.messageHolder != null;
            String[] javaArgs = this.javaCmd.getCommandline();
            String[] both = new String[javaArgs.length + args.length + (setMessageHolderOnForking ? 2 : 0)];
            System.arraycopy(javaArgs, 0, both, 0, javaArgs.length);
            System.arraycopy(args, 0, both, javaArgs.length, args.length);
            if (setMessageHolderOnForking) {
                both[both.length - 2] = "-messageHolder";
                both[both.length - 1] = this.messageHolder.getClass().getName();
            }
            if (both[0].endsWith("java.exe")) {
                String path = both[0];
                path = path.substring(0, path.length() - 4);
                File javaw = new File(path = path + "w.exe");
                if (javaw.canRead() && javaw.isFile()) {
                    both[0] = path;
                }
            }
            this.logVerbose("forking " + Arrays.asList(both));
            int result = this.execInOtherVM(both);
            if (0 > result) {
                throw new BuildException("failure[" + result + "] running ajc");
            }
            if (this.failonerror && 0 < result) {
                throw new BuildException("compile errors: " + result);
            }
            this.doCompletionTasks();
        }
        finally {
            if (null != tempFile) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execInOtherVM(String[] args) {
        try {
            Project project = this.getProject();
            LogStreamHandler handler = new LogStreamHandler((Task)this, this.verbose ? 3 : 2, 1);
            Execute exe = new Execute((ExecuteStreamHandler)handler);
            exe.setAntRun(project);
            exe.setWorkingDirectory(project.getBaseDir());
            exe.setCommandline(args);
            try {
                if (this.executingInOtherVM) {
                    String s = "already running in other vm?";
                    throw new BuildException(s, this.location);
                }
                this.executingInOtherVM = true;
                exe.execute();
            }
            finally {
                this.executingInOtherVM = false;
            }
            return exe.getExitValue();
        }
        catch (IOException e) {
            String m = "Error executing command " + Arrays.asList(args);
            throw new BuildException(m, (Throwable)e, this.location);
        }
    }

    protected static void addFlaggedPath(String flag, Path path, List<String> list) {
        if (!LangUtil.isEmpty((String)flag) && null != path && 0 < path.size()) {
            list.add(flag);
            list.add(path.toString());
        }
    }

    protected void addListArgs(List<String> list) throws BuildException {
        String[] files;
        AjcTask.addFlaggedPath("-classpath", this.classpath, list);
        AjcTask.addFlaggedPath("-bootclasspath", this.bootclasspath, list);
        AjcTask.addFlaggedPath("-extdirs", this.extdirs, list);
        AjcTask.addFlaggedPath("-aspectpath", this.aspectpath, list);
        AjcTask.addFlaggedPath("-injars", this.injars, list);
        AjcTask.addFlaggedPath("-inpath", this.inpath, list);
        AjcTask.addFlaggedPath("-sourceroots", this.sourceRoots, list);
        if (this.compilerArgs != null) {
            for (CompilerArg compilerArg : this.compilerArgs) {
                list.add(compilerArg.toString());
            }
        }
        if (this.argfiles != null) {
            for (String string : files = this.argfiles.list()) {
                File argfile = this.project.resolveFile(string);
                if (!this.check(argfile, string, false, this.location)) continue;
                list.add("-argfile");
                list.add(argfile.getAbsolutePath());
            }
        }
        if (this.inxmlfiles != null) {
            for (String string : files = this.inxmlfiles.list()) {
                File inxmlfile = this.project.resolveFile(string);
                if (!this.check(inxmlfile, string, false, this.location)) continue;
                list.add("-xmlConfigured");
                list.add(inxmlfile.getAbsolutePath());
            }
        }
        if (this.srcdir != null) {
            String[] dirs;
            for (String string : dirs = this.srcdir.list()) {
                String[] files2;
                File dir = this.project.resolveFile(string);
                this.check(dir, string, true, this.location);
                for (String file2 : files2 = this.getDirectoryScanner(dir).getIncludedFiles()) {
                    File file = new File(dir, file2);
                    if (!FileUtil.hasSourceSuffix((File)file) || list.contains(file.getAbsolutePath())) continue;
                    list.add(file.getAbsolutePath());
                }
            }
        }
        if (0 < this.adapterFiles.size()) {
            for (File file : this.adapterFiles) {
                if (file.canRead() && FileUtil.hasSourceSuffix((File)file)) {
                    list.add(file.getAbsolutePath());
                    continue;
                }
                this.logger.warning("skipping file: " + file);
            }
        }
    }

    protected final boolean check(File file, String name, boolean isDir, Location loc) {
        Location location = loc = loc != null ? loc : this.location;
        if (file == null) {
            throw new BuildException(name + " is null!", loc);
        }
        if (!file.exists()) {
            throw new BuildException(file + " doesn't exist!", loc);
        }
        if (isDir ^ file.isDirectory()) {
            String e = file + " should" + (isDir ? "" : "n't") + " be a directory!";
            throw new BuildException(e, loc);
        }
        return true;
    }

    protected void doCompletionTasks() {
        if (!this.executing) {
            throw new IllegalStateException("should be executing");
        }
        if (null != this.outjar) {
            this.completeOutjar();
        } else {
            this.completeDestdir();
        }
        if (null != this.xdoneSignal) {
            MessageUtil.info((IMessageHandler)this.messageHolder, (String)this.xdoneSignal);
        }
    }

    private void completeDestdir() {
        Copy copy;
        Object[] paths;
        if (!this.copyInjars && null == this.sourceRootCopyFilter && null == this.inpathDirCopyFilter) {
            return;
        }
        if (this.destDir == DEFAULT_DESTDIR || !this.destDir.canWrite()) {
            String s = "unable to copy resources to destDir: " + this.destDir;
            throw new BuildException(s);
        }
        Project project = this.getProject();
        if (this.copyInjars) {
            if (null != this.inpath) {
                this.log("copyInjars does not support inpath.\n", 1);
            }
            String taskName = this.getTaskName() + " - unzip";
            Object[] paths2 = this.injars.list();
            if (!LangUtil.isEmpty((Object[])paths2)) {
                Object[] patternSet = new PatternSet();
                patternSet.setProject(project);
                patternSet.setIncludes("**/*");
                patternSet.setExcludes("**/*.class");
                Object[] objectArray = paths2;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object path = objectArray[i];
                    Expand unzip = new Expand();
                    unzip.setProject(project);
                    unzip.setTaskName(taskName);
                    unzip.setDest(this.destDir);
                    unzip.setSrc(new File((String)path));
                    unzip.addPatternset((PatternSet)patternSet);
                    unzip.execute();
                }
            }
        }
        if (null != this.sourceRootCopyFilter && null != this.sourceRoots && !LangUtil.isEmpty((Object[])(paths = this.sourceRoots.list()))) {
            copy = new Copy();
            copy.setProject(project);
            copy.setTodir(this.destDir);
            for (Object path : paths) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File((String)path));
                fileSet.setIncludes("**/*");
                fileSet.setExcludes(this.sourceRootCopyFilter);
                copy.addFileset(fileSet);
            }
            copy.execute();
        }
        if (null != this.inpathDirCopyFilter && null != this.inpath && !LangUtil.isEmpty((Object[])(paths = this.inpath.list()))) {
            copy = new Copy();
            copy.setProject(project);
            copy.setTodir(this.destDir);
            boolean gotDir = false;
            for (Object path : paths) {
                File inpathDir = new File((String)path);
                if (!inpathDir.isDirectory() || !inpathDir.canRead()) continue;
                if (!gotDir) {
                    gotDir = true;
                }
                FileSet fileSet = new FileSet();
                fileSet.setDir(inpathDir);
                fileSet.setIncludes("**/*");
                fileSet.setExcludes(this.inpathDirCopyFilter);
                copy.addFileset(fileSet);
            }
            if (gotDir) {
                copy.execute();
            }
        }
    }

    private void completeOutjar() {
        FileSet fileset;
        Object[] paths;
        if (null == this.tmpOutjar || !this.tmpOutjar.canRead() || !this.copyInjars && null == this.sourceRootCopyFilter && null == this.inpathDirCopyFilter) {
            return;
        }
        Zip zip = new Zip();
        Project project = this.getProject();
        zip.setProject(project);
        zip.setTaskName(this.getTaskName() + " - zip");
        zip.setDestFile(this.outjar);
        ZipFileSet zipfileset = new ZipFileSet();
        zipfileset.setProject(project);
        zipfileset.setSrc(this.tmpOutjar);
        zipfileset.setIncludes("**/*.class");
        zip.addZipfileset(zipfileset);
        if (this.copyInjars && !LangUtil.isEmpty((Object[])(paths = this.injars.list()))) {
            for (Object path : paths) {
                File jarFile = new File((String)path);
                zipfileset = new ZipFileSet();
                zipfileset.setProject(project);
                zipfileset.setSrc(jarFile);
                zipfileset.setIncludes("**/*");
                zipfileset.setExcludes("**/*.class");
                zip.addZipfileset(zipfileset);
            }
        }
        if (null != this.sourceRootCopyFilter && null != this.sourceRoots && !LangUtil.isEmpty((Object[])(paths = this.sourceRoots.list()))) {
            for (Object path : paths) {
                File srcRoot = new File((String)path);
                fileset = new FileSet();
                fileset.setProject(project);
                fileset.setDir(srcRoot);
                fileset.setIncludes("**/*");
                fileset.setExcludes(this.sourceRootCopyFilter);
                zip.addFileset(fileset);
            }
        }
        if (null != this.inpathDirCopyFilter && null != this.inpath && !LangUtil.isEmpty((Object[])(paths = this.inpath.list()))) {
            for (Object path : paths) {
                File inpathDir = new File((String)path);
                if (!inpathDir.isDirectory() || !inpathDir.canRead()) continue;
                fileset = new FileSet();
                fileset.setProject(project);
                fileset.setDir(inpathDir);
                fileset.setIncludes("**/*");
                fileset.setExcludes(this.inpathDirCopyFilter);
                zip.addFileset(fileset);
            }
        }
        zip.execute();
    }

    void addFiles(File[] paths) {
        for (File path : paths) {
            this.addFile(path);
        }
    }

    void addFile(File path) {
        if (null != path) {
            this.adapterFiles.add(path);
        }
    }

    public void readArguments(String[] args) {
        if (null == args || 0 == args.length) {
            return;
        }
        class Args {
            final String[] args;
            int index = 0;

            Args(String[] args) {
                this.args = args;
            }

            boolean hasNext() {
                return this.index < this.args.length;
            }

            String next() {
                String s;
                String err = null;
                if (!this.hasNext()) {
                    err = "need arg for flag " + this.args[this.args.length - 1];
                } else if (null == (s = this.args[this.index++])) {
                    err = "null value";
                } else if (0 == (s = s.trim()).trim().length()) {
                    err = "no value";
                } else {
                    return s;
                }
                err = err + " at [" + this.index + "] of " + Arrays.asList(this.args);
                throw new BuildException(err);
            }
        }
        Args in = new Args(args);
        while (in.hasNext()) {
            File file;
            String flag = in.next();
            if ("-1.3".equals(flag)) {
                this.setCompliance(flag);
                continue;
            }
            if ("-1.4".equals(flag)) {
                this.setCompliance(flag);
                continue;
            }
            if ("-1.5".equals(flag)) {
                this.setCompliance("1.5");
                continue;
            }
            if ("-argfile".equals(flag)) {
                this.setArgfiles(new Path(this.project, in.next()));
                continue;
            }
            if ("-aspectpath".equals(flag)) {
                this.setAspectpath(new Path(this.project, in.next()));
                continue;
            }
            if ("-classpath".equals(flag)) {
                this.setClasspath(new Path(this.project, in.next()));
                continue;
            }
            if ("-extdirs".equals(flag)) {
                this.setExtdirs(new Path(this.project, in.next()));
                continue;
            }
            if ("-Xcopyinjars".equals(flag)) {
                this.setCopyInjars(true);
                continue;
            }
            if ("-g".equals(flag)) {
                this.setDebug(true);
                continue;
            }
            if (flag.startsWith("-g:")) {
                this.setDebugLevel(flag.substring(2));
                continue;
            }
            if ("-deprecation".equals(flag)) {
                this.setDeprecation(true);
                continue;
            }
            if ("-d".equals(flag)) {
                this.setDestdir(new File(in.next()));
                continue;
            }
            if ("-crossrefs".equals(flag)) {
                this.setCrossrefs(true);
                continue;
            }
            if ("-emacssym".equals(flag)) {
                this.setEmacssym(true);
                continue;
            }
            if ("-encoding".equals(flag)) {
                this.setEncoding(in.next());
                continue;
            }
            if ("-Xfailonerror".equals(flag)) {
                this.setFailonerror(true);
                continue;
            }
            if ("-fork".equals(flag)) {
                this.setFork(true);
                continue;
            }
            if ("-forkclasspath".equals(flag)) {
                this.setForkclasspath(new Path(this.project, in.next()));
                continue;
            }
            if ("-help".equals(flag)) {
                this.setHelp(true);
                continue;
            }
            if ("-incremental".equals(flag)) {
                this.setIncremental(true);
                continue;
            }
            if ("-injars".equals(flag)) {
                this.setInjars(new Path(this.project, in.next()));
                continue;
            }
            if ("-inpath".equals(flag)) {
                this.setInpath(new Path(this.project, in.next()));
                continue;
            }
            if ("-Xlistfileargs".equals(flag)) {
                this.setListFileArgs(true);
                continue;
            }
            if ("-Xmaxmem".equals(flag)) {
                this.setMaxmem(in.next());
                continue;
            }
            if ("-Xmessageholderclass".equals(flag)) {
                this.setMessageHolderClass(in.next());
                continue;
            }
            if ("-noexit".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-noimport".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-noExit".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-noImportError".equals(flag)) {
                this.setNoImportError(true);
                continue;
            }
            if ("-noWarn".equals(flag)) {
                this.setNowarn(true);
                continue;
            }
            if ("-noexit".equals(flag)) {
                this.setNoExit(true);
                continue;
            }
            if ("-outjar".equals(flag)) {
                this.setOutjar(new File(in.next()));
                continue;
            }
            if ("-outxml".equals(flag)) {
                this.setOutxml(true);
                continue;
            }
            if ("-outxmlfile".equals(flag)) {
                this.setOutxmlfile(in.next());
                continue;
            }
            if ("-preserveAllLocals".equals(flag)) {
                this.setPreserveAllLocals(true);
                continue;
            }
            if ("-proceedOnError".equals(flag)) {
                this.setProceedOnError(true);
                continue;
            }
            if ("-referenceInfo".equals(flag)) {
                this.setReferenceInfo(true);
                continue;
            }
            if ("-source".equals(flag)) {
                this.setSource(in.next());
                continue;
            }
            if ("-Xsourcerootcopyfilter".equals(flag)) {
                this.setSourceRootCopyFilter(in.next());
                continue;
            }
            if ("-sourceroots".equals(flag)) {
                this.setSourceRoots(new Path(this.project, in.next()));
                continue;
            }
            if ("-Xsrcdir".equals(flag)) {
                this.setSrcDir(new Path(this.project, in.next()));
                continue;
            }
            if ("-Xtagfile".equals(flag)) {
                this.setTagFile(new File(in.next()));
                continue;
            }
            if ("-target".equals(flag)) {
                this.setTarget(in.next());
                continue;
            }
            if ("-time".equals(flag)) {
                this.setTime(true);
                continue;
            }
            if ("-time".equals(flag)) {
                this.setTime(true);
                continue;
            }
            if ("-verbose".equals(flag)) {
                this.setVerbose(true);
                continue;
            }
            if ("-showWeaveInfo".equals(flag)) {
                this.setShowWeaveInfo(true);
                continue;
            }
            if ("-version".equals(flag)) {
                this.setVersion(true);
                continue;
            }
            if ("-warn".equals(flag)) {
                this.setWarn(in.next());
                continue;
            }
            if (flag.startsWith("-warn:")) {
                this.setWarn(flag.substring(6));
                continue;
            }
            if ("-Xlint".equals(flag)) {
                this.setXlintwarnings(true);
                continue;
            }
            if (flag.startsWith("-Xlint:")) {
                this.setXlint(flag.substring(7));
                continue;
            }
            if ("-Xlintfile".equals(flag)) {
                this.setXlintfile(new File(in.next()));
                continue;
            }
            if ("-XterminateAfterCompilation".equals(flag)) {
                this.setXTerminateAfterCompilation(true);
                continue;
            }
            if ("-Xreweavable".equals(flag)) {
                this.setXReweavable(true);
                continue;
            }
            if ("-XnotReweavable".equals(flag)) {
                this.setXNotReweavable(true);
                continue;
            }
            if (flag.startsWith("@")) {
                file = new File(flag.substring(1));
                if (file.canRead()) {
                    this.setArgfiles(new Path(this.project, file.getPath()));
                    continue;
                }
                this.ignore(flag);
                continue;
            }
            file = new File(flag);
            if (file.isFile() && file.canRead() && FileUtil.hasSourceSuffix((File)file)) {
                this.addFile(file);
                continue;
            }
            this.ignore(flag);
        }
    }

    protected void logVerbose(String text) {
        if (this.verbose) {
            this.logger.info(text);
        } else {
            this.logger.verbose(text);
        }
    }

    static {
        COMMAND_EDITOR_NAME = AjcTask.class.getName() + ".COMMAND_EDITOR";
        TARGET_INPUTS = new String[]{"1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "9", "10", "11", "12", "13", "14"};
        SOURCE_INPUTS = new String[]{"1.3", "1.4", "1.5", "1.6", "1.7", "1.8", "1.9", "9", "10", "11", "12", "13", "14"};
        COMPLIANCE_INPUTS = new String[]{"-1.3", "-1.4", "-1.5", "-1.6", "-1.7", "-1.8", "-1.9", "-9", "-10", "-11", "-12", "-13", "-14"};
        String[] xs = new String[]{"serializableAspects", "incrementalFile", "lazyTjp", "reweavable", "reweavable:compress", "notReweavable", "noInline", "terminateAfterCompilation", "hasMember", "ajruntimetarget:1.2", "ajruntimetarget:1.5", "addSerialVersionUID"};
        VALID_XOPTIONS = Collections.unmodifiableList(Arrays.asList(xs));
        xs = new String[]{"constructorName", "packageDefaultMethod", "deprecation", "maskedCatchBlocks", "unusedLocals", "unusedArguments", "unusedImports", "syntheticAccess", "assertIdentifier", "allDeprecation", "allJavadoc", "charConcat", "conditionAssign", "emptyBlock", "fieldHiding", "finally", "indirectStatic", "intfNonInherited", "javadoc", "localHiding", "nls", "noEffectAssign", "pkgDefaultMethod", "semicolon", "unqualifiedField", "unusedPrivate", "unusedThrown", "uselessTypeCheck", "specialParamHiding", "staticReceiver", "syntheticAccess", "none"};
        VALID_WARNINGS = Collections.unmodifiableList(Arrays.asList(xs));
        xs = new String[]{"none", "lines", "vars", "source"};
        VALID_DEBUG = Collections.unmodifiableList(Arrays.asList(xs));
        xs = new String[]{"error", "warning", "ignore"};
        VALID_XLINT = Collections.unmodifiableList(Arrays.asList(xs));
        ICommandEditor editor = null;
        try {
            String editorClassName = System.getProperty(COMMAND_EDITOR_NAME);
            if (null != editorClassName) {
                ClassLoader cl = AjcTask.class.getClassLoader();
                Class<?> editorClass = cl.loadClass(editorClassName);
                editor = (ICommandEditor)editorClass.newInstance();
            }
        }
        catch (Throwable t) {
            System.err.println("Warning: unable to load command editor");
            t.printStackTrace(System.err);
        }
        COMMAND_EDITOR = editor;
    }

    private static class AntMessageHandler
    implements IMessageHandler {
        private TaskLogger logger;
        private final boolean taskLevelVerbose;
        private final boolean handledMessage;

        public AntMessageHandler(TaskLogger logger, boolean taskVerbose, boolean handledMessage) {
            this.logger = logger;
            this.taskLevelVerbose = taskVerbose;
            this.handledMessage = handledMessage;
        }

        public boolean handleMessage(IMessage message) throws AbortException {
            IMessage.Kind messageKind = message.getKind();
            String messageText = message.toString();
            if (messageKind == IMessage.ABORT) {
                this.logger.error(messageText);
            } else if (messageKind == IMessage.DEBUG) {
                this.logger.debug(messageText);
            } else if (messageKind == IMessage.ERROR) {
                this.logger.error(messageText);
            } else if (messageKind == IMessage.FAIL) {
                this.logger.error(messageText);
            } else if (messageKind == IMessage.INFO) {
                if (this.taskLevelVerbose) {
                    this.logger.info(messageText);
                } else {
                    this.logger.verbose(messageText);
                }
            } else if (messageKind == IMessage.WARNING) {
                this.logger.warning(messageText);
            } else if (messageKind == IMessage.WEAVEINFO) {
                this.logger.info(messageText);
            } else if (messageKind != IMessage.TASKTAG) {
                throw new BuildException("Unknown message kind from AspectJ compiler: " + messageKind.toString());
            }
            return this.handledMessage;
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return false;
        }

        public void dontIgnore(IMessage.Kind kind) {
        }

        public void ignore(IMessage.Kind kind) {
        }
    }

    public static class GuardedCommand {
        Commandline command = new Commandline();

        static boolean isEmpty(String s) {
            return null == s || 0 == s.trim().length();
        }

        GuardedCommand() {
        }

        void addFlag(String flag, boolean doAdd) {
            if (doAdd && !GuardedCommand.isEmpty(flag)) {
                this.command.createArgument().setValue(flag);
            }
        }

        String addOption(String prefix, String[] validOptions, String input) {
            if (GuardedCommand.isEmpty(input)) {
                return null;
            }
            for (String validOption : validOptions) {
                if (!input.equals(validOption)) continue;
                if (GuardedCommand.isEmpty(prefix)) {
                    this.addFlag(input, true);
                } else {
                    this.addFlagged(prefix, input);
                }
                return null;
            }
            return null == prefix ? input : prefix + " " + input;
        }

        void addFlagged(String flag, String argument) {
            if (!GuardedCommand.isEmpty(flag) && !GuardedCommand.isEmpty(argument)) {
                this.command.addArguments(new String[]{flag, argument});
            }
        }

        List extractArguments() {
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] cmds = this.command.getArguments();
            if (!LangUtil.isEmpty((Object[])cmds)) {
                result.addAll(Arrays.asList(cmds));
            }
            return result;
        }

        static String[] limitTo(String[] args, int max, Location location) {
            if (max < 0) {
                throw new IllegalArgumentException("negative max: " + max);
            }
            int size = 0;
            for (int i = 0; i < args.length && size < max; size += 1 + (null == args[i] ? 0 : args[i].length()), ++i) {
            }
            if (size <= max) {
                return args;
            }
            File tmpFile = null;
            PrintWriter out = null;
            try {
                String userDirName = System.getProperty("user.dir");
                File userDir = new File(userDirName);
                tmpFile = File.createTempFile("argfile", "", userDir);
                out = new PrintWriter(new FileWriter(tmpFile));
                for (String arg : args) {
                    out.println(arg);
                }
                out.flush();
                String[] stringArray = new String[]{"-argfile", tmpFile.getAbsolutePath()};
                return stringArray;
            }
            catch (IOException e) {
                throw new BuildException("Error creating temporary file", (Throwable)e, location);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public static class CompilerArg {
        private String value;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

