/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.obeoviewpointanimator;

import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManagerGUI;
import fr.inria.aoste.timesquare.backend.obeoviewpointanimator.ObeoViewpointAnimatorBehaviorManager;
import fr.inria.aoste.timesquare.utils.ui.listeners.FileExtensionFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class ObeoViewpointAnimatorGUI
extends BehaviorManagerGUI {
    private Composite container;
    private String _airdFilePath;
    private ITreeContentProvider fContentProvider = new WorkbenchContentProvider();
    private String message = "choose AIRD file";
    private TreeViewer fViewer;
    private IStatus fCurrStatus = Status.OK_STATUS;
    private ISelectionStatusValidator fValidator = null;
    boolean fIsEmpty = false;
    private Object[] result;
    Label messageLabel = null;

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        int style = 2052;
        this.fViewer = new TreeViewer(new Tree(parent, style));
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObeoViewpointAnimatorGUI.this.result = ((IStructuredSelection)event.getSelection()).toList().toArray();
                ObeoViewpointAnimatorGUI.this.updateOKStatus();
            }
        });
        this.fViewer.addFilter((ViewerFilter)new FileExtensionFilter(new String[]{"aird"}));
        this.fValidator = new SelectionDiFile();
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection;
                ObeoViewpointAnimatorGUI.this.updateOKStatus();
                if (!ObeoViewpointAnimatorGUI.this.fCurrStatus.isOK() && (selection = event.getSelection()) instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ObeoViewpointAnimatorGUI.this.fViewer.getExpandedState(item)) {
                        ObeoViewpointAnimatorGUI.this.fViewer.collapseToLevel(item, 1);
                    } else {
                        ObeoViewpointAnimatorGUI.this.fViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.fViewer.setInput((Object)root);
        return this.fViewer;
    }

    public Point getMinimumSize() {
        return new Point(350, 250);
    }

    public void updateOKStatus() {
        if (!this.fIsEmpty) {
            if (this.fValidator != null) {
                this.fCurrStatus = this.fValidator.validate(this.getResult());
                if (this.dialog != null) {
                    this.dialog.updateStatus(this.fCurrStatus);
                }
            } else {
                this.fCurrStatus = Status.OK_STATUS;
            }
        } else {
            this.fCurrStatus = new Status(4, "fr.inria.aoste.timesquare.backend.papyrusmodelanimator", 4, "no file found", null);
        }
        if (this.dialog != null) {
            this.dialog.updateStatus(this.fCurrStatus);
        }
    }

    public Object[] getResult() {
        return this.result;
    }

    public Control createDialogArea(Composite composite) {
        block4: {
            try {
                if (composite != null) break block4;
                return null;
            }
            catch (Exception e) {
                System.err.println("Error");
                return composite;
            }
        }
        this.container = composite;
        this.messageLabel = this.createMessageArea(this.container);
        TreeViewer treeViewer = this.createTreeViewer(this.container);
        GridData data = new GridData(1808);
        data.minimumHeight = 250;
        data.minimumWidth = 450;
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(composite.getFont());
        this._airdFilePath = "";
        if (this.getBehaviorManager().getAirdIFile() != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.getBehaviorManager().getAirdIFile()));
        }
        return this.container;
    }

    public void okPressed() {
        try {
            this.addClockBehavior();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.print(e.getMessage());
        }
    }

    public void addClockBehavior() throws Throwable {
        if (this.getResult() != null && this.getResult().length != 0) {
            this._airdFilePath = ((IFile)this.getResult()[0]).getFullPath().toString();
        }
        if (this._airdFilePath != null && this._airdFilePath.length() != 0) {
            this.getBehaviorManager().setAird(this._airdFilePath);
            this.getBehaviorManager().manageBehavior(this._configurationHelper);
        } else {
            System.err.println("Error in add");
        }
    }

    protected ObeoViewpointAnimatorBehaviorManager getBehaviorManager() {
        return (ObeoViewpointAnimatorBehaviorManager)super.getBehaviorManager();
    }

    public void setBehaviorManager(BehaviorManager behaviorManager) {
        if (behaviorManager instanceof ObeoViewpointAnimatorBehaviorManager) {
            super.setBehaviorManager(behaviorManager);
        }
    }

    public void cancelPressed() {
    }

    public final class SelectionDiFile
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            boolean enableOK = false;
            if (selection != null && selection.length != 0 && selection[0] instanceof IFile) {
                enableOK = ObeoViewpointAnimatorGUI.this.getBehaviorManager().isValidAirdFile((IFile)selection[0]);
                return enableOK ? new Status(0, "fr.inria.aoste.timesquare.backend.papyrusmodelanimator", 0, "", null) : new Status(4, "fr.inria.aoste.timesquare.backend.papyrusmodelanimator", 0, "no link with a specification", null);
            }
            return new Status(4, "fr.inria.aoste.timesquare.backend.papyrusmodelanimator", 0, "", null);
        }
    }
}

