/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.obeoviewpointanimator;

import fr.inria.aoste.timesquare.backend.manager.visible.Behavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLFactory;

public class AnimateAssertBehaviour
implements ClockBehavior {
    private int _assertCounter = 0;
    private int _originalColor;
    private int _currentStep = 0;
    private String _stepsOfViolation = "\t";
    private GraphicalEditPart theEditPart = null;
    private ShapeStyle _elemShape = null;
    private DiagramEditPart _diagramEditPart = null;
    private Comment _comment = null;
    private String _assertName = "";
    private TraceHelper _helper = null;
    private NamedElement _elem = null;
    private HashMap<Integer, Integer> tablecolor = new HashMap();
    final ClockEntity _ae;

    public AnimateAssertBehaviour(ClockEntity ae) {
        this._ae = ae;
        this._assertName = this._ae.getName();
    }

    public String getDescription() {
        return "Papyrus Animator";
    }

    public void setEditPart(DiagramEditPart _diagramEditPart) {
        this._diagramEditPart = _diagramEditPart;
    }

    public void start() {
        if (this._diagramEditPart != null && this._diagramEditPart.resolveSemanticElement() instanceof NamedElement) {
            this.theEditPart = this._diagramEditPart;
            StartSetCommentOperation cmd = new StartSetCommentOperation(this.theEditPart);
            this._elem = (NamedElement)this._diagramEditPart.resolveSemanticElement();
            try {
                cmd.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                this._comment = UMLFactory.eINSTANCE.createComment();
            }
            if (this._comment == null) {
                this._comment = UMLFactory.eINSTANCE.createComment();
            }
        }
    }

    public void run(TraceHelper helper) {
        if (this._diagramEditPart != null) {
            this.theEditPart = this._diagramEditPart;
            this._helper = helper;
            ++this._assertCounter;
            this._currentStep = this._helper.getCurrentStepNumber();
            this._stepsOfViolation = String.valueOf(this._stepsOfViolation) + this._currentStep + "\n\t";
            Display.getDefault().syncExec((Runnable)new RunnableRun(this));
            this._helper = null;
        }
    }

    public void runWithWrongActivationState(TraceHelper helper) {
        if (this._diagramEditPart != null) {
            this.theEditPart = this._diagramEditPart;
            this._helper = helper;
            Display.getDefault().syncExec((Runnable)new RunnnableWithWrongActivationState(this));
            this._helper = null;
        }
    }

    public void againRun(TraceHelper helper) {
        if (this.theEditPart != null && this._diagramEditPart != null) {
            this._helper = helper;
            Display.getDefault().syncExec((Runnable)new AgainRunnable(this, 255));
            this._helper = null;
        }
    }

    public void againRunWithWrongActivationState(TraceHelper helper) {
        if (this.theEditPart != null && this._diagramEditPart != null) {
            this._helper = helper;
            Display.getDefault().syncExec((Runnable)new AgainRunnable(this, this._originalColor));
            this._helper = null;
        }
    }

    public boolean behaviorEquals(Behavior behavior) {
        return behavior == this;
    }

    public int getSizeofTableColor() {
        return this.tablecolor.size();
    }

    protected NamedElement getNamedElement() {
        return this._elem;
    }

    private static final class AgainRunnable
    implements Runnable {
        private final AnimateAssertBehaviour aab;
        private int color;

        public AgainRunnable(AnimateAssertBehaviour aab, int color) {
            this.aab = aab;
            this.color = color;
        }

        @Override
        public void run() {
            try {
                this.aab._diagramEditPart.activate();
                SetColorAgain cmd = new SetColorAgain(this.aab, this.color);
                try {
                    cmd.execute(null, null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                this.aab._diagramEditPart.refresh();
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
    }

    private static final class RunnableRun
    implements Runnable {
        private final AnimateAssertBehaviour aab;

        public RunnableRun(AnimateAssertBehaviour _aab) {
            this.aab = _aab;
        }

        @Override
        public void run() {
            try {
                this.aab._diagramEditPart.activate();
                SetColorRun cmd = new SetColorRun(this.aab);
                try {
                    cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                this.aab._diagramEditPart.refresh();
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
    }

    private static final class RunnnableWithWrongActivationState
    implements Runnable {
        private final AnimateAssertBehaviour aab;

        public RunnnableWithWrongActivationState(AnimateAssertBehaviour _aab) {
            this.aab = _aab;
        }

        @Override
        public void run() {
            try {
                this.aab._diagramEditPart.activate();
                SetColorRunWrongActivationState cmd = new SetColorRunWrongActivationState(this.aab);
                try {
                    cmd.execute(null, null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                this.aab._diagramEditPart.refresh();
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
    }

    private static final class SetColorAgain
    extends AbstractEMFOperation {
        private final AnimateAssertBehaviour aab;
        private final int color;

        public SetColorAgain(AnimateAssertBehaviour _aab, int _color) {
            super(_aab.theEditPart.getEditingDomain(), "SetColor");
            this.aab = _aab;
            Integer n = this.aab._helper.getCurrentStepNumber();
            this.color = this.aab.tablecolor.containsKey(n) ? (Integer)this.aab.tablecolor.get(n) : _color;
        }

        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }

    private static final class SetColorRun
    extends AbstractEMFOperation {
        private AnimateAssertBehaviour aab = null;

        public SetColorRun(AnimateAssertBehaviour aab) {
            super(aab.theEditPart.getEditingDomain(), "SetColor");
            this.aab = aab;
        }

        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }

    private static final class SetColorRunWrongActivationState
    extends AbstractEMFOperation {
        private final AnimateAssertBehaviour aab;

        public SetColorRunWrongActivationState(AnimateAssertBehaviour aab) {
            super(aab.theEditPart.getEditingDomain(), "SetColor");
            this.aab = aab;
        }

        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }

    private final class StartSetCommentOperation
    extends AbstractEMFOperation {
        public StartSetCommentOperation(GraphicalEditPart theEditPart) {
            super(theEditPart.getEditingDomain(), "SetComment");
        }

        protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return Status.OK_STATUS;
        }
    }
}

