/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.logical;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractSimpleBinaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class BooleanAndOperation
extends AbstractSimpleBinaryOperation {
    public static final @NonNull BooleanAndOperation INSTANCE = new BooleanAndOperation();

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        Object firstArgument;
        if (sourceValue == Boolean.FALSE) {
            return FALSE_VALUE;
        }
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        OCLExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        try {
            firstArgument = executor.evaluate(argument0);
        }
        catch (InvalidValueException e) {
            firstArgument = e;
        }
        return this.evaluate(sourceValue, firstArgument);
    }

    @Override
    public @Nullable Boolean evaluate(@Nullable Object left, @Nullable Object right) {
        if (left == Boolean.FALSE || right == Boolean.FALSE) {
            return FALSE_VALUE;
        }
        if (left == Boolean.TRUE && right == Boolean.TRUE) {
            return TRUE_VALUE;
        }
        if (left instanceof InvalidValueException) {
            throw (InvalidValueException)left;
        }
        if (right instanceof InvalidValueException) {
            throw (InvalidValueException)right;
        }
        if (left == null || right == null) {
            return null;
        }
        if (!(left instanceof Boolean)) {
            throw new InvalidValueException(PivotMessages.TypedValueRequired, "Boolean", BooleanAndOperation.getTypeName(left));
        }
        throw new InvalidValueException(PivotMessages.TypedValueRequired, "Boolean", BooleanAndOperation.getTypeName(right));
    }
}

