/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver;

import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.NoBooleanSolution;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.AbstractStepExecutionEngine;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.ISolverConcrete;
import fr.inria.aoste.timesquare.ccslkernel.solver.ImplicitClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.CCSLModel.SolverBlock;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.CCSLModel.SolverBlockTransition;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.expression.SolverExpression;
import fr.inria.aoste.timesquare.ccslkernel.solver.helpers.SemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.helpers.UpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelation;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelationWrapper;
import fr.inria.aoste.timesquare.ccslkernel.solver.statistics.SolverRuntimeStats;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyBase;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceState;
import fr.inria.aoste.timesquare.simulationpolicy.bitset.ClockTraceStateSet;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.EnableStateKind;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.TracePackage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.javabdd.BuDDyFactory;

public class StepExecutor
extends AbstractStepExecutionEngine {
    private CCSLKernelSolver solver;
    private List<ISolverConcrete> semanticDoneConcretes;
    private LogicalStep traceStep;
    public boolean inSimulationMode = true;

    public List<LogicalStep> reinitializeCurrentStepBDD() throws SimulationException {
        if (this.semanticBdd != null) {
            this.semanticBdd.free();
        }
        return this.computeAndGetPossibleLogicalSteps();
    }

    public StepExecutor(CCSLKernelSolver solver) {
        this.solver = solver;
        this.semanticBdd = solver.BuDDyFactory.one();
        this.semanticDoneConcretes = new ArrayList<ISolverConcrete>();
        this.initHelpers();
    }

    public void clearStepData() {
        super.clearStepData();
        this.semanticBdd = this.solver.BuDDyFactory.one();
    }

    protected SemanticHelper createSemanticHelper() {
        return new SemanticHelper(this.solver, this);
    }

    protected UpdateHelper createUpdateHelper() {
        return new UpdateHelper(this);
    }

    public List<RuntimeClock> getAllDiscreteClocks() {
        return this.solver.getAllDiscreteClocks();
    }

    public List<LogicalStep> computeAndGetPossibleLogicalSteps() throws SimulationException {
        this.computePossibleClockStates();
        return this.getAllSolutions();
    }

    public Map<Integer, Integer> getBddVarToIndexInSolution() {
        return this.solver.bddVarToIndexInSolution;
    }

    public ArrayList<String> lightApplyLogicalStepByIndex(int indexOfStepToApply) throws SimulationException {
        this.fired = (ClockTraceStateSet)this.allClockTraceStateSet.get(indexOfStepToApply);
        this.enabled = (ClockTraceStateSet)this.allClockTraceStateSet.get(indexOfStepToApply);
        this.rewriteSemanticsAndPropagateDeath();
        ArrayList<String> res = new ArrayList<String>();
        for (RuntimeClock clock : this.getAllDiscreteClocks()) {
            if (!this.getUsedClocks().contains(clock) || this.getClockFiredState(clock) != ClockTraceState.T || clock instanceof ImplicitClock) continue;
            res.add(clock.getName());
        }
        return res;
    }

    public void freeAll() {
        this.semanticBdd.free();
        this.semanticHelper = null;
        this.semanticHelper = this.createSemanticHelper();
        this.allClockTraceStateSet.clear();
    }

    public void stepPreHook() {
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.enterMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".executeStep");
        }
    }

    protected void stepPostHook() {
        this.traceStep = this.solver.getTraceFactory().createLogicalStep();
        this.fillTraceStep(this.solver, this.traceStep);
        this.dealWithBlockTransition();
        this.freeAll();
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.leaveMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".executeStep");
        }
    }

    public Set<RuntimeClock> getDeadClocks() {
        return this.solver.getDeadClocks();
    }

    public void addDeadClock(RuntimeClock clock) {
        this.solver.addDeadClock(clock);
    }

    protected void constructCurrentStepBDD() throws SimulationException {
        this.semanticDoneConcretes.clear();
        this.buildBooleanExpressions();
        BuDDyFactory.BuDDyBDD clockDisjunction = this.buildAllClocksDisjunction();
        this.semanticBdd.andWith(clockDisjunction);
        if (this.solver.getPrioritySpecification() != null && this.solver.getPrioritySpecification().getPriorityRelations().size() > 0) {
            this.semanticBdd.andWith(this.solver.getPrioSolver().ResolvePrio(this.semanticBdd, this.usedClocks));
        }
    }

    private void buildBooleanExpressions() throws SimulationException {
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.enterMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".buildBooleanExpressions");
        }
        for (SolverBlock topBlock : this.solver.getTopBlocks()) {
            this.buildBooleanExpressionsInBlock(topBlock);
        }
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.leaveMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".buildBooleanExpressions");
        }
    }

    private void buildBooleanExpressionsInBlock(SolverBlock block) throws SimulationException {
        for (ISolverConcrete conc : block.getConcretes()) {
            if (!(conc instanceof SolverRelation) && !(conc instanceof SolverRelationWrapper)) continue;
            conc.semantic(this.semanticHelper);
        }
        for (ISolverConcrete conc : block.getConcretes()) {
            if (!(conc instanceof SolverExpression)) continue;
            conc.semantic(this.semanticHelper);
        }
        for (SolverClock clock : block.getConcreteClocks()) {
            this.usedClocks.add(clock);
        }
        for (SolverBlock subBlock : block.getActiveSubBlocks()) {
            this.buildBooleanExpressionsInBlock(subBlock);
        }
    }

    private BuDDyFactory.BuDDyBDD buildAllClocksDisjunction() {
        BuDDyFactory.BuDDyBDD clockDisjunction = this.solver.BuDDyFactory.zero();
        for (RuntimeClock clock : this.usedClocks) {
            BuDDyFactory.BuDDyBDD bddClockVar = this.solver.BuDDyFactory.ithVar(clock.bddVariableNumber);
            clockDisjunction.orWith(bddClockVar);
        }
        return clockDisjunction;
    }

    public void semanticBDDAnd(BuDDyFactory.BuDDyBDD newTerm) {
        this.semanticBdd.andWith(newTerm);
    }

    public ArrayList<LogicalStep> getAllSolutions() throws NoBooleanSolution {
        this.allClockTraceStateSet = this.getAllBDDSolutions();
        ArrayList<LogicalStep> allNextStepSolutions = new ArrayList<LogicalStep>();
        for (ClockTraceStateSet clockTraceStateSet : this.allClockTraceStateSet) {
            LogicalStep newSolution = TracePackage.eINSTANCE.getTraceFactory().createLogicalStep();
            allNextStepSolutions.add(newSolution);
            this.fired = clockTraceStateSet;
            this.enabled = clockTraceStateSet;
            for (RuntimeClock clock : this.solver.getAllDiscreteClocks()) {
                if (!this.usedClocks.contains(clock)) continue;
                this.setTraceClockState((SolverClock)clock, newSolution);
            }
        }
        this.fired = null;
        this.enabled = null;
        return allNextStepSolutions;
    }

    public ArrayList<ClockTraceStateSet> getAllBDDSolutions() throws NoBooleanSolution {
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.enterMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getAllSolutions");
        }
        if (this.semanticBdd.isZero()) {
            System.err.println("there is a deadlock ! no solution can be found");
            if (CCSLKernelSolver.runtimeStatsCollection) {
                SolverRuntimeStats.leaveMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getAllSolutions");
            }
            System.err.println("no more futures are found in the model");
            return new ArrayList<ClockTraceStateSet>();
        }
        BuDDyFactory.BuDDyBDD varSet = this.solver.BuDDyFactory.one();
        for (Integer current : this.solver.bddVarToIndexInSolution.keySet()) {
            varSet = varSet.and(this.solver.BuDDyFactory.ithVar(current.intValue()));
        }
        BuDDyFactory.BuDDyBDD.BDDIterator it = this.semanticBdd.iterator(varSet);
        ArrayList<ClockTraceStateSet> allSolutionsF = new ArrayList<ClockTraceStateSet>();
        int allClockSize = this.solver.bddVarToIndexInSolution.size();
        while (it.hasNext()) {
            ClockTraceStateSet tempF = new ClockTraceStateSet(allClockSize);
            ClockTraceStateSet tempE = new ClockTraceStateSet(allClockSize);
            BuDDyFactory.BuDDyBDD v = (BuDDyFactory.BuDDyBDD)it.next();
            for (int bddVarNumber : this.solver.bddVarToIndexInSolution.keySet()) {
                int index = 0;
                index = this.solver.bddVarToIndexInSolution.get(bddVarNumber);
                if (!v.and(this.solver.BuDDyFactory.ithVar(bddVarNumber)).isZero()) {
                    tempF.set(index, ClockTraceState.T);
                    tempE.set(index, ClockTraceState.T);
                    continue;
                }
                tempF.set(index, ClockTraceState.F);
                tempE.set(index, ClockTraceState.F);
            }
            allSolutionsF.add(tempF);
        }
        varSet.free();
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.leaveMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".getAllSolutions");
        }
        this.allClockTraceStateSet = allSolutionsF;
        return allSolutionsF;
    }

    public SimulationPolicyBase getSimulationPolicy() {
        return this.solver.getPolicy();
    }

    protected BuDDyFactory getBuddyFactory() {
        return this.solver.getBuddyFactory();
    }

    protected void rewriteExpressions() throws SimulationException {
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.enterMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".rewriteExpressions");
        }
        for (SolverBlock block : this.solver.getTopBlocks()) {
            this.rewriteExpressionsInBlock(block);
        }
        for (SolverBlock block : this.solver.getTopBlocks()) {
            this.findDeadClocks(block);
        }
        if (CCSLKernelSolver.runtimeStatsCollection) {
            SolverRuntimeStats.leaveMethod(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".rewriteExpressions");
        }
    }

    private void rewriteExpressionsInBlock(SolverBlock block) throws SimulationException {
        for (SolverClock solverClock : block.getConcreteClocks()) {
            if (this.getClockFiredState(solverClock) == ClockTraceState.T) {
                this.registerClockFiring(solverClock);
            }
            if (this.getClockEnabledState(solverClock) != ClockTraceState.T) continue;
            this.enabledClocks.add(solverClock);
        }
        for (ImplicitClock implicitClock : block.getImplicitClocks()) {
            if (this.getClockFiredState(implicitClock) == ClockTraceState.T) {
                this.registerClockFiring(implicitClock);
            }
            if (this.getClockEnabledState(implicitClock) != ClockTraceState.T) continue;
            this.enabledClocks.add(implicitClock);
        }
        for (ISolverConcrete iSolverConcrete : block.getConcretes()) {
            iSolverConcrete.update(this.updateHelper);
        }
        for (SolverBlock solverBlock : block.getActiveSubBlocks()) {
            this.rewriteExpressionsInBlock(solverBlock);
        }
    }

    private void findDeadClocks(SolverBlock block) {
        for (SolverClock solverClock : block.getConcreteClocks()) {
            if (!solverClock.isDead()) continue;
            this.newDeadClocks.add(solverClock);
        }
        for (ImplicitClock implicitClock : block.getImplicitClocks()) {
            if (!implicitClock.isDead()) continue;
            this.newDeadClocks.add(implicitClock);
        }
        for (SolverBlock solverBlock : block.getSubBlocks()) {
            this.findDeadClocks(solverBlock);
        }
    }

    protected void buildDeathExpressions() throws SimulationException {
        for (SolverBlock block : this.solver.getTopBlocks()) {
            this.buildDeathExpressions(block);
        }
    }

    private void buildDeathExpressions(SolverBlock block) throws SimulationException {
        for (ISolverConcrete concrete : block.getConcretes()) {
            concrete.deathSemantic(this.semanticHelper);
        }
        for (SolverBlock sub : block.getActiveSubBlocks()) {
            this.buildDeathExpressions(sub);
        }
    }

    public synchronized List<ISolverConcrete> getSemanticDoneConcretes() {
        return this.semanticDoneConcretes;
    }

    public LogicalStep getTraceStep() {
        return this.traceStep;
    }

    private void fillTraceStep(CCSLKernelSolver ccslKernelSolver, LogicalStep step) {
        for (SolverBlock block : this.solver.getTopBlocks()) {
            this.setTraceStates(block, step);
        }
    }

    private void setTraceStates(SolverBlock block, LogicalStep step) {
        for (SolverClock solverClock : block.getConcreteClocks()) {
            this.setTraceClockState(solverClock, step);
        }
        for (ImplicitClock implicitClock : block.getImplicitClocks()) {
            this.setTraceClockState(implicitClock, step);
        }
        for (ISolverConcrete iSolverConcrete : block.getConcretes()) {
            if (!(iSolverConcrete instanceof SolverRelation) || !((SolverRelation)iSolverConcrete).isAssertion()) continue;
            this.setAssertionState((SolverRelation)iSolverConcrete, step);
        }
        for (SolverBlock solverBlock : block.getActiveSubBlocks()) {
            this.setTraceStates(solverBlock, step);
        }
    }

    private void setTraceClockState(SolverClock clock, LogicalStep step) {
        EventOccurrence eventOcc = TracePackage.eINSTANCE.getTraceFactory().createEventOccurrence();
        step.getEventOccurrences().add((Object)eventOcc);
        eventOcc.setCounter(clock.tickCount);
        eventOcc.setReferedElement((Reference)clock.traceReference);
        if (this.solver.getTraceReferences() != null && !this.solver.getTraceReferences().contains(clock.traceReference)) {
            this.solver.getTraceReferences().add((Reference)clock.traceReference);
        }
        if (clock instanceof ImplicitClock) {
            ImplicitClock ic = (ImplicitClock)clock;
            eventOcc.setWasBorn(((SolverExpression)ic.getExpression()).wasBorn());
        } else {
            eventOcc.setWasBorn(true);
        }
        if (this.solver.getDeadClocks().contains(clock)) {
            eventOcc.setIsClockDead(true);
        } else {
            eventOcc.setIsClockDead(false);
        }
        if (this.getClockFiredState(clock) == ClockTraceState.T) {
            eventOcc.setFState(FiredStateKind.TICK);
        } else if (this.getClockFiredState(clock) == ClockTraceState.F) {
            eventOcc.setFState(FiredStateKind.NO_TICK);
        }
        if (this.getClockEnabledState(clock) != null) {
            switch (this.getClockEnabledState(clock)) {
                case F: {
                    eventOcc.setEState(EnableStateKind.NO_TICK);
                    break;
                }
                case T: {
                    eventOcc.setEState(EnableStateKind.TICK);
                    break;
                }
                case X: {
                    eventOcc.setEState(EnableStateKind.INDETERMINED);
                    break;
                }
                case x: {
                    eventOcc.setEState(EnableStateKind.FREE);
                    break;
                }
            }
        } else {
            eventOcc.setEState(EnableStateKind.NO_TICK);
            eventOcc.setFState(FiredStateKind.NO_TICK);
        }
    }

    private void setAssertionState(SolverRelation assertion, LogicalStep step) {
        if (this.isAssertionViolated(assertion)) {
            ModelElementReference ref = this.solver.findReference(assertion.getInstantiatedElement());
            if (ref == null) {
                return;
            }
            AssertionState aState = TracePackage.eINSTANCE.getTraceFactory().createAssertionState();
            aState.setIsViolated(true);
            aState.setReferedElement((Reference)ref);
            step.getAssertionStates().add((Object)aState);
        }
    }

    public boolean isAssertionViolated(String qualifiedPath) {
        return this.isAssertionViolated(qualifiedPath, "::");
    }

    public boolean isAssertionViolated(String qualifiedPath, String separator) {
        ISolverConcrete concrete = (ISolverConcrete)this.solver.getConcreteInstantiationTree().lookupInstance(qualifiedPath, separator);
        if (concrete != null && concrete instanceof SolverRelation && ((SolverRelation)concrete).isAssertion()) {
            return this.isAssertionViolated((SolverRelation)concrete);
        }
        return false;
    }

    private boolean isAssertionViolated(SolverRelation assertion) {
        return this.fired.get(this.solver.assertionsToIndexInSolution.get(assertion).intValue()) == ClockTraceState.F;
    }

    public AbstractUpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public void dealWithBlockTransition() {
        ArrayList<SolverBlockTransition> transitionToFire = new ArrayList<SolverBlockTransition>();
        for (SolverBlockTransition sbt : this.solver.getAllBlockTransitions()) {
            if (this.getClockEnabledState(sbt.getOnClock()) != ClockTraceState.T || !sbt.getSource().isActiveBlock()) continue;
            transitionToFire.add(sbt);
        }
        for (SolverBlockTransition sbt : transitionToFire) {
            try {
                sbt.getSource().terminate(this.updateHelper);
            }
            catch (SimulationException e) {
                e.printStackTrace();
            }
            try {
                sbt.getTarget().start(this.semanticHelper);
            }
            catch (SimulationException e) {
                e.printStackTrace();
            }
        }
    }
}

